/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDataProviderRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ModifyDataProviderRequest.Builder, ModifyDataProviderRequest> {
    private static final SdkField<String> DATA_PROVIDER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataProviderIdentifier").getter(getter(ModifyDataProviderRequest::dataProviderIdentifier))
            .setter(setter(Builder::dataProviderIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderIdentifier").build())
            .build();

    private static final SdkField<String> DATA_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataProviderName").getter(getter(ModifyDataProviderRequest::dataProviderName))
            .setter(setter(Builder::dataProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ModifyDataProviderRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(ModifyDataProviderRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<Boolean> EXACT_SETTINGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExactSettings").getter(getter(ModifyDataProviderRequest::exactSettings))
            .setter(setter(Builder::exactSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExactSettings").build()).build();

    private static final SdkField<DataProviderSettings> SETTINGS_FIELD = SdkField
            .<DataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(ModifyDataProviderRequest::settings)).setter(setter(Builder::settings))
            .constructor(DataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_PROVIDER_IDENTIFIER_FIELD, DATA_PROVIDER_NAME_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, EXACT_SETTINGS_FIELD,
            SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataProviderIdentifier;

    private final String dataProviderName;

    private final String description;

    private final String engine;

    private final Boolean exactSettings;

    private final DataProviderSettings settings;

    private ModifyDataProviderRequest(BuilderImpl builder) {
        super(builder);
        this.dataProviderIdentifier = builder.dataProviderIdentifier;
        this.dataProviderName = builder.dataProviderName;
        this.description = builder.description;
        this.engine = builder.engine;
        this.exactSettings = builder.exactSettings;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The identifier of the data provider. Identifiers must begin with a letter and must contain only ASCII letters,
     * digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
     * </p>
     * 
     * @return The identifier of the data provider. Identifiers must begin with a letter and must contain only ASCII
     *         letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
     */
    public final String dataProviderIdentifier() {
        return dataProviderIdentifier;
    }

    /**
     * <p>
     * The name of the data provider.
     * </p>
     * 
     * @return The name of the data provider.
     */
    public final String dataProviderName() {
        return dataProviderName;
    }

    /**
     * <p>
     * A user-friendly description of the data provider.
     * </p>
     * 
     * @return A user-friendly description of the data provider.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of database engine for the data provider. Valid values include <code>"aurora"</code>,
     * <code>"aurora-postgresql"</code>, <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
     * <code>"sqlserver"</code>, <code>redshift</code>, <code>mariadb</code>, <code>mongodb</code>, <code>db2</code>,
     * <code>db2-zos</code> and <code>docdb</code>. A value of <code>"aurora"</code> represents Amazon Aurora
     * MySQL-Compatible Edition.
     * </p>
     * 
     * @return The type of database engine for the data provider. Valid values include <code>"aurora"</code>,
     *         <code>"aurora-postgresql"</code>, <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
     *         <code>"sqlserver"</code>, <code>redshift</code>, <code>mariadb</code>, <code>mongodb</code>,
     *         <code>db2</code>, <code>db2-zos</code> and <code>docdb</code>. A value of <code>"aurora"</code>
     *         represents Amazon Aurora MySQL-Compatible Edition.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * If this attribute is Y, the current call to <code>ModifyDataProvider</code> replaces all existing data provider
     * settings with the exact settings that you specify in this call. If this attribute is N, the current call to
     * <code>ModifyDataProvider</code> does two things:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It replaces any data provider settings that already exist with new values, for settings with the same names.
     * </p>
     * </li>
     * <li>
     * <p>
     * It creates new data provider settings that you specify in the call, for settings with different names.
     * </p>
     * </li>
     * </ul>
     * 
     * @return If this attribute is Y, the current call to <code>ModifyDataProvider</code> replaces all existing data
     *         provider settings with the exact settings that you specify in this call. If this attribute is N, the
     *         current call to <code>ModifyDataProvider</code> does two things: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It replaces any data provider settings that already exist with new values, for settings with the same
     *         names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It creates new data provider settings that you specify in the call, for settings with different names.
     *         </p>
     *         </li>
     */
    public final Boolean exactSettings() {
        return exactSettings;
    }

    /**
     * <p>
     * The settings in JSON format for a data provider.
     * </p>
     * 
     * @return The settings in JSON format for a data provider.
     */
    public final DataProviderSettings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataProviderIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dataProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(exactSettings());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDataProviderRequest)) {
            return false;
        }
        ModifyDataProviderRequest other = (ModifyDataProviderRequest) obj;
        return Objects.equals(dataProviderIdentifier(), other.dataProviderIdentifier())
                && Objects.equals(dataProviderName(), other.dataProviderName())
                && Objects.equals(description(), other.description()) && Objects.equals(engine(), other.engine())
                && Objects.equals(exactSettings(), other.exactSettings()) && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDataProviderRequest").add("DataProviderIdentifier", dataProviderIdentifier())
                .add("DataProviderName", dataProviderName()).add("Description", description()).add("Engine", engine())
                .add("ExactSettings", exactSettings()).add("Settings", settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataProviderIdentifier":
            return Optional.ofNullable(clazz.cast(dataProviderIdentifier()));
        case "DataProviderName":
            return Optional.ofNullable(clazz.cast(dataProviderName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "ExactSettings":
            return Optional.ofNullable(clazz.cast(exactSettings()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataProviderIdentifier", DATA_PROVIDER_IDENTIFIER_FIELD);
        map.put("DataProviderName", DATA_PROVIDER_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("ExactSettings", EXACT_SETTINGS_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDataProviderRequest, T> g) {
        return obj -> g.apply((ModifyDataProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyDataProviderRequest> {
        /**
         * <p>
         * The identifier of the data provider. Identifiers must begin with a letter and must contain only ASCII
         * letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * </p>
         * 
         * @param dataProviderIdentifier
         *        The identifier of the data provider. Identifiers must begin with a letter and must contain only ASCII
         *        letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProviderIdentifier(String dataProviderIdentifier);

        /**
         * <p>
         * The name of the data provider.
         * </p>
         * 
         * @param dataProviderName
         *        The name of the data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProviderName(String dataProviderName);

        /**
         * <p>
         * A user-friendly description of the data provider.
         * </p>
         * 
         * @param description
         *        A user-friendly description of the data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of database engine for the data provider. Valid values include <code>"aurora"</code>,
         * <code>"aurora-postgresql"</code>, <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
         * <code>"sqlserver"</code>, <code>redshift</code>, <code>mariadb</code>, <code>mongodb</code>, <code>db2</code>, <code>db2-zos</code> and <code>docdb</code>. A value of <code>"aurora"</code> represents Amazon Aurora
         * MySQL-Compatible Edition.
         * </p>
         * 
         * @param engine
         *        The type of database engine for the data provider. Valid values include <code>"aurora"</code>,
         *        <code>"aurora-postgresql"</code>, <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>
         *        , <code>"sqlserver"</code>, <code>redshift</code>, <code>mariadb</code>, <code>mongodb</code>,
         *        <code>db2</code>, <code>db2-zos</code> and <code>docdb</code>. A value of <code>"aurora"</code>
         *        represents Amazon Aurora MySQL-Compatible Edition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * If this attribute is Y, the current call to <code>ModifyDataProvider</code> replaces all existing data
         * provider settings with the exact settings that you specify in this call. If this attribute is N, the current
         * call to <code>ModifyDataProvider</code> does two things:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It replaces any data provider settings that already exist with new values, for settings with the same names.
         * </p>
         * </li>
         * <li>
         * <p>
         * It creates new data provider settings that you specify in the call, for settings with different names.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exactSettings
         *        If this attribute is Y, the current call to <code>ModifyDataProvider</code> replaces all existing data
         *        provider settings with the exact settings that you specify in this call. If this attribute is N, the
         *        current call to <code>ModifyDataProvider</code> does two things: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It replaces any data provider settings that already exist with new values, for settings with the same
         *        names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It creates new data provider settings that you specify in the call, for settings with different names.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exactSettings(Boolean exactSettings);

        /**
         * <p>
         * The settings in JSON format for a data provider.
         * </p>
         * 
         * @param settings
         *        The settings in JSON format for a data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(DataProviderSettings settings);

        /**
         * <p>
         * The settings in JSON format for a data provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProviderSettings.Builder} avoiding
         * the need to create one manually via {@link DataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProviderSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(DataProviderSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link DataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(DataProviderSettings)
         */
        default Builder settings(Consumer<DataProviderSettings.Builder> settings) {
            return settings(DataProviderSettings.builder().applyMutation(settings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String dataProviderIdentifier;

        private String dataProviderName;

        private String description;

        private String engine;

        private Boolean exactSettings;

        private DataProviderSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDataProviderRequest model) {
            super(model);
            dataProviderIdentifier(model.dataProviderIdentifier);
            dataProviderName(model.dataProviderName);
            description(model.description);
            engine(model.engine);
            exactSettings(model.exactSettings);
            settings(model.settings);
        }

        public final String getDataProviderIdentifier() {
            return dataProviderIdentifier;
        }

        public final void setDataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
        }

        @Override
        public final Builder dataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
            return this;
        }

        public final String getDataProviderName() {
            return dataProviderName;
        }

        public final void setDataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
        }

        @Override
        public final Builder dataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Boolean getExactSettings() {
            return exactSettings;
        }

        public final void setExactSettings(Boolean exactSettings) {
            this.exactSettings = exactSettings;
        }

        @Override
        public final Builder exactSettings(Boolean exactSettings) {
            this.exactSettings = exactSettings;
            return this;
        }

        public final DataProviderSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(DataProviderSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(DataProviderSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDataProviderRequest build() {
            return new ModifyDataProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
