/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a maintenance action pending for an DMS resource, including when and how it will be applied. This data type
 * is a response element to the <code>DescribePendingMaintenanceActions</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingMaintenanceAction implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingMaintenanceAction.Builder, PendingMaintenanceAction> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(PendingMaintenanceAction::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Instant> AUTO_APPLIED_AFTER_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AutoAppliedAfterDate").getter(getter(PendingMaintenanceAction::autoAppliedAfterDate))
            .setter(setter(Builder::autoAppliedAfterDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAppliedAfterDate").build())
            .build();

    private static final SdkField<Instant> FORCED_APPLY_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ForcedApplyDate").getter(getter(PendingMaintenanceAction::forcedApplyDate))
            .setter(setter(Builder::forcedApplyDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForcedApplyDate").build()).build();

    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptInStatus").getter(getter(PendingMaintenanceAction::optInStatus)).setter(setter(Builder::optInStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus").build()).build();

    private static final SdkField<Instant> CURRENT_APPLY_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CurrentApplyDate").getter(getter(PendingMaintenanceAction::currentApplyDate))
            .setter(setter(Builder::currentApplyDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplyDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PendingMaintenanceAction::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            AUTO_APPLIED_AFTER_DATE_FIELD, FORCED_APPLY_DATE_FIELD, OPT_IN_STATUS_FIELD, CURRENT_APPLY_DATE_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final Instant autoAppliedAfterDate;

    private final Instant forcedApplyDate;

    private final String optInStatus;

    private final Instant currentApplyDate;

    private final String description;

    private PendingMaintenanceAction(BuilderImpl builder) {
        this.action = builder.action;
        this.autoAppliedAfterDate = builder.autoAppliedAfterDate;
        this.forcedApplyDate = builder.forcedApplyDate;
        this.optInStatus = builder.optInStatus;
        this.currentApplyDate = builder.currentApplyDate;
        this.description = builder.description;
    }

    /**
     * <p>
     * The type of pending maintenance action that is available for the resource.
     * </p>
     * 
     * @return The type of pending maintenance action that is available for the resource.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The date of the maintenance window when the action is to be applied. The maintenance action is applied to the
     * resource during its first maintenance window after this date. If this date is specified, any
     * <code>next-maintenance</code> opt-in requests are ignored.
     * </p>
     * 
     * @return The date of the maintenance window when the action is to be applied. The maintenance action is applied to
     *         the resource during its first maintenance window after this date. If this date is specified, any
     *         <code>next-maintenance</code> opt-in requests are ignored.
     */
    public final Instant autoAppliedAfterDate() {
        return autoAppliedAfterDate;
    }

    /**
     * <p>
     * The date when the maintenance action will be automatically applied. The maintenance action is applied to the
     * resource on this date regardless of the maintenance window for the resource. If this date is specified, any
     * <code>immediate</code> opt-in requests are ignored.
     * </p>
     * 
     * @return The date when the maintenance action will be automatically applied. The maintenance action is applied to
     *         the resource on this date regardless of the maintenance window for the resource. If this date is
     *         specified, any <code>immediate</code> opt-in requests are ignored.
     */
    public final Instant forcedApplyDate() {
        return forcedApplyDate;
    }

    /**
     * <p>
     * The type of opt-in request that has been received for the resource.
     * </p>
     * 
     * @return The type of opt-in request that has been received for the resource.
     */
    public final String optInStatus() {
        return optInStatus;
    }

    /**
     * <p>
     * The effective date when the pending maintenance action will be applied to the resource. This date takes into
     * account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API operation, and also the
     * <code>AutoAppliedAfterDate</code> and <code>ForcedApplyDate</code> parameter values. This value is blank if an
     * opt-in request has not been received and nothing has been specified for <code>AutoAppliedAfterDate</code> or
     * <code>ForcedApplyDate</code>.
     * </p>
     * 
     * @return The effective date when the pending maintenance action will be applied to the resource. This date takes
     *         into account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API operation,
     *         and also the <code>AutoAppliedAfterDate</code> and <code>ForcedApplyDate</code> parameter values. This
     *         value is blank if an opt-in request has not been received and nothing has been specified for
     *         <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.
     */
    public final Instant currentApplyDate() {
        return currentApplyDate;
    }

    /**
     * <p>
     * A description providing more detail about the maintenance action.
     * </p>
     * 
     * @return A description providing more detail about the maintenance action.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(autoAppliedAfterDate());
        hashCode = 31 * hashCode + Objects.hashCode(forcedApplyDate());
        hashCode = 31 * hashCode + Objects.hashCode(optInStatus());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplyDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingMaintenanceAction)) {
            return false;
        }
        PendingMaintenanceAction other = (PendingMaintenanceAction) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(autoAppliedAfterDate(), other.autoAppliedAfterDate())
                && Objects.equals(forcedApplyDate(), other.forcedApplyDate())
                && Objects.equals(optInStatus(), other.optInStatus())
                && Objects.equals(currentApplyDate(), other.currentApplyDate())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingMaintenanceAction").add("Action", action())
                .add("AutoAppliedAfterDate", autoAppliedAfterDate()).add("ForcedApplyDate", forcedApplyDate())
                .add("OptInStatus", optInStatus()).add("CurrentApplyDate", currentApplyDate()).add("Description", description())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "AutoAppliedAfterDate":
            return Optional.ofNullable(clazz.cast(autoAppliedAfterDate()));
        case "ForcedApplyDate":
            return Optional.ofNullable(clazz.cast(forcedApplyDate()));
        case "OptInStatus":
            return Optional.ofNullable(clazz.cast(optInStatus()));
        case "CurrentApplyDate":
            return Optional.ofNullable(clazz.cast(currentApplyDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("AutoAppliedAfterDate", AUTO_APPLIED_AFTER_DATE_FIELD);
        map.put("ForcedApplyDate", FORCED_APPLY_DATE_FIELD);
        map.put("OptInStatus", OPT_IN_STATUS_FIELD);
        map.put("CurrentApplyDate", CURRENT_APPLY_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PendingMaintenanceAction, T> g) {
        return obj -> g.apply((PendingMaintenanceAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingMaintenanceAction> {
        /**
         * <p>
         * The type of pending maintenance action that is available for the resource.
         * </p>
         * 
         * @param action
         *        The type of pending maintenance action that is available for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The date of the maintenance window when the action is to be applied. The maintenance action is applied to the
         * resource during its first maintenance window after this date. If this date is specified, any
         * <code>next-maintenance</code> opt-in requests are ignored.
         * </p>
         * 
         * @param autoAppliedAfterDate
         *        The date of the maintenance window when the action is to be applied. The maintenance action is applied
         *        to the resource during its first maintenance window after this date. If this date is specified, any
         *        <code>next-maintenance</code> opt-in requests are ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAppliedAfterDate(Instant autoAppliedAfterDate);

        /**
         * <p>
         * The date when the maintenance action will be automatically applied. The maintenance action is applied to the
         * resource on this date regardless of the maintenance window for the resource. If this date is specified, any
         * <code>immediate</code> opt-in requests are ignored.
         * </p>
         * 
         * @param forcedApplyDate
         *        The date when the maintenance action will be automatically applied. The maintenance action is applied
         *        to the resource on this date regardless of the maintenance window for the resource. If this date is
         *        specified, any <code>immediate</code> opt-in requests are ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forcedApplyDate(Instant forcedApplyDate);

        /**
         * <p>
         * The type of opt-in request that has been received for the resource.
         * </p>
         * 
         * @param optInStatus
         *        The type of opt-in request that has been received for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optInStatus(String optInStatus);

        /**
         * <p>
         * The effective date when the pending maintenance action will be applied to the resource. This date takes into
         * account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API operation, and also
         * the <code>AutoAppliedAfterDate</code> and <code>ForcedApplyDate</code> parameter values. This value is blank
         * if an opt-in request has not been received and nothing has been specified for
         * <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.
         * </p>
         * 
         * @param currentApplyDate
         *        The effective date when the pending maintenance action will be applied to the resource. This date
         *        takes into account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API
         *        operation, and also the <code>AutoAppliedAfterDate</code> and <code>ForcedApplyDate</code> parameter
         *        values. This value is blank if an opt-in request has not been received and nothing has been specified
         *        for <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplyDate(Instant currentApplyDate);

        /**
         * <p>
         * A description providing more detail about the maintenance action.
         * </p>
         * 
         * @param description
         *        A description providing more detail about the maintenance action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private Instant autoAppliedAfterDate;

        private Instant forcedApplyDate;

        private String optInStatus;

        private Instant currentApplyDate;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingMaintenanceAction model) {
            action(model.action);
            autoAppliedAfterDate(model.autoAppliedAfterDate);
            forcedApplyDate(model.forcedApplyDate);
            optInStatus(model.optInStatus);
            currentApplyDate(model.currentApplyDate);
            description(model.description);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final Instant getAutoAppliedAfterDate() {
            return autoAppliedAfterDate;
        }

        public final void setAutoAppliedAfterDate(Instant autoAppliedAfterDate) {
            this.autoAppliedAfterDate = autoAppliedAfterDate;
        }

        @Override
        public final Builder autoAppliedAfterDate(Instant autoAppliedAfterDate) {
            this.autoAppliedAfterDate = autoAppliedAfterDate;
            return this;
        }

        public final Instant getForcedApplyDate() {
            return forcedApplyDate;
        }

        public final void setForcedApplyDate(Instant forcedApplyDate) {
            this.forcedApplyDate = forcedApplyDate;
        }

        @Override
        public final Builder forcedApplyDate(Instant forcedApplyDate) {
            this.forcedApplyDate = forcedApplyDate;
            return this;
        }

        public final String getOptInStatus() {
            return optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        public final Instant getCurrentApplyDate() {
            return currentApplyDate;
        }

        public final void setCurrentApplyDate(Instant currentApplyDate) {
            this.currentApplyDate = currentApplyDate;
        }

        @Override
        public final Builder currentApplyDate(Instant currentApplyDate) {
            this.currentApplyDate = currentApplyDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public PendingMaintenanceAction build() {
            return new PendingMaintenanceAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
