/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines an Amazon Redshift endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftSettings.Builder, RedshiftSettings> {
    private static final SdkField<Boolean> ACCEPT_ANY_DATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AcceptAnyDate").getter(getter(RedshiftSettings::acceptAnyDate)).setter(setter(Builder::acceptAnyDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptAnyDate").build()).build();

    private static final SdkField<String> AFTER_CONNECT_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AfterConnectScript").getter(getter(RedshiftSettings::afterConnectScript))
            .setter(setter(Builder::afterConnectScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterConnectScript").build())
            .build();

    private static final SdkField<String> BUCKET_FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketFolder").getter(getter(RedshiftSettings::bucketFolder)).setter(setter(Builder::bucketFolder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketFolder").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(RedshiftSettings::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<Boolean> CASE_SENSITIVE_NAMES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CaseSensitiveNames").getter(getter(RedshiftSettings::caseSensitiveNames))
            .setter(setter(Builder::caseSensitiveNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseSensitiveNames").build())
            .build();

    private static final SdkField<Boolean> COMP_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CompUpdate").getter(getter(RedshiftSettings::compUpdate)).setter(setter(Builder::compUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompUpdate").build()).build();

    private static final SdkField<Integer> CONNECTION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConnectionTimeout").getter(getter(RedshiftSettings::connectionTimeout))
            .setter(setter(Builder::connectionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTimeout").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(RedshiftSettings::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DATE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateFormat").getter(getter(RedshiftSettings::dateFormat)).setter(setter(Builder::dateFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFormat").build()).build();

    private static final SdkField<Boolean> EMPTY_AS_NULL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EmptyAsNull").getter(getter(RedshiftSettings::emptyAsNull)).setter(setter(Builder::emptyAsNull))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmptyAsNull").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionMode").getter(getter(RedshiftSettings::encryptionModeAsString))
            .setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()).build();

    private static final SdkField<Boolean> EXPLICIT_IDS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExplicitIds").getter(getter(RedshiftSettings::explicitIds)).setter(setter(Builder::explicitIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitIds").build()).build();

    private static final SdkField<Integer> FILE_TRANSFER_UPLOAD_STREAMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("FileTransferUploadStreams")
            .getter(getter(RedshiftSettings::fileTransferUploadStreams)).setter(setter(Builder::fileTransferUploadStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileTransferUploadStreams").build())
            .build();

    private static final SdkField<Integer> LOAD_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LoadTimeout").getter(getter(RedshiftSettings::loadTimeout)).setter(setter(Builder::loadTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadTimeout").build()).build();

    private static final SdkField<Integer> MAX_FILE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxFileSize").getter(getter(RedshiftSettings::maxFileSize)).setter(setter(Builder::maxFileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFileSize").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(RedshiftSettings::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RedshiftSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Boolean> REMOVE_QUOTES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveQuotes").getter(getter(RedshiftSettings::removeQuotes)).setter(setter(Builder::removeQuotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveQuotes").build()).build();

    private static final SdkField<String> REPLACE_INVALID_CHARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplaceInvalidChars").getter(getter(RedshiftSettings::replaceInvalidChars))
            .setter(setter(Builder::replaceInvalidChars))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceInvalidChars").build())
            .build();

    private static final SdkField<String> REPLACE_CHARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplaceChars").getter(getter(RedshiftSettings::replaceChars)).setter(setter(Builder::replaceChars))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceChars").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(RedshiftSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(RedshiftSettings::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServerSideEncryptionKmsKeyId")
            .getter(getter(RedshiftSettings::serverSideEncryptionKmsKeyId))
            .setter(setter(Builder::serverSideEncryptionKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionKmsKeyId")
                    .build()).build();

    private static final SdkField<String> TIME_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeFormat").getter(getter(RedshiftSettings::timeFormat)).setter(setter(Builder::timeFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeFormat").build()).build();

    private static final SdkField<Boolean> TRIM_BLANKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TrimBlanks").getter(getter(RedshiftSettings::trimBlanks)).setter(setter(Builder::trimBlanks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrimBlanks").build()).build();

    private static final SdkField<Boolean> TRUNCATE_COLUMNS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TruncateColumns").getter(getter(RedshiftSettings::truncateColumns))
            .setter(setter(Builder::truncateColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruncateColumns").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(RedshiftSettings::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<Integer> WRITE_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WriteBufferSize").getter(getter(RedshiftSettings::writeBufferSize))
            .setter(setter(Builder::writeBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteBufferSize").build()).build();

    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerAccessRoleArn")
            .getter(getter(RedshiftSettings::secretsManagerAccessRoleArn))
            .setter(setter(Builder::secretsManagerAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn")
                    .build()).build();

    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerSecretId").getter(getter(RedshiftSettings::secretsManagerSecretId))
            .setter(setter(Builder::secretsManagerSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build())
            .build();

    private static final SdkField<Boolean> MAP_BOOLEAN_AS_BOOLEAN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MapBooleanAsBoolean").getter(getter(RedshiftSettings::mapBooleanAsBoolean))
            .setter(setter(Builder::mapBooleanAsBoolean))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapBooleanAsBoolean").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_ANY_DATE_FIELD,
            AFTER_CONNECT_SCRIPT_FIELD, BUCKET_FOLDER_FIELD, BUCKET_NAME_FIELD, CASE_SENSITIVE_NAMES_FIELD, COMP_UPDATE_FIELD,
            CONNECTION_TIMEOUT_FIELD, DATABASE_NAME_FIELD, DATE_FORMAT_FIELD, EMPTY_AS_NULL_FIELD, ENCRYPTION_MODE_FIELD,
            EXPLICIT_IDS_FIELD, FILE_TRANSFER_UPLOAD_STREAMS_FIELD, LOAD_TIMEOUT_FIELD, MAX_FILE_SIZE_FIELD, PASSWORD_FIELD,
            PORT_FIELD, REMOVE_QUOTES_FIELD, REPLACE_INVALID_CHARS_FIELD, REPLACE_CHARS_FIELD, SERVER_NAME_FIELD,
            SERVICE_ACCESS_ROLE_ARN_FIELD, SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD, TIME_FORMAT_FIELD, TRIM_BLANKS_FIELD,
            TRUNCATE_COLUMNS_FIELD, USERNAME_FIELD, WRITE_BUFFER_SIZE_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD,
            SECRETS_MANAGER_SECRET_ID_FIELD, MAP_BOOLEAN_AS_BOOLEAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean acceptAnyDate;

    private final String afterConnectScript;

    private final String bucketFolder;

    private final String bucketName;

    private final Boolean caseSensitiveNames;

    private final Boolean compUpdate;

    private final Integer connectionTimeout;

    private final String databaseName;

    private final String dateFormat;

    private final Boolean emptyAsNull;

    private final String encryptionMode;

    private final Boolean explicitIds;

    private final Integer fileTransferUploadStreams;

    private final Integer loadTimeout;

    private final Integer maxFileSize;

    private final String password;

    private final Integer port;

    private final Boolean removeQuotes;

    private final String replaceInvalidChars;

    private final String replaceChars;

    private final String serverName;

    private final String serviceAccessRoleArn;

    private final String serverSideEncryptionKmsKeyId;

    private final String timeFormat;

    private final Boolean trimBlanks;

    private final Boolean truncateColumns;

    private final String username;

    private final Integer writeBufferSize;

    private final String secretsManagerAccessRoleArn;

    private final String secretsManagerSecretId;

    private final Boolean mapBooleanAsBoolean;

    private RedshiftSettings(BuilderImpl builder) {
        this.acceptAnyDate = builder.acceptAnyDate;
        this.afterConnectScript = builder.afterConnectScript;
        this.bucketFolder = builder.bucketFolder;
        this.bucketName = builder.bucketName;
        this.caseSensitiveNames = builder.caseSensitiveNames;
        this.compUpdate = builder.compUpdate;
        this.connectionTimeout = builder.connectionTimeout;
        this.databaseName = builder.databaseName;
        this.dateFormat = builder.dateFormat;
        this.emptyAsNull = builder.emptyAsNull;
        this.encryptionMode = builder.encryptionMode;
        this.explicitIds = builder.explicitIds;
        this.fileTransferUploadStreams = builder.fileTransferUploadStreams;
        this.loadTimeout = builder.loadTimeout;
        this.maxFileSize = builder.maxFileSize;
        this.password = builder.password;
        this.port = builder.port;
        this.removeQuotes = builder.removeQuotes;
        this.replaceInvalidChars = builder.replaceInvalidChars;
        this.replaceChars = builder.replaceChars;
        this.serverName = builder.serverName;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.serverSideEncryptionKmsKeyId = builder.serverSideEncryptionKmsKeyId;
        this.timeFormat = builder.timeFormat;
        this.trimBlanks = builder.trimBlanks;
        this.truncateColumns = builder.truncateColumns;
        this.username = builder.username;
        this.writeBufferSize = builder.writeBufferSize;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.mapBooleanAsBoolean = builder.mapBooleanAsBoolean;
    }

    /**
     * <p>
     * A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be
     * loaded without generating an error. You can choose <code>true</code> or <code>false</code> (the default).
     * </p>
     * <p>
     * This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT
     * parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift inserts a
     * NULL value into that field.
     * </p>
     * 
     * @return A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to
     *         be loaded without generating an error. You can choose <code>true</code> or <code>false</code> (the
     *         default).</p>
     *         <p>
     *         This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT
     *         parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift
     *         inserts a NULL value into that field.
     */
    public final Boolean acceptAnyDate() {
        return acceptAnyDate;
    }

    /**
     * <p>
     * Code to run after connecting. This parameter should contain the code itself, not the name of a file containing
     * the code.
     * </p>
     * 
     * @return Code to run after connecting. This parameter should contain the code itself, not the name of a file
     *         containing the code.
     */
    public final String afterConnectScript() {
        return afterConnectScript;
    }

    /**
     * <p>
     * An S3 folder where the comma-separated-value (.csv) files are stored before being uploaded to the target Redshift
     * cluster.
     * </p>
     * <p>
     * For full load mode, DMS converts source records into .csv files and loads them to the <i>BucketFolder/TableID</i>
     * path. DMS uses the Redshift <code>COPY</code> command to upload the .csv files to the target table. The files are
     * deleted once the <code>COPY</code> operation has finished. For more information, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the <i>Amazon Redshift Database
     * Developer Guide</i>.
     * </p>
     * <p>
     * For change-data-capture (CDC) mode, DMS creates a <i>NetChanges</i> table, and loads the .csv files to this
     * <i>BucketFolder/NetChangesTableID</i> path.
     * </p>
     * 
     * @return An S3 folder where the comma-separated-value (.csv) files are stored before being uploaded to the target
     *         Redshift cluster. </p>
     *         <p>
     *         For full load mode, DMS converts source records into .csv files and loads them to the
     *         <i>BucketFolder/TableID</i> path. DMS uses the Redshift <code>COPY</code> command to upload the .csv
     *         files to the target table. The files are deleted once the <code>COPY</code> operation has finished. For
     *         more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in
     *         the <i>Amazon Redshift Database Developer Guide</i>.
     *         </p>
     *         <p>
     *         For change-data-capture (CDC) mode, DMS creates a <i>NetChanges</i> table, and loads the .csv files to
     *         this <i>BucketFolder/NetChangesTableID</i> path.
     */
    public final String bucketFolder() {
        return bucketFolder;
    }

    /**
     * <p>
     * The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.
     * </p>
     * 
     * @return The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * If Amazon Redshift is configured to support case sensitive schema names, set <code>CaseSensitiveNames</code> to
     * <code>true</code>. The default is <code>false</code>.
     * </p>
     * 
     * @return If Amazon Redshift is configured to support case sensitive schema names, set
     *         <code>CaseSensitiveNames</code> to <code>true</code>. The default is <code>false</code>.
     */
    public final Boolean caseSensitiveNames() {
        return caseSensitiveNames;
    }

    /**
     * <p>
     * If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies automatic compression if the
     * table is empty. This applies even if the table columns already have encodings other than <code>RAW</code>. If you
     * set <code>CompUpdate</code> to <code>false</code>, automatic compression is disabled and existing column
     * encodings aren't changed. The default is <code>true</code>.
     * </p>
     * 
     * @return If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies automatic compression if
     *         the table is empty. This applies even if the table columns already have encodings other than
     *         <code>RAW</code>. If you set <code>CompUpdate</code> to <code>false</code>, automatic compression is
     *         disabled and existing column encodings aren't changed. The default is <code>true</code>.
     */
    public final Boolean compUpdate() {
        return compUpdate;
    }

    /**
     * <p>
     * A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you
     * initially establish a connection.
     * </p>
     * 
     * @return A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you
     *         initially establish a connection.
     */
    public final Integer connectionTimeout() {
        return connectionTimeout;
    }

    /**
     * <p>
     * The name of the Amazon Redshift data warehouse (service) that you are working with.
     * </p>
     * 
     * @return The name of the Amazon Redshift data warehouse (service) that you are working with.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The date format that you are using. Valid values are <code>auto</code> (case-sensitive), your date format string
     * enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of 'YYYY-MM-DD'.
     * Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a date format
     * string.
     * </p>
     * <p>
     * If your date and time values use formats different from each other, set this to <code>auto</code>.
     * </p>
     * 
     * @return The date format that you are using. Valid values are <code>auto</code> (case-sensitive), your date format
     *         string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of
     *         'YYYY-MM-DD'. Using <code>auto</code> recognizes most strings, even some that aren't supported when you
     *         use a date format string. </p>
     *         <p>
     *         If your date and time values use formats different from each other, set this to <code>auto</code>.
     */
    public final String dateFormat() {
        return dateFormat;
    }

    /**
     * <p>
     * A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of
     * <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code>.
     * </p>
     * 
     * @return A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of
     *         <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code>.
     */
    public final Boolean emptyAsNull() {
        return emptyAsNull;
    }

    /**
     * <p>
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the
     * endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code>
     * (the default) or <code>SSE_KMS</code>.
     * </p>
     * <note>
     * <p>
     * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
     * <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change the
     * existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
     * </p>
     * </note>
     * <p>
     * To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with a policy that allows
     * <code>"arn:aws:s3:::*"</code> to use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that you want to use for your data. This encryption type is part of
     *         the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
     *         <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note>
     *         <p>
     *         For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
     *         <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t
     *         change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
     *         </p>
     *         </note>
     *         <p>
     *         To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with a policy that allows
     *         <code>"arn:aws:s3:::*"</code> to use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
     * @see EncryptionModeValue
     */
    public final EncryptionModeValue encryptionMode() {
        return EncryptionModeValue.fromValue(encryptionMode);
    }

    /**
     * <p>
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the
     * endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code>
     * (the default) or <code>SSE_KMS</code>.
     * </p>
     * <note>
     * <p>
     * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
     * <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change the
     * existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
     * </p>
     * </note>
     * <p>
     * To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with a policy that allows
     * <code>"arn:aws:s3:::*"</code> to use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that you want to use for your data. This encryption type is part of
     *         the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
     *         <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note>
     *         <p>
     *         For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
     *         <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t
     *         change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
     *         </p>
     *         </note>
     *         <p>
     *         To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with a policy that allows
     *         <code>"arn:aws:s3:::*"</code> to use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
     * @see EncryptionModeValue
     */
    public final String encryptionModeAsString() {
        return encryptionMode;
    }

    /**
     * <p>
     * This setting is only valid for a full-load migration task. Set <code>ExplicitIds</code> to <code>true</code> to
     * have tables with <code>IDENTITY</code> columns override their auto-generated values with explicit values loaded
     * from the source data files used to populate the tables. The default is <code>false</code>.
     * </p>
     * 
     * @return This setting is only valid for a full-load migration task. Set <code>ExplicitIds</code> to
     *         <code>true</code> to have tables with <code>IDENTITY</code> columns override their auto-generated values
     *         with explicit values loaded from the source data files used to populate the tables. The default is
     *         <code>false</code>.
     */
    public final Boolean explicitIds() {
        return explicitIds;
    }

    /**
     * <p>
     * The number of threads used to upload a single file. This parameter accepts a value from 1 through 64. It defaults
     * to 10.
     * </p>
     * <p>
     * The number of parallel streams used to upload a single .csv file to an S3 bucket using S3 Multipart Upload. For
     * more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload
     * overview</a>.
     * </p>
     * <p>
     * <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It defaults to 10.
     * </p>
     * 
     * @return The number of threads used to upload a single file. This parameter accepts a value from 1 through 64. It
     *         defaults to 10.</p>
     *         <p>
     *         The number of parallel streams used to upload a single .csv file to an S3 bucket using S3 Multipart
     *         Upload. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload overview</a>.
     *         </p>
     *         <p>
     *         <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It defaults to 10.
     */
    public final Integer fileTransferUploadStreams() {
        return fileTransferUploadStreams;
    }

    /**
     * <p>
     * The amount of time to wait (in milliseconds) before timing out of operations performed by DMS on a Redshift
     * cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.
     * </p>
     * 
     * @return The amount of time to wait (in milliseconds) before timing out of operations performed by DMS on a
     *         Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.
     */
    public final Integer loadTimeout() {
        return loadTimeout;
    }

    /**
     * <p>
     * The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer data to Amazon Redshift.
     * It defaults to 1048576KB (1 GB).
     * </p>
     * 
     * @return The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer data to Amazon
     *         Redshift. It defaults to 1048576KB (1 GB).
     */
    public final Integer maxFileSize() {
        return maxFileSize;
    }

    /**
     * <p>
     * The password for the user named in the <code>username</code> property.
     * </p>
     * 
     * @return The password for the user named in the <code>username</code> property.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The port number for Amazon Redshift. The default value is 5439.
     * </p>
     * 
     * @return The port number for Amazon Redshift. The default value is 5439.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * A value that specifies to remove surrounding quotation marks from strings in the incoming data. All characters
     * within the quotation marks, including delimiters, are retained. Choose <code>true</code> to remove quotation
     * marks. The default is <code>false</code>.
     * </p>
     * 
     * @return A value that specifies to remove surrounding quotation marks from strings in the incoming data. All
     *         characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to
     *         remove quotation marks. The default is <code>false</code>.
     */
    public final Boolean removeQuotes() {
        return removeQuotes;
    }

    /**
     * <p>
     * A list of characters that you want to replace. Use with <code>ReplaceChars</code>.
     * </p>
     * 
     * @return A list of characters that you want to replace. Use with <code>ReplaceChars</code>.
     */
    public final String replaceInvalidChars() {
        return replaceInvalidChars;
    }

    /**
     * <p>
     * A value that specifies to replaces the invalid characters specified in <code>ReplaceInvalidChars</code>,
     * substituting the specified characters instead. The default is <code>"?"</code>.
     * </p>
     * 
     * @return A value that specifies to replaces the invalid characters specified in <code>ReplaceInvalidChars</code>,
     *         substituting the specified characters instead. The default is <code>"?"</code>.
     */
    public final String replaceChars() {
        return replaceChars;
    }

    /**
     * <p>
     * The name of the Amazon Redshift cluster you are using.
     * </p>
     * 
     * @return The name of the Amazon Redshift cluster you are using.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service. The role must
     * allow the <code>iam:PassRole</code> action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service. The role
     *         must allow the <code>iam:PassRole</code> action.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * The KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide this key ID.
     * The key that you use needs an attached policy that enables IAM user permissions and allows use of the key.
     * </p>
     * 
     * @return The KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide this
     *         key ID. The key that you use needs an attached policy that enables IAM user permissions and allows use of
     *         the key.
     */
    public final String serverSideEncryptionKmsKeyId() {
        return serverSideEncryptionKmsKeyId;
    }

    /**
     * <p>
     * The time format that you want to use. Valid values are <code>auto</code> (case-sensitive),
     * <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or <code>'epochmillisecs'</code>. It defaults to 10.
     * Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a time format
     * string.
     * </p>
     * <p>
     * If your date and time values use formats different from each other, set this parameter to <code>auto</code>.
     * </p>
     * 
     * @return The time format that you want to use. Valid values are <code>auto</code> (case-sensitive),
     *         <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or <code>'epochmillisecs'</code>. It defaults
     *         to 10. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a
     *         time format string. </p>
     *         <p>
     *         If your date and time values use formats different from each other, set this parameter to
     *         <code>auto</code>.
     */
    public final String timeFormat() {
        return timeFormat;
    }

    /**
     * <p>
     * A value that specifies to remove the trailing white space characters from a VARCHAR string. This parameter
     * applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded white space. The
     * default is <code>false</code>.
     * </p>
     * 
     * @return A value that specifies to remove the trailing white space characters from a VARCHAR string. This
     *         parameter applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded
     *         white space. The default is <code>false</code>.
     */
    public final Boolean trimBlanks() {
        return trimBlanks;
    }

    /**
     * <p>
     * A value that specifies to truncate data in columns to the appropriate number of characters, so that the data fits
     * in the column. This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a size of 4
     * MB or less. Choose <code>true</code> to truncate data. The default is <code>false</code>.
     * </p>
     * 
     * @return A value that specifies to truncate data in columns to the appropriate number of characters, so that the
     *         data fits in the column. This parameter applies only to columns with a VARCHAR or CHAR data type, and
     *         rows with a size of 4 MB or less. Choose <code>true</code> to truncate data. The default is
     *         <code>false</code>.
     */
    public final Boolean truncateColumns() {
        return truncateColumns;
    }

    /**
     * <p>
     * An Amazon Redshift user name for a registered user.
     * </p>
     * 
     * @return An Amazon Redshift user name for a registered user.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk at the DMS
     * replication instance. The default value is 1000 (buffer size is 1000KB).
     * </p>
     * 
     * @return The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk at
     *         the DMS replication instance. The default value is 1000 (buffer size is 1000KB).
     */
    public final Integer writeBufferSize() {
        return writeBufferSize;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the
     * required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the
     * <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services
     * Secrets Manager secret that allows access to the Amazon Redshift endpoint.
     * </p>
     * <note>
     * <p>
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and
     * <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
     * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
     * information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code>
     * and <code>SecretsManagerSecretId</code> required to access it, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using
     * secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants
     *         the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow
     *         the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web
     *         Services Secrets Manager secret that allows access to the Amazon Redshift endpoint.</p> <note>
     *         <p>
     *         You can specify one of two sets of values for these permissions. You can specify the values for this
     *         setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
     *         <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't
     *         specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
     *         <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it,
     *         see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
     *         >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
     *         User Guide</i>.
     *         </p>
     */
    public final String secretsManagerAccessRoleArn() {
        return secretsManagerAccessRoleArn;
    }

    /**
     * <p>
     * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Amazon
     * Redshift endpoint connection details.
     * </p>
     * 
     * @return The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
     *         Amazon Redshift endpoint connection details.
     */
    public final String secretsManagerSecretId() {
        return secretsManagerSecretId;
    }

    /**
     * <p>
     * When true, lets Redshift migrate the boolean type as boolean. By default, Redshift migrates booleans as
     * <code>varchar(1)</code>. You must set this setting on both the source and target endpoints for it to take effect.
     * </p>
     * 
     * @return When true, lets Redshift migrate the boolean type as boolean. By default, Redshift migrates booleans as
     *         <code>varchar(1)</code>. You must set this setting on both the source and target endpoints for it to take
     *         effect.
     */
    public final Boolean mapBooleanAsBoolean() {
        return mapBooleanAsBoolean;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceptAnyDate());
        hashCode = 31 * hashCode + Objects.hashCode(afterConnectScript());
        hashCode = 31 * hashCode + Objects.hashCode(bucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(caseSensitiveNames());
        hashCode = 31 * hashCode + Objects.hashCode(compUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(dateFormat());
        hashCode = 31 * hashCode + Objects.hashCode(emptyAsNull());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(explicitIds());
        hashCode = 31 * hashCode + Objects.hashCode(fileTransferUploadStreams());
        hashCode = 31 * hashCode + Objects.hashCode(loadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(maxFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(removeQuotes());
        hashCode = 31 * hashCode + Objects.hashCode(replaceInvalidChars());
        hashCode = 31 * hashCode + Objects.hashCode(replaceChars());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(timeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(trimBlanks());
        hashCode = 31 * hashCode + Objects.hashCode(truncateColumns());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(writeBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(mapBooleanAsBoolean());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftSettings)) {
            return false;
        }
        RedshiftSettings other = (RedshiftSettings) obj;
        return Objects.equals(acceptAnyDate(), other.acceptAnyDate())
                && Objects.equals(afterConnectScript(), other.afterConnectScript())
                && Objects.equals(bucketFolder(), other.bucketFolder()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(caseSensitiveNames(), other.caseSensitiveNames())
                && Objects.equals(compUpdate(), other.compUpdate())
                && Objects.equals(connectionTimeout(), other.connectionTimeout())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(dateFormat(), other.dateFormat())
                && Objects.equals(emptyAsNull(), other.emptyAsNull())
                && Objects.equals(encryptionModeAsString(), other.encryptionModeAsString())
                && Objects.equals(explicitIds(), other.explicitIds())
                && Objects.equals(fileTransferUploadStreams(), other.fileTransferUploadStreams())
                && Objects.equals(loadTimeout(), other.loadTimeout()) && Objects.equals(maxFileSize(), other.maxFileSize())
                && Objects.equals(password(), other.password()) && Objects.equals(port(), other.port())
                && Objects.equals(removeQuotes(), other.removeQuotes())
                && Objects.equals(replaceInvalidChars(), other.replaceInvalidChars())
                && Objects.equals(replaceChars(), other.replaceChars()) && Objects.equals(serverName(), other.serverName())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(serverSideEncryptionKmsKeyId(), other.serverSideEncryptionKmsKeyId())
                && Objects.equals(timeFormat(), other.timeFormat()) && Objects.equals(trimBlanks(), other.trimBlanks())
                && Objects.equals(truncateColumns(), other.truncateColumns()) && Objects.equals(username(), other.username())
                && Objects.equals(writeBufferSize(), other.writeBufferSize())
                && Objects.equals(secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn())
                && Objects.equals(secretsManagerSecretId(), other.secretsManagerSecretId())
                && Objects.equals(mapBooleanAsBoolean(), other.mapBooleanAsBoolean());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftSettings").add("AcceptAnyDate", acceptAnyDate())
                .add("AfterConnectScript", afterConnectScript()).add("BucketFolder", bucketFolder())
                .add("BucketName", bucketName()).add("CaseSensitiveNames", caseSensitiveNames()).add("CompUpdate", compUpdate())
                .add("ConnectionTimeout", connectionTimeout()).add("DatabaseName", databaseName())
                .add("DateFormat", dateFormat()).add("EmptyAsNull", emptyAsNull())
                .add("EncryptionMode", encryptionModeAsString()).add("ExplicitIds", explicitIds())
                .add("FileTransferUploadStreams", fileTransferUploadStreams()).add("LoadTimeout", loadTimeout())
                .add("MaxFileSize", maxFileSize()).add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Port", port()).add("RemoveQuotes", removeQuotes()).add("ReplaceInvalidChars", replaceInvalidChars())
                .add("ReplaceChars", replaceChars()).add("ServerName", serverName())
                .add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("ServerSideEncryptionKmsKeyId", serverSideEncryptionKmsKeyId()).add("TimeFormat", timeFormat())
                .add("TrimBlanks", trimBlanks()).add("TruncateColumns", truncateColumns()).add("Username", username())
                .add("WriteBufferSize", writeBufferSize()).add("SecretsManagerAccessRoleArn", secretsManagerAccessRoleArn())
                .add("SecretsManagerSecretId", secretsManagerSecretId()).add("MapBooleanAsBoolean", mapBooleanAsBoolean())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptAnyDate":
            return Optional.ofNullable(clazz.cast(acceptAnyDate()));
        case "AfterConnectScript":
            return Optional.ofNullable(clazz.cast(afterConnectScript()));
        case "BucketFolder":
            return Optional.ofNullable(clazz.cast(bucketFolder()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "CaseSensitiveNames":
            return Optional.ofNullable(clazz.cast(caseSensitiveNames()));
        case "CompUpdate":
            return Optional.ofNullable(clazz.cast(compUpdate()));
        case "ConnectionTimeout":
            return Optional.ofNullable(clazz.cast(connectionTimeout()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "DateFormat":
            return Optional.ofNullable(clazz.cast(dateFormat()));
        case "EmptyAsNull":
            return Optional.ofNullable(clazz.cast(emptyAsNull()));
        case "EncryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionModeAsString()));
        case "ExplicitIds":
            return Optional.ofNullable(clazz.cast(explicitIds()));
        case "FileTransferUploadStreams":
            return Optional.ofNullable(clazz.cast(fileTransferUploadStreams()));
        case "LoadTimeout":
            return Optional.ofNullable(clazz.cast(loadTimeout()));
        case "MaxFileSize":
            return Optional.ofNullable(clazz.cast(maxFileSize()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "RemoveQuotes":
            return Optional.ofNullable(clazz.cast(removeQuotes()));
        case "ReplaceInvalidChars":
            return Optional.ofNullable(clazz.cast(replaceInvalidChars()));
        case "ReplaceChars":
            return Optional.ofNullable(clazz.cast(replaceChars()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "ServerSideEncryptionKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionKmsKeyId()));
        case "TimeFormat":
            return Optional.ofNullable(clazz.cast(timeFormat()));
        case "TrimBlanks":
            return Optional.ofNullable(clazz.cast(trimBlanks()));
        case "TruncateColumns":
            return Optional.ofNullable(clazz.cast(truncateColumns()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "WriteBufferSize":
            return Optional.ofNullable(clazz.cast(writeBufferSize()));
        case "SecretsManagerAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretsManagerAccessRoleArn()));
        case "SecretsManagerSecretId":
            return Optional.ofNullable(clazz.cast(secretsManagerSecretId()));
        case "MapBooleanAsBoolean":
            return Optional.ofNullable(clazz.cast(mapBooleanAsBoolean()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptAnyDate", ACCEPT_ANY_DATE_FIELD);
        map.put("AfterConnectScript", AFTER_CONNECT_SCRIPT_FIELD);
        map.put("BucketFolder", BUCKET_FOLDER_FIELD);
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("CaseSensitiveNames", CASE_SENSITIVE_NAMES_FIELD);
        map.put("CompUpdate", COMP_UPDATE_FIELD);
        map.put("ConnectionTimeout", CONNECTION_TIMEOUT_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("DateFormat", DATE_FORMAT_FIELD);
        map.put("EmptyAsNull", EMPTY_AS_NULL_FIELD);
        map.put("EncryptionMode", ENCRYPTION_MODE_FIELD);
        map.put("ExplicitIds", EXPLICIT_IDS_FIELD);
        map.put("FileTransferUploadStreams", FILE_TRANSFER_UPLOAD_STREAMS_FIELD);
        map.put("LoadTimeout", LOAD_TIMEOUT_FIELD);
        map.put("MaxFileSize", MAX_FILE_SIZE_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("RemoveQuotes", REMOVE_QUOTES_FIELD);
        map.put("ReplaceInvalidChars", REPLACE_INVALID_CHARS_FIELD);
        map.put("ReplaceChars", REPLACE_CHARS_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("ServiceAccessRoleArn", SERVICE_ACCESS_ROLE_ARN_FIELD);
        map.put("ServerSideEncryptionKmsKeyId", SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD);
        map.put("TimeFormat", TIME_FORMAT_FIELD);
        map.put("TrimBlanks", TRIM_BLANKS_FIELD);
        map.put("TruncateColumns", TRUNCATE_COLUMNS_FIELD);
        map.put("Username", USERNAME_FIELD);
        map.put("WriteBufferSize", WRITE_BUFFER_SIZE_FIELD);
        map.put("SecretsManagerAccessRoleArn", SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD);
        map.put("SecretsManagerSecretId", SECRETS_MANAGER_SECRET_ID_FIELD);
        map.put("MapBooleanAsBoolean", MAP_BOOLEAN_AS_BOOLEAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftSettings, T> g) {
        return obj -> g.apply((RedshiftSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftSettings> {
        /**
         * <p>
         * A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be
         * loaded without generating an error. You can choose <code>true</code> or <code>false</code> (the default).
         * </p>
         * <p>
         * This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT
         * parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift
         * inserts a NULL value into that field.
         * </p>
         * 
         * @param acceptAnyDate
         *        A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00,
         *        to be loaded without generating an error. You can choose <code>true</code> or <code>false</code> (the
         *        default).</p>
         *        <p>
         *        This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the
         *        DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT specification,
         *        Amazon Redshift inserts a NULL value into that field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptAnyDate(Boolean acceptAnyDate);

        /**
         * <p>
         * Code to run after connecting. This parameter should contain the code itself, not the name of a file
         * containing the code.
         * </p>
         * 
         * @param afterConnectScript
         *        Code to run after connecting. This parameter should contain the code itself, not the name of a file
         *        containing the code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterConnectScript(String afterConnectScript);

        /**
         * <p>
         * An S3 folder where the comma-separated-value (.csv) files are stored before being uploaded to the target
         * Redshift cluster.
         * </p>
         * <p>
         * For full load mode, DMS converts source records into .csv files and loads them to the
         * <i>BucketFolder/TableID</i> path. DMS uses the Redshift <code>COPY</code> command to upload the .csv files to
         * the target table. The files are deleted once the <code>COPY</code> operation has finished. For more
         * information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the
         * <i>Amazon Redshift Database Developer Guide</i>.
         * </p>
         * <p>
         * For change-data-capture (CDC) mode, DMS creates a <i>NetChanges</i> table, and loads the .csv files to this
         * <i>BucketFolder/NetChangesTableID</i> path.
         * </p>
         * 
         * @param bucketFolder
         *        An S3 folder where the comma-separated-value (.csv) files are stored before being uploaded to the
         *        target Redshift cluster. </p>
         *        <p>
         *        For full load mode, DMS converts source records into .csv files and loads them to the
         *        <i>BucketFolder/TableID</i> path. DMS uses the Redshift <code>COPY</code> command to upload the .csv
         *        files to the target table. The files are deleted once the <code>COPY</code> operation has finished.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the <i>Amazon Redshift
         *        Database Developer Guide</i>.
         *        </p>
         *        <p>
         *        For change-data-capture (CDC) mode, DMS creates a <i>NetChanges</i> table, and loads the .csv files to
         *        this <i>BucketFolder/NetChangesTableID</i> path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketFolder(String bucketFolder);

        /**
         * <p>
         * The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.
         * </p>
         * 
         * @param bucketName
         *        The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * If Amazon Redshift is configured to support case sensitive schema names, set <code>CaseSensitiveNames</code>
         * to <code>true</code>. The default is <code>false</code>.
         * </p>
         * 
         * @param caseSensitiveNames
         *        If Amazon Redshift is configured to support case sensitive schema names, set
         *        <code>CaseSensitiveNames</code> to <code>true</code>. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseSensitiveNames(Boolean caseSensitiveNames);

        /**
         * <p>
         * If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies automatic compression if the
         * table is empty. This applies even if the table columns already have encodings other than <code>RAW</code>. If
         * you set <code>CompUpdate</code> to <code>false</code>, automatic compression is disabled and existing column
         * encodings aren't changed. The default is <code>true</code>.
         * </p>
         * 
         * @param compUpdate
         *        If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies automatic compression
         *        if the table is empty. This applies even if the table columns already have encodings other than
         *        <code>RAW</code>. If you set <code>CompUpdate</code> to <code>false</code>, automatic compression is
         *        disabled and existing column encodings aren't changed. The default is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compUpdate(Boolean compUpdate);

        /**
         * <p>
         * A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you
         * initially establish a connection.
         * </p>
         * 
         * @param connectionTimeout
         *        A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when
         *        you initially establish a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTimeout(Integer connectionTimeout);

        /**
         * <p>
         * The name of the Amazon Redshift data warehouse (service) that you are working with.
         * </p>
         * 
         * @param databaseName
         *        The name of the Amazon Redshift data warehouse (service) that you are working with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The date format that you are using. Valid values are <code>auto</code> (case-sensitive), your date format
         * string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of
         * 'YYYY-MM-DD'. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a
         * date format string.
         * </p>
         * <p>
         * If your date and time values use formats different from each other, set this to <code>auto</code>.
         * </p>
         * 
         * @param dateFormat
         *        The date format that you are using. Valid values are <code>auto</code> (case-sensitive), your date
         *        format string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a
         *        format of 'YYYY-MM-DD'. Using <code>auto</code> recognizes most strings, even some that aren't
         *        supported when you use a date format string. </p>
         *        <p>
         *        If your date and time values use formats different from each other, set this to <code>auto</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFormat(String dateFormat);

        /**
         * <p>
         * A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of
         * <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code>.
         * </p>
         * 
         * @param emptyAsNull
         *        A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of
         *        <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emptyAsNull(Boolean emptyAsNull);

        /**
         * <p>
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the
         * endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         * <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>.
         * </p>
         * <note>
         * <p>
         * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
         * <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change
         * the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
         * </p>
         * </note>
         * <p>
         * To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with a policy that allows
         * <code>"arn:aws:s3:::*"</code> to use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
         * </p>
         * 
         * @param encryptionMode
         *        The type of server-side encryption that you want to use for your data. This encryption type is part of
         *        the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         *        <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note>
         *        <p>
         *        For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
         *        <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t
         *        change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
         *        </p>
         *        </note>
         *        <p>
         *        To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with a policy that
         *        allows <code>"arn:aws:s3:::*"</code> to use the following actions:
         *        <code>"s3:PutObject", "s3:ListBucket"</code>
         * @see EncryptionModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionModeValue
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the
         * endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         * <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>.
         * </p>
         * <note>
         * <p>
         * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
         * <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change
         * the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
         * </p>
         * </note>
         * <p>
         * To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with a policy that allows
         * <code>"arn:aws:s3:::*"</code> to use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
         * </p>
         * 
         * @param encryptionMode
         *        The type of server-side encryption that you want to use for your data. This encryption type is part of
         *        the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         *        <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note>
         *        <p>
         *        For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
         *        <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t
         *        change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
         *        </p>
         *        </note>
         *        <p>
         *        To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with a policy that
         *        allows <code>"arn:aws:s3:::*"</code> to use the following actions:
         *        <code>"s3:PutObject", "s3:ListBucket"</code>
         * @see EncryptionModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionModeValue
         */
        Builder encryptionMode(EncryptionModeValue encryptionMode);

        /**
         * <p>
         * This setting is only valid for a full-load migration task. Set <code>ExplicitIds</code> to <code>true</code>
         * to have tables with <code>IDENTITY</code> columns override their auto-generated values with explicit values
         * loaded from the source data files used to populate the tables. The default is <code>false</code>.
         * </p>
         * 
         * @param explicitIds
         *        This setting is only valid for a full-load migration task. Set <code>ExplicitIds</code> to
         *        <code>true</code> to have tables with <code>IDENTITY</code> columns override their auto-generated
         *        values with explicit values loaded from the source data files used to populate the tables. The default
         *        is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitIds(Boolean explicitIds);

        /**
         * <p>
         * The number of threads used to upload a single file. This parameter accepts a value from 1 through 64. It
         * defaults to 10.
         * </p>
         * <p>
         * The number of parallel streams used to upload a single .csv file to an S3 bucket using S3 Multipart Upload.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload overview</a>.
         * </p>
         * <p>
         * <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It defaults to 10.
         * </p>
         * 
         * @param fileTransferUploadStreams
         *        The number of threads used to upload a single file. This parameter accepts a value from 1 through 64.
         *        It defaults to 10.</p>
         *        <p>
         *        The number of parallel streams used to upload a single .csv file to an S3 bucket using S3 Multipart
         *        Upload. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload overview</a>.
         *        </p>
         *        <p>
         *        <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It defaults to 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileTransferUploadStreams(Integer fileTransferUploadStreams);

        /**
         * <p>
         * The amount of time to wait (in milliseconds) before timing out of operations performed by DMS on a Redshift
         * cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.
         * </p>
         * 
         * @param loadTimeout
         *        The amount of time to wait (in milliseconds) before timing out of operations performed by DMS on a
         *        Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadTimeout(Integer loadTimeout);

        /**
         * <p>
         * The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer data to Amazon
         * Redshift. It defaults to 1048576KB (1 GB).
         * </p>
         * 
         * @param maxFileSize
         *        The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer data to
         *        Amazon Redshift. It defaults to 1048576KB (1 GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFileSize(Integer maxFileSize);

        /**
         * <p>
         * The password for the user named in the <code>username</code> property.
         * </p>
         * 
         * @param password
         *        The password for the user named in the <code>username</code> property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The port number for Amazon Redshift. The default value is 5439.
         * </p>
         * 
         * @param port
         *        The port number for Amazon Redshift. The default value is 5439.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * A value that specifies to remove surrounding quotation marks from strings in the incoming data. All
         * characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to remove
         * quotation marks. The default is <code>false</code>.
         * </p>
         * 
         * @param removeQuotes
         *        A value that specifies to remove surrounding quotation marks from strings in the incoming data. All
         *        characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to
         *        remove quotation marks. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeQuotes(Boolean removeQuotes);

        /**
         * <p>
         * A list of characters that you want to replace. Use with <code>ReplaceChars</code>.
         * </p>
         * 
         * @param replaceInvalidChars
         *        A list of characters that you want to replace. Use with <code>ReplaceChars</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceInvalidChars(String replaceInvalidChars);

        /**
         * <p>
         * A value that specifies to replaces the invalid characters specified in <code>ReplaceInvalidChars</code>,
         * substituting the specified characters instead. The default is <code>"?"</code>.
         * </p>
         * 
         * @param replaceChars
         *        A value that specifies to replaces the invalid characters specified in
         *        <code>ReplaceInvalidChars</code>, substituting the specified characters instead. The default is
         *        <code>"?"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceChars(String replaceChars);

        /**
         * <p>
         * The name of the Amazon Redshift cluster you are using.
         * </p>
         * 
         * @param serverName
         *        The name of the Amazon Redshift cluster you are using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service. The role must
         * allow the <code>iam:PassRole</code> action.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service. The
         *        role must allow the <code>iam:PassRole</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * The KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide this key
         * ID. The key that you use needs an attached policy that enables IAM user permissions and allows use of the
         * key.
         * </p>
         * 
         * @param serverSideEncryptionKmsKeyId
         *        The KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide
         *        this key ID. The key that you use needs an attached policy that enables IAM user permissions and
         *        allows use of the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId);

        /**
         * <p>
         * The time format that you want to use. Valid values are <code>auto</code> (case-sensitive),
         * <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or <code>'epochmillisecs'</code>. It defaults to
         * 10. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a time
         * format string.
         * </p>
         * <p>
         * If your date and time values use formats different from each other, set this parameter to <code>auto</code>.
         * </p>
         * 
         * @param timeFormat
         *        The time format that you want to use. Valid values are <code>auto</code> (case-sensitive),
         *        <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or <code>'epochmillisecs'</code>. It
         *        defaults to 10. Using <code>auto</code> recognizes most strings, even some that aren't supported when
         *        you use a time format string. </p>
         *        <p>
         *        If your date and time values use formats different from each other, set this parameter to
         *        <code>auto</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeFormat(String timeFormat);

        /**
         * <p>
         * A value that specifies to remove the trailing white space characters from a VARCHAR string. This parameter
         * applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded white space.
         * The default is <code>false</code>.
         * </p>
         * 
         * @param trimBlanks
         *        A value that specifies to remove the trailing white space characters from a VARCHAR string. This
         *        parameter applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove
         *        unneeded white space. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trimBlanks(Boolean trimBlanks);

        /**
         * <p>
         * A value that specifies to truncate data in columns to the appropriate number of characters, so that the data
         * fits in the column. This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a
         * size of 4 MB or less. Choose <code>true</code> to truncate data. The default is <code>false</code>.
         * </p>
         * 
         * @param truncateColumns
         *        A value that specifies to truncate data in columns to the appropriate number of characters, so that
         *        the data fits in the column. This parameter applies only to columns with a VARCHAR or CHAR data type,
         *        and rows with a size of 4 MB or less. Choose <code>true</code> to truncate data. The default is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truncateColumns(Boolean truncateColumns);

        /**
         * <p>
         * An Amazon Redshift user name for a registered user.
         * </p>
         * 
         * @param username
         *        An Amazon Redshift user name for a registered user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk at the
         * DMS replication instance. The default value is 1000 (buffer size is 1000KB).
         * </p>
         * 
         * @param writeBufferSize
         *        The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk
         *        at the DMS replication instance. The default value is 1000 (buffer size is 1000KB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeBufferSize(Integer writeBufferSize);

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the
         * required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the
         * <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services
         * Secrets Manager secret that allows access to the Amazon Redshift endpoint.
         * </p>
         * <note>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting
         * and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
         * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
         * information on creating this <code>SecretsManagerSecret</code> and the
         * <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see
         * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">
         * Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param secretsManagerAccessRoleArn
         *        The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and
         *        grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role
         *        must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of
         *        the Amazon Web Services Secrets Manager secret that allows access to the Amazon Redshift endpoint.</p>
         *        <note>
         *        <p>
         *        You can specify one of two sets of values for these permissions. You can specify the values for this
         *        setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
         *        <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You
         *        can't specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
         *        <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access
         *        it, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
         *        >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
         *        User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn);

        /**
         * <p>
         * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Amazon
         * Redshift endpoint connection details.
         * </p>
         * 
         * @param secretsManagerSecretId
         *        The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
         *        Amazon Redshift endpoint connection details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecretId(String secretsManagerSecretId);

        /**
         * <p>
         * When true, lets Redshift migrate the boolean type as boolean. By default, Redshift migrates booleans as
         * <code>varchar(1)</code>. You must set this setting on both the source and target endpoints for it to take
         * effect.
         * </p>
         * 
         * @param mapBooleanAsBoolean
         *        When true, lets Redshift migrate the boolean type as boolean. By default, Redshift migrates booleans
         *        as <code>varchar(1)</code>. You must set this setting on both the source and target endpoints for it
         *        to take effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapBooleanAsBoolean(Boolean mapBooleanAsBoolean);
    }

    static final class BuilderImpl implements Builder {
        private Boolean acceptAnyDate;

        private String afterConnectScript;

        private String bucketFolder;

        private String bucketName;

        private Boolean caseSensitiveNames;

        private Boolean compUpdate;

        private Integer connectionTimeout;

        private String databaseName;

        private String dateFormat;

        private Boolean emptyAsNull;

        private String encryptionMode;

        private Boolean explicitIds;

        private Integer fileTransferUploadStreams;

        private Integer loadTimeout;

        private Integer maxFileSize;

        private String password;

        private Integer port;

        private Boolean removeQuotes;

        private String replaceInvalidChars;

        private String replaceChars;

        private String serverName;

        private String serviceAccessRoleArn;

        private String serverSideEncryptionKmsKeyId;

        private String timeFormat;

        private Boolean trimBlanks;

        private Boolean truncateColumns;

        private String username;

        private Integer writeBufferSize;

        private String secretsManagerAccessRoleArn;

        private String secretsManagerSecretId;

        private Boolean mapBooleanAsBoolean;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftSettings model) {
            acceptAnyDate(model.acceptAnyDate);
            afterConnectScript(model.afterConnectScript);
            bucketFolder(model.bucketFolder);
            bucketName(model.bucketName);
            caseSensitiveNames(model.caseSensitiveNames);
            compUpdate(model.compUpdate);
            connectionTimeout(model.connectionTimeout);
            databaseName(model.databaseName);
            dateFormat(model.dateFormat);
            emptyAsNull(model.emptyAsNull);
            encryptionMode(model.encryptionMode);
            explicitIds(model.explicitIds);
            fileTransferUploadStreams(model.fileTransferUploadStreams);
            loadTimeout(model.loadTimeout);
            maxFileSize(model.maxFileSize);
            password(model.password);
            port(model.port);
            removeQuotes(model.removeQuotes);
            replaceInvalidChars(model.replaceInvalidChars);
            replaceChars(model.replaceChars);
            serverName(model.serverName);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            serverSideEncryptionKmsKeyId(model.serverSideEncryptionKmsKeyId);
            timeFormat(model.timeFormat);
            trimBlanks(model.trimBlanks);
            truncateColumns(model.truncateColumns);
            username(model.username);
            writeBufferSize(model.writeBufferSize);
            secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            secretsManagerSecretId(model.secretsManagerSecretId);
            mapBooleanAsBoolean(model.mapBooleanAsBoolean);
        }

        public final Boolean getAcceptAnyDate() {
            return acceptAnyDate;
        }

        public final void setAcceptAnyDate(Boolean acceptAnyDate) {
            this.acceptAnyDate = acceptAnyDate;
        }

        @Override
        public final Builder acceptAnyDate(Boolean acceptAnyDate) {
            this.acceptAnyDate = acceptAnyDate;
            return this;
        }

        public final String getAfterConnectScript() {
            return afterConnectScript;
        }

        public final void setAfterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
        }

        @Override
        public final Builder afterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
            return this;
        }

        public final String getBucketFolder() {
            return bucketFolder;
        }

        public final void setBucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
        }

        @Override
        public final Builder bucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final Boolean getCaseSensitiveNames() {
            return caseSensitiveNames;
        }

        public final void setCaseSensitiveNames(Boolean caseSensitiveNames) {
            this.caseSensitiveNames = caseSensitiveNames;
        }

        @Override
        public final Builder caseSensitiveNames(Boolean caseSensitiveNames) {
            this.caseSensitiveNames = caseSensitiveNames;
            return this;
        }

        public final Boolean getCompUpdate() {
            return compUpdate;
        }

        public final void setCompUpdate(Boolean compUpdate) {
            this.compUpdate = compUpdate;
        }

        @Override
        public final Builder compUpdate(Boolean compUpdate) {
            this.compUpdate = compUpdate;
            return this;
        }

        public final Integer getConnectionTimeout() {
            return connectionTimeout;
        }

        public final void setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        @Override
        public final Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDateFormat() {
            return dateFormat;
        }

        public final void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public final Boolean getEmptyAsNull() {
            return emptyAsNull;
        }

        public final void setEmptyAsNull(Boolean emptyAsNull) {
            this.emptyAsNull = emptyAsNull;
        }

        @Override
        public final Builder emptyAsNull(Boolean emptyAsNull) {
            this.emptyAsNull = emptyAsNull;
            return this;
        }

        public final String getEncryptionMode() {
            return encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionModeValue encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final Boolean getExplicitIds() {
            return explicitIds;
        }

        public final void setExplicitIds(Boolean explicitIds) {
            this.explicitIds = explicitIds;
        }

        @Override
        public final Builder explicitIds(Boolean explicitIds) {
            this.explicitIds = explicitIds;
            return this;
        }

        public final Integer getFileTransferUploadStreams() {
            return fileTransferUploadStreams;
        }

        public final void setFileTransferUploadStreams(Integer fileTransferUploadStreams) {
            this.fileTransferUploadStreams = fileTransferUploadStreams;
        }

        @Override
        public final Builder fileTransferUploadStreams(Integer fileTransferUploadStreams) {
            this.fileTransferUploadStreams = fileTransferUploadStreams;
            return this;
        }

        public final Integer getLoadTimeout() {
            return loadTimeout;
        }

        public final void setLoadTimeout(Integer loadTimeout) {
            this.loadTimeout = loadTimeout;
        }

        @Override
        public final Builder loadTimeout(Integer loadTimeout) {
            this.loadTimeout = loadTimeout;
            return this;
        }

        public final Integer getMaxFileSize() {
            return maxFileSize;
        }

        public final void setMaxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        @Override
        public final Builder maxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getRemoveQuotes() {
            return removeQuotes;
        }

        public final void setRemoveQuotes(Boolean removeQuotes) {
            this.removeQuotes = removeQuotes;
        }

        @Override
        public final Builder removeQuotes(Boolean removeQuotes) {
            this.removeQuotes = removeQuotes;
            return this;
        }

        public final String getReplaceInvalidChars() {
            return replaceInvalidChars;
        }

        public final void setReplaceInvalidChars(String replaceInvalidChars) {
            this.replaceInvalidChars = replaceInvalidChars;
        }

        @Override
        public final Builder replaceInvalidChars(String replaceInvalidChars) {
            this.replaceInvalidChars = replaceInvalidChars;
            return this;
        }

        public final String getReplaceChars() {
            return replaceChars;
        }

        public final void setReplaceChars(String replaceChars) {
            this.replaceChars = replaceChars;
        }

        @Override
        public final Builder replaceChars(String replaceChars) {
            this.replaceChars = replaceChars;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getServerSideEncryptionKmsKeyId() {
            return serverSideEncryptionKmsKeyId;
        }

        public final void setServerSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        }

        @Override
        public final Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
            return this;
        }

        public final String getTimeFormat() {
            return timeFormat;
        }

        public final void setTimeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
        }

        @Override
        public final Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public final Boolean getTrimBlanks() {
            return trimBlanks;
        }

        public final void setTrimBlanks(Boolean trimBlanks) {
            this.trimBlanks = trimBlanks;
        }

        @Override
        public final Builder trimBlanks(Boolean trimBlanks) {
            this.trimBlanks = trimBlanks;
            return this;
        }

        public final Boolean getTruncateColumns() {
            return truncateColumns;
        }

        public final void setTruncateColumns(Boolean truncateColumns) {
            this.truncateColumns = truncateColumns;
        }

        @Override
        public final Builder truncateColumns(Boolean truncateColumns) {
            this.truncateColumns = truncateColumns;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Integer getWriteBufferSize() {
            return writeBufferSize;
        }

        public final void setWriteBufferSize(Integer writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
        }

        @Override
        public final Builder writeBufferSize(Integer writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final Boolean getMapBooleanAsBoolean() {
            return mapBooleanAsBoolean;
        }

        public final void setMapBooleanAsBoolean(Boolean mapBooleanAsBoolean) {
            this.mapBooleanAsBoolean = mapBooleanAsBoolean;
        }

        @Override
        public final Builder mapBooleanAsBoolean(Boolean mapBooleanAsBoolean) {
            this.mapBooleanAsBoolean = mapBooleanAsBoolean;
            return this;
        }

        @Override
        public RedshiftSettings build() {
            return new RedshiftSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
