/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object provides configuration information about a serverless replication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationConfig.Builder, ReplicationConfig> {
    private static final SdkField<String> REPLICATION_CONFIG_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationConfigIdentifier")
            .getter(getter(ReplicationConfig::replicationConfigIdentifier))
            .setter(setter(Builder::replicationConfigIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigIdentifier")
                    .build()).build();

    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationConfigArn").getter(getter(ReplicationConfig::replicationConfigArn))
            .setter(setter(Builder::replicationConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build())
            .build();

    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEndpointArn").getter(getter(ReplicationConfig::sourceEndpointArn))
            .setter(setter(Builder::sourceEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()).build();

    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetEndpointArn").getter(getter(ReplicationConfig::targetEndpointArn))
            .setter(setter(Builder::targetEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()).build();

    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationType").getter(getter(ReplicationConfig::replicationTypeAsString))
            .setter(setter(Builder::replicationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationType").build()).build();

    private static final SdkField<ComputeConfig> COMPUTE_CONFIG_FIELD = SdkField
            .<ComputeConfig> builder(MarshallingType.SDK_POJO).memberName("ComputeConfig")
            .getter(getter(ReplicationConfig::computeConfig)).setter(setter(Builder::computeConfig))
            .constructor(ComputeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeConfig").build()).build();

    private static final SdkField<String> REPLICATION_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSettings").getter(getter(ReplicationConfig::replicationSettings))
            .setter(setter(Builder::replicationSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSettings").build())
            .build();

    private static final SdkField<String> SUPPLEMENTAL_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupplementalSettings").getter(getter(ReplicationConfig::supplementalSettings))
            .setter(setter(Builder::supplementalSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalSettings").build())
            .build();

    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableMappings").getter(getter(ReplicationConfig::tableMappings)).setter(setter(Builder::tableMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()).build();

    private static final SdkField<Instant> REPLICATION_CONFIG_CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplicationConfigCreateTime")
            .getter(getter(ReplicationConfig::replicationConfigCreateTime))
            .setter(setter(Builder::replicationConfigCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigCreateTime")
                    .build()).build();

    private static final SdkField<Instant> REPLICATION_CONFIG_UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplicationConfigUpdateTime")
            .getter(getter(ReplicationConfig::replicationConfigUpdateTime))
            .setter(setter(Builder::replicationConfigUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigUpdateTime")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_CONFIG_IDENTIFIER_FIELD, REPLICATION_CONFIG_ARN_FIELD, SOURCE_ENDPOINT_ARN_FIELD,
            TARGET_ENDPOINT_ARN_FIELD, REPLICATION_TYPE_FIELD, COMPUTE_CONFIG_FIELD, REPLICATION_SETTINGS_FIELD,
            SUPPLEMENTAL_SETTINGS_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_CONFIG_CREATE_TIME_FIELD,
            REPLICATION_CONFIG_UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String replicationConfigIdentifier;

    private final String replicationConfigArn;

    private final String sourceEndpointArn;

    private final String targetEndpointArn;

    private final String replicationType;

    private final ComputeConfig computeConfig;

    private final String replicationSettings;

    private final String supplementalSettings;

    private final String tableMappings;

    private final Instant replicationConfigCreateTime;

    private final Instant replicationConfigUpdateTime;

    private ReplicationConfig(BuilderImpl builder) {
        this.replicationConfigIdentifier = builder.replicationConfigIdentifier;
        this.replicationConfigArn = builder.replicationConfigArn;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.replicationType = builder.replicationType;
        this.computeConfig = builder.computeConfig;
        this.replicationSettings = builder.replicationSettings;
        this.supplementalSettings = builder.supplementalSettings;
        this.tableMappings = builder.tableMappings;
        this.replicationConfigCreateTime = builder.replicationConfigCreateTime;
        this.replicationConfigUpdateTime = builder.replicationConfigUpdateTime;
    }

    /**
     * <p>
     * The identifier for the <code>ReplicationConfig</code> associated with the replication.
     * </p>
     * 
     * @return The identifier for the <code>ReplicationConfig</code> associated with the replication.
     */
    public final String replicationConfigIdentifier() {
        return replicationConfigIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this DMS Serverless replication configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this DMS Serverless replication configuration.
     */
    public final String replicationConfigArn() {
        return replicationConfigArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source endpoint for this DMS serverless replication configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source endpoint for this DMS serverless replication configuration.
     */
    public final String sourceEndpointArn() {
        return sourceEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication configuration.
     */
    public final String targetEndpointArn() {
        return targetEndpointArn;
    }

    /**
     * <p>
     * The type of the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return The type of the replication.
     * @see MigrationTypeValue
     */
    public final MigrationTypeValue replicationType() {
        return MigrationTypeValue.fromValue(replicationType);
    }

    /**
     * <p>
     * The type of the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return The type of the replication.
     * @see MigrationTypeValue
     */
    public final String replicationTypeAsString() {
        return replicationType;
    }

    /**
     * <p>
     * Configuration parameters for provisioning an DMS serverless replication.
     * </p>
     * 
     * @return Configuration parameters for provisioning an DMS serverless replication.
     */
    public final ComputeConfig computeConfig() {
        return computeConfig;
    }

    /**
     * <p>
     * Configuration parameters for an DMS serverless replication.
     * </p>
     * 
     * @return Configuration parameters for an DMS serverless replication.
     */
    public final String replicationSettings() {
        return replicationSettings;
    }

    /**
     * <p>
     * Additional parameters for an DMS serverless replication.
     * </p>
     * 
     * @return Additional parameters for an DMS serverless replication.
     */
    public final String supplementalSettings() {
        return supplementalSettings;
    }

    /**
     * <p>
     * Table mappings specified in the replication.
     * </p>
     * 
     * @return Table mappings specified in the replication.
     */
    public final String tableMappings() {
        return tableMappings;
    }

    /**
     * <p>
     * The time the serverless replication config was created.
     * </p>
     * 
     * @return The time the serverless replication config was created.
     */
    public final Instant replicationConfigCreateTime() {
        return replicationConfigCreateTime;
    }

    /**
     * <p>
     * The time the serverless replication config was updated.
     * </p>
     * 
     * @return The time the serverless replication config was updated.
     */
    public final Instant replicationConfigUpdateTime() {
        return replicationConfigUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(computeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(supplementalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfig)) {
            return false;
        }
        ReplicationConfig other = (ReplicationConfig) obj;
        return Objects.equals(replicationConfigIdentifier(), other.replicationConfigIdentifier())
                && Objects.equals(replicationConfigArn(), other.replicationConfigArn())
                && Objects.equals(sourceEndpointArn(), other.sourceEndpointArn())
                && Objects.equals(targetEndpointArn(), other.targetEndpointArn())
                && Objects.equals(replicationTypeAsString(), other.replicationTypeAsString())
                && Objects.equals(computeConfig(), other.computeConfig())
                && Objects.equals(replicationSettings(), other.replicationSettings())
                && Objects.equals(supplementalSettings(), other.supplementalSettings())
                && Objects.equals(tableMappings(), other.tableMappings())
                && Objects.equals(replicationConfigCreateTime(), other.replicationConfigCreateTime())
                && Objects.equals(replicationConfigUpdateTime(), other.replicationConfigUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationConfig").add("ReplicationConfigIdentifier", replicationConfigIdentifier())
                .add("ReplicationConfigArn", replicationConfigArn()).add("SourceEndpointArn", sourceEndpointArn())
                .add("TargetEndpointArn", targetEndpointArn()).add("ReplicationType", replicationTypeAsString())
                .add("ComputeConfig", computeConfig()).add("ReplicationSettings", replicationSettings())
                .add("SupplementalSettings", supplementalSettings()).add("TableMappings", tableMappings())
                .add("ReplicationConfigCreateTime", replicationConfigCreateTime())
                .add("ReplicationConfigUpdateTime", replicationConfigUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationConfigIdentifier":
            return Optional.ofNullable(clazz.cast(replicationConfigIdentifier()));
        case "ReplicationConfigArn":
            return Optional.ofNullable(clazz.cast(replicationConfigArn()));
        case "SourceEndpointArn":
            return Optional.ofNullable(clazz.cast(sourceEndpointArn()));
        case "TargetEndpointArn":
            return Optional.ofNullable(clazz.cast(targetEndpointArn()));
        case "ReplicationType":
            return Optional.ofNullable(clazz.cast(replicationTypeAsString()));
        case "ComputeConfig":
            return Optional.ofNullable(clazz.cast(computeConfig()));
        case "ReplicationSettings":
            return Optional.ofNullable(clazz.cast(replicationSettings()));
        case "SupplementalSettings":
            return Optional.ofNullable(clazz.cast(supplementalSettings()));
        case "TableMappings":
            return Optional.ofNullable(clazz.cast(tableMappings()));
        case "ReplicationConfigCreateTime":
            return Optional.ofNullable(clazz.cast(replicationConfigCreateTime()));
        case "ReplicationConfigUpdateTime":
            return Optional.ofNullable(clazz.cast(replicationConfigUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationConfigIdentifier", REPLICATION_CONFIG_IDENTIFIER_FIELD);
        map.put("ReplicationConfigArn", REPLICATION_CONFIG_ARN_FIELD);
        map.put("SourceEndpointArn", SOURCE_ENDPOINT_ARN_FIELD);
        map.put("TargetEndpointArn", TARGET_ENDPOINT_ARN_FIELD);
        map.put("ReplicationType", REPLICATION_TYPE_FIELD);
        map.put("ComputeConfig", COMPUTE_CONFIG_FIELD);
        map.put("ReplicationSettings", REPLICATION_SETTINGS_FIELD);
        map.put("SupplementalSettings", SUPPLEMENTAL_SETTINGS_FIELD);
        map.put("TableMappings", TABLE_MAPPINGS_FIELD);
        map.put("ReplicationConfigCreateTime", REPLICATION_CONFIG_CREATE_TIME_FIELD);
        map.put("ReplicationConfigUpdateTime", REPLICATION_CONFIG_UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationConfig, T> g) {
        return obj -> g.apply((ReplicationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationConfig> {
        /**
         * <p>
         * The identifier for the <code>ReplicationConfig</code> associated with the replication.
         * </p>
         * 
         * @param replicationConfigIdentifier
         *        The identifier for the <code>ReplicationConfig</code> associated with the replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigIdentifier(String replicationConfigIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of this DMS Serverless replication configuration.
         * </p>
         * 
         * @param replicationConfigArn
         *        The Amazon Resource Name (ARN) of this DMS Serverless replication configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigArn(String replicationConfigArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source endpoint for this DMS serverless replication configuration.
         * </p>
         * 
         * @param sourceEndpointArn
         *        The Amazon Resource Name (ARN) of the source endpoint for this DMS serverless replication
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEndpointArn(String sourceEndpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication configuration.
         * </p>
         * 
         * @param targetEndpointArn
         *        The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEndpointArn(String targetEndpointArn);

        /**
         * <p>
         * The type of the replication.
         * </p>
         * 
         * @param replicationType
         *        The type of the replication.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder replicationType(String replicationType);

        /**
         * <p>
         * The type of the replication.
         * </p>
         * 
         * @param replicationType
         *        The type of the replication.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder replicationType(MigrationTypeValue replicationType);

        /**
         * <p>
         * Configuration parameters for provisioning an DMS serverless replication.
         * </p>
         * 
         * @param computeConfig
         *        Configuration parameters for provisioning an DMS serverless replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeConfig(ComputeConfig computeConfig);

        /**
         * <p>
         * Configuration parameters for provisioning an DMS serverless replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeConfig.Builder} avoiding the need
         * to create one manually via {@link ComputeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #computeConfig(ComputeConfig)}.
         * 
         * @param computeConfig
         *        a consumer that will call methods on {@link ComputeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeConfig(ComputeConfig)
         */
        default Builder computeConfig(Consumer<ComputeConfig.Builder> computeConfig) {
            return computeConfig(ComputeConfig.builder().applyMutation(computeConfig).build());
        }

        /**
         * <p>
         * Configuration parameters for an DMS serverless replication.
         * </p>
         * 
         * @param replicationSettings
         *        Configuration parameters for an DMS serverless replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSettings(String replicationSettings);

        /**
         * <p>
         * Additional parameters for an DMS serverless replication.
         * </p>
         * 
         * @param supplementalSettings
         *        Additional parameters for an DMS serverless replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalSettings(String supplementalSettings);

        /**
         * <p>
         * Table mappings specified in the replication.
         * </p>
         * 
         * @param tableMappings
         *        Table mappings specified in the replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMappings(String tableMappings);

        /**
         * <p>
         * The time the serverless replication config was created.
         * </p>
         * 
         * @param replicationConfigCreateTime
         *        The time the serverless replication config was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigCreateTime(Instant replicationConfigCreateTime);

        /**
         * <p>
         * The time the serverless replication config was updated.
         * </p>
         * 
         * @param replicationConfigUpdateTime
         *        The time the serverless replication config was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigUpdateTime(Instant replicationConfigUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String replicationConfigIdentifier;

        private String replicationConfigArn;

        private String sourceEndpointArn;

        private String targetEndpointArn;

        private String replicationType;

        private ComputeConfig computeConfig;

        private String replicationSettings;

        private String supplementalSettings;

        private String tableMappings;

        private Instant replicationConfigCreateTime;

        private Instant replicationConfigUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfig model) {
            replicationConfigIdentifier(model.replicationConfigIdentifier);
            replicationConfigArn(model.replicationConfigArn);
            sourceEndpointArn(model.sourceEndpointArn);
            targetEndpointArn(model.targetEndpointArn);
            replicationType(model.replicationType);
            computeConfig(model.computeConfig);
            replicationSettings(model.replicationSettings);
            supplementalSettings(model.supplementalSettings);
            tableMappings(model.tableMappings);
            replicationConfigCreateTime(model.replicationConfigCreateTime);
            replicationConfigUpdateTime(model.replicationConfigUpdateTime);
        }

        public final String getReplicationConfigIdentifier() {
            return replicationConfigIdentifier;
        }

        public final void setReplicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
        }

        @Override
        public final Builder replicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
            return this;
        }

        public final String getReplicationConfigArn() {
            return replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final String getSourceEndpointArn() {
            return sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTargetEndpointArn() {
            return targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final String getReplicationType() {
            return replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(MigrationTypeValue replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final ComputeConfig.Builder getComputeConfig() {
            return computeConfig != null ? computeConfig.toBuilder() : null;
        }

        public final void setComputeConfig(ComputeConfig.BuilderImpl computeConfig) {
            this.computeConfig = computeConfig != null ? computeConfig.build() : null;
        }

        @Override
        public final Builder computeConfig(ComputeConfig computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        public final String getReplicationSettings() {
            return replicationSettings;
        }

        public final void setReplicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
        }

        @Override
        public final Builder replicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
            return this;
        }

        public final String getSupplementalSettings() {
            return supplementalSettings;
        }

        public final void setSupplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
        }

        @Override
        public final Builder supplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
            return this;
        }

        public final String getTableMappings() {
            return tableMappings;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final Instant getReplicationConfigCreateTime() {
            return replicationConfigCreateTime;
        }

        public final void setReplicationConfigCreateTime(Instant replicationConfigCreateTime) {
            this.replicationConfigCreateTime = replicationConfigCreateTime;
        }

        @Override
        public final Builder replicationConfigCreateTime(Instant replicationConfigCreateTime) {
            this.replicationConfigCreateTime = replicationConfigCreateTime;
            return this;
        }

        public final Instant getReplicationConfigUpdateTime() {
            return replicationConfigUpdateTime;
        }

        public final void setReplicationConfigUpdateTime(Instant replicationConfigUpdateTime) {
            this.replicationConfigUpdateTime = replicationConfigUpdateTime;
        }

        @Override
        public final Builder replicationConfigUpdateTime(Instant replicationConfigUpdateTime) {
            this.replicationConfigUpdateTime = replicationConfigUpdateTime;
            return this;
        }

        @Override
        public ReplicationConfig build() {
            return new ReplicationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
