/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a schema conversion action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaConversionRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaConversionRequest.Builder, SchemaConversionRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SchemaConversionRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestIdentifier").getter(getter(SchemaConversionRequest::requestIdentifier))
            .setter(setter(Builder::requestIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestIdentifier").build()).build();

    private static final SdkField<String> MIGRATION_PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MigrationProjectArn").getter(getter(SchemaConversionRequest::migrationProjectArn))
            .setter(setter(Builder::migrationProjectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectArn").build())
            .build();

    private static final SdkField<ErrorDetails> ERROR_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(SchemaConversionRequest::error)).setter(setter(Builder::error))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<ExportSqlDetails> EXPORT_SQL_DETAILS_FIELD = SdkField
            .<ExportSqlDetails> builder(MarshallingType.SDK_POJO).memberName("ExportSqlDetails")
            .getter(getter(SchemaConversionRequest::exportSqlDetails)).setter(setter(Builder::exportSqlDetails))
            .constructor(ExportSqlDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSqlDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            REQUEST_IDENTIFIER_FIELD, MIGRATION_PROJECT_ARN_FIELD, ERROR_FIELD, EXPORT_SQL_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String requestIdentifier;

    private final String migrationProjectArn;

    private final ErrorDetails error;

    private final ExportSqlDetails exportSqlDetails;

    private SchemaConversionRequest(BuilderImpl builder) {
        this.status = builder.status;
        this.requestIdentifier = builder.requestIdentifier;
        this.migrationProjectArn = builder.migrationProjectArn;
        this.error = builder.error;
        this.exportSqlDetails = builder.exportSqlDetails;
    }

    /**
     * <p>
     * The schema conversion action status.
     * </p>
     * 
     * @return The schema conversion action status.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The identifier for the schema conversion action.
     * </p>
     * 
     * @return The identifier for the schema conversion action.
     */
    public final String requestIdentifier() {
        return requestIdentifier;
    }

    /**
     * <p>
     * The migration project ARN.
     * </p>
     * 
     * @return The migration project ARN.
     */
    public final String migrationProjectArn() {
        return migrationProjectArn;
    }

    /**
     * Returns the value of the Error property for this object.
     * 
     * @return The value of the Error property for this object.
     */
    public final ErrorDetails error() {
        return error;
    }

    /**
     * Returns the value of the ExportSqlDetails property for this object.
     * 
     * @return The value of the ExportSqlDetails property for this object.
     */
    public final ExportSqlDetails exportSqlDetails() {
        return exportSqlDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(migrationProjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(exportSqlDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaConversionRequest)) {
            return false;
        }
        SchemaConversionRequest other = (SchemaConversionRequest) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(requestIdentifier(), other.requestIdentifier())
                && Objects.equals(migrationProjectArn(), other.migrationProjectArn()) && Objects.equals(error(), other.error())
                && Objects.equals(exportSqlDetails(), other.exportSqlDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaConversionRequest").add("Status", status()).add("RequestIdentifier", requestIdentifier())
                .add("MigrationProjectArn", migrationProjectArn()).add("Error", error())
                .add("ExportSqlDetails", exportSqlDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestIdentifier":
            return Optional.ofNullable(clazz.cast(requestIdentifier()));
        case "MigrationProjectArn":
            return Optional.ofNullable(clazz.cast(migrationProjectArn()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "ExportSqlDetails":
            return Optional.ofNullable(clazz.cast(exportSqlDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("RequestIdentifier", REQUEST_IDENTIFIER_FIELD);
        map.put("MigrationProjectArn", MIGRATION_PROJECT_ARN_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("ExportSqlDetails", EXPORT_SQL_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaConversionRequest, T> g) {
        return obj -> g.apply((SchemaConversionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaConversionRequest> {
        /**
         * <p>
         * The schema conversion action status.
         * </p>
         * 
         * @param status
         *        The schema conversion action status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The identifier for the schema conversion action.
         * </p>
         * 
         * @param requestIdentifier
         *        The identifier for the schema conversion action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestIdentifier(String requestIdentifier);

        /**
         * <p>
         * The migration project ARN.
         * </p>
         * 
         * @param migrationProjectArn
         *        The migration project ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationProjectArn(String migrationProjectArn);

        /**
         * Sets the value of the Error property for this object.
         *
         * @param error
         *        The new value for the Error property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetails error);

        /**
         * Sets the value of the Error property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ErrorDetails)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetails)
         */
        default Builder error(Consumer<ErrorDetails.Builder> error) {
            return error(ErrorDetails.builder().applyMutation(error).build());
        }

        /**
         * Sets the value of the ExportSqlDetails property for this object.
         *
         * @param exportSqlDetails
         *        The new value for the ExportSqlDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSqlDetails(ExportSqlDetails exportSqlDetails);

        /**
         * Sets the value of the ExportSqlDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExportSqlDetails.Builder} avoiding the
         * need to create one manually via {@link ExportSqlDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportSqlDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #exportSqlDetails(ExportSqlDetails)}.
         * 
         * @param exportSqlDetails
         *        a consumer that will call methods on {@link ExportSqlDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportSqlDetails(ExportSqlDetails)
         */
        default Builder exportSqlDetails(Consumer<ExportSqlDetails.Builder> exportSqlDetails) {
            return exportSqlDetails(ExportSqlDetails.builder().applyMutation(exportSqlDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String requestIdentifier;

        private String migrationProjectArn;

        private ErrorDetails error;

        private ExportSqlDetails exportSqlDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaConversionRequest model) {
            status(model.status);
            requestIdentifier(model.requestIdentifier);
            migrationProjectArn(model.migrationProjectArn);
            error(model.error);
            exportSqlDetails(model.exportSqlDetails);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getRequestIdentifier() {
            return requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public final String getMigrationProjectArn() {
            return migrationProjectArn;
        }

        public final void setMigrationProjectArn(String migrationProjectArn) {
            this.migrationProjectArn = migrationProjectArn;
        }

        @Override
        public final Builder migrationProjectArn(String migrationProjectArn) {
            this.migrationProjectArn = migrationProjectArn;
            return this;
        }

        public final ErrorDetails.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetails error) {
            this.error = error;
            return this;
        }

        public final ExportSqlDetails.Builder getExportSqlDetails() {
            return exportSqlDetails != null ? exportSqlDetails.toBuilder() : null;
        }

        public final void setExportSqlDetails(ExportSqlDetails.BuilderImpl exportSqlDetails) {
            this.exportSqlDetails = exportSqlDetails != null ? exportSqlDetails.build() : null;
        }

        @Override
        public final Builder exportSqlDetails(ExportSqlDetails exportSqlDetails) {
            this.exportSqlDetails = exportSqlDetails;
            return this;
        }

        @Override
        public SchemaConversionRequest build() {
            return new SchemaConversionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
