/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines settings for a source data provider for a data migration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDataSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceDataSetting.Builder, SourceDataSetting> {
    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CDCStartPosition").getter(getter(SourceDataSetting::cdcStartPosition))
            .setter(setter(Builder::cdcStartPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CDCStartPosition").build()).build();

    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CDCStartTime")
            .getter(getter(SourceDataSetting::cdcStartTime))
            .setter(setter(Builder::cdcStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CDCStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CDC_STOP_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CDCStopTime")
            .getter(getter(SourceDataSetting::cdcStopTime))
            .setter(setter(Builder::cdcStopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CDCStopTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlotName").getter(getter(SourceDataSetting::slotName)).setter(setter(Builder::slotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDC_START_POSITION_FIELD,
            CDC_START_TIME_FIELD, CDC_STOP_TIME_FIELD, SLOT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cdcStartPosition;

    private final Instant cdcStartTime;

    private final Instant cdcStopTime;

    private final String slotName;

    private SourceDataSetting(BuilderImpl builder) {
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStopTime = builder.cdcStopTime;
        this.slotName = builder.slotName;
    }

    /**
     * <p>
     * The change data capture (CDC) start position for the source data provider.
     * </p>
     * 
     * @return The change data capture (CDC) start position for the source data provider.
     */
    public final String cdcStartPosition() {
        return cdcStartPosition;
    }

    /**
     * <p>
     * The change data capture (CDC) start time for the source data provider.
     * </p>
     * 
     * @return The change data capture (CDC) start time for the source data provider.
     */
    public final Instant cdcStartTime() {
        return cdcStartTime;
    }

    /**
     * <p>
     * The change data capture (CDC) stop time for the source data provider.
     * </p>
     * 
     * @return The change data capture (CDC) stop time for the source data provider.
     */
    public final Instant cdcStopTime() {
        return cdcStopTime;
    }

    /**
     * <p>
     * The name of the replication slot on the source data provider. This attribute is only valid for a PostgreSQL or
     * Aurora PostgreSQL source.
     * </p>
     * 
     * @return The name of the replication slot on the source data provider. This attribute is only valid for a
     *         PostgreSQL or Aurora PostgreSQL source.
     */
    public final String slotName() {
        return slotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(slotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDataSetting)) {
            return false;
        }
        SourceDataSetting other = (SourceDataSetting) obj;
        return Objects.equals(cdcStartPosition(), other.cdcStartPosition())
                && Objects.equals(cdcStartTime(), other.cdcStartTime()) && Objects.equals(cdcStopTime(), other.cdcStopTime())
                && Objects.equals(slotName(), other.slotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceDataSetting").add("CDCStartPosition", cdcStartPosition())
                .add("CDCStartTime", cdcStartTime()).add("CDCStopTime", cdcStopTime()).add("SlotName", slotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CDCStartPosition":
            return Optional.ofNullable(clazz.cast(cdcStartPosition()));
        case "CDCStartTime":
            return Optional.ofNullable(clazz.cast(cdcStartTime()));
        case "CDCStopTime":
            return Optional.ofNullable(clazz.cast(cdcStopTime()));
        case "SlotName":
            return Optional.ofNullable(clazz.cast(slotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CDCStartPosition", CDC_START_POSITION_FIELD);
        map.put("CDCStartTime", CDC_START_TIME_FIELD);
        map.put("CDCStopTime", CDC_STOP_TIME_FIELD);
        map.put("SlotName", SLOT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDataSetting, T> g) {
        return obj -> g.apply((SourceDataSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDataSetting> {
        /**
         * <p>
         * The change data capture (CDC) start position for the source data provider.
         * </p>
         * 
         * @param cdcStartPosition
         *        The change data capture (CDC) start position for the source data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartPosition(String cdcStartPosition);

        /**
         * <p>
         * The change data capture (CDC) start time for the source data provider.
         * </p>
         * 
         * @param cdcStartTime
         *        The change data capture (CDC) start time for the source data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartTime(Instant cdcStartTime);

        /**
         * <p>
         * The change data capture (CDC) stop time for the source data provider.
         * </p>
         * 
         * @param cdcStopTime
         *        The change data capture (CDC) stop time for the source data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStopTime(Instant cdcStopTime);

        /**
         * <p>
         * The name of the replication slot on the source data provider. This attribute is only valid for a PostgreSQL
         * or Aurora PostgreSQL source.
         * </p>
         * 
         * @param slotName
         *        The name of the replication slot on the source data provider. This attribute is only valid for a
         *        PostgreSQL or Aurora PostgreSQL source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotName(String slotName);
    }

    static final class BuilderImpl implements Builder {
        private String cdcStartPosition;

        private Instant cdcStartTime;

        private Instant cdcStopTime;

        private String slotName;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDataSetting model) {
            cdcStartPosition(model.cdcStartPosition);
            cdcStartTime(model.cdcStartTime);
            cdcStopTime(model.cdcStopTime);
            slotName(model.slotName);
        }

        public final String getCdcStartPosition() {
            return cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final Instant getCdcStartTime() {
            return cdcStartTime;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final Instant getCdcStopTime() {
            return cdcStopTime;
        }

        public final void setCdcStopTime(Instant cdcStopTime) {
            this.cdcStopTime = cdcStopTime;
        }

        @Override
        public final Builder cdcStopTime(Instant cdcStopTime) {
            this.cdcStopTime = cdcStopTime;
            return this;
        }

        public final String getSlotName() {
            return slotName;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        @Override
        public SourceDataSetting build() {
            return new SourceDataSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
