/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDataMigrationRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<StartDataMigrationRequest.Builder, StartDataMigrationRequest> {
    private static final SdkField<String> DATA_MIGRATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataMigrationIdentifier").getter(getter(StartDataMigrationRequest::dataMigrationIdentifier))
            .setter(setter(Builder::dataMigrationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationIdentifier").build())
            .build();

    private static final SdkField<String> START_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartType").getter(getter(StartDataMigrationRequest::startTypeAsString))
            .setter(setter(Builder::startType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_MIGRATION_IDENTIFIER_FIELD, START_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataMigrationIdentifier;

    private final String startType;

    private StartDataMigrationRequest(BuilderImpl builder) {
        super(builder);
        this.dataMigrationIdentifier = builder.dataMigrationIdentifier;
        this.startType = builder.startType;
    }

    /**
     * <p>
     * The identifier (name or ARN) of the data migration to start.
     * </p>
     * 
     * @return The identifier (name or ARN) of the data migration to start.
     */
    public final String dataMigrationIdentifier() {
        return dataMigrationIdentifier;
    }

    /**
     * <p>
     * Specifies the start type for the data migration. Valid values include <code>start-replication</code>,
     * <code>reload-target</code>, and <code>resume-processing</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startType} will
     * return {@link StartReplicationMigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #startTypeAsString}.
     * </p>
     * 
     * @return Specifies the start type for the data migration. Valid values include <code>start-replication</code>,
     *         <code>reload-target</code>, and <code>resume-processing</code>.
     * @see StartReplicationMigrationTypeValue
     */
    public final StartReplicationMigrationTypeValue startType() {
        return StartReplicationMigrationTypeValue.fromValue(startType);
    }

    /**
     * <p>
     * Specifies the start type for the data migration. Valid values include <code>start-replication</code>,
     * <code>reload-target</code>, and <code>resume-processing</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startType} will
     * return {@link StartReplicationMigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #startTypeAsString}.
     * </p>
     * 
     * @return Specifies the start type for the data migration. Valid values include <code>start-replication</code>,
     *         <code>reload-target</code>, and <code>resume-processing</code>.
     * @see StartReplicationMigrationTypeValue
     */
    public final String startTypeAsString() {
        return startType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataMigrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(startTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataMigrationRequest)) {
            return false;
        }
        StartDataMigrationRequest other = (StartDataMigrationRequest) obj;
        return Objects.equals(dataMigrationIdentifier(), other.dataMigrationIdentifier())
                && Objects.equals(startTypeAsString(), other.startTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDataMigrationRequest").add("DataMigrationIdentifier", dataMigrationIdentifier())
                .add("StartType", startTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataMigrationIdentifier":
            return Optional.ofNullable(clazz.cast(dataMigrationIdentifier()));
        case "StartType":
            return Optional.ofNullable(clazz.cast(startTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataMigrationIdentifier", DATA_MIGRATION_IDENTIFIER_FIELD);
        map.put("StartType", START_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDataMigrationRequest, T> g) {
        return obj -> g.apply((StartDataMigrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDataMigrationRequest> {
        /**
         * <p>
         * The identifier (name or ARN) of the data migration to start.
         * </p>
         * 
         * @param dataMigrationIdentifier
         *        The identifier (name or ARN) of the data migration to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataMigrationIdentifier(String dataMigrationIdentifier);

        /**
         * <p>
         * Specifies the start type for the data migration. Valid values include <code>start-replication</code>,
         * <code>reload-target</code>, and <code>resume-processing</code>.
         * </p>
         * 
         * @param startType
         *        Specifies the start type for the data migration. Valid values include <code>start-replication</code>,
         *        <code>reload-target</code>, and <code>resume-processing</code>.
         * @see StartReplicationMigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartReplicationMigrationTypeValue
         */
        Builder startType(String startType);

        /**
         * <p>
         * Specifies the start type for the data migration. Valid values include <code>start-replication</code>,
         * <code>reload-target</code>, and <code>resume-processing</code>.
         * </p>
         * 
         * @param startType
         *        Specifies the start type for the data migration. Valid values include <code>start-replication</code>,
         *        <code>reload-target</code>, and <code>resume-processing</code>.
         * @see StartReplicationMigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartReplicationMigrationTypeValue
         */
        Builder startType(StartReplicationMigrationTypeValue startType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String dataMigrationIdentifier;

        private String startType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataMigrationRequest model) {
            super(model);
            dataMigrationIdentifier(model.dataMigrationIdentifier);
            startType(model.startType);
        }

        public final String getDataMigrationIdentifier() {
            return dataMigrationIdentifier;
        }

        public final void setDataMigrationIdentifier(String dataMigrationIdentifier) {
            this.dataMigrationIdentifier = dataMigrationIdentifier;
        }

        @Override
        public final Builder dataMigrationIdentifier(String dataMigrationIdentifier) {
            this.dataMigrationIdentifier = dataMigrationIdentifier;
            return this;
        }

        public final String getStartType() {
            return startType;
        }

        public final void setStartType(String startType) {
            this.startType = startType;
        }

        @Override
        public final Builder startType(String startType) {
            this.startType = startType;
            return this;
        }

        @Override
        public final Builder startType(StartReplicationMigrationTypeValue startType) {
            this.startType(startType == null ? null : startType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataMigrationRequest build() {
            return new StartDataMigrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
