/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines settings for a target data provider for a data migration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetDataSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetDataSetting.Builder, TargetDataSetting> {
    private static final SdkField<String> TABLE_PREPARATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TablePreparationMode").getter(getter(TargetDataSetting::tablePreparationModeAsString))
            .setter(setter(Builder::tablePreparationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePreparationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_PREPARATION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tablePreparationMode;

    private TargetDataSetting(BuilderImpl builder) {
        this.tablePreparationMode = builder.tablePreparationMode;
    }

    /**
     * <p>
     * This setting determines how DMS handles the target tables before starting a data migration, either by leaving
     * them untouched, dropping and recreating them, or truncating the existing data in the target tables.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tablePreparationMode} will return {@link TablePreparationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tablePreparationModeAsString}.
     * </p>
     * 
     * @return This setting determines how DMS handles the target tables before starting a data migration, either by
     *         leaving them untouched, dropping and recreating them, or truncating the existing data in the target
     *         tables.
     * @see TablePreparationMode
     */
    public final TablePreparationMode tablePreparationMode() {
        return TablePreparationMode.fromValue(tablePreparationMode);
    }

    /**
     * <p>
     * This setting determines how DMS handles the target tables before starting a data migration, either by leaving
     * them untouched, dropping and recreating them, or truncating the existing data in the target tables.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tablePreparationMode} will return {@link TablePreparationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tablePreparationModeAsString}.
     * </p>
     * 
     * @return This setting determines how DMS handles the target tables before starting a data migration, either by
     *         leaving them untouched, dropping and recreating them, or truncating the existing data in the target
     *         tables.
     * @see TablePreparationMode
     */
    public final String tablePreparationModeAsString() {
        return tablePreparationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tablePreparationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetDataSetting)) {
            return false;
        }
        TargetDataSetting other = (TargetDataSetting) obj;
        return Objects.equals(tablePreparationModeAsString(), other.tablePreparationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetDataSetting").add("TablePreparationMode", tablePreparationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TablePreparationMode":
            return Optional.ofNullable(clazz.cast(tablePreparationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TablePreparationMode", TABLE_PREPARATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetDataSetting, T> g) {
        return obj -> g.apply((TargetDataSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetDataSetting> {
        /**
         * <p>
         * This setting determines how DMS handles the target tables before starting a data migration, either by leaving
         * them untouched, dropping and recreating them, or truncating the existing data in the target tables.
         * </p>
         * 
         * @param tablePreparationMode
         *        This setting determines how DMS handles the target tables before starting a data migration, either by
         *        leaving them untouched, dropping and recreating them, or truncating the existing data in the target
         *        tables.
         * @see TablePreparationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TablePreparationMode
         */
        Builder tablePreparationMode(String tablePreparationMode);

        /**
         * <p>
         * This setting determines how DMS handles the target tables before starting a data migration, either by leaving
         * them untouched, dropping and recreating them, or truncating the existing data in the target tables.
         * </p>
         * 
         * @param tablePreparationMode
         *        This setting determines how DMS handles the target tables before starting a data migration, either by
         *        leaving them untouched, dropping and recreating them, or truncating the existing data in the target
         *        tables.
         * @see TablePreparationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TablePreparationMode
         */
        Builder tablePreparationMode(TablePreparationMode tablePreparationMode);
    }

    static final class BuilderImpl implements Builder {
        private String tablePreparationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetDataSetting model) {
            tablePreparationMode(model.tablePreparationMode);
        }

        public final String getTablePreparationMode() {
            return tablePreparationMode;
        }

        public final void setTablePreparationMode(String tablePreparationMode) {
            this.tablePreparationMode = tablePreparationMode;
        }

        @Override
        public final Builder tablePreparationMode(String tablePreparationMode) {
            this.tablePreparationMode = tablePreparationMode;
            return this;
        }

        @Override
        public final Builder tablePreparationMode(TablePreparationMode tablePreparationMode) {
            this.tablePreparationMode(tablePreparationMode == null ? null : tablePreparationMode.toString());
            return this;
        }

        @Override
        public TargetDataSetting build() {
            return new TargetDataSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
