/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;

@SdkPublicApi
public final class DataBrewEndpointParams {
    private final Region region;
    private final Boolean useDualStack;
    private final Boolean useFIPS;
    private final String endpoint;

    private DataBrewEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useDualStack = builder.useDualStack;
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return this.region;
    }

    public Boolean useDualStack() {
        return this.useDualStack;
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public String endpoint() {
        return this.endpoint;
    }

    private static class BuilderImpl
    implements Builder {
        private Region region;
        private Boolean useDualStack = false;
        private Boolean useFIPS = false;
        private String endpoint;

        private BuilderImpl() {
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public DataBrewEndpointParams build() {
            return new DataBrewEndpointParams(this);
        }
    }

    public static interface Builder {
        public Builder region(Region var1);

        public Builder useDualStack(Boolean var1);

        public Builder useFips(Boolean var1);

        public Builder endpoint(String var1);

        public DataBrewEndpointParams build();
    }
}

