/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.Order;
import software.amazon.awssdk.services.databrew.model.OrderedBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilesLimit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilesLimit> {
    private static final SdkField<Integer> MAX_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFiles").getter(FilesLimit.getter(FilesLimit::maxFiles)).setter(FilesLimit.setter(Builder::maxFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFiles").build()}).build();
    private static final SdkField<String> ORDERED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderedBy").getter(FilesLimit.getter(FilesLimit::orderedByAsString)).setter(FilesLimit.setter(Builder::orderedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedBy").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Order").getter(FilesLimit.getter(FilesLimit::orderAsString)).setter(FilesLimit.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_FILES_FIELD, ORDERED_BY_FIELD, ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MaxFiles", MAX_FILES_FIELD);
            this.put("OrderedBy", ORDERED_BY_FIELD);
            this.put("Order", ORDER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer maxFiles;
    private final String orderedBy;
    private final String order;

    private FilesLimit(BuilderImpl builder) {
        this.maxFiles = builder.maxFiles;
        this.orderedBy = builder.orderedBy;
        this.order = builder.order;
    }

    public final Integer maxFiles() {
        return this.maxFiles;
    }

    public final OrderedBy orderedBy() {
        return OrderedBy.fromValue(this.orderedBy);
    }

    public final String orderedByAsString() {
        return this.orderedBy;
    }

    public final Order order() {
        return Order.fromValue(this.order);
    }

    public final String orderAsString() {
        return this.order;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilesLimit)) {
            return false;
        }
        FilesLimit other = (FilesLimit)obj;
        return Objects.equals(this.maxFiles(), other.maxFiles()) && Objects.equals(this.orderedByAsString(), other.orderedByAsString()) && Objects.equals(this.orderAsString(), other.orderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FilesLimit").add("MaxFiles", (Object)this.maxFiles()).add("OrderedBy", (Object)this.orderedByAsString()).add("Order", (Object)this.orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxFiles": {
                return Optional.ofNullable(clazz.cast(this.maxFiles()));
            }
            case "OrderedBy": {
                return Optional.ofNullable(clazz.cast(this.orderedByAsString()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FilesLimit, T> g) {
        return obj -> g.apply((FilesLimit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxFiles;
        private String orderedBy;
        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(FilesLimit model) {
            this.maxFiles(model.maxFiles);
            this.orderedBy(model.orderedBy);
            this.order(model.order);
        }

        public final Integer getMaxFiles() {
            return this.maxFiles;
        }

        public final void setMaxFiles(Integer maxFiles) {
            this.maxFiles = maxFiles;
        }

        @Override
        public final Builder maxFiles(Integer maxFiles) {
            this.maxFiles = maxFiles;
            return this;
        }

        public final String getOrderedBy() {
            return this.orderedBy;
        }

        public final void setOrderedBy(String orderedBy) {
            this.orderedBy = orderedBy;
        }

        @Override
        public final Builder orderedBy(String orderedBy) {
            this.orderedBy = orderedBy;
            return this;
        }

        @Override
        public final Builder orderedBy(OrderedBy orderedBy) {
            this.orderedBy(orderedBy == null ? null : orderedBy.toString());
            return this;
        }

        public final String getOrder() {
            return this.order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public FilesLimit build() {
            return new FilesLimit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilesLimit> {
        public Builder maxFiles(Integer var1);

        public Builder orderedBy(String var1);

        public Builder orderedBy(OrderedBy var1);

        public Builder order(String var1);

        public Builder order(Order var1);
    }
}

