/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.RecipeStep;
import software.amazon.awssdk.services.databrew.model.RecipeStepListCopier;
import software.amazon.awssdk.services.databrew.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recipe
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recipe> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(Recipe.getter(Recipe::createdBy)).setter(Recipe.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(Recipe.getter(Recipe::createDate)).setter(Recipe.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(Recipe.getter(Recipe::lastModifiedBy)).setter(Recipe.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(Recipe.getter(Recipe::lastModifiedDate)).setter(Recipe.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(Recipe.getter(Recipe::projectName)).setter(Recipe.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<String> PUBLISHED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishedBy").getter(Recipe.getter(Recipe::publishedBy)).setter(Recipe.setter(Builder::publishedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedBy").build()}).build();
    private static final SdkField<Instant> PUBLISHED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PublishedDate").getter(Recipe.getter(Recipe::publishedDate)).setter(Recipe.setter(Builder::publishedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Recipe.getter(Recipe::description)).setter(Recipe.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Recipe.getter(Recipe::name)).setter(Recipe.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(Recipe.getter(Recipe::resourceArn)).setter(Recipe.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<RecipeStep>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Steps").getter(Recipe.getter(Recipe::steps)).setter(Recipe.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecipeStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Recipe.getter(Recipe::tags)).setter(Recipe.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RECIPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecipeVersion").getter(Recipe.getter(Recipe::recipeVersion)).setter(Recipe.setter(Builder::recipeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD, CREATE_DATE_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, PROJECT_NAME_FIELD, PUBLISHED_BY_FIELD, PUBLISHED_DATE_FIELD, DESCRIPTION_FIELD, NAME_FIELD, RESOURCE_ARN_FIELD, STEPS_FIELD, TAGS_FIELD, RECIPE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreatedBy", CREATED_BY_FIELD);
            this.put("CreateDate", CREATE_DATE_FIELD);
            this.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
            this.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
            this.put("ProjectName", PROJECT_NAME_FIELD);
            this.put("PublishedBy", PUBLISHED_BY_FIELD);
            this.put("PublishedDate", PUBLISHED_DATE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("Steps", STEPS_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("RecipeVersion", RECIPE_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String createdBy;
    private final Instant createDate;
    private final String lastModifiedBy;
    private final Instant lastModifiedDate;
    private final String projectName;
    private final String publishedBy;
    private final Instant publishedDate;
    private final String description;
    private final String name;
    private final String resourceArn;
    private final List<RecipeStep> steps;
    private final Map<String, String> tags;
    private final String recipeVersion;

    private Recipe(BuilderImpl builder) {
        this.createdBy = builder.createdBy;
        this.createDate = builder.createDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.projectName = builder.projectName;
        this.publishedBy = builder.publishedBy;
        this.publishedDate = builder.publishedDate;
        this.description = builder.description;
        this.name = builder.name;
        this.resourceArn = builder.resourceArn;
        this.steps = builder.steps;
        this.tags = builder.tags;
        this.recipeVersion = builder.recipeVersion;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String publishedBy() {
        return this.publishedBy;
    }

    public final Instant publishedDate() {
        return this.publishedDate;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<RecipeStep> steps() {
        return this.steps;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String recipeVersion() {
        return this.recipeVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe)obj;
        return Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.publishedBy(), other.publishedBy()) && Objects.equals(this.publishedDate(), other.publishedDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.recipeVersion(), other.recipeVersion());
    }

    public final String toString() {
        return ToString.builder((String)"Recipe").add("CreatedBy", (Object)this.createdBy()).add("CreateDate", (Object)this.createDate()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("ProjectName", (Object)this.projectName()).add("PublishedBy", (Object)this.publishedBy()).add("PublishedDate", (Object)this.publishedDate()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("ResourceArn", (Object)this.resourceArn()).add("Steps", this.hasSteps() ? this.steps() : null).add("Tags", this.hasTags() ? this.tags() : null).add("RecipeVersion", (Object)this.recipeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "PublishedBy": {
                return Optional.ofNullable(clazz.cast(this.publishedBy()));
            }
            case "PublishedDate": {
                return Optional.ofNullable(clazz.cast(this.publishedDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RecipeVersion": {
                return Optional.ofNullable(clazz.cast(this.recipeVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Recipe, T> g) {
        return obj -> g.apply((Recipe)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String createdBy;
        private Instant createDate;
        private String lastModifiedBy;
        private Instant lastModifiedDate;
        private String projectName;
        private String publishedBy;
        private Instant publishedDate;
        private String description;
        private String name;
        private String resourceArn;
        private List<RecipeStep> steps = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String recipeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Recipe model) {
            this.createdBy(model.createdBy);
            this.createDate(model.createDate);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedDate(model.lastModifiedDate);
            this.projectName(model.projectName);
            this.publishedBy(model.publishedBy);
            this.publishedDate(model.publishedDate);
            this.description(model.description);
            this.name(model.name);
            this.resourceArn(model.resourceArn);
            this.steps(model.steps);
            this.tags(model.tags);
            this.recipeVersion(model.recipeVersion);
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getPublishedBy() {
            return this.publishedBy;
        }

        public final void setPublishedBy(String publishedBy) {
            this.publishedBy = publishedBy;
        }

        @Override
        public final Builder publishedBy(String publishedBy) {
            this.publishedBy = publishedBy;
            return this;
        }

        public final Instant getPublishedDate() {
            return this.publishedDate;
        }

        public final void setPublishedDate(Instant publishedDate) {
            this.publishedDate = publishedDate;
        }

        @Override
        public final Builder publishedDate(Instant publishedDate) {
            this.publishedDate = publishedDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<RecipeStep.Builder> getSteps() {
            List<RecipeStep.Builder> result = RecipeStepListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<RecipeStep.BuilderImpl> steps) {
            this.steps = RecipeStepListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<RecipeStep> steps) {
            this.steps = RecipeStepListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(RecipeStep ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<RecipeStep.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (RecipeStep)((RecipeStep.Builder)RecipeStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRecipeVersion() {
            return this.recipeVersion;
        }

        public final void setRecipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
        }

        @Override
        public final Builder recipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
            return this;
        }

        public Recipe build() {
            return new Recipe(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recipe> {
        public Builder createdBy(String var1);

        public Builder createDate(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder projectName(String var1);

        public Builder publishedBy(String var1);

        public Builder publishedDate(Instant var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder resourceArn(String var1);

        public Builder steps(Collection<RecipeStep> var1);

        public Builder steps(RecipeStep ... var1);

        public Builder steps(Consumer<RecipeStep.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder recipeVersion(String var1);
    }
}

