/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSubnetsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeSubnetsRequest.Builder, DescribeSubnetsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeSubnetsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(DescribeSubnetsRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SubnetId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SubnetId").unmarshallLocationName("SubnetId").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeSubnetsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeSubnetsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeSubnetsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            SUBNET_IDS_FIELD, DRY_RUN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<Filter> filters;

    private final List<String> subnetIds;

    private final Boolean dryRun;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeSubnetsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.subnetIds = builder.subnetIds;
        this.dryRun = builder.dryRun;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone for the subnet. You can also use
     * <code>availabilityZone</code> as the filter name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet. You can also use
     * <code>availabilityZoneId</code> as the filter name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the
     * subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
     * <code>cidrBlock</code> as the filter names.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>customer-owned-ipv4-pool</code> - The customer-owned IPv4 address pool associated with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-for-az</code> - Indicates whether this is the default subnet for the Availability Zone (
     * <code>true</code> | <code>false</code>). You can also use <code>defaultForAz</code> as the filter name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>enable-dns64</code> - Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet
     * should return synthetic IPv6 addresses for IPv4-only destinations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>enable-lni-at-device-index</code> - Indicates the device position for local network interfaces in this
     * subnet. For example, <code>1</code> indicates local network interfaces in this subnet are the secondary network
     * interface (eth1).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
     * with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-native</code> - Indicates whether this is an IPv6 only subnet (<code>true</code> | <code>false</code>
     * ).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>map-customer-owned-ip-on-launch</code> - Indicates whether a network interface created in this subnet
     * (including a network interface created by <a>RunInstances</a>) receives a customer-owned IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>map-public-ip-on-launch</code> - Indicates whether instances launched in this subnet receive a public IPv4
     * address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The ID of the Amazon Web Services account that owns the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name-options-on-launch.hostname-type</code> - The type of hostname to assign to instances in
     * the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6) subnets, an instance DNS name can be based on
     * the instance IPv4 address (ip-name) or the instance ID (resource-name). For IPv6 only subnets, an instance DNS
     * name must be based on the instance ID (resource-name).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name-options-on-launch.enable-resource-name-dns-a-record</code> - Indicates whether to respond
     * to DNS queries for instance hostnames with DNS A records.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name-options-on-launch.enable-resource-name-dns-aaaa-record</code> - Indicates whether to
     * respond to DNS queries for instance hostnames with DNS AAAA records.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC for the subnet.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone for the subnet. You can also use
     *         <code>availabilityZone</code> as the filter name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet. You can also use
     *         <code>availabilityZoneId</code> as the filter name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly
     *         match the subnet's CIDR block for information to be returned for the subnet. You can also use
     *         <code>cidr</code> or <code>cidrBlock</code> as the filter names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>customer-owned-ipv4-pool</code> - The customer-owned IPv4 address pool associated with the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>default-for-az</code> - Indicates whether this is the default subnet for the Availability Zone (
     *         <code>true</code> | <code>false</code>). You can also use <code>defaultForAz</code> as the filter name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>enable-dns64</code> - Indicates whether DNS queries made to the Amazon-provided DNS Resolver in
     *         this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>enable-lni-at-device-index</code> - Indicates the device position for local network interfaces in
     *         this subnet. For example, <code>1</code> indicates local network interfaces in this subnet are the
     *         secondary network interface (eth1).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block
     *         associated with the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the
     *         subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-native</code> - Indicates whether this is an IPv6 only subnet (<code>true</code> |
     *         <code>false</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>map-customer-owned-ip-on-launch</code> - Indicates whether a network interface created in this
     *         subnet (including a network interface created by <a>RunInstances</a>) receives a customer-owned IPv4
     *         address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>map-public-ip-on-launch</code> - Indicates whether instances launched in this subnet receive a
     *         public IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The ID of the Amazon Web Services account that owns the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name-options-on-launch.hostname-type</code> - The type of hostname to assign to
     *         instances in the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6) subnets, an instance DNS
     *         name can be based on the instance IPv4 address (ip-name) or the instance ID (resource-name). For IPv6
     *         only subnets, an instance DNS name must be based on the instance ID (resource-name).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name-options-on-launch.enable-resource-name-dns-a-record</code> - Indicates whether to
     *         respond to DNS queries for instance hostnames with DNS A records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name-options-on-launch.enable-resource-name-dns-aaaa-record</code> - Indicates whether
     *         to respond to DNS queries for instance hostnames with DNS AAAA records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC for the subnet.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets.
     * </p>
     * <p>
     * Default: Describes all your subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The IDs of the subnets.</p>
     *         <p>
     *         Default: Describes all your subnets.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The token returned from a previous paginated request. Pagination continues from the end of the items returned by
     * the previous request.
     * </p>
     * 
     * @return The token returned from a previous paginated request. Pagination continues from the end of the items
     *         returned by the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetsRequest)) {
            return false;
        }
        DescribeSubnetsRequest other = (DescribeSubnetsRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSubnetsRequest").add("Filters", hasFilters() ? filters() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("DryRun", dryRun()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubnetsRequest, T> g) {
        return obj -> g.apply((DescribeSubnetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSubnetsRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone for the subnet. You can also use
         * <code>availabilityZone</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet. You can also use
         * <code>availabilityZoneId</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match
         * the subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
         * <code>cidrBlock</code> as the filter names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-owned-ipv4-pool</code> - The customer-owned IPv4 address pool associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default-for-az</code> - Indicates whether this is the default subnet for the Availability Zone (
         * <code>true</code> | <code>false</code>). You can also use <code>defaultForAz</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enable-dns64</code> - Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this
         * subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enable-lni-at-device-index</code> - Indicates the device position for local network interfaces in this
         * subnet. For example, <code>1</code> indicates local network interfaces in this subnet are the secondary
         * network interface (eth1).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
         * with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-native</code> - Indicates whether this is an IPv6 only subnet (<code>true</code> |
         * <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>map-customer-owned-ip-on-launch</code> - Indicates whether a network interface created in this subnet
         * (including a network interface created by <a>RunInstances</a>) receives a customer-owned IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>map-public-ip-on-launch</code> - Indicates whether instances launched in this subnet receive a public
         * IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the Amazon Web Services account that owns the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options-on-launch.hostname-type</code> - The type of hostname to assign to instances
         * in the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6) subnets, an instance DNS name can be
         * based on the instance IPv4 address (ip-name) or the instance ID (resource-name). For IPv6 only subnets, an
         * instance DNS name must be based on the instance ID (resource-name).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options-on-launch.enable-resource-name-dns-a-record</code> - Indicates whether to
         * respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options-on-launch.enable-resource-name-dns-aaaa-record</code> - Indicates whether to
         * respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the subnet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone for the subnet. You can also use
         *        <code>availabilityZone</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet. You can also use
         *        <code>availabilityZoneId</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly
         *        match the subnet's CIDR block for information to be returned for the subnet. You can also use
         *        <code>cidr</code> or <code>cidrBlock</code> as the filter names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-owned-ipv4-pool</code> - The customer-owned IPv4 address pool associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default-for-az</code> - Indicates whether this is the default subnet for the Availability Zone (
         *        <code>true</code> | <code>false</code>). You can also use <code>defaultForAz</code> as the filter
         *        name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enable-dns64</code> - Indicates whether DNS queries made to the Amazon-provided DNS Resolver in
         *        this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enable-lni-at-device-index</code> - Indicates the device position for local network interfaces
         *        in this subnet. For example, <code>1</code> indicates local network interfaces in this subnet are the
         *        secondary network interface (eth1).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block
         *        associated with the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-native</code> - Indicates whether this is an IPv6 only subnet (<code>true</code> |
         *        <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>map-customer-owned-ip-on-launch</code> - Indicates whether a network interface created in this
         *        subnet (including a network interface created by <a>RunInstances</a>) receives a customer-owned IPv4
         *        address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>map-public-ip-on-launch</code> - Indicates whether instances launched in this subnet receive a
         *        public IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the Amazon Web Services account that owns the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options-on-launch.hostname-type</code> - The type of hostname to assign to
         *        instances in the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6) subnets, an instance
         *        DNS name can be based on the instance IPv4 address (ip-name) or the instance ID (resource-name). For
         *        IPv6 only subnets, an instance DNS name must be based on the instance ID (resource-name).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options-on-launch.enable-resource-name-dns-a-record</code> - Indicates whether
         *        to respond to DNS queries for instance hostnames with DNS A records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options-on-launch.enable-resource-name-dns-aaaa-record</code> - Indicates
         *        whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the subnet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone for the subnet. You can also use
         * <code>availabilityZone</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet. You can also use
         * <code>availabilityZoneId</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match
         * the subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
         * <code>cidrBlock</code> as the filter names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-owned-ipv4-pool</code> - The customer-owned IPv4 address pool associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default-for-az</code> - Indicates whether this is the default subnet for the Availability Zone (
         * <code>true</code> | <code>false</code>). You can also use <code>defaultForAz</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enable-dns64</code> - Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this
         * subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enable-lni-at-device-index</code> - Indicates the device position for local network interfaces in this
         * subnet. For example, <code>1</code> indicates local network interfaces in this subnet are the secondary
         * network interface (eth1).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
         * with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-native</code> - Indicates whether this is an IPv6 only subnet (<code>true</code> |
         * <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>map-customer-owned-ip-on-launch</code> - Indicates whether a network interface created in this subnet
         * (including a network interface created by <a>RunInstances</a>) receives a customer-owned IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>map-public-ip-on-launch</code> - Indicates whether instances launched in this subnet receive a public
         * IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the Amazon Web Services account that owns the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options-on-launch.hostname-type</code> - The type of hostname to assign to instances
         * in the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6) subnets, an instance DNS name can be
         * based on the instance IPv4 address (ip-name) or the instance ID (resource-name). For IPv6 only subnets, an
         * instance DNS name must be based on the instance ID (resource-name).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options-on-launch.enable-resource-name-dns-a-record</code> - Indicates whether to
         * respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options-on-launch.enable-resource-name-dns-aaaa-record</code> - Indicates whether to
         * respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the subnet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone for the subnet. You can also use
         *        <code>availabilityZone</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet. You can also use
         *        <code>availabilityZoneId</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly
         *        match the subnet's CIDR block for information to be returned for the subnet. You can also use
         *        <code>cidr</code> or <code>cidrBlock</code> as the filter names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-owned-ipv4-pool</code> - The customer-owned IPv4 address pool associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default-for-az</code> - Indicates whether this is the default subnet for the Availability Zone (
         *        <code>true</code> | <code>false</code>). You can also use <code>defaultForAz</code> as the filter
         *        name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enable-dns64</code> - Indicates whether DNS queries made to the Amazon-provided DNS Resolver in
         *        this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enable-lni-at-device-index</code> - Indicates the device position for local network interfaces
         *        in this subnet. For example, <code>1</code> indicates local network interfaces in this subnet are the
         *        secondary network interface (eth1).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block
         *        associated with the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-native</code> - Indicates whether this is an IPv6 only subnet (<code>true</code> |
         *        <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>map-customer-owned-ip-on-launch</code> - Indicates whether a network interface created in this
         *        subnet (including a network interface created by <a>RunInstances</a>) receives a customer-owned IPv4
         *        address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>map-public-ip-on-launch</code> - Indicates whether instances launched in this subnet receive a
         *        public IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the Amazon Web Services account that owns the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options-on-launch.hostname-type</code> - The type of hostname to assign to
         *        instances in the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6) subnets, an instance
         *        DNS name can be based on the instance IPv4 address (ip-name) or the instance ID (resource-name). For
         *        IPv6 only subnets, an instance DNS name must be based on the instance ID (resource-name).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options-on-launch.enable-resource-name-dns-a-record</code> - Indicates whether
         *        to respond to DNS queries for instance hostnames with DNS A records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options-on-launch.enable-resource-name-dns-aaaa-record</code> - Indicates
         *        whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the subnet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone for the subnet. You can also use
         * <code>availabilityZone</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet. You can also use
         * <code>availabilityZoneId</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match
         * the subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
         * <code>cidrBlock</code> as the filter names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-owned-ipv4-pool</code> - The customer-owned IPv4 address pool associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default-for-az</code> - Indicates whether this is the default subnet for the Availability Zone (
         * <code>true</code> | <code>false</code>). You can also use <code>defaultForAz</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enable-dns64</code> - Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this
         * subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enable-lni-at-device-index</code> - Indicates the device position for local network interfaces in this
         * subnet. For example, <code>1</code> indicates local network interfaces in this subnet are the secondary
         * network interface (eth1).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
         * with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-native</code> - Indicates whether this is an IPv6 only subnet (<code>true</code> |
         * <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>map-customer-owned-ip-on-launch</code> - Indicates whether a network interface created in this subnet
         * (including a network interface created by <a>RunInstances</a>) receives a customer-owned IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>map-public-ip-on-launch</code> - Indicates whether instances launched in this subnet receive a public
         * IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the Amazon Web Services account that owns the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options-on-launch.hostname-type</code> - The type of hostname to assign to instances
         * in the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6) subnets, an instance DNS name can be
         * based on the instance IPv4 address (ip-name) or the instance ID (resource-name). For IPv6 only subnets, an
         * instance DNS name must be based on the instance ID (resource-name).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options-on-launch.enable-resource-name-dns-a-record</code> - Indicates whether to
         * respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options-on-launch.enable-resource-name-dns-aaaa-record</code> - Indicates whether to
         * respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the subnet.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The IDs of the subnets.
         * </p>
         * <p>
         * Default: Describes all your subnets.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of the subnets.</p>
         *        <p>
         *        Default: Describes all your subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The IDs of the subnets.
         * </p>
         * <p>
         * Default: Describes all your subnets.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of the subnets.</p>
         *        <p>
         *        Default: Describes all your subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The token returned from a previous paginated request. Pagination continues from the end of the items returned
         * by the previous request.
         * </p>
         * 
         * @param nextToken
         *        The token returned from a previous paginated request. Pagination continues from the end of the items
         *        returned by the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetsRequest model) {
            super(model);
            filters(model.filters);
            subnetIds(model.subnetIds);
            dryRun(model.dryRun);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdStringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdStringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSubnetsRequest build() {
            return new DescribeSubnetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
