/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignPrivateIpAddressesResponse extends Ec2Response implements
        ToCopyableBuilder<AssignPrivateIpAddressesResponse.Builder, AssignPrivateIpAddressesResponse> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AssignPrivateIpAddressesResponse::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<List<AssignedPrivateIpAddress>> ASSIGNED_PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<AssignedPrivateIpAddress>> builder(MarshallingType.LIST)
            .memberName("AssignedPrivateIpAddresses")
            .getter(getter(AssignPrivateIpAddressesResponse::assignedPrivateIpAddresses))
            .setter(setter(Builder::assignedPrivateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedPrivateIpAddressesSet")
                    .unmarshallLocationName("assignedPrivateIpAddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AssignedPrivateIpAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssignedPrivateIpAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Ipv4PrefixSpecification>> ASSIGNED_IPV4_PREFIXES_FIELD = SdkField
            .<List<Ipv4PrefixSpecification>> builder(MarshallingType.LIST)
            .memberName("AssignedIpv4Prefixes")
            .getter(getter(AssignPrivateIpAddressesResponse::assignedIpv4Prefixes))
            .setter(setter(Builder::assignedIpv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedIpv4PrefixSet")
                    .unmarshallLocationName("assignedIpv4PrefixSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv4PrefixSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv4PrefixSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD,
            ASSIGNED_PRIVATE_IP_ADDRESSES_FIELD, ASSIGNED_IPV4_PREFIXES_FIELD));

    private final String networkInterfaceId;

    private final List<AssignedPrivateIpAddress> assignedPrivateIpAddresses;

    private final List<Ipv4PrefixSpecification> assignedIpv4Prefixes;

    private AssignPrivateIpAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.assignedPrivateIpAddresses = builder.assignedPrivateIpAddresses;
        this.assignedIpv4Prefixes = builder.assignedIpv4Prefixes;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssignedPrivateIpAddresses property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssignedPrivateIpAddresses() {
        return assignedPrivateIpAddresses != null && !(assignedPrivateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private IP addresses assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssignedPrivateIpAddresses} method.
     * </p>
     * 
     * @return The private IP addresses assigned to the network interface.
     */
    public final List<AssignedPrivateIpAddress> assignedPrivateIpAddresses() {
        return assignedPrivateIpAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssignedIpv4Prefixes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssignedIpv4Prefixes() {
        return assignedIpv4Prefixes != null && !(assignedIpv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 prefixes that are assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssignedIpv4Prefixes} method.
     * </p>
     * 
     * @return The IPv4 prefixes that are assigned to the network interface.
     */
    public final List<Ipv4PrefixSpecification> assignedIpv4Prefixes() {
        return assignedIpv4Prefixes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssignedPrivateIpAddresses() ? assignedPrivateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssignedIpv4Prefixes() ? assignedIpv4Prefixes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesResponse)) {
            return false;
        }
        AssignPrivateIpAddressesResponse other = (AssignPrivateIpAddressesResponse) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && hasAssignedPrivateIpAddresses() == other.hasAssignedPrivateIpAddresses()
                && Objects.equals(assignedPrivateIpAddresses(), other.assignedPrivateIpAddresses())
                && hasAssignedIpv4Prefixes() == other.hasAssignedIpv4Prefixes()
                && Objects.equals(assignedIpv4Prefixes(), other.assignedIpv4Prefixes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignPrivateIpAddressesResponse").add("NetworkInterfaceId", networkInterfaceId())
                .add("AssignedPrivateIpAddresses", hasAssignedPrivateIpAddresses() ? assignedPrivateIpAddresses() : null)
                .add("AssignedIpv4Prefixes", hasAssignedIpv4Prefixes() ? assignedIpv4Prefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "AssignedPrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(assignedPrivateIpAddresses()));
        case "AssignedIpv4Prefixes":
            return Optional.ofNullable(clazz.cast(assignedIpv4Prefixes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignPrivateIpAddressesResponse, T> g) {
        return obj -> g.apply((AssignPrivateIpAddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AssignPrivateIpAddressesResponse> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The private IP addresses assigned to the network interface.
         * </p>
         * 
         * @param assignedPrivateIpAddresses
         *        The private IP addresses assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress> assignedPrivateIpAddresses);

        /**
         * <p>
         * The private IP addresses assigned to the network interface.
         * </p>
         * 
         * @param assignedPrivateIpAddresses
         *        The private IP addresses assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedPrivateIpAddresses(AssignedPrivateIpAddress... assignedPrivateIpAddresses);

        /**
         * <p>
         * The private IP addresses assigned to the network interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress.Builder#build()} is called
         * immediately and its result is passed to {@link #assignedPrivateIpAddresses(List<AssignedPrivateIpAddress>)}.
         * 
         * @param assignedPrivateIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignedPrivateIpAddresses(java.util.Collection<AssignedPrivateIpAddress>)
         */
        Builder assignedPrivateIpAddresses(Consumer<AssignedPrivateIpAddress.Builder>... assignedPrivateIpAddresses);

        /**
         * <p>
         * The IPv4 prefixes that are assigned to the network interface.
         * </p>
         * 
         * @param assignedIpv4Prefixes
         *        The IPv4 prefixes that are assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv4Prefixes(Collection<Ipv4PrefixSpecification> assignedIpv4Prefixes);

        /**
         * <p>
         * The IPv4 prefixes that are assigned to the network interface.
         * </p>
         * 
         * @param assignedIpv4Prefixes
         *        The IPv4 prefixes that are assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv4Prefixes(Ipv4PrefixSpecification... assignedIpv4Prefixes);

        /**
         * <p>
         * The IPv4 prefixes that are assigned to the network interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #assignedIpv4Prefixes(List<Ipv4PrefixSpecification>)}.
         * 
         * @param assignedIpv4Prefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignedIpv4Prefixes(java.util.Collection<Ipv4PrefixSpecification>)
         */
        Builder assignedIpv4Prefixes(Consumer<Ipv4PrefixSpecification.Builder>... assignedIpv4Prefixes);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String networkInterfaceId;

        private List<AssignedPrivateIpAddress> assignedPrivateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<Ipv4PrefixSpecification> assignedIpv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesResponse model) {
            super(model);
            networkInterfaceId(model.networkInterfaceId);
            assignedPrivateIpAddresses(model.assignedPrivateIpAddresses);
            assignedIpv4Prefixes(model.assignedIpv4Prefixes);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final List<AssignedPrivateIpAddress.Builder> getAssignedPrivateIpAddresses() {
            List<AssignedPrivateIpAddress.Builder> result = AssignedPrivateIpAddressListCopier
                    .copyToBuilder(this.assignedPrivateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssignedPrivateIpAddresses(
                Collection<AssignedPrivateIpAddress.BuilderImpl> assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses = AssignedPrivateIpAddressListCopier.copyFromBuilder(assignedPrivateIpAddresses);
        }

        @Override
        public final Builder assignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress> assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses = AssignedPrivateIpAddressListCopier.copy(assignedPrivateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedPrivateIpAddresses(AssignedPrivateIpAddress... assignedPrivateIpAddresses) {
            assignedPrivateIpAddresses(Arrays.asList(assignedPrivateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedPrivateIpAddresses(Consumer<AssignedPrivateIpAddress.Builder>... assignedPrivateIpAddresses) {
            assignedPrivateIpAddresses(Stream.of(assignedPrivateIpAddresses)
                    .map(c -> AssignedPrivateIpAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Ipv4PrefixSpecification.Builder> getAssignedIpv4Prefixes() {
            List<Ipv4PrefixSpecification.Builder> result = Ipv4PrefixesListCopier.copyToBuilder(this.assignedIpv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssignedIpv4Prefixes(Collection<Ipv4PrefixSpecification.BuilderImpl> assignedIpv4Prefixes) {
            this.assignedIpv4Prefixes = Ipv4PrefixesListCopier.copyFromBuilder(assignedIpv4Prefixes);
        }

        @Override
        public final Builder assignedIpv4Prefixes(Collection<Ipv4PrefixSpecification> assignedIpv4Prefixes) {
            this.assignedIpv4Prefixes = Ipv4PrefixesListCopier.copy(assignedIpv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv4Prefixes(Ipv4PrefixSpecification... assignedIpv4Prefixes) {
            assignedIpv4Prefixes(Arrays.asList(assignedIpv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv4Prefixes(Consumer<Ipv4PrefixSpecification.Builder>... assignedIpv4Prefixes) {
            assignedIpv4Prefixes(Stream.of(assignedIpv4Prefixes)
                    .map(c -> Ipv4PrefixSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssignPrivateIpAddressesResponse build() {
            return new AssignPrivateIpAddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
