/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVolumesModificationsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVolumesModificationsResponse.Builder, DescribeVolumesModificationsResponse> {
    private static final SdkField<List<VolumeModification>> VOLUMES_MODIFICATIONS_FIELD = SdkField
            .<List<VolumeModification>> builder(MarshallingType.LIST)
            .memberName("VolumesModifications")
            .getter(getter(DescribeVolumesModificationsResponse::volumesModifications))
            .setter(setter(Builder::volumesModifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeModificationSet")
                    .unmarshallLocationName("volumeModificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VolumeModification> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeModification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVolumesModificationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUMES_MODIFICATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<VolumeModification> volumesModifications;

    private final String nextToken;

    private DescribeVolumesModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.volumesModifications = builder.volumesModifications;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumesModifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumesModifications() {
        return volumesModifications != null && !(volumesModifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the volume modifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumesModifications} method.
     * </p>
     * 
     * @return Information about the volume modifications.
     */
    public final List<VolumeModification> volumesModifications() {
        return volumesModifications;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> if there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code> if
     *         there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumesModifications() ? volumesModifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesModificationsResponse)) {
            return false;
        }
        DescribeVolumesModificationsResponse other = (DescribeVolumesModificationsResponse) obj;
        return hasVolumesModifications() == other.hasVolumesModifications()
                && Objects.equals(volumesModifications(), other.volumesModifications())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVolumesModificationsResponse")
                .add("VolumesModifications", hasVolumesModifications() ? volumesModifications() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumesModifications":
            return Optional.ofNullable(clazz.cast(volumesModifications()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumesModificationsResponse, T> g) {
        return obj -> g.apply((DescribeVolumesModificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVolumesModificationsResponse> {
        /**
         * <p>
         * Information about the volume modifications.
         * </p>
         * 
         * @param volumesModifications
         *        Information about the volume modifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesModifications(Collection<VolumeModification> volumesModifications);

        /**
         * <p>
         * Information about the volume modifications.
         * </p>
         * 
         * @param volumesModifications
         *        Information about the volume modifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesModifications(VolumeModification... volumesModifications);

        /**
         * <p>
         * Information about the volume modifications.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VolumeModification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.VolumeModification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VolumeModification.Builder#build()} is called immediately
         * and its result is passed to {@link #volumesModifications(List<VolumeModification>)}.
         * 
         * @param volumesModifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VolumeModification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumesModifications(java.util.Collection<VolumeModification>)
         */
        Builder volumesModifications(Consumer<VolumeModification.Builder>... volumesModifications);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> if
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        if there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<VolumeModification> volumesModifications = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesModificationsResponse model) {
            super(model);
            volumesModifications(model.volumesModifications);
            nextToken(model.nextToken);
        }

        public final List<VolumeModification.Builder> getVolumesModifications() {
            List<VolumeModification.Builder> result = VolumeModificationListCopier.copyToBuilder(this.volumesModifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumesModifications(Collection<VolumeModification.BuilderImpl> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copyFromBuilder(volumesModifications);
        }

        @Override
        public final Builder volumesModifications(Collection<VolumeModification> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copy(volumesModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesModifications(VolumeModification... volumesModifications) {
            volumesModifications(Arrays.asList(volumesModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesModifications(Consumer<VolumeModification.Builder>... volumesModifications) {
            volumesModifications(Stream.of(volumesModifications).map(c -> VolumeModification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVolumesModificationsResponse build() {
            return new DescribeVolumesModificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
