/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DomainPackageStatus {
    ASSOCIATING("ASSOCIATING"),
    ASSOCIATION_FAILED("ASSOCIATION_FAILED"),
    ACTIVE("ACTIVE"),
    DISSOCIATING("DISSOCIATING"),
    DISSOCIATION_FAILED("DISSOCIATION_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DomainPackageStatus> VALUE_MAP;
    private final String value;

    private DomainPackageStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DomainPackageStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DomainPackageStatus> knownValues() {
        EnumSet<DomainPackageStatus> knownValues = EnumSet.allOf(DomainPackageStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DomainPackageStatus.class, DomainPackageStatus::toString);
    }
}

