/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elastictranscoder.DefaultElasticTranscoderBaseClientBuilder;
import software.amazon.awssdk.services.elastictranscoder.DefaultElasticTranscoderClient;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderClient;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderClientBuilder;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderServiceClientConfiguration;
import software.amazon.awssdk.services.elastictranscoder.endpoints.ElasticTranscoderEndpointProvider;

@SdkInternalApi
final class DefaultElasticTranscoderClientBuilder
extends DefaultElasticTranscoderBaseClientBuilder<ElasticTranscoderClientBuilder, ElasticTranscoderClient>
implements ElasticTranscoderClientBuilder {
    DefaultElasticTranscoderClientBuilder() {
    }

    @Override
    public DefaultElasticTranscoderClientBuilder endpointProvider(ElasticTranscoderEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticTranscoderClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultElasticTranscoderClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ElasticTranscoderServiceClientConfiguration serviceClientConfiguration = ElasticTranscoderServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultElasticTranscoderClient(serviceClientConfiguration, clientConfiguration);
    }
}

