/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderAsyncClient;
import software.amazon.awssdk.services.elastictranscoder.internal.UserAgentUtils;
import software.amazon.awssdk.services.elastictranscoder.model.Job;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse;

public class ListJobsByStatusPublisher
implements SdkPublisher<ListJobsByStatusResponse> {
    private final ElasticTranscoderAsyncClient client;
    private final ListJobsByStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobsByStatusPublisher(ElasticTranscoderAsyncClient client, ListJobsByStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobsByStatusPublisher(ElasticTranscoderAsyncClient client, ListJobsByStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobsByStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobsByStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Job> jobs() {
        Function<ListJobsByStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobsByStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobsByStatusResponseFetcher
    implements AsyncPageFetcher<ListJobsByStatusResponse> {
        private ListJobsByStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsByStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListJobsByStatusResponse> nextPage(ListJobsByStatusResponse previousPage) {
            if (previousPage == null) {
                return ListJobsByStatusPublisher.this.client.listJobsByStatus(ListJobsByStatusPublisher.this.firstRequest);
            }
            return ListJobsByStatusPublisher.this.client.listJobsByStatus((ListJobsByStatusRequest)((Object)ListJobsByStatusPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

