/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.Notifications;
import software.amazon.awssdk.services.elastictranscoder.model.PipelineOutputConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Pipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Pipeline> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Pipeline.getter(Pipeline::id)).setter(Pipeline.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Pipeline.getter(Pipeline::arn)).setter(Pipeline.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Pipeline.getter(Pipeline::name)).setter(Pipeline.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Pipeline.getter(Pipeline::status)).setter(Pipeline.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> INPUT_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputBucket").getter(Pipeline.getter(Pipeline::inputBucket)).setter(Pipeline.setter(Builder::inputBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputBucket").build()}).build();
    private static final SdkField<String> OUTPUT_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputBucket").getter(Pipeline.getter(Pipeline::outputBucket)).setter(Pipeline.setter(Builder::outputBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucket").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(Pipeline.getter(Pipeline::role)).setter(Pipeline.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> AWS_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsKmsKeyArn").getter(Pipeline.getter(Pipeline::awsKmsKeyArn)).setter(Pipeline.setter(Builder::awsKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKeyArn").build()}).build();
    private static final SdkField<Notifications> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Notifications").getter(Pipeline.getter(Pipeline::notifications)).setter(Pipeline.setter(Builder::notifications)).constructor(Notifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build()}).build();
    private static final SdkField<PipelineOutputConfig> CONTENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentConfig").getter(Pipeline.getter(Pipeline::contentConfig)).setter(Pipeline.setter(Builder::contentConfig)).constructor(PipelineOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentConfig").build()}).build();
    private static final SdkField<PipelineOutputConfig> THUMBNAIL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThumbnailConfig").getter(Pipeline.getter(Pipeline::thumbnailConfig)).setter(Pipeline.setter(Builder::thumbnailConfig)).constructor(PipelineOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, STATUS_FIELD, INPUT_BUCKET_FIELD, OUTPUT_BUCKET_FIELD, ROLE_FIELD, AWS_KMS_KEY_ARN_FIELD, NOTIFICATIONS_FIELD, CONTENT_CONFIG_FIELD, THUMBNAIL_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("InputBucket", INPUT_BUCKET_FIELD);
            this.put("OutputBucket", OUTPUT_BUCKET_FIELD);
            this.put("Role", ROLE_FIELD);
            this.put("AwsKmsKeyArn", AWS_KMS_KEY_ARN_FIELD);
            this.put("Notifications", NOTIFICATIONS_FIELD);
            this.put("ContentConfig", CONTENT_CONFIG_FIELD);
            this.put("ThumbnailConfig", THUMBNAIL_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String status;
    private final String inputBucket;
    private final String outputBucket;
    private final String role;
    private final String awsKmsKeyArn;
    private final Notifications notifications;
    private final PipelineOutputConfig contentConfig;
    private final PipelineOutputConfig thumbnailConfig;

    private Pipeline(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.inputBucket = builder.inputBucket;
        this.outputBucket = builder.outputBucket;
        this.role = builder.role;
        this.awsKmsKeyArn = builder.awsKmsKeyArn;
        this.notifications = builder.notifications;
        this.contentConfig = builder.contentConfig;
        this.thumbnailConfig = builder.thumbnailConfig;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String status() {
        return this.status;
    }

    public final String inputBucket() {
        return this.inputBucket;
    }

    public final String outputBucket() {
        return this.outputBucket;
    }

    public final String role() {
        return this.role;
    }

    public final String awsKmsKeyArn() {
        return this.awsKmsKeyArn;
    }

    public final Notifications notifications() {
        return this.notifications;
    }

    public final PipelineOutputConfig contentConfig() {
        return this.contentConfig;
    }

    public final PipelineOutputConfig thumbnailConfig() {
        return this.thumbnailConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.inputBucket(), other.inputBucket()) && Objects.equals(this.outputBucket(), other.outputBucket()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.awsKmsKeyArn(), other.awsKmsKeyArn()) && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.contentConfig(), other.contentConfig()) && Objects.equals(this.thumbnailConfig(), other.thumbnailConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Pipeline").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("InputBucket", (Object)this.inputBucket()).add("OutputBucket", (Object)this.outputBucket()).add("Role", (Object)this.role()).add("AwsKmsKeyArn", (Object)this.awsKmsKeyArn()).add("Notifications", (Object)this.notifications()).add("ContentConfig", (Object)this.contentConfig()).add("ThumbnailConfig", (Object)this.thumbnailConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "InputBucket": {
                return Optional.ofNullable(clazz.cast(this.inputBucket()));
            }
            case "OutputBucket": {
                return Optional.ofNullable(clazz.cast(this.outputBucket()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "AwsKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.awsKmsKeyArn()));
            }
            case "Notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "ContentConfig": {
                return Optional.ofNullable(clazz.cast(this.contentConfig()));
            }
            case "ThumbnailConfig": {
                return Optional.ofNullable(clazz.cast(this.thumbnailConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Pipeline, T> g) {
        return obj -> g.apply((Pipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String status;
        private String inputBucket;
        private String outputBucket;
        private String role;
        private String awsKmsKeyArn;
        private Notifications notifications;
        private PipelineOutputConfig contentConfig;
        private PipelineOutputConfig thumbnailConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Pipeline model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
            this.inputBucket(model.inputBucket);
            this.outputBucket(model.outputBucket);
            this.role(model.role);
            this.awsKmsKeyArn(model.awsKmsKeyArn);
            this.notifications(model.notifications);
            this.contentConfig(model.contentConfig);
            this.thumbnailConfig(model.thumbnailConfig);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getInputBucket() {
            return this.inputBucket;
        }

        public final void setInputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
        }

        @Override
        public final Builder inputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
            return this;
        }

        public final String getOutputBucket() {
            return this.outputBucket;
        }

        public final void setOutputBucket(String outputBucket) {
            this.outputBucket = outputBucket;
        }

        @Override
        public final Builder outputBucket(String outputBucket) {
            this.outputBucket = outputBucket;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getAwsKmsKeyArn() {
            return this.awsKmsKeyArn;
        }

        public final void setAwsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
        }

        @Override
        public final Builder awsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
            return this;
        }

        public final Notifications.Builder getNotifications() {
            return this.notifications != null ? this.notifications.toBuilder() : null;
        }

        public final void setNotifications(Notifications.BuilderImpl notifications) {
            this.notifications = notifications != null ? notifications.build() : null;
        }

        @Override
        public final Builder notifications(Notifications notifications) {
            this.notifications = notifications;
            return this;
        }

        public final PipelineOutputConfig.Builder getContentConfig() {
            return this.contentConfig != null ? this.contentConfig.toBuilder() : null;
        }

        public final void setContentConfig(PipelineOutputConfig.BuilderImpl contentConfig) {
            this.contentConfig = contentConfig != null ? contentConfig.build() : null;
        }

        @Override
        public final Builder contentConfig(PipelineOutputConfig contentConfig) {
            this.contentConfig = contentConfig;
            return this;
        }

        public final PipelineOutputConfig.Builder getThumbnailConfig() {
            return this.thumbnailConfig != null ? this.thumbnailConfig.toBuilder() : null;
        }

        public final void setThumbnailConfig(PipelineOutputConfig.BuilderImpl thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig != null ? thumbnailConfig.build() : null;
        }

        @Override
        public final Builder thumbnailConfig(PipelineOutputConfig thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig;
            return this;
        }

        public Pipeline build() {
            return new Pipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Pipeline> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder inputBucket(String var1);

        public Builder outputBucket(String var1);

        public Builder role(String var1);

        public Builder awsKmsKeyArn(String var1);

        public Builder notifications(Notifications var1);

        default public Builder notifications(Consumer<Notifications.Builder> notifications) {
            return this.notifications((Notifications)((Notifications.Builder)Notifications.builder().applyMutation(notifications)).build());
        }

        public Builder contentConfig(PipelineOutputConfig var1);

        default public Builder contentConfig(Consumer<PipelineOutputConfig.Builder> contentConfig) {
            return this.contentConfig((PipelineOutputConfig)((PipelineOutputConfig.Builder)PipelineOutputConfig.builder().applyMutation(contentConfig)).build());
        }

        public Builder thumbnailConfig(PipelineOutputConfig var1);

        default public Builder thumbnailConfig(Consumer<PipelineOutputConfig.Builder> thumbnailConfig) {
            return this.thumbnailConfig((PipelineOutputConfig)((PipelineOutputConfig.Builder)PipelineOutputConfig.builder().applyMutation(thumbnailConfig)).build());
        }
    }
}

