/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for one clip in a composition. All jobs in a playlist must have the same clip settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Clip implements SdkPojo, Serializable, ToCopyableBuilder<Clip.Builder, Clip> {
    private static final SdkField<TimeSpan> TIME_SPAN_FIELD = SdkField.<TimeSpan> builder(MarshallingType.SDK_POJO)
            .memberName("TimeSpan").getter(getter(Clip::timeSpan)).setter(setter(Builder::timeSpan))
            .constructor(TimeSpan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSpan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_SPAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TimeSpan timeSpan;

    private Clip(BuilderImpl builder) {
        this.timeSpan = builder.timeSpan;
    }

    /**
     * <p>
     * Settings that determine when a clip begins and how long it lasts.
     * </p>
     * 
     * @return Settings that determine when a clip begins and how long it lasts.
     */
    public final TimeSpan timeSpan() {
        return timeSpan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeSpan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Clip)) {
            return false;
        }
        Clip other = (Clip) obj;
        return Objects.equals(timeSpan(), other.timeSpan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Clip").add("TimeSpan", timeSpan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeSpan":
            return Optional.ofNullable(clazz.cast(timeSpan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimeSpan", TIME_SPAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Clip, T> g) {
        return obj -> g.apply((Clip) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Clip> {
        /**
         * <p>
         * Settings that determine when a clip begins and how long it lasts.
         * </p>
         * 
         * @param timeSpan
         *        Settings that determine when a clip begins and how long it lasts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSpan(TimeSpan timeSpan);

        /**
         * <p>
         * Settings that determine when a clip begins and how long it lasts.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeSpan.Builder} avoiding the need to
         * create one manually via {@link TimeSpan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSpan.Builder#build()} is called immediately and its result is
         * passed to {@link #timeSpan(TimeSpan)}.
         * 
         * @param timeSpan
         *        a consumer that will call methods on {@link TimeSpan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSpan(TimeSpan)
         */
        default Builder timeSpan(Consumer<TimeSpan.Builder> timeSpan) {
            return timeSpan(TimeSpan.builder().applyMutation(timeSpan).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimeSpan timeSpan;

        private BuilderImpl() {
        }

        private BuilderImpl(Clip model) {
            timeSpan(model.timeSpan);
        }

        public final TimeSpan.Builder getTimeSpan() {
            return timeSpan != null ? timeSpan.toBuilder() : null;
        }

        public final void setTimeSpan(TimeSpan.BuilderImpl timeSpan) {
            this.timeSpan = timeSpan != null ? timeSpan.build() : null;
        }

        @Override
        public final Builder timeSpan(TimeSpan timeSpan) {
            this.timeSpan = timeSpan;
            return this;
        }

        @Override
        public Clip build() {
            return new Clip(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
