/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>CreateJobRequest</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobRequest extends ElasticTranscoderRequest implements
        ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineId").getter(getter(CreateJobRequest::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineId").build()).build();

    private static final SdkField<JobInput> INPUT_FIELD = SdkField.<JobInput> builder(MarshallingType.SDK_POJO)
            .memberName("Input").getter(getter(CreateJobRequest::input)).setter(setter(Builder::input))
            .constructor(JobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<List<JobInput>> INPUTS_FIELD = SdkField
            .<List<JobInput>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(CreateJobRequest::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CreateJobOutput> OUTPUT_FIELD = SdkField.<CreateJobOutput> builder(MarshallingType.SDK_POJO)
            .memberName("Output").getter(getter(CreateJobRequest::output)).setter(setter(Builder::output))
            .constructor(CreateJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final SdkField<List<CreateJobOutput>> OUTPUTS_FIELD = SdkField
            .<List<CreateJobOutput>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(CreateJobRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateJobOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateJobOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OUTPUT_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputKeyPrefix").getter(getter(CreateJobRequest::outputKeyPrefix))
            .setter(setter(Builder::outputKeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeyPrefix").build()).build();

    private static final SdkField<List<CreateJobPlaylist>> PLAYLISTS_FIELD = SdkField
            .<List<CreateJobPlaylist>> builder(MarshallingType.LIST)
            .memberName("Playlists")
            .getter(getter(CreateJobRequest::playlists))
            .setter(setter(Builder::playlists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Playlists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateJobPlaylist> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateJobPlaylist::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("UserMetadata")
            .getter(getter(CreateJobRequest::userMetadata))
            .setter(setter(Builder::userMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PIPELINE_ID_FIELD, INPUT_FIELD, INPUTS_FIELD, OUTPUT_FIELD, OUTPUTS_FIELD, OUTPUT_KEY_PREFIX_FIELD,
                    PLAYLISTS_FIELD, USER_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineId;

    private final JobInput input;

    private final List<JobInput> inputs;

    private final CreateJobOutput output;

    private final List<CreateJobOutput> outputs;

    private final String outputKeyPrefix;

    private final List<CreateJobPlaylist> playlists;

    private final Map<String, String> userMetadata;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.input = builder.input;
        this.inputs = builder.inputs;
        this.output = builder.output;
        this.outputs = builder.outputs;
        this.outputKeyPrefix = builder.outputKeyPrefix;
        this.playlists = builder.playlists;
        this.userMetadata = builder.userMetadata;
    }

    /**
     * <p>
     * The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline
     * determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to
     * transcode and the bucket into which Elastic Transcoder puts the transcoded files.
     * </p>
     * 
     * @return The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline
     *         determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files
     *         to transcode and the bucket into which Elastic Transcoder puts the transcoded files.
     */
    public final String pipelineId() {
        return pipelineId;
    }

    /**
     * <p>
     * A section of the request body that provides information about the file that is being transcoded.
     * </p>
     * 
     * @return A section of the request body that provides information about the file that is being transcoded.
     */
    public final JobInput input() {
        return input;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A section of the request body that provides information about the files that are being transcoded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return A section of the request body that provides information about the files that are being transcoded.
     */
    public final List<JobInput> inputs() {
        return inputs;
    }

    /**
     * <p>
     * A section of the request body that provides information about the transcoded (target) file. We strongly recommend
     * that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
     * </p>
     * 
     * @return A section of the request body that provides information about the transcoded (target) file. We strongly
     *         recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
     */
    public final CreateJobOutput output() {
        return output;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A section of the request body that provides information about the transcoded (target) files. We recommend that
     * you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return A section of the request body that provides information about the transcoded (target) files. We recommend
     *         that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
     */
    public final List<CreateJobOutput> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates,
     * including output files, thumbnails, and playlists.
     * </p>
     * 
     * @return The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job
     *         creates, including output files, thumbnails, and playlists.
     */
    public final String outputKeyPrefix() {
        return outputKeyPrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the Playlists property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPlaylists() {
        return playlists != null && !(playlists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
     * (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want Elastic
     * Transcoder to create.
     * </p>
     * <p>
     * The maximum number of master playlists in a job is 30.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlaylists} method.
     * </p>
     * 
     * @return If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
     *         (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want
     *         Elastic Transcoder to create.</p>
     *         <p>
     *         The maximum number of master playlists in a job is 30.
     */
    public final List<CreateJobPlaylist> playlists() {
        return playlists;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserMetadata() {
        return userMetadata != null && !(userMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in
     * <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic Transcoder
     * does not guarantee that <code>key/value</code> pairs are returned in the same order in which you specify them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserMetadata} method.
     * </p>
     * 
     * @return User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in
     *         <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic
     *         Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which
     *         you specify them.
     */
    public final Map<String, String> userMetadata() {
        return userMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlaylists() ? playlists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserMetadata() ? userMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        return Objects.equals(pipelineId(), other.pipelineId()) && Objects.equals(input(), other.input())
                && hasInputs() == other.hasInputs() && Objects.equals(inputs(), other.inputs())
                && Objects.equals(output(), other.output()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(outputKeyPrefix(), other.outputKeyPrefix())
                && hasPlaylists() == other.hasPlaylists() && Objects.equals(playlists(), other.playlists())
                && hasUserMetadata() == other.hasUserMetadata() && Objects.equals(userMetadata(), other.userMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobRequest").add("PipelineId", pipelineId()).add("Input", input())
                .add("Inputs", hasInputs() ? inputs() : null).add("Output", output())
                .add("Outputs", hasOutputs() ? outputs() : null).add("OutputKeyPrefix", outputKeyPrefix())
                .add("Playlists", hasPlaylists() ? playlists() : null)
                .add("UserMetadata", hasUserMetadata() ? userMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "OutputKeyPrefix":
            return Optional.ofNullable(clazz.cast(outputKeyPrefix()));
        case "Playlists":
            return Optional.ofNullable(clazz.cast(playlists()));
        case "UserMetadata":
            return Optional.ofNullable(clazz.cast(userMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineId", PIPELINE_ID_FIELD);
        map.put("Input", INPUT_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("Output", OUTPUT_FIELD);
        map.put("Outputs", OUTPUTS_FIELD);
        map.put("OutputKeyPrefix", OUTPUT_KEY_PREFIX_FIELD);
        map.put("Playlists", PLAYLISTS_FIELD);
        map.put("UserMetadata", USER_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * <p>
         * The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline
         * determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to
         * transcode and the bucket into which Elastic Transcoder puts the transcoded files.
         * </p>
         * 
         * @param pipelineId
         *        The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The
         *        pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder
         *        gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * <p>
         * A section of the request body that provides information about the file that is being transcoded.
         * </p>
         * 
         * @param input
         *        A section of the request body that provides information about the file that is being transcoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(JobInput input);

        /**
         * <p>
         * A section of the request body that provides information about the file that is being transcoded.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobInput.Builder} avoiding the need to
         * create one manually via {@link JobInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobInput.Builder#build()} is called immediately and its result is
         * passed to {@link #input(JobInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link JobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(JobInput)
         */
        default Builder input(Consumer<JobInput.Builder> input) {
            return input(JobInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * A section of the request body that provides information about the files that are being transcoded.
         * </p>
         * 
         * @param inputs
         *        A section of the request body that provides information about the files that are being transcoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<JobInput> inputs);

        /**
         * <p>
         * A section of the request body that provides information about the files that are being transcoded.
         * </p>
         * 
         * @param inputs
         *        A section of the request body that provides information about the files that are being transcoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(JobInput... inputs);

        /**
         * <p>
         * A section of the request body that provides information about the files that are being transcoded.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elastictranscoder.model.JobInput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.elastictranscoder.model.JobInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elastictranscoder.model.JobInput.Builder#build()} is called
         * immediately and its result is passed to {@link #inputs(List<JobInput>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elastictranscoder.model.JobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(java.util.Collection<JobInput>)
         */
        Builder inputs(Consumer<JobInput.Builder>... inputs);

        /**
         * <p>
         * A section of the request body that provides information about the transcoded (target) file. We strongly
         * recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
         * </p>
         * 
         * @param output
         *        A section of the request body that provides information about the transcoded (target) file. We
         *        strongly recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code>
         *        syntax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(CreateJobOutput output);

        /**
         * <p>
         * A section of the request body that provides information about the transcoded (target) file. We strongly
         * recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateJobOutput.Builder} avoiding the
         * need to create one manually via {@link CreateJobOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateJobOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #output(CreateJobOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link CreateJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(CreateJobOutput)
         */
        default Builder output(Consumer<CreateJobOutput.Builder> output) {
            return output(CreateJobOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * A section of the request body that provides information about the transcoded (target) files. We recommend
         * that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
         * </p>
         * 
         * @param outputs
         *        A section of the request body that provides information about the transcoded (target) files. We
         *        recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<CreateJobOutput> outputs);

        /**
         * <p>
         * A section of the request body that provides information about the transcoded (target) files. We recommend
         * that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
         * </p>
         * 
         * @param outputs
         *        A section of the request body that provides information about the transcoded (target) files. We
         *        recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(CreateJobOutput... outputs);

        /**
         * <p>
         * A section of the request body that provides information about the transcoded (target) files. We recommend
         * that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<CreateJobOutput>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<CreateJobOutput>)
         */
        Builder outputs(Consumer<CreateJobOutput.Builder>... outputs);

        /**
         * <p>
         * The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job
         * creates, including output files, thumbnails, and playlists.
         * </p>
         * 
         * @param outputKeyPrefix
         *        The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job
         *        creates, including output files, thumbnails, and playlists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKeyPrefix(String outputKeyPrefix);

        /**
         * <p>
         * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         * (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want
         * Elastic Transcoder to create.
         * </p>
         * <p>
         * The maximum number of master playlists in a job is 30.
         * </p>
         * 
         * @param playlists
         *        If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         *        (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you
         *        want Elastic Transcoder to create.</p>
         *        <p>
         *        The maximum number of master playlists in a job is 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playlists(Collection<CreateJobPlaylist> playlists);

        /**
         * <p>
         * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         * (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want
         * Elastic Transcoder to create.
         * </p>
         * <p>
         * The maximum number of master playlists in a job is 30.
         * </p>
         * 
         * @param playlists
         *        If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         *        (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you
         *        want Elastic Transcoder to create.</p>
         *        <p>
         *        The maximum number of master playlists in a job is 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playlists(CreateJobPlaylist... playlists);

        /**
         * <p>
         * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         * (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want
         * Elastic Transcoder to create.
         * </p>
         * <p>
         * The maximum number of master playlists in a job is 30.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist.Builder#build()} is called
         * immediately and its result is passed to {@link #playlists(List<CreateJobPlaylist>)}.
         * 
         * @param playlists
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #playlists(java.util.Collection<CreateJobPlaylist>)
         */
        Builder playlists(Consumer<CreateJobPlaylist.Builder>... playlists);

        /**
         * <p>
         * User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in
         * <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic
         * Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which you
         * specify them.
         * </p>
         * 
         * @param userMetadata
         *        User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata
         *        in <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job.
         *        Elastic Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order
         *        in which you specify them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMetadata(Map<String, String> userMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticTranscoderRequest.BuilderImpl implements Builder {
        private String pipelineId;

        private JobInput input;

        private List<JobInput> inputs = DefaultSdkAutoConstructList.getInstance();

        private CreateJobOutput output;

        private List<CreateJobOutput> outputs = DefaultSdkAutoConstructList.getInstance();

        private String outputKeyPrefix;

        private List<CreateJobPlaylist> playlists = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            pipelineId(model.pipelineId);
            input(model.input);
            inputs(model.inputs);
            output(model.output);
            outputs(model.outputs);
            outputKeyPrefix(model.outputKeyPrefix);
            playlists(model.playlists);
            userMetadata(model.userMetadata);
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final JobInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(JobInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(JobInput input) {
            this.input = input;
            return this;
        }

        public final List<JobInput.Builder> getInputs() {
            List<JobInput.Builder> result = JobInputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<JobInput.BuilderImpl> inputs) {
            this.inputs = JobInputsCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<JobInput> inputs) {
            this.inputs = JobInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(JobInput... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<JobInput.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> JobInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CreateJobOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(CreateJobOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(CreateJobOutput output) {
            this.output = output;
            return this;
        }

        public final List<CreateJobOutput.Builder> getOutputs() {
            List<CreateJobOutput.Builder> result = CreateJobOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<CreateJobOutput.BuilderImpl> outputs) {
            this.outputs = CreateJobOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<CreateJobOutput> outputs) {
            this.outputs = CreateJobOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(CreateJobOutput... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<CreateJobOutput.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> CreateJobOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOutputKeyPrefix() {
            return outputKeyPrefix;
        }

        public final void setOutputKeyPrefix(String outputKeyPrefix) {
            this.outputKeyPrefix = outputKeyPrefix;
        }

        @Override
        public final Builder outputKeyPrefix(String outputKeyPrefix) {
            this.outputKeyPrefix = outputKeyPrefix;
            return this;
        }

        public final List<CreateJobPlaylist.Builder> getPlaylists() {
            List<CreateJobPlaylist.Builder> result = CreateJobPlaylistsCopier.copyToBuilder(this.playlists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlaylists(Collection<CreateJobPlaylist.BuilderImpl> playlists) {
            this.playlists = CreateJobPlaylistsCopier.copyFromBuilder(playlists);
        }

        @Override
        public final Builder playlists(Collection<CreateJobPlaylist> playlists) {
            this.playlists = CreateJobPlaylistsCopier.copy(playlists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playlists(CreateJobPlaylist... playlists) {
            playlists(Arrays.asList(playlists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playlists(Consumer<CreateJobPlaylist.Builder>... playlists) {
            playlists(Stream.of(playlists).map(c -> CreateJobPlaylist.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getUserMetadata() {
            if (userMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return userMetadata;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = UserMetadataCopier.copy(userMetadata);
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = UserMetadataCopier.copy(userMetadata);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
