/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The HLS content protection settings, if any, that you want Elastic Transcoder to apply to your output files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsContentProtection implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsContentProtection.Builder, HlsContentProtection> {
    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Method")
            .getter(getter(HlsContentProtection::method)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(HlsContentProtection::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> KEY_MD5_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyMd5")
            .getter(getter(HlsContentProtection::keyMd5)).setter(setter(Builder::keyMd5))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMd5").build()).build();

    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitializationVector").getter(getter(HlsContentProtection::initializationVector))
            .setter(setter(Builder::initializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build())
            .build();

    private static final SdkField<String> LICENSE_ACQUISITION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseAcquisitionUrl").getter(getter(HlsContentProtection::licenseAcquisitionUrl))
            .setter(setter(Builder::licenseAcquisitionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAcquisitionUrl").build())
            .build();

    private static final SdkField<String> KEY_STORAGE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyStoragePolicy").getter(getter(HlsContentProtection::keyStoragePolicy))
            .setter(setter(Builder::keyStoragePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStoragePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METHOD_FIELD, KEY_FIELD,
            KEY_MD5_FIELD, INITIALIZATION_VECTOR_FIELD, LICENSE_ACQUISITION_URL_FIELD, KEY_STORAGE_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String method;

    private final String key;

    private final String keyMd5;

    private final String initializationVector;

    private final String licenseAcquisitionUrl;

    private final String keyStoragePolicy;

    private HlsContentProtection(BuilderImpl builder) {
        this.method = builder.method;
        this.key = builder.key;
        this.keyMd5 = builder.keyMd5;
        this.initializationVector = builder.initializationVector;
        this.licenseAcquisitionUrl = builder.licenseAcquisitionUrl;
        this.keyStoragePolicy = builder.keyStoragePolicy;
    }

    /**
     * <p>
     * The content protection method for your output. The only valid value is: <code>aes-128</code>.
     * </p>
     * <p>
     * This value is written into the method attribute of the <code>EXT-X-KEY</code> metadata tag in the output
     * playlist.
     * </p>
     * 
     * @return The content protection method for your output. The only valid value is: <code>aes-128</code>.</p>
     *         <p>
     *         This value is written into the method attribute of the <code>EXT-X-KEY</code> metadata tag in the output
     *         playlist.
     */
    public final String method() {
        return method;
    }

    /**
     * <p>
     * If you want Elastic Transcoder to generate a key for you, leave this field blank.
     * </p>
     * <p>
     * If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be base64-encoded,
     * and it must be one of the following bit lengths before being base64-encoded:
     * </p>
     * <p>
     * <code>128</code>, <code>192</code>, or <code>256</code>.
     * </p>
     * 
     * @return If you want Elastic Transcoder to generate a key for you, leave this field blank.</p>
     *         <p>
     *         If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be
     *         base64-encoded, and it must be one of the following bit lengths before being base64-encoded:
     *         </p>
     *         <p>
     *         <code>128</code>, <code>192</code>, or <code>256</code>.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * If Elastic Transcoder is generating your key for you, you must leave this field blank.
     * </p>
     * <p>
     * The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and that you want
     * Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be
     * base64-encoded, and it must be exactly 16 bytes before being base64- encoded.
     * </p>
     * 
     * @return If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
     *         <p>
     *         The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and that
     *         you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The
     *         key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64- encoded.
     */
    public final String keyMd5() {
        return keyMd5;
    }

    /**
     * <p>
     * If Elastic Transcoder is generating your key for you, you must leave this field blank.
     * </p>
     * <p>
     * The series of random bits created by a random bit generator, unique for every encryption operation, that you want
     * Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it
     * must be exactly 16 bytes before being base64-encoded.
     * </p>
     * 
     * @return If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
     *         <p>
     *         The series of random bits created by a random bit generator, unique for every encryption operation, that
     *         you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be
     *         base64-encoded, and it must be exactly 16 bytes before being base64-encoded.
     */
    public final String initializationVector() {
        return initializationVector;
    }

    /**
     * <p>
     * The location of the license key required to decrypt your HLS playlist. The URL must be an absolute path, and is
     * referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.
     * </p>
     * 
     * @return The location of the license key required to decrypt your HLS playlist. The URL must be an absolute path,
     *         and is referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.
     */
    public final String licenseAcquisitionUrl() {
        return licenseAcquisitionUrl;
    }

    /**
     * <p>
     * Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If you choose
     * <code>WithVariantPlaylists</code>, <code>LicenseAcquisitionUrl</code> must be left blank and Elastic Transcoder
     * writes your data key into the same bucket as the associated playlist.
     * </p>
     * 
     * @return Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If you
     *         choose <code>WithVariantPlaylists</code>, <code>LicenseAcquisitionUrl</code> must be left blank and
     *         Elastic Transcoder writes your data key into the same bucket as the associated playlist.
     */
    public final String keyStoragePolicy() {
        return keyStoragePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(method());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(keyMd5());
        hashCode = 31 * hashCode + Objects.hashCode(initializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(licenseAcquisitionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(keyStoragePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsContentProtection)) {
            return false;
        }
        HlsContentProtection other = (HlsContentProtection) obj;
        return Objects.equals(method(), other.method()) && Objects.equals(key(), other.key())
                && Objects.equals(keyMd5(), other.keyMd5())
                && Objects.equals(initializationVector(), other.initializationVector())
                && Objects.equals(licenseAcquisitionUrl(), other.licenseAcquisitionUrl())
                && Objects.equals(keyStoragePolicy(), other.keyStoragePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsContentProtection").add("Method", method()).add("Key", key()).add("KeyMd5", keyMd5())
                .add("InitializationVector", initializationVector()).add("LicenseAcquisitionUrl", licenseAcquisitionUrl())
                .add("KeyStoragePolicy", keyStoragePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Method":
            return Optional.ofNullable(clazz.cast(method()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "KeyMd5":
            return Optional.ofNullable(clazz.cast(keyMd5()));
        case "InitializationVector":
            return Optional.ofNullable(clazz.cast(initializationVector()));
        case "LicenseAcquisitionUrl":
            return Optional.ofNullable(clazz.cast(licenseAcquisitionUrl()));
        case "KeyStoragePolicy":
            return Optional.ofNullable(clazz.cast(keyStoragePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Method", METHOD_FIELD);
        map.put("Key", KEY_FIELD);
        map.put("KeyMd5", KEY_MD5_FIELD);
        map.put("InitializationVector", INITIALIZATION_VECTOR_FIELD);
        map.put("LicenseAcquisitionUrl", LICENSE_ACQUISITION_URL_FIELD);
        map.put("KeyStoragePolicy", KEY_STORAGE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HlsContentProtection, T> g) {
        return obj -> g.apply((HlsContentProtection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsContentProtection> {
        /**
         * <p>
         * The content protection method for your output. The only valid value is: <code>aes-128</code>.
         * </p>
         * <p>
         * This value is written into the method attribute of the <code>EXT-X-KEY</code> metadata tag in the output
         * playlist.
         * </p>
         * 
         * @param method
         *        The content protection method for your output. The only valid value is: <code>aes-128</code>.</p>
         *        <p>
         *        This value is written into the method attribute of the <code>EXT-X-KEY</code> metadata tag in the
         *        output playlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder method(String method);

        /**
         * <p>
         * If you want Elastic Transcoder to generate a key for you, leave this field blank.
         * </p>
         * <p>
         * If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be
         * base64-encoded, and it must be one of the following bit lengths before being base64-encoded:
         * </p>
         * <p>
         * <code>128</code>, <code>192</code>, or <code>256</code>.
         * </p>
         * 
         * @param key
         *        If you want Elastic Transcoder to generate a key for you, leave this field blank.</p>
         *        <p>
         *        If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be
         *        base64-encoded, and it must be one of the following bit lengths before being base64-encoded:
         *        </p>
         *        <p>
         *        <code>128</code>, <code>192</code>, or <code>256</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * If Elastic Transcoder is generating your key for you, you must leave this field blank.
         * </p>
         * <p>
         * The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and that you
         * want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5
         * must be base64-encoded, and it must be exactly 16 bytes before being base64- encoded.
         * </p>
         * 
         * @param keyMd5
         *        If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
         *        <p>
         *        The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and
         *        that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in
         *        transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64-
         *        encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMd5(String keyMd5);

        /**
         * <p>
         * If Elastic Transcoder is generating your key for you, you must leave this field blank.
         * </p>
         * <p>
         * The series of random bits created by a random bit generator, unique for every encryption operation, that you
         * want Elastic Transcoder to use to encrypt your output files. The initialization vector must be
         * base64-encoded, and it must be exactly 16 bytes before being base64-encoded.
         * </p>
         * 
         * @param initializationVector
         *        If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
         *        <p>
         *        The series of random bits created by a random bit generator, unique for every encryption operation,
         *        that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must
         *        be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationVector(String initializationVector);

        /**
         * <p>
         * The location of the license key required to decrypt your HLS playlist. The URL must be an absolute path, and
         * is referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.
         * </p>
         * 
         * @param licenseAcquisitionUrl
         *        The location of the license key required to decrypt your HLS playlist. The URL must be an absolute
         *        path, and is referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseAcquisitionUrl(String licenseAcquisitionUrl);

        /**
         * <p>
         * Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If you
         * choose <code>WithVariantPlaylists</code>, <code>LicenseAcquisitionUrl</code> must be left blank and Elastic
         * Transcoder writes your data key into the same bucket as the associated playlist.
         * </p>
         * 
         * @param keyStoragePolicy
         *        Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If
         *        you choose <code>WithVariantPlaylists</code>, <code>LicenseAcquisitionUrl</code> must be left blank
         *        and Elastic Transcoder writes your data key into the same bucket as the associated playlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyStoragePolicy(String keyStoragePolicy);
    }

    static final class BuilderImpl implements Builder {
        private String method;

        private String key;

        private String keyMd5;

        private String initializationVector;

        private String licenseAcquisitionUrl;

        private String keyStoragePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsContentProtection model) {
            method(model.method);
            key(model.key);
            keyMd5(model.keyMd5);
            initializationVector(model.initializationVector);
            licenseAcquisitionUrl(model.licenseAcquisitionUrl);
            keyStoragePolicy(model.keyStoragePolicy);
        }

        public final String getMethod() {
            return method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getKeyMd5() {
            return keyMd5;
        }

        public final void setKeyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
        }

        @Override
        public final Builder keyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
            return this;
        }

        public final String getInitializationVector() {
            return initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public final String getLicenseAcquisitionUrl() {
            return licenseAcquisitionUrl;
        }

        public final void setLicenseAcquisitionUrl(String licenseAcquisitionUrl) {
            this.licenseAcquisitionUrl = licenseAcquisitionUrl;
        }

        @Override
        public final Builder licenseAcquisitionUrl(String licenseAcquisitionUrl) {
            this.licenseAcquisitionUrl = licenseAcquisitionUrl;
            return this;
        }

        public final String getKeyStoragePolicy() {
            return keyStoragePolicy;
        }

        public final void setKeyStoragePolicy(String keyStoragePolicy) {
            this.keyStoragePolicy = keyStoragePolicy;
        }

        @Override
        public final Builder keyStoragePolicy(String keyStoragePolicy) {
            this.keyStoragePolicy = keyStoragePolicy;
            return this;
        }

        @Override
        public HlsContentProtection build() {
            return new HlsContentProtection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
