/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <important>
 * <p>
 * Outputs recommended instead.
 * </p>
 * </important>
 * <p>
 * If you specified one output for a job, information about that output. If you specified multiple outputs for a job,
 * the <code>Output</code> object lists information about the first output. This duplicates the information that is
 * listed for the first output in the <code>Outputs</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobOutput implements SdkPojo, Serializable, ToCopyableBuilder<JobOutput.Builder, JobOutput> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(JobOutput::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(JobOutput::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> THUMBNAIL_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThumbnailPattern").getter(getter(JobOutput::thumbnailPattern)).setter(setter(Builder::thumbnailPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailPattern").build()).build();

    private static final SdkField<Encryption> THUMBNAIL_ENCRYPTION_FIELD = SdkField
            .<Encryption> builder(MarshallingType.SDK_POJO).memberName("ThumbnailEncryption")
            .getter(getter(JobOutput::thumbnailEncryption)).setter(setter(Builder::thumbnailEncryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailEncryption").build())
            .build();

    private static final SdkField<String> ROTATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Rotate")
            .getter(getter(JobOutput::rotate)).setter(setter(Builder::rotate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rotate").build()).build();

    private static final SdkField<String> PRESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PresetId").getter(getter(JobOutput::presetId)).setter(setter(Builder::presetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetId").build()).build();

    private static final SdkField<String> SEGMENT_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentDuration").getter(getter(JobOutput::segmentDuration)).setter(setter(Builder::segmentDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDuration").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(JobOutput::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetail").getter(getter(JobOutput::statusDetail)).setter(setter(Builder::statusDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(JobOutput::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(JobOutput::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(JobOutput::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()).build();

    private static final SdkField<String> FRAME_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameRate").getter(getter(JobOutput::frameRate)).setter(setter(Builder::frameRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameRate").build()).build();

    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("FileSize")
            .getter(getter(JobOutput::fileSize)).setter(setter(Builder::fileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSize").build()).build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(JobOutput::durationMillis)).setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final SdkField<List<JobWatermark>> WATERMARKS_FIELD = SdkField
            .<List<JobWatermark>> builder(MarshallingType.LIST)
            .memberName("Watermarks")
            .getter(getter(JobOutput::watermarks))
            .setter(setter(Builder::watermarks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Watermarks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobWatermark> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobWatermark::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<JobAlbumArt> ALBUM_ART_FIELD = SdkField.<JobAlbumArt> builder(MarshallingType.SDK_POJO)
            .memberName("AlbumArt").getter(getter(JobOutput::albumArt)).setter(setter(Builder::albumArt))
            .constructor(JobAlbumArt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlbumArt").build()).build();

    private static final SdkField<List<Clip>> COMPOSITION_FIELD = SdkField
            .<List<Clip>> builder(MarshallingType.LIST)
            .memberName("Composition")
            .getter(getter(JobOutput::composition))
            .setter(setter(Builder::composition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Composition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Clip> builder(MarshallingType.SDK_POJO)
                                            .constructor(Clip::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Captions> CAPTIONS_FIELD = SdkField.<Captions> builder(MarshallingType.SDK_POJO)
            .memberName("Captions").getter(getter(JobOutput::captions)).setter(setter(Builder::captions))
            .constructor(Captions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Captions").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(JobOutput::encryption)).setter(setter(Builder::encryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final SdkField<String> APPLIED_COLOR_SPACE_CONVERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AppliedColorSpaceConversion")
            .getter(getter(JobOutput::appliedColorSpaceConversion))
            .setter(setter(Builder::appliedColorSpaceConversion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedColorSpaceConversion")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, KEY_FIELD,
            THUMBNAIL_PATTERN_FIELD, THUMBNAIL_ENCRYPTION_FIELD, ROTATE_FIELD, PRESET_ID_FIELD, SEGMENT_DURATION_FIELD,
            STATUS_FIELD, STATUS_DETAIL_FIELD, DURATION_FIELD, WIDTH_FIELD, HEIGHT_FIELD, FRAME_RATE_FIELD, FILE_SIZE_FIELD,
            DURATION_MILLIS_FIELD, WATERMARKS_FIELD, ALBUM_ART_FIELD, COMPOSITION_FIELD, CAPTIONS_FIELD, ENCRYPTION_FIELD,
            APPLIED_COLOR_SPACE_CONVERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String key;

    private final String thumbnailPattern;

    private final Encryption thumbnailEncryption;

    private final String rotate;

    private final String presetId;

    private final String segmentDuration;

    private final String status;

    private final String statusDetail;

    private final Long duration;

    private final Integer width;

    private final Integer height;

    private final String frameRate;

    private final Long fileSize;

    private final Long durationMillis;

    private final List<JobWatermark> watermarks;

    private final JobAlbumArt albumArt;

    private final List<Clip> composition;

    private final Captions captions;

    private final Encryption encryption;

    private final String appliedColorSpaceConversion;

    private JobOutput(BuilderImpl builder) {
        this.id = builder.id;
        this.key = builder.key;
        this.thumbnailPattern = builder.thumbnailPattern;
        this.thumbnailEncryption = builder.thumbnailEncryption;
        this.rotate = builder.rotate;
        this.presetId = builder.presetId;
        this.segmentDuration = builder.segmentDuration;
        this.status = builder.status;
        this.statusDetail = builder.statusDetail;
        this.duration = builder.duration;
        this.width = builder.width;
        this.height = builder.height;
        this.frameRate = builder.frameRate;
        this.fileSize = builder.fileSize;
        this.durationMillis = builder.durationMillis;
        this.watermarks = builder.watermarks;
        this.albumArt = builder.albumArt;
        this.composition = builder.composition;
        this.captions = builder.captions;
        this.encryption = builder.encryption;
        this.appliedColorSpaceConversion = builder.appliedColorSpaceConversion;
    }

    /**
     * <p>
     * A sequential counter, starting with 1, that identifies an output among the outputs from the current job. In the
     * Output syntax, this value is always 1.
     * </p>
     * 
     * @return A sequential counter, starting with 1, that identifies an output among the outputs from the current job.
     *         In the Output syntax, this value is always 1.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by
     * the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID.
     * </p>
     * 
     * @return The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket
     *         specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic
     * Transcoder to name the files.
     * </p>
     * <p>
     * If you don't want Elastic Transcoder to create thumbnails, specify "".
     * </p>
     * <p>
     * If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the
     * file name for each thumbnail. You can specify the following values in any sequence:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code>
     * in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a
     * five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a
     * given thumbnail appears in the sequence of thumbnails for a transcoded file.
     * </p>
     * <important>
     * <p>
     * If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic
     * Transcoder returns a validation error and does not create the job.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code>
     * object. For example, you can include them as a file name prefix or as a delimiter between
     * <code>{resolution}</code> and <code>{count}</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the
     * file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that
     * appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>.
     * Elastic Transcoder also appends the applicable file name extension.
     * </p>
     * 
     * @return Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic
     *         Transcoder to name the files.</p>
     *         <p>
     *         If you don't want Elastic Transcoder to create thumbnails, specify "".
     *         </p>
     *         <p>
     *         If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include
     *         in the file name for each thumbnail. You can specify the following values in any sequence:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include
     *         <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify
     *         <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>)
     *         to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of
     *         thumbnails for a transcoded file.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>,
     *         Elastic Transcoder returns a validation error and does not create the job.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>Literal values (Optional)</b>: You can specify literal values anywhere in the
     *         <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a
     *         delimiter between <code>{resolution}</code> and <code>{count}</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in
     *         the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png)
     *         that appears in the preset that you specified in the <code>PresetID</code> value of
     *         <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.
     */
    public final String thumbnailPattern() {
        return thumbnailPattern;
    }

    /**
     * <p>
     * The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
     * </p>
     * 
     * @return The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
     */
    public final Encryption thumbnailEncryption() {
        return thumbnailEncryption;
    }

    /**
     * <p>
     * The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input.
     * Enter one of the following values:
     * </p>
     * <p>
     * <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code>
     * </p>
     * <p>
     * The value <code>auto</code> generally works only if the file that you're transcoding contains rotation metadata.
     * </p>
     * 
     * @return The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the
     *         input. Enter one of the following values:</p>
     *         <p>
     *         <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code>
     *         </p>
     *         <p>
     *         The value <code>auto</code> generally works only if the file that you're transcoding contains rotation
     *         metadata.
     */
    public final String rotate() {
        return rotate;
    }

    /**
     * <p>
     * The value of the <code>Id</code> object for the preset that you want to use for this job. The preset determines
     * the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To use a preset that you
     * created, specify the preset ID that Elastic Transcoder returned in the response when you created the preset. You
     * can also use the Elastic Transcoder system presets, which you can get with <code>ListPresets</code>.
     * </p>
     * 
     * @return The value of the <code>Id</code> object for the preset that you want to use for this job. The preset
     *         determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To use
     *         a preset that you created, specify the preset ID that Elastic Transcoder returned in the response when
     *         you created the preset. You can also use the Elastic Transcoder system presets, which you can get with
     *         <code>ListPresets</code>.
     */
    public final String presetId() {
        return presetId;
    }

    /**
     * <important>
     * <p>
     * (Outputs in Fragmented MP4 or MPEG-TS format only.
     * </p>
     * </important>
     * <p>
     * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is
     * <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target
     * maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is
     * stored in a separate <code>.ts</code> file. For <code>HLSv4</code>, <code>MPEG-DASH</code>, and
     * <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is
     * approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or
     * longer.
     * </p>
     * <p>
     * The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by
     * <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.
     * </p>
     * <p>
     * Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify
     * in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of
     * the associated playlist.
     * </p>
     * 
     * @return <p>
     *         (Outputs in Fragmented MP4 or MPEG-TS format only.
     *         </p>
     *         </important>
     *         <p>
     *         If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is
     *         <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the
     *         target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media
     *         segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code>, <code>MPEG-DASH</code>,
     *         and <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each
     *         segment is approximately the length of the <code>SegmentDuration</code>, though individual segments might
     *         be shorter or longer.
     *         </p>
     *         <p>
     *         The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by
     *         <code>SegmentDuration</code>, the duration of the last segment is the remainder of total
     *         length/SegmentDuration.
     *         </p>
     *         <p>
     *         Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you
     *         specify in OutputKeys. To add an output to the master playlist for this job, include it in the
     *         <code>OutputKeys</code> of the associated playlist.
     */
    public final String segmentDuration() {
        return segmentDuration;
    }

    /**
     * <p>
     * The status of one output in a job. If you specified only one output for the job, <code>Outputs:Status</code> is
     * always the same as <code>Job:Status</code>. If you specified more than one output:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Job:Status</code> and <code>Outputs:Status</code> for all of the outputs is Submitted until Elastic
     * Transcoder starts to process the first output.
     * </p>
     * </li>
     * <li>
     * <p>
     * When Elastic Transcoder starts to process the first output, <code>Outputs:Status</code> for that output and
     * <code>Job:Status</code> both change to Progressing. For each output, the value of <code>Outputs:Status</code>
     * remains Submitted until Elastic Transcoder starts to process the output.
     * </p>
     * </li>
     * <li>
     * <p>
     * Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or Error.
     * </p>
     * </li>
     * <li>
     * <p>
     * When all of the outputs reach a terminal status, <code>Job:Status</code> changes to Complete only if
     * <code>Outputs:Status</code> for all of the outputs is <code>Complete</code>. If <code>Outputs:Status</code> for
     * one or more outputs is <code>Error</code>, the terminal status for <code>Job:Status</code> is also
     * <code>Error</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The value of <code>Status</code> is one of the following: <code>Submitted</code>, <code>Progressing</code>,
     * <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>.
     * </p>
     * 
     * @return The status of one output in a job. If you specified only one output for the job,
     *         <code>Outputs:Status</code> is always the same as <code>Job:Status</code>. If you specified more than one
     *         output: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Job:Status</code> and <code>Outputs:Status</code> for all of the outputs is Submitted until Elastic
     *         Transcoder starts to process the first output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When Elastic Transcoder starts to process the first output, <code>Outputs:Status</code> for that output
     *         and <code>Job:Status</code> both change to Progressing. For each output, the value of
     *         <code>Outputs:Status</code> remains Submitted until Elastic Transcoder starts to process the output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or
     *         Error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When all of the outputs reach a terminal status, <code>Job:Status</code> changes to Complete only if
     *         <code>Outputs:Status</code> for all of the outputs is <code>Complete</code>. If
     *         <code>Outputs:Status</code> for one or more outputs is <code>Error</code>, the terminal status for
     *         <code>Job:Status</code> is also <code>Error</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The value of <code>Status</code> is one of the following: <code>Submitted</code>,
     *         <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Information that further explains <code>Status</code>.
     * </p>
     * 
     * @return Information that further explains <code>Status</code>.
     */
    public final String statusDetail() {
        return statusDetail;
    }

    /**
     * <p>
     * Duration of the output file, in seconds.
     * </p>
     * 
     * @return Duration of the output file, in seconds.
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * Specifies the width of the output file in pixels.
     * </p>
     * 
     * @return Specifies the width of the output file in pixels.
     */
    public final Integer width() {
        return width;
    }

    /**
     * <p>
     * Height of the output file, in pixels.
     * </p>
     * 
     * @return Height of the output file, in pixels.
     */
    public final Integer height() {
        return height;
    }

    /**
     * <p>
     * Frame rate of the output file, in frames per second.
     * </p>
     * 
     * @return Frame rate of the output file, in frames per second.
     */
    public final String frameRate() {
        return frameRate;
    }

    /**
     * <p>
     * File size of the output file, in bytes.
     * </p>
     * 
     * @return File size of the output file, in bytes.
     */
    public final Long fileSize() {
        return fileSize;
    }

    /**
     * <p>
     * Duration of the output file, in milliseconds.
     * </p>
     * 
     * @return Duration of the output file, in milliseconds.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    /**
     * For responses, this returns true if the service returned a value for the Watermarks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWatermarks() {
        return watermarks != null && !(watermarks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can
     * specify up to four watermarks for each output. Settings for each watermark must be defined in the preset that you
     * specify in <code>Preset</code> for the current output.
     * </p>
     * <p>
     * Watermarks are added to the output video in the sequence in which you list them in the job output—the first
     * watermark in the list is added to the output video first, the second watermark in the list is added next, and so
     * on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same
     * location, the second watermark that you add covers the first one, the third one covers the second, and the fourth
     * one covers the third.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWatermarks} method.
     * </p>
     * 
     * @return Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding.
     *         You can specify up to four watermarks for each output. Settings for each watermark must be defined in the
     *         preset that you specify in <code>Preset</code> for the current output.</p>
     *         <p>
     *         Watermarks are added to the output video in the sequence in which you list them in the job output—the
     *         first watermark in the list is added to the output video first, the second watermark in the list is added
     *         next, and so on. As a result, if the settings in a preset cause Elastic Transcoder to place all
     *         watermarks in the same location, the second watermark that you add covers the first one, the third one
     *         covers the second, and the fourth one covers the third.
     */
    public final List<JobWatermark> watermarks() {
        return watermarks;
    }

    /**
     * <p>
     * The album art to be associated with the output file, if any.
     * </p>
     * 
     * @return The album art to be associated with the output file, if any.
     */
    public final JobAlbumArt albumArt() {
        return albumArt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Composition property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated
     */
    @Deprecated
    public final boolean hasComposition() {
        return composition != null && !(composition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come
     * from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make
     * up an output file. For the current release, you can only specify settings for a single clip per output file. The
     * Composition object cannot be null.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComposition} method.
     * </p>
     * 
     * @return You can create an output file that contains an excerpt from the input file. This excerpt, called a clip,
     *         can come from the beginning, middle, or end of the file. The Composition object contains settings for the
     *         clips that make up an output file. For the current release, you can only specify settings for a single
     *         clip per output file. The Composition object cannot be null.
     * @deprecated
     */
    @Deprecated
    public final List<Clip> composition() {
        return composition;
    }

    /**
     * <p>
     * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
     * captions must be in UTF-8. Elastic Transcoder supports two types of captions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder
     * supports only one embedded caption per language, to a maximum of 300 embedded captions per file.
     * </p>
     * <p>
     * Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
     * <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
     * </p>
     * <p>
     * Valid outputs include: <code>mov-text</code>
     * </p>
     * <p>
     * Elastic Transcoder supports a maximum of one embedded format per output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar
     * captions require a player that is capable of understanding the relationship between the video file and the
     * sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar
     * captions per file.
     * </p>
     * <p>
     * Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>,
     * <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code>
     * </p>
     * <p>
     * Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and
     * <code>webvtt</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     * </p>
     * <p>
     * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid
     * input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text
     * formatting (for example, italics) during the transcoding process.
     * </p>
     * <p>
     * To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing
     * captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null
     * <code>CaptionSources</code> array.
     * </p>
     * <p>
     * For more information on embedded files, see the Subtitles Wikipedia page.
     * </p>
     * <p>
     * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
     * </p>
     * 
     * @return You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
     *         captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic
     *         Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per
     *         file.
     *         </p>
     *         <p>
     *         Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
     *         <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
     *         </p>
     *         <p>
     *         Valid outputs include: <code>mov-text</code>
     *         </p>
     *         <p>
     *         Elastic Transcoder supports a maximum of one embedded format per output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data.
     *         Sidecar captions require a player that is capable of understanding the relationship between the video
     *         file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a
     *         maximum of 20 sidecar captions per file.
     *         </p>
     *         <p>
     *         Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>,
     *         <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and
     *         <code>webvtt</code>
     *         </p>
     *         <p>
     *         Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>,
     *         and <code>webvtt</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     *         </p>
     *         <p>
     *         Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a
     *         valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not
     *         preserve text formatting (for example, italics) during the transcoding process.
     *         </p>
     *         <p>
     *         To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through
     *         existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a
     *         null <code>CaptionSources</code> array.
     *         </p>
     *         <p>
     *         For more information on embedded files, see the Subtitles Wikipedia page.
     *         </p>
     *         <p>
     *         For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia
     *         pages.
     */
    public final Captions captions() {
        return captions;
    }

    /**
     * <p>
     * The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you choose to
     * use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic Transcoder writes an
     * unencrypted file to your Amazon S3 bucket.
     * </p>
     * 
     * @return The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you
     *         choose to use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic
     *         Transcoder writes an unencrypted file to your Amazon S3 bucket.
     */
    public final Encryption encryption() {
        return encryption;
    }

    /**
     * <p>
     * If Elastic Transcoder used a preset with a <code>ColorSpaceConversionMode</code> to transcode the output file,
     * the <code>AppliedColorSpaceConversion</code> parameter shows the conversion used. If no
     * <code>ColorSpaceConversionMode</code> was defined in the preset, this parameter is not be included in the job
     * response.
     * </p>
     * 
     * @return If Elastic Transcoder used a preset with a <code>ColorSpaceConversionMode</code> to transcode the output
     *         file, the <code>AppliedColorSpaceConversion</code> parameter shows the conversion used. If no
     *         <code>ColorSpaceConversionMode</code> was defined in the preset, this parameter is not be included in the
     *         job response.
     */
    public final String appliedColorSpaceConversion() {
        return appliedColorSpaceConversion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailPattern());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(rotate());
        hashCode = 31 * hashCode + Objects.hashCode(presetId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDuration());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(hasWatermarks() ? watermarks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(albumArt());
        hashCode = 31 * hashCode + Objects.hashCode(hasComposition() ? composition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(captions());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(appliedColorSpaceConversion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobOutput)) {
            return false;
        }
        JobOutput other = (JobOutput) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(key(), other.key())
                && Objects.equals(thumbnailPattern(), other.thumbnailPattern())
                && Objects.equals(thumbnailEncryption(), other.thumbnailEncryption()) && Objects.equals(rotate(), other.rotate())
                && Objects.equals(presetId(), other.presetId()) && Objects.equals(segmentDuration(), other.segmentDuration())
                && Objects.equals(status(), other.status()) && Objects.equals(statusDetail(), other.statusDetail())
                && Objects.equals(duration(), other.duration()) && Objects.equals(width(), other.width())
                && Objects.equals(height(), other.height()) && Objects.equals(frameRate(), other.frameRate())
                && Objects.equals(fileSize(), other.fileSize()) && Objects.equals(durationMillis(), other.durationMillis())
                && hasWatermarks() == other.hasWatermarks() && Objects.equals(watermarks(), other.watermarks())
                && Objects.equals(albumArt(), other.albumArt()) && hasComposition() == other.hasComposition()
                && Objects.equals(composition(), other.composition()) && Objects.equals(captions(), other.captions())
                && Objects.equals(encryption(), other.encryption())
                && Objects.equals(appliedColorSpaceConversion(), other.appliedColorSpaceConversion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobOutput").add("Id", id()).add("Key", key()).add("ThumbnailPattern", thumbnailPattern())
                .add("ThumbnailEncryption", thumbnailEncryption()).add("Rotate", rotate()).add("PresetId", presetId())
                .add("SegmentDuration", segmentDuration()).add("Status", status()).add("StatusDetail", statusDetail())
                .add("Duration", duration()).add("Width", width()).add("Height", height()).add("FrameRate", frameRate())
                .add("FileSize", fileSize()).add("DurationMillis", durationMillis())
                .add("Watermarks", hasWatermarks() ? watermarks() : null).add("AlbumArt", albumArt())
                .add("Composition", hasComposition() ? composition() : null).add("Captions", captions())
                .add("Encryption", encryption()).add("AppliedColorSpaceConversion", appliedColorSpaceConversion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "ThumbnailPattern":
            return Optional.ofNullable(clazz.cast(thumbnailPattern()));
        case "ThumbnailEncryption":
            return Optional.ofNullable(clazz.cast(thumbnailEncryption()));
        case "Rotate":
            return Optional.ofNullable(clazz.cast(rotate()));
        case "PresetId":
            return Optional.ofNullable(clazz.cast(presetId()));
        case "SegmentDuration":
            return Optional.ofNullable(clazz.cast(segmentDuration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusDetail":
            return Optional.ofNullable(clazz.cast(statusDetail()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "FrameRate":
            return Optional.ofNullable(clazz.cast(frameRate()));
        case "FileSize":
            return Optional.ofNullable(clazz.cast(fileSize()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        case "Watermarks":
            return Optional.ofNullable(clazz.cast(watermarks()));
        case "AlbumArt":
            return Optional.ofNullable(clazz.cast(albumArt()));
        case "Composition":
            return Optional.ofNullable(clazz.cast(composition()));
        case "Captions":
            return Optional.ofNullable(clazz.cast(captions()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "AppliedColorSpaceConversion":
            return Optional.ofNullable(clazz.cast(appliedColorSpaceConversion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Key", KEY_FIELD);
        map.put("ThumbnailPattern", THUMBNAIL_PATTERN_FIELD);
        map.put("ThumbnailEncryption", THUMBNAIL_ENCRYPTION_FIELD);
        map.put("Rotate", ROTATE_FIELD);
        map.put("PresetId", PRESET_ID_FIELD);
        map.put("SegmentDuration", SEGMENT_DURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusDetail", STATUS_DETAIL_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("Width", WIDTH_FIELD);
        map.put("Height", HEIGHT_FIELD);
        map.put("FrameRate", FRAME_RATE_FIELD);
        map.put("FileSize", FILE_SIZE_FIELD);
        map.put("DurationMillis", DURATION_MILLIS_FIELD);
        map.put("Watermarks", WATERMARKS_FIELD);
        map.put("AlbumArt", ALBUM_ART_FIELD);
        map.put("Composition", COMPOSITION_FIELD);
        map.put("Captions", CAPTIONS_FIELD);
        map.put("Encryption", ENCRYPTION_FIELD);
        map.put("AppliedColorSpaceConversion", APPLIED_COLOR_SPACE_CONVERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobOutput, T> g) {
        return obj -> g.apply((JobOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobOutput> {
        /**
         * <p>
         * A sequential counter, starting with 1, that identifies an output among the outputs from the current job. In
         * the Output syntax, this value is always 1.
         * </p>
         * 
         * @param id
         *        A sequential counter, starting with 1, that identifies an output among the outputs from the current
         *        job. In the Output syntax, this value is always 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket
         * specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID.
         * </p>
         * 
         * @param key
         *        The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket
         *        specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic
         * Transcoder to name the files.
         * </p>
         * <p>
         * If you don't want Elastic Transcoder to create thumbnails, specify "".
         * </p>
         * <p>
         * If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in
         * the file name for each thumbnail. You can specify the following values in any sequence:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include
         * <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>,
         * Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names.
         * The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file.
         * </p>
         * <important>
         * <p>
         * If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic
         * Transcoder returns a validation error and does not create the job.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>Literal values (Optional)</b>: You can specify literal values anywhere in the
         * <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a
         * delimiter between <code>{resolution}</code> and <code>{count}</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the
         * file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that
         * appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>.
         * Elastic Transcoder also appends the applicable file name extension.
         * </p>
         * 
         * @param thumbnailPattern
         *        Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want
         *        Elastic Transcoder to name the files.</p>
         *        <p>
         *        If you don't want Elastic Transcoder to create thumbnails, specify "".
         *        </p>
         *        <p>
         *        If you do want Elastic Transcoder to create thumbnails, specify the information that you want to
         *        include in the file name for each thumbnail. You can specify the following values in any sequence:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include
         *        <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify
         *        <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with
         *        <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the
         *        sequence of thumbnails for a transcoded file.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>,
         *        Elastic Transcoder returns a validation error and does not create the job.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>Literal values (Optional)</b>: You can specify literal values anywhere in the
         *        <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a
         *        delimiter between <code>{resolution}</code> and <code>{count}</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution
         *        in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or
         *        .png) that appears in the preset that you specified in the <code>PresetID</code> value of
         *        <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailPattern(String thumbnailPattern);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
         * </p>
         * 
         * @param thumbnailEncryption
         *        The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailEncryption(Encryption thumbnailEncryption);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
         * </p>
         * This is a convenience method that creates an instance of the {@link Encryption.Builder} avoiding the need to
         * create one manually via {@link Encryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #thumbnailEncryption(Encryption)}.
         * 
         * @param thumbnailEncryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailEncryption(Encryption)
         */
        default Builder thumbnailEncryption(Consumer<Encryption.Builder> thumbnailEncryption) {
            return thumbnailEncryption(Encryption.builder().applyMutation(thumbnailEncryption).build());
        }

        /**
         * <p>
         * The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the
         * input. Enter one of the following values:
         * </p>
         * <p>
         * <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code>
         * </p>
         * <p>
         * The value <code>auto</code> generally works only if the file that you're transcoding contains rotation
         * metadata.
         * </p>
         * 
         * @param rotate
         *        The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to
         *        the input. Enter one of the following values:</p>
         *        <p>
         *        <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code>
         *        </p>
         *        <p>
         *        The value <code>auto</code> generally works only if the file that you're transcoding contains rotation
         *        metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotate(String rotate);

        /**
         * <p>
         * The value of the <code>Id</code> object for the preset that you want to use for this job. The preset
         * determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To use a
         * preset that you created, specify the preset ID that Elastic Transcoder returned in the response when you
         * created the preset. You can also use the Elastic Transcoder system presets, which you can get with
         * <code>ListPresets</code>.
         * </p>
         * 
         * @param presetId
         *        The value of the <code>Id</code> object for the preset that you want to use for this job. The preset
         *        determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To
         *        use a preset that you created, specify the preset ID that Elastic Transcoder returned in the response
         *        when you created the preset. You can also use the Elastic Transcoder system presets, which you can get
         *        with <code>ListPresets</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presetId(String presetId);

        /**
         * <important>
         * <p>
         * (Outputs in Fragmented MP4 or MPEG-TS format only.
         * </p>
         * </important>
         * <p>
         * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is
         * <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target
         * maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is
         * stored in a separate <code>.ts</code> file. For <code>HLSv4</code>, <code>MPEG-DASH</code>, and
         * <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is
         * approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or
         * longer.
         * </p>
         * <p>
         * The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by
         * <code>SegmentDuration</code>, the duration of the last segment is the remainder of total
         * length/SegmentDuration.
         * </p>
         * <p>
         * Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you
         * specify in OutputKeys. To add an output to the master playlist for this job, include it in the
         * <code>OutputKeys</code> of the associated playlist.
         * </p>
         * 
         * @param segmentDuration
         *        <p>
         *        (Outputs in Fragmented MP4 or MPEG-TS format only.
         *        </p>
         *        </important>
         *        <p>
         *        If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is
         *        <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the
         *        target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each
         *        media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code>,
         *        <code>MPEG-DASH</code>, and <code>Smooth</code> playlists, all media segments for an output are stored
         *        in a single file. Each segment is approximately the length of the <code>SegmentDuration</code>, though
         *        individual segments might be shorter or longer.
         *        </p>
         *        <p>
         *        The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by
         *        <code>SegmentDuration</code>, the duration of the last segment is the remainder of total
         *        length/SegmentDuration.
         *        </p>
         *        <p>
         *        Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that
         *        you specify in OutputKeys. To add an output to the master playlist for this job, include it in the
         *        <code>OutputKeys</code> of the associated playlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDuration(String segmentDuration);

        /**
         * <p>
         * The status of one output in a job. If you specified only one output for the job, <code>Outputs:Status</code>
         * is always the same as <code>Job:Status</code>. If you specified more than one output:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Job:Status</code> and <code>Outputs:Status</code> for all of the outputs is Submitted until Elastic
         * Transcoder starts to process the first output.
         * </p>
         * </li>
         * <li>
         * <p>
         * When Elastic Transcoder starts to process the first output, <code>Outputs:Status</code> for that output and
         * <code>Job:Status</code> both change to Progressing. For each output, the value of <code>Outputs:Status</code>
         * remains Submitted until Elastic Transcoder starts to process the output.
         * </p>
         * </li>
         * <li>
         * <p>
         * Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or Error.
         * </p>
         * </li>
         * <li>
         * <p>
         * When all of the outputs reach a terminal status, <code>Job:Status</code> changes to Complete only if
         * <code>Outputs:Status</code> for all of the outputs is <code>Complete</code>. If <code>Outputs:Status</code>
         * for one or more outputs is <code>Error</code>, the terminal status for <code>Job:Status</code> is also
         * <code>Error</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The value of <code>Status</code> is one of the following: <code>Submitted</code>, <code>Progressing</code>,
         * <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>.
         * </p>
         * 
         * @param status
         *        The status of one output in a job. If you specified only one output for the job,
         *        <code>Outputs:Status</code> is always the same as <code>Job:Status</code>. If you specified more than
         *        one output: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Job:Status</code> and <code>Outputs:Status</code> for all of the outputs is Submitted until
         *        Elastic Transcoder starts to process the first output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When Elastic Transcoder starts to process the first output, <code>Outputs:Status</code> for that
         *        output and <code>Job:Status</code> both change to Progressing. For each output, the value of
         *        <code>Outputs:Status</code> remains Submitted until Elastic Transcoder starts to process the output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or
         *        Error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When all of the outputs reach a terminal status, <code>Job:Status</code> changes to Complete only if
         *        <code>Outputs:Status</code> for all of the outputs is <code>Complete</code>. If
         *        <code>Outputs:Status</code> for one or more outputs is <code>Error</code>, the terminal status for
         *        <code>Job:Status</code> is also <code>Error</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The value of <code>Status</code> is one of the following: <code>Submitted</code>,
         *        <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Information that further explains <code>Status</code>.
         * </p>
         * 
         * @param statusDetail
         *        Information that further explains <code>Status</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetail(String statusDetail);

        /**
         * <p>
         * Duration of the output file, in seconds.
         * </p>
         * 
         * @param duration
         *        Duration of the output file, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * Specifies the width of the output file in pixels.
         * </p>
         * 
         * @param width
         *        Specifies the width of the output file in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * <p>
         * Height of the output file, in pixels.
         * </p>
         * 
         * @param height
         *        Height of the output file, in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * <p>
         * Frame rate of the output file, in frames per second.
         * </p>
         * 
         * @param frameRate
         *        Frame rate of the output file, in frames per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameRate(String frameRate);

        /**
         * <p>
         * File size of the output file, in bytes.
         * </p>
         * 
         * @param fileSize
         *        File size of the output file, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSize(Long fileSize);

        /**
         * <p>
         * Duration of the output file, in milliseconds.
         * </p>
         * 
         * @param durationMillis
         *        Duration of the output file, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);

        /**
         * <p>
         * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You
         * can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset
         * that you specify in <code>Preset</code> for the current output.
         * </p>
         * <p>
         * Watermarks are added to the output video in the sequence in which you list them in the job output—the first
         * watermark in the list is added to the output video first, the second watermark in the list is added next, and
         * so on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same
         * location, the second watermark that you add covers the first one, the third one covers the second, and the
         * fourth one covers the third.
         * </p>
         * 
         * @param watermarks
         *        Information about the watermarks that you want Elastic Transcoder to add to the video during
         *        transcoding. You can specify up to four watermarks for each output. Settings for each watermark must
         *        be defined in the preset that you specify in <code>Preset</code> for the current output.</p>
         *        <p>
         *        Watermarks are added to the output video in the sequence in which you list them in the job output—the
         *        first watermark in the list is added to the output video first, the second watermark in the list is
         *        added next, and so on. As a result, if the settings in a preset cause Elastic Transcoder to place all
         *        watermarks in the same location, the second watermark that you add covers the first one, the third one
         *        covers the second, and the fourth one covers the third.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watermarks(Collection<JobWatermark> watermarks);

        /**
         * <p>
         * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You
         * can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset
         * that you specify in <code>Preset</code> for the current output.
         * </p>
         * <p>
         * Watermarks are added to the output video in the sequence in which you list them in the job output—the first
         * watermark in the list is added to the output video first, the second watermark in the list is added next, and
         * so on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same
         * location, the second watermark that you add covers the first one, the third one covers the second, and the
         * fourth one covers the third.
         * </p>
         * 
         * @param watermarks
         *        Information about the watermarks that you want Elastic Transcoder to add to the video during
         *        transcoding. You can specify up to four watermarks for each output. Settings for each watermark must
         *        be defined in the preset that you specify in <code>Preset</code> for the current output.</p>
         *        <p>
         *        Watermarks are added to the output video in the sequence in which you list them in the job output—the
         *        first watermark in the list is added to the output video first, the second watermark in the list is
         *        added next, and so on. As a result, if the settings in a preset cause Elastic Transcoder to place all
         *        watermarks in the same location, the second watermark that you add covers the first one, the third one
         *        covers the second, and the fourth one covers the third.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watermarks(JobWatermark... watermarks);

        /**
         * <p>
         * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You
         * can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset
         * that you specify in <code>Preset</code> for the current output.
         * </p>
         * <p>
         * Watermarks are added to the output video in the sequence in which you list them in the job output—the first
         * watermark in the list is added to the output video first, the second watermark in the list is added next, and
         * so on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same
         * location, the second watermark that you add covers the first one, the third one covers the second, and the
         * fourth one covers the third.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elastictranscoder.model.JobWatermark.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elastictranscoder.model.JobWatermark#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elastictranscoder.model.JobWatermark.Builder#build()} is called
         * immediately and its result is passed to {@link #watermarks(List<JobWatermark>)}.
         * 
         * @param watermarks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elastictranscoder.model.JobWatermark.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #watermarks(java.util.Collection<JobWatermark>)
         */
        Builder watermarks(Consumer<JobWatermark.Builder>... watermarks);

        /**
         * <p>
         * The album art to be associated with the output file, if any.
         * </p>
         * 
         * @param albumArt
         *        The album art to be associated with the output file, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder albumArt(JobAlbumArt albumArt);

        /**
         * <p>
         * The album art to be associated with the output file, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobAlbumArt.Builder} avoiding the need to
         * create one manually via {@link JobAlbumArt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobAlbumArt.Builder#build()} is called immediately and its result
         * is passed to {@link #albumArt(JobAlbumArt)}.
         * 
         * @param albumArt
         *        a consumer that will call methods on {@link JobAlbumArt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #albumArt(JobAlbumArt)
         */
        default Builder albumArt(Consumer<JobAlbumArt.Builder> albumArt) {
            return albumArt(JobAlbumArt.builder().applyMutation(albumArt).build());
        }

        /**
         * <p>
         * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can
         * come from the beginning, middle, or end of the file. The Composition object contains settings for the clips
         * that make up an output file. For the current release, you can only specify settings for a single clip per
         * output file. The Composition object cannot be null.
         * </p>
         * 
         * @param composition
         *        You can create an output file that contains an excerpt from the input file. This excerpt, called a
         *        clip, can come from the beginning, middle, or end of the file. The Composition object contains
         *        settings for the clips that make up an output file. For the current release, you can only specify
         *        settings for a single clip per output file. The Composition object cannot be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder composition(Collection<Clip> composition);

        /**
         * <p>
         * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can
         * come from the beginning, middle, or end of the file. The Composition object contains settings for the clips
         * that make up an output file. For the current release, you can only specify settings for a single clip per
         * output file. The Composition object cannot be null.
         * </p>
         * 
         * @param composition
         *        You can create an output file that contains an excerpt from the input file. This excerpt, called a
         *        clip, can come from the beginning, middle, or end of the file. The Composition object contains
         *        settings for the clips that make up an output file. For the current release, you can only specify
         *        settings for a single clip per output file. The Composition object cannot be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder composition(Clip... composition);

        /**
         * <p>
         * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can
         * come from the beginning, middle, or end of the file. The Composition object contains settings for the clips
         * that make up an output file. For the current release, you can only specify settings for a single clip per
         * output file. The Composition object cannot be null.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elastictranscoder.model.Clip.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elastictranscoder.model.Clip#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elastictranscoder.model.Clip.Builder#build()} is called immediately
         * and its result is passed to {@link #composition(List<Clip>)}.
         * 
         * @param composition
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elastictranscoder.model.Clip.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #composition(java.util.Collection<Clip>)
         * @deprecated
         */
        @Deprecated
        Builder composition(Consumer<Clip.Builder>... composition);

        /**
         * <p>
         * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
         * captions must be in UTF-8. Elastic Transcoder supports two types of captions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder
         * supports only one embedded caption per language, to a maximum of 300 embedded captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
         * <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
         * </p>
         * <p>
         * Valid outputs include: <code>mov-text</code>
         * </p>
         * <p>
         * Elastic Transcoder supports a maximum of one embedded format per output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar
         * captions require a player that is capable of understanding the relationship between the video file and the
         * sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar
         * captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code>
         * </p>
         * <p>
         * Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and
         * <code>webvtt</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         * </p>
         * <p>
         * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid
         * input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve
         * text formatting (for example, italics) during the transcoding process.
         * </p>
         * <p>
         * To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing
         * captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null
         * <code>CaptionSources</code> array.
         * </p>
         * <p>
         * For more information on embedded files, see the Subtitles Wikipedia page.
         * </p>
         * <p>
         * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
         * </p>
         * 
         * @param captions
         *        You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another.
         *        All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic
         *        Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per
         *        file.
         *        </p>
         *        <p>
         *        Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
         *        <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
         *        </p>
         *        <p>
         *        Valid outputs include: <code>mov-text</code>
         *        </p>
         *        <p>
         *        Elastic Transcoder supports a maximum of one embedded format per output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data.
         *        Sidecar captions require a player that is capable of understanding the relationship between the video
         *        file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a
         *        maximum of 20 sidecar captions per file.
         *        </p>
         *        <p>
         *        Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>,
         *        <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and
         *        <code>webvtt</code>
         *        </p>
         *        <p>
         *        Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>,
         *        and <code>webvtt</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         *        </p>
         *        <p>
         *        Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a
         *        valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not
         *        preserve text formatting (for example, italics) during the transcoding process.
         *        </p>
         *        <p>
         *        To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through
         *        existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in
         *        a null <code>CaptionSources</code> array.
         *        </p>
         *        <p>
         *        For more information on embedded files, see the Subtitles Wikipedia page.
         *        </p>
         *        <p>
         *        For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia
         *        pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captions(Captions captions);

        /**
         * <p>
         * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
         * captions must be in UTF-8. Elastic Transcoder supports two types of captions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder
         * supports only one embedded caption per language, to a maximum of 300 embedded captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
         * <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
         * </p>
         * <p>
         * Valid outputs include: <code>mov-text</code>
         * </p>
         * <p>
         * Elastic Transcoder supports a maximum of one embedded format per output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar
         * captions require a player that is capable of understanding the relationship between the video file and the
         * sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar
         * captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code>
         * </p>
         * <p>
         * Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and
         * <code>webvtt</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         * </p>
         * <p>
         * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid
         * input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve
         * text formatting (for example, italics) during the transcoding process.
         * </p>
         * <p>
         * To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing
         * captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null
         * <code>CaptionSources</code> array.
         * </p>
         * <p>
         * For more information on embedded files, see the Subtitles Wikipedia page.
         * </p>
         * <p>
         * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
         * </p>
         * This is a convenience method that creates an instance of the {@link Captions.Builder} avoiding the need to
         * create one manually via {@link Captions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Captions.Builder#build()} is called immediately and its result is
         * passed to {@link #captions(Captions)}.
         * 
         * @param captions
         *        a consumer that will call methods on {@link Captions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captions(Captions)
         */
        default Builder captions(Consumer<Captions.Builder> captions) {
            return captions(Captions.builder().applyMutation(captions).build());
        }

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you
         * choose to use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic
         * Transcoder writes an unencrypted file to your Amazon S3 bucket.
         * </p>
         * 
         * @param encryption
         *        The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If
         *        you choose to use encryption, you must specify a mode to use. If you choose not to use encryption,
         *        Elastic Transcoder writes an unencrypted file to your Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you
         * choose to use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic
         * Transcoder writes an unencrypted file to your Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link Encryption.Builder} avoiding the need to
         * create one manually via {@link Encryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }

        /**
         * <p>
         * If Elastic Transcoder used a preset with a <code>ColorSpaceConversionMode</code> to transcode the output
         * file, the <code>AppliedColorSpaceConversion</code> parameter shows the conversion used. If no
         * <code>ColorSpaceConversionMode</code> was defined in the preset, this parameter is not be included in the job
         * response.
         * </p>
         * 
         * @param appliedColorSpaceConversion
         *        If Elastic Transcoder used a preset with a <code>ColorSpaceConversionMode</code> to transcode the
         *        output file, the <code>AppliedColorSpaceConversion</code> parameter shows the conversion used. If no
         *        <code>ColorSpaceConversionMode</code> was defined in the preset, this parameter is not be included in
         *        the job response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedColorSpaceConversion(String appliedColorSpaceConversion);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String key;

        private String thumbnailPattern;

        private Encryption thumbnailEncryption;

        private String rotate;

        private String presetId;

        private String segmentDuration;

        private String status;

        private String statusDetail;

        private Long duration;

        private Integer width;

        private Integer height;

        private String frameRate;

        private Long fileSize;

        private Long durationMillis;

        private List<JobWatermark> watermarks = DefaultSdkAutoConstructList.getInstance();

        private JobAlbumArt albumArt;

        private List<Clip> composition = DefaultSdkAutoConstructList.getInstance();

        private Captions captions;

        private Encryption encryption;

        private String appliedColorSpaceConversion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobOutput model) {
            id(model.id);
            key(model.key);
            thumbnailPattern(model.thumbnailPattern);
            thumbnailEncryption(model.thumbnailEncryption);
            rotate(model.rotate);
            presetId(model.presetId);
            segmentDuration(model.segmentDuration);
            status(model.status);
            statusDetail(model.statusDetail);
            duration(model.duration);
            width(model.width);
            height(model.height);
            frameRate(model.frameRate);
            fileSize(model.fileSize);
            durationMillis(model.durationMillis);
            watermarks(model.watermarks);
            albumArt(model.albumArt);
            composition(model.composition);
            captions(model.captions);
            encryption(model.encryption);
            appliedColorSpaceConversion(model.appliedColorSpaceConversion);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getThumbnailPattern() {
            return thumbnailPattern;
        }

        public final void setThumbnailPattern(String thumbnailPattern) {
            this.thumbnailPattern = thumbnailPattern;
        }

        @Override
        public final Builder thumbnailPattern(String thumbnailPattern) {
            this.thumbnailPattern = thumbnailPattern;
            return this;
        }

        public final Encryption.Builder getThumbnailEncryption() {
            return thumbnailEncryption != null ? thumbnailEncryption.toBuilder() : null;
        }

        public final void setThumbnailEncryption(Encryption.BuilderImpl thumbnailEncryption) {
            this.thumbnailEncryption = thumbnailEncryption != null ? thumbnailEncryption.build() : null;
        }

        @Override
        public final Builder thumbnailEncryption(Encryption thumbnailEncryption) {
            this.thumbnailEncryption = thumbnailEncryption;
            return this;
        }

        public final String getRotate() {
            return rotate;
        }

        public final void setRotate(String rotate) {
            this.rotate = rotate;
        }

        @Override
        public final Builder rotate(String rotate) {
            this.rotate = rotate;
            return this;
        }

        public final String getPresetId() {
            return presetId;
        }

        public final void setPresetId(String presetId) {
            this.presetId = presetId;
        }

        @Override
        public final Builder presetId(String presetId) {
            this.presetId = presetId;
            return this;
        }

        public final String getSegmentDuration() {
            return segmentDuration;
        }

        public final void setSegmentDuration(String segmentDuration) {
            this.segmentDuration = segmentDuration;
        }

        @Override
        public final Builder segmentDuration(String segmentDuration) {
            this.segmentDuration = segmentDuration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusDetail() {
            return statusDetail;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final String getFrameRate() {
            return frameRate;
        }

        public final void setFrameRate(String frameRate) {
            this.frameRate = frameRate;
        }

        @Override
        public final Builder frameRate(String frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final Long getFileSize() {
            return fileSize;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final List<JobWatermark.Builder> getWatermarks() {
            List<JobWatermark.Builder> result = JobWatermarksCopier.copyToBuilder(this.watermarks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatermarks(Collection<JobWatermark.BuilderImpl> watermarks) {
            this.watermarks = JobWatermarksCopier.copyFromBuilder(watermarks);
        }

        @Override
        public final Builder watermarks(Collection<JobWatermark> watermarks) {
            this.watermarks = JobWatermarksCopier.copy(watermarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(JobWatermark... watermarks) {
            watermarks(Arrays.asList(watermarks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(Consumer<JobWatermark.Builder>... watermarks) {
            watermarks(Stream.of(watermarks).map(c -> JobWatermark.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final JobAlbumArt.Builder getAlbumArt() {
            return albumArt != null ? albumArt.toBuilder() : null;
        }

        public final void setAlbumArt(JobAlbumArt.BuilderImpl albumArt) {
            this.albumArt = albumArt != null ? albumArt.build() : null;
        }

        @Override
        public final Builder albumArt(JobAlbumArt albumArt) {
            this.albumArt = albumArt;
            return this;
        }

        @Deprecated
        public final List<Clip.Builder> getComposition() {
            List<Clip.Builder> result = CompositionCopier.copyToBuilder(this.composition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setComposition(Collection<Clip.BuilderImpl> composition) {
            this.composition = CompositionCopier.copyFromBuilder(composition);
        }

        @Override
        @Deprecated
        public final Builder composition(Collection<Clip> composition) {
            this.composition = CompositionCopier.copy(composition);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder composition(Clip... composition) {
            composition(Arrays.asList(composition));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder composition(Consumer<Clip.Builder>... composition) {
            composition(Stream.of(composition).map(c -> Clip.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Captions.Builder getCaptions() {
            return captions != null ? captions.toBuilder() : null;
        }

        public final void setCaptions(Captions.BuilderImpl captions) {
            this.captions = captions != null ? captions.build() : null;
        }

        @Override
        public final Builder captions(Captions captions) {
            this.captions = captions;
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final String getAppliedColorSpaceConversion() {
            return appliedColorSpaceConversion;
        }

        public final void setAppliedColorSpaceConversion(String appliedColorSpaceConversion) {
            this.appliedColorSpaceConversion = appliedColorSpaceConversion;
        }

        @Override
        public final Builder appliedColorSpaceConversion(String appliedColorSpaceConversion) {
            this.appliedColorSpaceConversion = appliedColorSpaceConversion;
            return this;
        }

        @Override
        public JobOutput build() {
            return new JobOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
