/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of the pipelines associated with the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelinesResponse extends ElasticTranscoderResponse implements
        ToCopyableBuilder<ListPipelinesResponse.Builder, ListPipelinesResponse> {
    private static final SdkField<List<Pipeline>> PIPELINES_FIELD = SdkField
            .<List<Pipeline>> builder(MarshallingType.LIST)
            .memberName("Pipelines")
            .getter(getter(ListPipelinesResponse::pipelines))
            .setter(setter(Builder::pipelines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipelines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Pipeline> builder(MarshallingType.SDK_POJO)
                                            .constructor(Pipeline::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(ListPipelinesResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINES_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Pipeline> pipelines;

    private final String nextPageToken;

    private ListPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelines = builder.pipelines;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Pipelines property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPipelines() {
        return pipelines != null && !(pipelines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Pipeline</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelines} method.
     * </p>
     * 
     * @return An array of <code>Pipeline</code> objects.
     */
    public final List<Pipeline> pipelines() {
        return pipelines;
    }

    /**
     * <p>
     * A value that you use to access the second and subsequent pages of results, if any. When the pipelines fit on one
     * page or when you've reached the last page of results, the value of <code>NextPageToken</code> is
     * <code>null</code>.
     * </p>
     * 
     * @return A value that you use to access the second and subsequent pages of results, if any. When the pipelines fit
     *         on one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is
     *         <code>null</code>.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelines() ? pipelines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse) obj;
        return hasPipelines() == other.hasPipelines() && Objects.equals(pipelines(), other.pipelines())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipelinesResponse").add("Pipelines", hasPipelines() ? pipelines() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pipelines":
            return Optional.ofNullable(clazz.cast(pipelines()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Pipelines", PIPELINES_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPipelinesResponse, T> g) {
        return obj -> g.apply((ListPipelinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPipelinesResponse> {
        /**
         * <p>
         * An array of <code>Pipeline</code> objects.
         * </p>
         * 
         * @param pipelines
         *        An array of <code>Pipeline</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelines(Collection<Pipeline> pipelines);

        /**
         * <p>
         * An array of <code>Pipeline</code> objects.
         * </p>
         * 
         * @param pipelines
         *        An array of <code>Pipeline</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelines(Pipeline... pipelines);

        /**
         * <p>
         * An array of <code>Pipeline</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elastictranscoder.model.Pipeline.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.elastictranscoder.model.Pipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elastictranscoder.model.Pipeline.Builder#build()} is called
         * immediately and its result is passed to {@link #pipelines(List<Pipeline>)}.
         * 
         * @param pipelines
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elastictranscoder.model.Pipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelines(java.util.Collection<Pipeline>)
         */
        Builder pipelines(Consumer<Pipeline.Builder>... pipelines);

        /**
         * <p>
         * A value that you use to access the second and subsequent pages of results, if any. When the pipelines fit on
         * one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is
         * <code>null</code>.
         * </p>
         * 
         * @param nextPageToken
         *        A value that you use to access the second and subsequent pages of results, if any. When the pipelines
         *        fit on one page or when you've reached the last page of results, the value of
         *        <code>NextPageToken</code> is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ElasticTranscoderResponse.BuilderImpl implements Builder {
        private List<Pipeline> pipelines = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            super(model);
            pipelines(model.pipelines);
            nextPageToken(model.nextPageToken);
        }

        public final List<Pipeline.Builder> getPipelines() {
            List<Pipeline.Builder> result = PipelinesCopier.copyToBuilder(this.pipelines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelines(Collection<Pipeline.BuilderImpl> pipelines) {
            this.pipelines = PipelinesCopier.copyFromBuilder(pipelines);
        }

        @Override
        public final Builder pipelines(Collection<Pipeline> pipelines) {
            this.pipelines = PipelinesCopier.copy(pipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(Pipeline... pipelines) {
            pipelines(Arrays.asList(pipelines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(Consumer<Pipeline.Builder>... pipelines) {
            pipelines(Stream.of(pipelines).map(c -> Pipeline.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
