/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over videos that
 * are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks appear in the
 * specified size and location, and with the specified opacity for the duration of the transcoded video.
 * </p>
 * <p>
 * Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the .png
 * format, which supports transparency.
 * </p>
 * <p>
 * When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic Transcoder
 * to include in the transcoded videos. You can specify fewer graphics in the job than you specify watermark settings in
 * the preset, which allows you to use the same preset for up to four watermarks that have different dimensions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PresetWatermark implements SdkPojo, Serializable, ToCopyableBuilder<PresetWatermark.Builder, PresetWatermark> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(PresetWatermark::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> MAX_WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxWidth").getter(getter(PresetWatermark::maxWidth)).setter(setter(Builder::maxWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWidth").build()).build();

    private static final SdkField<String> MAX_HEIGHT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxHeight").getter(getter(PresetWatermark::maxHeight)).setter(setter(Builder::maxHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHeight").build()).build();

    private static final SdkField<String> SIZING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SizingPolicy").getter(getter(PresetWatermark::sizingPolicy)).setter(setter(Builder::sizingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizingPolicy").build()).build();

    private static final SdkField<String> HORIZONTAL_ALIGN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HorizontalAlign").getter(getter(PresetWatermark::horizontalAlign))
            .setter(setter(Builder::horizontalAlign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HorizontalAlign").build()).build();

    private static final SdkField<String> HORIZONTAL_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HorizontalOffset").getter(getter(PresetWatermark::horizontalOffset))
            .setter(setter(Builder::horizontalOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HorizontalOffset").build()).build();

    private static final SdkField<String> VERTICAL_ALIGN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerticalAlign").getter(getter(PresetWatermark::verticalAlign)).setter(setter(Builder::verticalAlign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalAlign").build()).build();

    private static final SdkField<String> VERTICAL_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerticalOffset").getter(getter(PresetWatermark::verticalOffset)).setter(setter(Builder::verticalOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalOffset").build()).build();

    private static final SdkField<String> OPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Opacity")
            .getter(getter(PresetWatermark::opacity)).setter(setter(Builder::opacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Opacity").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(PresetWatermark::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MAX_WIDTH_FIELD,
            MAX_HEIGHT_FIELD, SIZING_POLICY_FIELD, HORIZONTAL_ALIGN_FIELD, HORIZONTAL_OFFSET_FIELD, VERTICAL_ALIGN_FIELD,
            VERTICAL_OFFSET_FIELD, OPACITY_FIELD, TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String maxWidth;

    private final String maxHeight;

    private final String sizingPolicy;

    private final String horizontalAlign;

    private final String horizontalOffset;

    private final String verticalAlign;

    private final String verticalOffset;

    private final String opacity;

    private final String target;

    private PresetWatermark(BuilderImpl builder) {
        this.id = builder.id;
        this.maxWidth = builder.maxWidth;
        this.maxHeight = builder.maxHeight;
        this.sizingPolicy = builder.sizingPolicy;
        this.horizontalAlign = builder.horizontalAlign;
        this.horizontalOffset = builder.horizontalOffset;
        this.verticalAlign = builder.verticalAlign;
        this.verticalOffset = builder.verticalOffset;
        this.opacity = builder.opacity;
        this.target = builder.target;
    }

    /**
     * <p>
     * A unique identifier for the settings for one watermark. The value of <code>Id</code> can be up to 40 characters
     * long.
     * </p>
     * 
     * @return A unique identifier for the settings for one watermark. The value of <code>Id</code> can be up to 40
     *         characters long.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The maximum width of the watermark in one of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of
     * <code>MaxWidth</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify
     * whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in
     * the calculation.
     * </p>
     * <p>
     * If you specify the value in pixels, it must be less than or equal to the value of <code>MaxWidth</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The maximum width of the watermark in one of the following formats: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of
     *         <code>MaxWidth</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to
     *         specify whether you want Elastic Transcoder to include the black bars that are added by Elastic
     *         Transcoder, if any, in the calculation.
     *         </p>
     *         <p>
     *         If you specify the value in pixels, it must be less than or equal to the value of <code>MaxWidth</code>.
     *         </p>
     *         </li>
     */
    public final String maxWidth() {
        return maxWidth;
    }

    /**
     * <p>
     * The maximum height of the watermark in one of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of
     * <code>MaxHeight</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify
     * whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in
     * the calculation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify the value in pixels, it must be less than or equal to the value of <code>MaxHeight</code>.
     * </p>
     * 
     * @return The maximum height of the watermark in one of the following formats: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of
     *         <code>MaxHeight</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to
     *         specify whether you want Elastic Transcoder to include the black bars that are added by Elastic
     *         Transcoder, if any, in the calculation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify the value in pixels, it must be less than or equal to the value of <code>MaxHeight</code>.
     */
    public final String maxHeight() {
        return maxHeight;
    }

    /**
     * <p>
     * A value that controls scaling of the watermark:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Fit</b>: Elastic Transcoder scales the watermark so it matches the value that you specified in either
     * <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Stretch</b>: Elastic Transcoder stretches the watermark to match the values that you specified for
     * <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the watermark and the values of
     * <code>MaxWidth</code> and <code>MaxHeight</code> are different, the watermark will be distorted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ShrinkToFit</b>: Elastic Transcoder scales the watermark down so that its dimensions match the values that you
     * specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If
     * you specify this option, Elastic Transcoder does not scale the watermark up.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A value that controls scaling of the watermark: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Fit</b>: Elastic Transcoder scales the watermark so it matches the value that you specified in either
     *         <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Stretch</b>: Elastic Transcoder stretches the watermark to match the values that you specified for
     *         <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the watermark and the
     *         values of <code>MaxWidth</code> and <code>MaxHeight</code> are different, the watermark will be
     *         distorted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ShrinkToFit</b>: Elastic Transcoder scales the watermark down so that its dimensions match the values
     *         that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding
     *         either value. If you specify this option, Elastic Transcoder does not scale the watermark up.
     *         </p>
     *         </li>
     */
    public final String sizingPolicy() {
        return sizingPolicy;
    }

    /**
     * <p>
     * The horizontal position of the watermark unless you specify a non-zero value for <code>HorizontalOffset</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Left</b>: The left edge of the watermark is aligned with the left border of the video.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Right</b>: The right edge of the watermark is aligned with the right border of the video.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Center</b>: The watermark is centered between the left and right borders.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The horizontal position of the watermark unless you specify a non-zero value for
     *         <code>HorizontalOffset</code>: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Left</b>: The left edge of the watermark is aligned with the left border of the video.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Right</b>: The right edge of the watermark is aligned with the right border of the video.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Center</b>: The watermark is centered between the left and right borders.
     *         </p>
     *         </li>
     */
    public final String horizontalAlign() {
        return horizontalAlign;
    }

    /**
     * <p>
     * The amount by which you want the horizontal position of the watermark to be offset from the position specified by
     * HorizontalAlign:
     * </p>
     * <ul>
     * <li>
     * <p>
     * number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.
     * </p>
     * </li>
     * <li>
     * <p>
     * integer percentage (%): The range of valid values is 0 to 100.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, if you specify Left for <code>HorizontalAlign</code> and 5px for <code>HorizontalOffset</code>, the
     * left side of the watermark appears 5 pixels from the left border of the output video.
     * </p>
     * <p>
     * <code>HorizontalOffset</code> is only valid when the value of <code>HorizontalAlign</code> is <code>Left</code>
     * or <code>Right</code>. If you specify an offset that causes the watermark to extend beyond the left or right
     * border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added
     * black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is
     * cropped.
     * </p>
     * <p>
     * Use the value of <code>Target</code> to specify whether you want to include the black bars that are added by
     * Elastic Transcoder, if any, in the offset calculation.
     * </p>
     * 
     * @return The amount by which you want the horizontal position of the watermark to be offset from the position
     *         specified by HorizontalAlign: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         integer percentage (%): The range of valid values is 0 to 100.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, if you specify Left for <code>HorizontalAlign</code> and 5px for
     *         <code>HorizontalOffset</code>, the left side of the watermark appears 5 pixels from the left border of
     *         the output video.
     *         </p>
     *         <p>
     *         <code>HorizontalOffset</code> is only valid when the value of <code>HorizontalAlign</code> is
     *         <code>Left</code> or <code>Right</code>. If you specify an offset that causes the watermark to extend
     *         beyond the left or right border and Elastic Transcoder has not added black bars, the watermark is
     *         cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the
     *         watermark extends beyond the black bars, it is cropped.
     *         </p>
     *         <p>
     *         Use the value of <code>Target</code> to specify whether you want to include the black bars that are added
     *         by Elastic Transcoder, if any, in the offset calculation.
     */
    public final String horizontalOffset() {
        return horizontalOffset;
    }

    /**
     * <p>
     * The vertical position of the watermark unless you specify a non-zero value for <code>VerticalOffset</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Top</b>: The top edge of the watermark is aligned with the top border of the video.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Bottom</b>: The bottom edge of the watermark is aligned with the bottom border of the video.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Center</b>: The watermark is centered between the top and bottom borders.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The vertical position of the watermark unless you specify a non-zero value for
     *         <code>VerticalOffset</code>: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Top</b>: The top edge of the watermark is aligned with the top border of the video.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Bottom</b>: The bottom edge of the watermark is aligned with the bottom border of the video.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Center</b>: The watermark is centered between the top and bottom borders.
     *         </p>
     *         </li>
     */
    public final String verticalAlign() {
        return verticalAlign;
    }

    /**
     * <p>
     * <code>VerticalOffset</code>
     * </p>
     * <p>
     * The amount by which you want the vertical position of the watermark to be offset from the position specified by
     * VerticalAlign:
     * </p>
     * <ul>
     * <li>
     * <p>
     * number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of
     * <code>MaxHeight</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * integer percentage (%): The range of valid values is 0 to 100.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, if you specify <code>Top</code> for <code>VerticalAlign</code> and <code>5px</code> for
     * <code>VerticalOffset</code>, the top of the watermark appears 5 pixels from the top border of the output video.
     * </p>
     * <p>
     * <code>VerticalOffset</code> is only valid when the value of VerticalAlign is Top or Bottom.
     * </p>
     * <p>
     * If you specify an offset that causes the watermark to extend beyond the top or bottom border and Elastic
     * Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the
     * watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.
     * </p>
     * <p>
     * Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars
     * that are added by Elastic Transcoder, if any, in the offset calculation.
     * </p>
     * 
     * @return <code>VerticalOffset</code> </p>
     *         <p>
     *         The amount by which you want the vertical position of the watermark to be offset from the position
     *         specified by VerticalAlign:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of
     *         <code>MaxHeight</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         integer percentage (%): The range of valid values is 0 to 100.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, if you specify <code>Top</code> for <code>VerticalAlign</code> and <code>5px</code> for
     *         <code>VerticalOffset</code>, the top of the watermark appears 5 pixels from the top border of the output
     *         video.
     *         </p>
     *         <p>
     *         <code>VerticalOffset</code> is only valid when the value of VerticalAlign is Top or Bottom.
     *         </p>
     *         <p>
     *         If you specify an offset that causes the watermark to extend beyond the top or bottom border and Elastic
     *         Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black
     *         bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is
     *         cropped.
     *         </p>
     *         <p>
     *         Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black
     *         bars that are added by Elastic Transcoder, if any, in the offset calculation.
     */
    public final String verticalOffset() {
        return verticalOffset;
    }

    /**
     * <p>
     * A percentage that indicates how much you want a watermark to obscure the video in the location where it appears.
     * Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures the video in the
     * specified location). The datatype of <code>Opacity</code> is float.
     * </p>
     * <p>
     * Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent portion of
     * the video appears as if you had specified a value of 0 for <code>Opacity</code>. The .jpg file format doesn't
     * support transparency.
     * </p>
     * 
     * @return A percentage that indicates how much you want a watermark to obscure the video in the location where it
     *         appears. Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures the
     *         video in the specified location). The datatype of <code>Opacity</code> is float.</p>
     *         <p>
     *         Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent
     *         portion of the video appears as if you had specified a value of 0 for <code>Opacity</code>. The .jpg file
     *         format doesn't support transparency.
     */
    public final String opacity() {
        return opacity;
    }

    /**
     * <p>
     * A value that determines how Elastic Transcoder interprets values that you specified for
     * <code>HorizontalOffset</code>, <code>VerticalOffset</code>, <code>MaxWidth</code>, and <code>MaxHeight</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Content</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the
     * borders of the video excluding black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code>
     * and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video
     * excluding black bars added by Elastic Transcoder, if any.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Frame</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the
     * borders of the video including black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code>
     * and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video
     * including black bars added by Elastic Transcoder, if any.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A value that determines how Elastic Transcoder interprets values that you specified for
     *         <code>HorizontalOffset</code>, <code>VerticalOffset</code>, <code>MaxWidth</code>, and
     *         <code>MaxHeight</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Content</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based
     *         on the borders of the video excluding black bars added by Elastic Transcoder, if any. In addition,
     *         <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on
     *         the borders of the video excluding black bars added by Elastic Transcoder, if any.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Frame</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based
     *         on the borders of the video including black bars added by Elastic Transcoder, if any. In addition,
     *         <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on
     *         the borders of the video including black bars added by Elastic Transcoder, if any.
     *         </p>
     *         </li>
     */
    public final String target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(maxWidth());
        hashCode = 31 * hashCode + Objects.hashCode(maxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(sizingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(horizontalAlign());
        hashCode = 31 * hashCode + Objects.hashCode(horizontalOffset());
        hashCode = 31 * hashCode + Objects.hashCode(verticalAlign());
        hashCode = 31 * hashCode + Objects.hashCode(verticalOffset());
        hashCode = 31 * hashCode + Objects.hashCode(opacity());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresetWatermark)) {
            return false;
        }
        PresetWatermark other = (PresetWatermark) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(maxWidth(), other.maxWidth())
                && Objects.equals(maxHeight(), other.maxHeight()) && Objects.equals(sizingPolicy(), other.sizingPolicy())
                && Objects.equals(horizontalAlign(), other.horizontalAlign())
                && Objects.equals(horizontalOffset(), other.horizontalOffset())
                && Objects.equals(verticalAlign(), other.verticalAlign())
                && Objects.equals(verticalOffset(), other.verticalOffset()) && Objects.equals(opacity(), other.opacity())
                && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PresetWatermark").add("Id", id()).add("MaxWidth", maxWidth()).add("MaxHeight", maxHeight())
                .add("SizingPolicy", sizingPolicy()).add("HorizontalAlign", horizontalAlign())
                .add("HorizontalOffset", horizontalOffset()).add("VerticalAlign", verticalAlign())
                .add("VerticalOffset", verticalOffset()).add("Opacity", opacity()).add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MaxWidth":
            return Optional.ofNullable(clazz.cast(maxWidth()));
        case "MaxHeight":
            return Optional.ofNullable(clazz.cast(maxHeight()));
        case "SizingPolicy":
            return Optional.ofNullable(clazz.cast(sizingPolicy()));
        case "HorizontalAlign":
            return Optional.ofNullable(clazz.cast(horizontalAlign()));
        case "HorizontalOffset":
            return Optional.ofNullable(clazz.cast(horizontalOffset()));
        case "VerticalAlign":
            return Optional.ofNullable(clazz.cast(verticalAlign()));
        case "VerticalOffset":
            return Optional.ofNullable(clazz.cast(verticalOffset()));
        case "Opacity":
            return Optional.ofNullable(clazz.cast(opacity()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("MaxWidth", MAX_WIDTH_FIELD);
        map.put("MaxHeight", MAX_HEIGHT_FIELD);
        map.put("SizingPolicy", SIZING_POLICY_FIELD);
        map.put("HorizontalAlign", HORIZONTAL_ALIGN_FIELD);
        map.put("HorizontalOffset", HORIZONTAL_OFFSET_FIELD);
        map.put("VerticalAlign", VERTICAL_ALIGN_FIELD);
        map.put("VerticalOffset", VERTICAL_OFFSET_FIELD);
        map.put("Opacity", OPACITY_FIELD);
        map.put("Target", TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PresetWatermark, T> g) {
        return obj -> g.apply((PresetWatermark) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PresetWatermark> {
        /**
         * <p>
         * A unique identifier for the settings for one watermark. The value of <code>Id</code> can be up to 40
         * characters long.
         * </p>
         * 
         * @param id
         *        A unique identifier for the settings for one watermark. The value of <code>Id</code> can be up to 40
         *        characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The maximum width of the watermark in one of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of
         * <code>MaxWidth</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to
         * specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder,
         * if any, in the calculation.
         * </p>
         * <p>
         * If you specify the value in pixels, it must be less than or equal to the value of <code>MaxWidth</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param maxWidth
         *        The maximum width of the watermark in one of the following formats: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of
         *        <code>MaxWidth</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to
         *        specify whether you want Elastic Transcoder to include the black bars that are added by Elastic
         *        Transcoder, if any, in the calculation.
         *        </p>
         *        <p>
         *        If you specify the value in pixels, it must be less than or equal to the value of
         *        <code>MaxWidth</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWidth(String maxWidth);

        /**
         * <p>
         * The maximum height of the watermark in one of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of
         * <code>MaxHeight</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to
         * specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder,
         * if any, in the calculation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify the value in pixels, it must be less than or equal to the value of <code>MaxHeight</code>.
         * </p>
         * 
         * @param maxHeight
         *        The maximum height of the watermark in one of the following formats: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of
         *        <code>MaxHeight</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to
         *        specify whether you want Elastic Transcoder to include the black bars that are added by Elastic
         *        Transcoder, if any, in the calculation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify the value in pixels, it must be less than or equal to the value of
         *        <code>MaxHeight</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHeight(String maxHeight);

        /**
         * <p>
         * A value that controls scaling of the watermark:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Fit</b>: Elastic Transcoder scales the watermark so it matches the value that you specified in either
         * <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Stretch</b>: Elastic Transcoder stretches the watermark to match the values that you specified for
         * <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the watermark and the values
         * of <code>MaxWidth</code> and <code>MaxHeight</code> are different, the watermark will be distorted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ShrinkToFit</b>: Elastic Transcoder scales the watermark down so that its dimensions match the values that
         * you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either
         * value. If you specify this option, Elastic Transcoder does not scale the watermark up.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sizingPolicy
         *        A value that controls scaling of the watermark: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Fit</b>: Elastic Transcoder scales the watermark so it matches the value that you specified in
         *        either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Stretch</b>: Elastic Transcoder stretches the watermark to match the values that you specified for
         *        <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the watermark and the
         *        values of <code>MaxWidth</code> and <code>MaxHeight</code> are different, the watermark will be
         *        distorted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ShrinkToFit</b>: Elastic Transcoder scales the watermark down so that its dimensions match the
         *        values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without
         *        exceeding either value. If you specify this option, Elastic Transcoder does not scale the watermark
         *        up.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizingPolicy(String sizingPolicy);

        /**
         * <p>
         * The horizontal position of the watermark unless you specify a non-zero value for
         * <code>HorizontalOffset</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Left</b>: The left edge of the watermark is aligned with the left border of the video.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Right</b>: The right edge of the watermark is aligned with the right border of the video.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Center</b>: The watermark is centered between the left and right borders.
         * </p>
         * </li>
         * </ul>
         * 
         * @param horizontalAlign
         *        The horizontal position of the watermark unless you specify a non-zero value for
         *        <code>HorizontalOffset</code>: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Left</b>: The left edge of the watermark is aligned with the left border of the video.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Right</b>: The right edge of the watermark is aligned with the right border of the video.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Center</b>: The watermark is centered between the left and right borders.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder horizontalAlign(String horizontalAlign);

        /**
         * <p>
         * The amount by which you want the horizontal position of the watermark to be offset from the position
         * specified by HorizontalAlign:
         * </p>
         * <ul>
         * <li>
         * <p>
         * number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.
         * </p>
         * </li>
         * <li>
         * <p>
         * integer percentage (%): The range of valid values is 0 to 100.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, if you specify Left for <code>HorizontalAlign</code> and 5px for <code>HorizontalOffset</code>,
         * the left side of the watermark appears 5 pixels from the left border of the output video.
         * </p>
         * <p>
         * <code>HorizontalOffset</code> is only valid when the value of <code>HorizontalAlign</code> is
         * <code>Left</code> or <code>Right</code>. If you specify an offset that causes the watermark to extend beyond
         * the left or right border and Elastic Transcoder has not added black bars, the watermark is cropped. If
         * Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends
         * beyond the black bars, it is cropped.
         * </p>
         * <p>
         * Use the value of <code>Target</code> to specify whether you want to include the black bars that are added by
         * Elastic Transcoder, if any, in the offset calculation.
         * </p>
         * 
         * @param horizontalOffset
         *        The amount by which you want the horizontal position of the watermark to be offset from the position
         *        specified by HorizontalAlign: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        integer percentage (%): The range of valid values is 0 to 100.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, if you specify Left for <code>HorizontalAlign</code> and 5px for
         *        <code>HorizontalOffset</code>, the left side of the watermark appears 5 pixels from the left border of
         *        the output video.
         *        </p>
         *        <p>
         *        <code>HorizontalOffset</code> is only valid when the value of <code>HorizontalAlign</code> is
         *        <code>Left</code> or <code>Right</code>. If you specify an offset that causes the watermark to extend
         *        beyond the left or right border and Elastic Transcoder has not added black bars, the watermark is
         *        cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the
         *        watermark extends beyond the black bars, it is cropped.
         *        </p>
         *        <p>
         *        Use the value of <code>Target</code> to specify whether you want to include the black bars that are
         *        added by Elastic Transcoder, if any, in the offset calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder horizontalOffset(String horizontalOffset);

        /**
         * <p>
         * The vertical position of the watermark unless you specify a non-zero value for <code>VerticalOffset</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Top</b>: The top edge of the watermark is aligned with the top border of the video.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Bottom</b>: The bottom edge of the watermark is aligned with the bottom border of the video.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Center</b>: The watermark is centered between the top and bottom borders.
         * </p>
         * </li>
         * </ul>
         * 
         * @param verticalAlign
         *        The vertical position of the watermark unless you specify a non-zero value for
         *        <code>VerticalOffset</code>: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Top</b>: The top edge of the watermark is aligned with the top border of the video.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Bottom</b>: The bottom edge of the watermark is aligned with the bottom border of the video.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Center</b>: The watermark is centered between the top and bottom borders.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verticalAlign(String verticalAlign);

        /**
         * <p>
         * <code>VerticalOffset</code>
         * </p>
         * <p>
         * The amount by which you want the vertical position of the watermark to be offset from the position specified
         * by VerticalAlign:
         * </p>
         * <ul>
         * <li>
         * <p>
         * number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of
         * <code>MaxHeight</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * integer percentage (%): The range of valid values is 0 to 100.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, if you specify <code>Top</code> for <code>VerticalAlign</code> and <code>5px</code> for
         * <code>VerticalOffset</code>, the top of the watermark appears 5 pixels from the top border of the output
         * video.
         * </p>
         * <p>
         * <code>VerticalOffset</code> is only valid when the value of VerticalAlign is Top or Bottom.
         * </p>
         * <p>
         * If you specify an offset that causes the watermark to extend beyond the top or bottom border and Elastic
         * Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars,
         * the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.
         * </p>
         * <p>
         * Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars
         * that are added by Elastic Transcoder, if any, in the offset calculation.
         * </p>
         * 
         * @param verticalOffset
         *        <code>VerticalOffset</code> </p>
         *        <p>
         *        The amount by which you want the vertical position of the watermark to be offset from the position
         *        specified by VerticalAlign:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of
         *        <code>MaxHeight</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        integer percentage (%): The range of valid values is 0 to 100.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, if you specify <code>Top</code> for <code>VerticalAlign</code> and <code>5px</code> for
         *        <code>VerticalOffset</code>, the top of the watermark appears 5 pixels from the top border of the
         *        output video.
         *        </p>
         *        <p>
         *        <code>VerticalOffset</code> is only valid when the value of VerticalAlign is Top or Bottom.
         *        </p>
         *        <p>
         *        If you specify an offset that causes the watermark to extend beyond the top or bottom border and
         *        Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added
         *        black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars,
         *        it is cropped.
         *        </p>
         *        <p>
         *        Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the
         *        black bars that are added by Elastic Transcoder, if any, in the offset calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verticalOffset(String verticalOffset);

        /**
         * <p>
         * A percentage that indicates how much you want a watermark to obscure the video in the location where it
         * appears. Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures the video
         * in the specified location). The datatype of <code>Opacity</code> is float.
         * </p>
         * <p>
         * Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent portion
         * of the video appears as if you had specified a value of 0 for <code>Opacity</code>. The .jpg file format
         * doesn't support transparency.
         * </p>
         * 
         * @param opacity
         *        A percentage that indicates how much you want a watermark to obscure the video in the location where
         *        it appears. Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures
         *        the video in the specified location). The datatype of <code>Opacity</code> is float.</p>
         *        <p>
         *        Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent
         *        portion of the video appears as if you had specified a value of 0 for <code>Opacity</code>. The .jpg
         *        file format doesn't support transparency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opacity(String opacity);

        /**
         * <p>
         * A value that determines how Elastic Transcoder interprets values that you specified for
         * <code>HorizontalOffset</code>, <code>VerticalOffset</code>, <code>MaxWidth</code>, and <code>MaxHeight</code>
         * :
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Content</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on
         * the borders of the video excluding black bars added by Elastic Transcoder, if any. In addition,
         * <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the
         * borders of the video excluding black bars added by Elastic Transcoder, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Frame</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on
         * the borders of the video including black bars added by Elastic Transcoder, if any. In addition,
         * <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the
         * borders of the video including black bars added by Elastic Transcoder, if any.
         * </p>
         * </li>
         * </ul>
         * 
         * @param target
         *        A value that determines how Elastic Transcoder interprets values that you specified for
         *        <code>HorizontalOffset</code>, <code>VerticalOffset</code>, <code>MaxWidth</code>, and
         *        <code>MaxHeight</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Content</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated
         *        based on the borders of the video excluding black bars added by Elastic Transcoder, if any. In
         *        addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are
         *        calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Frame</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated
         *        based on the borders of the video including black bars added by Elastic Transcoder, if any. In
         *        addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are
         *        calculated based on the borders of the video including black bars added by Elastic Transcoder, if any.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String maxWidth;

        private String maxHeight;

        private String sizingPolicy;

        private String horizontalAlign;

        private String horizontalOffset;

        private String verticalAlign;

        private String verticalOffset;

        private String opacity;

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(PresetWatermark model) {
            id(model.id);
            maxWidth(model.maxWidth);
            maxHeight(model.maxHeight);
            sizingPolicy(model.sizingPolicy);
            horizontalAlign(model.horizontalAlign);
            horizontalOffset(model.horizontalOffset);
            verticalAlign(model.verticalAlign);
            verticalOffset(model.verticalOffset);
            opacity(model.opacity);
            target(model.target);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMaxWidth() {
            return maxWidth;
        }

        public final void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public final Builder maxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public final String getMaxHeight() {
            return maxHeight;
        }

        public final void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public final Builder maxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public final String getSizingPolicy() {
            return sizingPolicy;
        }

        public final void setSizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
        }

        @Override
        public final Builder sizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
            return this;
        }

        public final String getHorizontalAlign() {
            return horizontalAlign;
        }

        public final void setHorizontalAlign(String horizontalAlign) {
            this.horizontalAlign = horizontalAlign;
        }

        @Override
        public final Builder horizontalAlign(String horizontalAlign) {
            this.horizontalAlign = horizontalAlign;
            return this;
        }

        public final String getHorizontalOffset() {
            return horizontalOffset;
        }

        public final void setHorizontalOffset(String horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
        }

        @Override
        public final Builder horizontalOffset(String horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            return this;
        }

        public final String getVerticalAlign() {
            return verticalAlign;
        }

        public final void setVerticalAlign(String verticalAlign) {
            this.verticalAlign = verticalAlign;
        }

        @Override
        public final Builder verticalAlign(String verticalAlign) {
            this.verticalAlign = verticalAlign;
            return this;
        }

        public final String getVerticalOffset() {
            return verticalOffset;
        }

        public final void setVerticalOffset(String verticalOffset) {
            this.verticalOffset = verticalOffset;
        }

        @Override
        public final Builder verticalOffset(String verticalOffset) {
            this.verticalOffset = verticalOffset;
            return this;
        }

        public final String getOpacity() {
            return opacity;
        }

        public final void setOpacity(String opacity) {
            this.opacity = opacity;
        }

        @Override
        public final Builder opacity(String opacity) {
            this.opacity = opacity;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public PresetWatermark build() {
            return new PresetWatermark(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
