/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Thumbnails for videos.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Thumbnails implements SdkPojo, Serializable, ToCopyableBuilder<Thumbnails.Builder, Thumbnails> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(Thumbnails::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Interval").getter(getter(Thumbnails::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resolution").getter(getter(Thumbnails::resolution)).setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resolution").build()).build();

    private static final SdkField<String> ASPECT_RATIO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AspectRatio").getter(getter(Thumbnails::aspectRatio)).setter(setter(Builder::aspectRatio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AspectRatio").build()).build();

    private static final SdkField<String> MAX_WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxWidth").getter(getter(Thumbnails::maxWidth)).setter(setter(Builder::maxWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWidth").build()).build();

    private static final SdkField<String> MAX_HEIGHT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxHeight").getter(getter(Thumbnails::maxHeight)).setter(setter(Builder::maxHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHeight").build()).build();

    private static final SdkField<String> SIZING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SizingPolicy").getter(getter(Thumbnails::sizingPolicy)).setter(setter(Builder::sizingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizingPolicy").build()).build();

    private static final SdkField<String> PADDING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaddingPolicy").getter(getter(Thumbnails::paddingPolicy)).setter(setter(Builder::paddingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaddingPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, INTERVAL_FIELD,
            RESOLUTION_FIELD, ASPECT_RATIO_FIELD, MAX_WIDTH_FIELD, MAX_HEIGHT_FIELD, SIZING_POLICY_FIELD, PADDING_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String interval;

    private final String resolution;

    private final String aspectRatio;

    private final String maxWidth;

    private final String maxHeight;

    private final String sizingPolicy;

    private final String paddingPolicy;

    private Thumbnails(BuilderImpl builder) {
        this.format = builder.format;
        this.interval = builder.interval;
        this.resolution = builder.resolution;
        this.aspectRatio = builder.aspectRatio;
        this.maxWidth = builder.maxWidth;
        this.maxHeight = builder.maxHeight;
        this.sizingPolicy = builder.sizingPolicy;
        this.paddingPolicy = builder.paddingPolicy;
    }

    /**
     * <p>
     * The format of thumbnails, if any. Valid values are <code>jpg</code> and <code>png</code>.
     * </p>
     * <p>
     * You specify whether you want Elastic Transcoder to create thumbnails when you create a job.
     * </p>
     * 
     * @return The format of thumbnails, if any. Valid values are <code>jpg</code> and <code>png</code>. </p>
     *         <p>
     *         You specify whether you want Elastic Transcoder to create thumbnails when you create a job.
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * The approximate number of seconds between thumbnails. Specify an integer value.
     * </p>
     * 
     * @return The approximate number of seconds between thumbnails. Specify an integer value.
     */
    public final String interval() {
        return interval;
    }

    /**
     * <important>
     * <p>
     * To better control resolution and aspect ratio of thumbnails, we recommend that you use the values
     * <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead
     * of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do
     * not use them together.
     * </p>
     * </important>
     * <p>
     * The width and height of thumbnail files in pixels. Specify a value in the format <code> <i>width</i> </code> x
     * <code> <i>height</i> </code> where both values are even integers. The values cannot exceed the width and height
     * that you specified in the <code>Video:Resolution</code> object.
     * </p>
     * 
     * @return <p>
     *         To better control resolution and aspect ratio of thumbnails, we recommend that you use the values
     *         <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code>
     *         instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually
     *         exclusive. Do not use them together.
     *         </p>
     *         </important>
     *         <p>
     *         The width and height of thumbnail files in pixels. Specify a value in the format
     *         <code> <i>width</i> </code> x <code> <i>height</i> </code> where both values are even integers. The
     *         values cannot exceed the width and height that you specified in the <code>Video:Resolution</code> object.
     */
    public final String resolution() {
        return resolution;
    }

    /**
     * <important>
     * <p>
     * To better control resolution and aspect ratio of thumbnails, we recommend that you use the values
     * <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead
     * of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do
     * not use them together.
     * </p>
     * </important>
     * <p>
     * The aspect ratio of thumbnails. Valid values include:
     * </p>
     * <p>
     * <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
     * </p>
     * <p>
     * If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the video in the
     * output file.
     * </p>
     * 
     * @return <p>
     *         To better control resolution and aspect ratio of thumbnails, we recommend that you use the values
     *         <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code>
     *         instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually
     *         exclusive. Do not use them together.
     *         </p>
     *         </important>
     *         <p>
     *         The aspect ratio of thumbnails. Valid values include:
     *         </p>
     *         <p>
     *         <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
     *         </p>
     *         <p>
     *         If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the video in
     *         the output file.
     */
    public final String aspectRatio() {
        return aspectRatio;
    }

    /**
     * <p>
     * The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the
     * default value. If you specify a numeric value, enter an even integer between 32 and 4096.
     * </p>
     * 
     * @return The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as
     *         the default value. If you specify a numeric value, enter an even integer between 32 and 4096.
     */
    public final String maxWidth() {
        return maxWidth;
    }

    /**
     * <p>
     * The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the
     * default value. If you specify a numeric value, enter an even integer between 32 and 3072.
     * </p>
     * 
     * @return The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD)
     *         as the default value. If you specify a numeric value, enter an even integer between 32 and 3072.
     */
    public final String maxHeight() {
        return maxHeight;
    }

    /**
     * <p>
     * Specify one of the following values to control scaling of thumbnails:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Fit</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail
     * MaxWidth or MaxHeight settings without exceeding the other value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fill</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail
     * <code>MaxWidth</code> or <code>MaxHeight</code> settings and matches or exceeds the other value. Elastic
     * Transcoder centers the image in thumbnails and then crops in the dimension (if any) that exceeds the maximum
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stretch</code>: Elastic Transcoder stretches thumbnails to match the values that you specified for
     * thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings. If the relative proportions of the input
     * video and thumbnails are different, the thumbnails will be distorted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Keep</code>: Elastic Transcoder does not scale thumbnails. If either dimension of the input video exceeds
     * the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings, Elastic
     * Transcoder crops the thumbnails.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ShrinkToFit</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values
     * that you specified for at least one of thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> without
     * exceeding either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ShrinkToFill</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values
     * that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below
     * either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify one of the following values to control scaling of thumbnails:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Fit</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in
     *         thumbnail MaxWidth or MaxHeight settings without exceeding the other value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fill</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in
     *         thumbnail <code>MaxWidth</code> or <code>MaxHeight</code> settings and matches or exceeds the other
     *         value. Elastic Transcoder centers the image in thumbnails and then crops in the dimension (if any) that
     *         exceeds the maximum value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stretch</code>: Elastic Transcoder stretches thumbnails to match the values that you specified for
     *         thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings. If the relative proportions of the
     *         input video and thumbnails are different, the thumbnails will be distorted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Keep</code>: Elastic Transcoder does not scale thumbnails. If either dimension of the input video
     *         exceeds the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code>
     *         settings, Elastic Transcoder crops the thumbnails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ShrinkToFit</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the
     *         values that you specified for at least one of thumbnail <code>MaxWidth</code> and <code>MaxHeight</code>
     *         without exceeding either value. If you specify this option, Elastic Transcoder does not scale thumbnails
     *         up.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ShrinkToFill</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the
     *         values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without
     *         dropping below either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.
     *         </p>
     *         </li>
     */
    public final String sizingPolicy() {
        return sizingPolicy;
    }

    /**
     * <p>
     * When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and
     * bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that
     * you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings.
     * </p>
     * 
     * @return When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the
     *         top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match
     *         the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings.
     */
    public final String paddingPolicy() {
        return paddingPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(resolution());
        hashCode = 31 * hashCode + Objects.hashCode(aspectRatio());
        hashCode = 31 * hashCode + Objects.hashCode(maxWidth());
        hashCode = 31 * hashCode + Objects.hashCode(maxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(sizingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(paddingPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Thumbnails)) {
            return false;
        }
        Thumbnails other = (Thumbnails) obj;
        return Objects.equals(format(), other.format()) && Objects.equals(interval(), other.interval())
                && Objects.equals(resolution(), other.resolution()) && Objects.equals(aspectRatio(), other.aspectRatio())
                && Objects.equals(maxWidth(), other.maxWidth()) && Objects.equals(maxHeight(), other.maxHeight())
                && Objects.equals(sizingPolicy(), other.sizingPolicy()) && Objects.equals(paddingPolicy(), other.paddingPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Thumbnails").add("Format", format()).add("Interval", interval()).add("Resolution", resolution())
                .add("AspectRatio", aspectRatio()).add("MaxWidth", maxWidth()).add("MaxHeight", maxHeight())
                .add("SizingPolicy", sizingPolicy()).add("PaddingPolicy", paddingPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "Resolution":
            return Optional.ofNullable(clazz.cast(resolution()));
        case "AspectRatio":
            return Optional.ofNullable(clazz.cast(aspectRatio()));
        case "MaxWidth":
            return Optional.ofNullable(clazz.cast(maxWidth()));
        case "MaxHeight":
            return Optional.ofNullable(clazz.cast(maxHeight()));
        case "SizingPolicy":
            return Optional.ofNullable(clazz.cast(sizingPolicy()));
        case "PaddingPolicy":
            return Optional.ofNullable(clazz.cast(paddingPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Format", FORMAT_FIELD);
        map.put("Interval", INTERVAL_FIELD);
        map.put("Resolution", RESOLUTION_FIELD);
        map.put("AspectRatio", ASPECT_RATIO_FIELD);
        map.put("MaxWidth", MAX_WIDTH_FIELD);
        map.put("MaxHeight", MAX_HEIGHT_FIELD);
        map.put("SizingPolicy", SIZING_POLICY_FIELD);
        map.put("PaddingPolicy", PADDING_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Thumbnails, T> g) {
        return obj -> g.apply((Thumbnails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Thumbnails> {
        /**
         * <p>
         * The format of thumbnails, if any. Valid values are <code>jpg</code> and <code>png</code>.
         * </p>
         * <p>
         * You specify whether you want Elastic Transcoder to create thumbnails when you create a job.
         * </p>
         * 
         * @param format
         *        The format of thumbnails, if any. Valid values are <code>jpg</code> and <code>png</code>. </p>
         *        <p>
         *        You specify whether you want Elastic Transcoder to create thumbnails when you create a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The approximate number of seconds between thumbnails. Specify an integer value.
         * </p>
         * 
         * @param interval
         *        The approximate number of seconds between thumbnails. Specify an integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(String interval);

        /**
         * <important>
         * <p>
         * To better control resolution and aspect ratio of thumbnails, we recommend that you use the values
         * <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code>
         * instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually
         * exclusive. Do not use them together.
         * </p>
         * </important>
         * <p>
         * The width and height of thumbnail files in pixels. Specify a value in the format <code> <i>width</i> </code>
         * x <code> <i>height</i> </code> where both values are even integers. The values cannot exceed the width and
         * height that you specified in the <code>Video:Resolution</code> object.
         * </p>
         * 
         * @param resolution
         *        <p>
         *        To better control resolution and aspect ratio of thumbnails, we recommend that you use the values
         *        <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and
         *        <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two
         *        groups of settings are mutually exclusive. Do not use them together.
         *        </p>
         *        </important>
         *        <p>
         *        The width and height of thumbnail files in pixels. Specify a value in the format
         *        <code> <i>width</i> </code> x <code> <i>height</i> </code> where both values are even integers. The
         *        values cannot exceed the width and height that you specified in the <code>Video:Resolution</code>
         *        object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolution(String resolution);

        /**
         * <important>
         * <p>
         * To better control resolution and aspect ratio of thumbnails, we recommend that you use the values
         * <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code>
         * instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually
         * exclusive. Do not use them together.
         * </p>
         * </important>
         * <p>
         * The aspect ratio of thumbnails. Valid values include:
         * </p>
         * <p>
         * <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
         * </p>
         * <p>
         * If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the video in the
         * output file.
         * </p>
         * 
         * @param aspectRatio
         *        <p>
         *        To better control resolution and aspect ratio of thumbnails, we recommend that you use the values
         *        <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and
         *        <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two
         *        groups of settings are mutually exclusive. Do not use them together.
         *        </p>
         *        </important>
         *        <p>
         *        The aspect ratio of thumbnails. Valid values include:
         *        </p>
         *        <p>
         *        <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
         *        </p>
         *        <p>
         *        If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the video
         *        in the output file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aspectRatio(String aspectRatio);

        /**
         * <p>
         * The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the
         * default value. If you specify a numeric value, enter an even integer between 32 and 4096.
         * </p>
         * 
         * @param maxWidth
         *        The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD)
         *        as the default value. If you specify a numeric value, enter an even integer between 32 and 4096.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWidth(String maxWidth);

        /**
         * <p>
         * The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as
         * the default value. If you specify a numeric value, enter an even integer between 32 and 3072.
         * </p>
         * 
         * @param maxHeight
         *        The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full
         *        HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHeight(String maxHeight);

        /**
         * <p>
         * Specify one of the following values to control scaling of thumbnails:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Fit</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in
         * thumbnail MaxWidth or MaxHeight settings without exceeding the other value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fill</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in
         * thumbnail <code>MaxWidth</code> or <code>MaxHeight</code> settings and matches or exceeds the other value.
         * Elastic Transcoder centers the image in thumbnails and then crops in the dimension (if any) that exceeds the
         * maximum value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stretch</code>: Elastic Transcoder stretches thumbnails to match the values that you specified for
         * thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings. If the relative proportions of the input
         * video and thumbnails are different, the thumbnails will be distorted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Keep</code>: Elastic Transcoder does not scale thumbnails. If either dimension of the input video
         * exceeds the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code>
         * settings, Elastic Transcoder crops the thumbnails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ShrinkToFit</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values
         * that you specified for at least one of thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> without
         * exceeding either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ShrinkToFill</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the
         * values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without
         * dropping below either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sizingPolicy
         *        Specify one of the following values to control scaling of thumbnails:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Fit</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in
         *        thumbnail MaxWidth or MaxHeight settings without exceeding the other value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fill</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in
         *        thumbnail <code>MaxWidth</code> or <code>MaxHeight</code> settings and matches or exceeds the other
         *        value. Elastic Transcoder centers the image in thumbnails and then crops in the dimension (if any)
         *        that exceeds the maximum value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stretch</code>: Elastic Transcoder stretches thumbnails to match the values that you specified
         *        for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings. If the relative proportions
         *        of the input video and thumbnails are different, the thumbnails will be distorted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Keep</code>: Elastic Transcoder does not scale thumbnails. If either dimension of the input
         *        video exceeds the values that you specified for thumbnail <code>MaxWidth</code> and
         *        <code>MaxHeight</code> settings, Elastic Transcoder crops the thumbnails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ShrinkToFit</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the
         *        values that you specified for at least one of thumbnail <code>MaxWidth</code> and
         *        <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder
         *        does not scale thumbnails up.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ShrinkToFill</code>: Elastic Transcoder scales thumbnails down so that their dimensions match
         *        the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code>
         *        without dropping below either value. If you specify this option, Elastic Transcoder does not scale
         *        thumbnails up.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizingPolicy(String sizingPolicy);

        /**
         * <p>
         * When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top
         * and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the
         * values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings.
         * </p>
         * 
         * @param paddingPolicy
         *        When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to
         *        the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails
         *        match the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code>
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paddingPolicy(String paddingPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String interval;

        private String resolution;

        private String aspectRatio;

        private String maxWidth;

        private String maxHeight;

        private String sizingPolicy;

        private String paddingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(Thumbnails model) {
            format(model.format);
            interval(model.interval);
            resolution(model.resolution);
            aspectRatio(model.aspectRatio);
            maxWidth(model.maxWidth);
            maxHeight(model.maxHeight);
            sizingPolicy(model.sizingPolicy);
            paddingPolicy(model.paddingPolicy);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getInterval() {
            return interval;
        }

        public final void setInterval(String interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        public final String getResolution() {
            return resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final String getAspectRatio() {
            return aspectRatio;
        }

        public final void setAspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
        }

        @Override
        public final Builder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public final String getMaxWidth() {
            return maxWidth;
        }

        public final void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public final Builder maxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public final String getMaxHeight() {
            return maxHeight;
        }

        public final void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public final Builder maxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public final String getSizingPolicy() {
            return sizingPolicy;
        }

        public final void setSizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
        }

        @Override
        public final Builder sizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
            return this;
        }

        public final String getPaddingPolicy() {
            return paddingPolicy;
        }

        public final void setPaddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
        }

        @Override
        public final Builder paddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
            return this;
        }

        @Override
        public Thumbnails build() {
            return new Thumbnails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
