/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Encryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Encryption> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(Encryption.getter(Encryption::mode)).setter(Encryption.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(Encryption.getter(Encryption::key)).setter(Encryption.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> KEY_MD5_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMd5").getter(Encryption.getter(Encryption::keyMd5)).setter(Encryption.setter(Builder::keyMd5)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMd5").build()}).build();
    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitializationVector").getter(Encryption.getter(Encryption::initializationVector)).setter(Encryption.setter(Builder::initializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, KEY_FIELD, KEY_MD5_FIELD, INITIALIZATION_VECTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Encryption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final String key;
    private final String keyMd5;
    private final String initializationVector;

    private Encryption(BuilderImpl builder) {
        this.mode = builder.mode;
        this.key = builder.key;
        this.keyMd5 = builder.keyMd5;
        this.initializationVector = builder.initializationVector;
    }

    public final String mode() {
        return this.mode;
    }

    public final String key() {
        return this.key;
    }

    public final String keyMd5() {
        return this.keyMd5;
    }

    public final String initializationVector() {
        return this.initializationVector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mode());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMd5());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Encryption)) {
            return false;
        }
        Encryption other = (Encryption)obj;
        return Objects.equals(this.mode(), other.mode()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.keyMd5(), other.keyMd5()) && Objects.equals(this.initializationVector(), other.initializationVector());
    }

    public final String toString() {
        return ToString.builder((String)"Encryption").add("Mode", (Object)this.mode()).add("Key", (Object)this.key()).add("KeyMd5", (Object)this.keyMd5()).add("InitializationVector", (Object)this.initializationVector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.mode()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "KeyMd5": {
                return Optional.ofNullable(clazz.cast(this.keyMd5()));
            }
            case "InitializationVector": {
                return Optional.ofNullable(clazz.cast(this.initializationVector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Mode", MODE_FIELD);
        map.put("Key", KEY_FIELD);
        map.put("KeyMd5", KEY_MD5_FIELD);
        map.put("InitializationVector", INITIALIZATION_VECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Encryption, T> g) {
        return obj -> g.apply((Encryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private String key;
        private String keyMd5;
        private String initializationVector;

        private BuilderImpl() {
        }

        private BuilderImpl(Encryption model) {
            this.mode(model.mode);
            this.key(model.key);
            this.keyMd5(model.keyMd5);
            this.initializationVector(model.initializationVector);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getKeyMd5() {
            return this.keyMd5;
        }

        public final void setKeyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
        }

        @Override
        public final Builder keyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
            return this;
        }

        public final String getInitializationVector() {
            return this.initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public Encryption build() {
            return new Encryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Encryption> {
        public Builder mode(String var1);

        public Builder key(String var1);

        public Builder keyMd5(String var1);

        public Builder initializationVector(String var1);
    }
}

