/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportGameConfigurationSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportGameConfigurationSource> {
    private static final SdkField<SdkBytes> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("File").getter(ImportGameConfigurationSource.getter(ImportGameConfigurationSource::file)).setter(ImportGameConfigurationSource.setter(Builder::file)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("File").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes file;

    private ImportGameConfigurationSource(BuilderImpl builder) {
        this.file = builder.file;
    }

    public final SdkBytes file() {
        return this.file;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportGameConfigurationSource)) {
            return false;
        }
        ImportGameConfigurationSource other = (ImportGameConfigurationSource)obj;
        return Objects.equals(this.file(), other.file());
    }

    public final String toString() {
        return ToString.builder((String)"ImportGameConfigurationSource").add("File", (Object)this.file()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "File": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportGameConfigurationSource, T> g) {
        return obj -> g.apply((ImportGameConfigurationSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes file;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportGameConfigurationSource model) {
            this.file(model.file);
        }

        public final ByteBuffer getFile() {
            return this.file == null ? null : this.file.asByteBuffer();
        }

        public final void setFile(ByteBuffer file) {
            this.file(file == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)file));
        }

        @Override
        public final Builder file(SdkBytes file) {
            this.file = file;
            return this;
        }

        public ImportGameConfigurationSource build() {
            return new ImportGameConfigurationSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportGameConfigurationSource> {
        public Builder file(SdkBytes var1);
    }
}

