/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.IsolineMatchingOptions;
import software.amazon.awssdk.services.georoutes.model.IsolineSideOfStreetOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IsolineDestinationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IsolineDestinationOptions> {
    private static final SdkField<Long> AVOID_ACTIONS_FOR_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AvoidActionsForDistance").getter(IsolineDestinationOptions.getter(IsolineDestinationOptions::avoidActionsForDistance)).setter(IsolineDestinationOptions.setter(Builder::avoidActionsForDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidActionsForDistance").build()}).build();
    private static final SdkField<Double> HEADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Heading").getter(IsolineDestinationOptions.getter(IsolineDestinationOptions::heading)).setter(IsolineDestinationOptions.setter(Builder::heading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()}).build();
    private static final SdkField<IsolineMatchingOptions> MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Matching").getter(IsolineDestinationOptions.getter(IsolineDestinationOptions::matching)).setter(IsolineDestinationOptions.setter(Builder::matching)).constructor(IsolineMatchingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matching").build()}).build();
    private static final SdkField<IsolineSideOfStreetOptions> SIDE_OF_STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SideOfStreet").getter(IsolineDestinationOptions.getter(IsolineDestinationOptions::sideOfStreet)).setter(IsolineDestinationOptions.setter(Builder::sideOfStreet)).constructor(IsolineSideOfStreetOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideOfStreet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVOID_ACTIONS_FOR_DISTANCE_FIELD, HEADING_FIELD, MATCHING_FIELD, SIDE_OF_STREET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AvoidActionsForDistance", AVOID_ACTIONS_FOR_DISTANCE_FIELD);
            this.put("Heading", HEADING_FIELD);
            this.put("Matching", MATCHING_FIELD);
            this.put("SideOfStreet", SIDE_OF_STREET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long avoidActionsForDistance;
    private final Double heading;
    private final IsolineMatchingOptions matching;
    private final IsolineSideOfStreetOptions sideOfStreet;

    private IsolineDestinationOptions(BuilderImpl builder) {
        this.avoidActionsForDistance = builder.avoidActionsForDistance;
        this.heading = builder.heading;
        this.matching = builder.matching;
        this.sideOfStreet = builder.sideOfStreet;
    }

    public final Long avoidActionsForDistance() {
        return this.avoidActionsForDistance;
    }

    public final Double heading() {
        return this.heading;
    }

    public final IsolineMatchingOptions matching() {
        return this.matching;
    }

    public final IsolineSideOfStreetOptions sideOfStreet() {
        return this.sideOfStreet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.avoidActionsForDistance());
        hashCode = 31 * hashCode + Objects.hashCode(this.heading());
        hashCode = 31 * hashCode + Objects.hashCode(this.matching());
        hashCode = 31 * hashCode + Objects.hashCode(this.sideOfStreet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineDestinationOptions)) {
            return false;
        }
        IsolineDestinationOptions other = (IsolineDestinationOptions)obj;
        return Objects.equals(this.avoidActionsForDistance(), other.avoidActionsForDistance()) && Objects.equals(this.heading(), other.heading()) && Objects.equals(this.matching(), other.matching()) && Objects.equals(this.sideOfStreet(), other.sideOfStreet());
    }

    public final String toString() {
        return ToString.builder((String)"IsolineDestinationOptions").add("AvoidActionsForDistance", (Object)this.avoidActionsForDistance()).add("Heading", (Object)this.heading()).add("Matching", (Object)this.matching()).add("SideOfStreet", (Object)this.sideOfStreet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvoidActionsForDistance": {
                return Optional.ofNullable(clazz.cast(this.avoidActionsForDistance()));
            }
            case "Heading": {
                return Optional.ofNullable(clazz.cast(this.heading()));
            }
            case "Matching": {
                return Optional.ofNullable(clazz.cast(this.matching()));
            }
            case "SideOfStreet": {
                return Optional.ofNullable(clazz.cast(this.sideOfStreet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IsolineDestinationOptions, T> g) {
        return obj -> g.apply((IsolineDestinationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long avoidActionsForDistance;
        private Double heading;
        private IsolineMatchingOptions matching;
        private IsolineSideOfStreetOptions sideOfStreet;

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineDestinationOptions model) {
            this.avoidActionsForDistance(model.avoidActionsForDistance);
            this.heading(model.heading);
            this.matching(model.matching);
            this.sideOfStreet(model.sideOfStreet);
        }

        public final Long getAvoidActionsForDistance() {
            return this.avoidActionsForDistance;
        }

        public final void setAvoidActionsForDistance(Long avoidActionsForDistance) {
            this.avoidActionsForDistance = avoidActionsForDistance;
        }

        @Override
        public final Builder avoidActionsForDistance(Long avoidActionsForDistance) {
            this.avoidActionsForDistance = avoidActionsForDistance;
            return this;
        }

        public final Double getHeading() {
            return this.heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final IsolineMatchingOptions.Builder getMatching() {
            return this.matching != null ? this.matching.toBuilder() : null;
        }

        public final void setMatching(IsolineMatchingOptions.BuilderImpl matching) {
            this.matching = matching != null ? matching.build() : null;
        }

        @Override
        public final Builder matching(IsolineMatchingOptions matching) {
            this.matching = matching;
            return this;
        }

        public final IsolineSideOfStreetOptions.Builder getSideOfStreet() {
            return this.sideOfStreet != null ? this.sideOfStreet.toBuilder() : null;
        }

        public final void setSideOfStreet(IsolineSideOfStreetOptions.BuilderImpl sideOfStreet) {
            this.sideOfStreet = sideOfStreet != null ? sideOfStreet.build() : null;
        }

        @Override
        public final Builder sideOfStreet(IsolineSideOfStreetOptions sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
            return this;
        }

        public IsolineDestinationOptions build() {
            return new IsolineDestinationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IsolineDestinationOptions> {
        public Builder avoidActionsForDistance(Long var1);

        public Builder heading(Double var1);

        public Builder matching(IsolineMatchingOptions var1);

        default public Builder matching(Consumer<IsolineMatchingOptions.Builder> matching) {
            return this.matching((IsolineMatchingOptions)((IsolineMatchingOptions.Builder)IsolineMatchingOptions.builder().applyMutation(matching)).build());
        }

        public Builder sideOfStreet(IsolineSideOfStreetOptions var1);

        default public Builder sideOfStreet(Consumer<IsolineSideOfStreetOptions.Builder> sideOfStreet) {
            return this.sideOfStreet((IsolineSideOfStreetOptions)((IsolineSideOfStreetOptions.Builder)IsolineSideOfStreetOptions.builder().applyMutation(sideOfStreet)).build());
        }
    }
}

