/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.IsolineEngineType;
import software.amazon.awssdk.services.georoutes.model.IsolineVehicleLicensePlate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IsolineScooterOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IsolineScooterOptions> {
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineType").getter(IsolineScooterOptions.getter(IsolineScooterOptions::engineTypeAsString)).setter(IsolineScooterOptions.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineType").build()}).build();
    private static final SdkField<IsolineVehicleLicensePlate> LICENSE_PLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LicensePlate").getter(IsolineScooterOptions.getter(IsolineScooterOptions::licensePlate)).setter(IsolineScooterOptions.setter(Builder::licensePlate)).constructor(IsolineVehicleLicensePlate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicensePlate").build()}).build();
    private static final SdkField<Double> MAX_SPEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxSpeed").getter(IsolineScooterOptions.getter(IsolineScooterOptions::maxSpeed)).setter(IsolineScooterOptions.setter(Builder::maxSpeed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeed").build()}).build();
    private static final SdkField<Integer> OCCUPANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Occupancy").getter(IsolineScooterOptions.getter(IsolineScooterOptions::occupancy)).setter(IsolineScooterOptions.setter(Builder::occupancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Occupancy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_TYPE_FIELD, LICENSE_PLATE_FIELD, MAX_SPEED_FIELD, OCCUPANCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EngineType", ENGINE_TYPE_FIELD);
            this.put("LicensePlate", LICENSE_PLATE_FIELD);
            this.put("MaxSpeed", MAX_SPEED_FIELD);
            this.put("Occupancy", OCCUPANCY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String engineType;
    private final IsolineVehicleLicensePlate licensePlate;
    private final Double maxSpeed;
    private final Integer occupancy;

    private IsolineScooterOptions(BuilderImpl builder) {
        this.engineType = builder.engineType;
        this.licensePlate = builder.licensePlate;
        this.maxSpeed = builder.maxSpeed;
        this.occupancy = builder.occupancy;
    }

    public final IsolineEngineType engineType() {
        return IsolineEngineType.fromValue(this.engineType);
    }

    public final String engineTypeAsString() {
        return this.engineType;
    }

    public final IsolineVehicleLicensePlate licensePlate() {
        return this.licensePlate;
    }

    public final Double maxSpeed() {
        return this.maxSpeed;
    }

    public final Integer occupancy() {
        return this.occupancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licensePlate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(this.occupancy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineScooterOptions)) {
            return false;
        }
        IsolineScooterOptions other = (IsolineScooterOptions)obj;
        return Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.licensePlate(), other.licensePlate()) && Objects.equals(this.maxSpeed(), other.maxSpeed()) && Objects.equals(this.occupancy(), other.occupancy());
    }

    public final String toString() {
        return ToString.builder((String)"IsolineScooterOptions").add("EngineType", (Object)this.engineTypeAsString()).add("LicensePlate", (Object)this.licensePlate()).add("MaxSpeed", (Object)this.maxSpeed()).add("Occupancy", (Object)this.occupancy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "LicensePlate": {
                return Optional.ofNullable(clazz.cast(this.licensePlate()));
            }
            case "MaxSpeed": {
                return Optional.ofNullable(clazz.cast(this.maxSpeed()));
            }
            case "Occupancy": {
                return Optional.ofNullable(clazz.cast(this.occupancy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IsolineScooterOptions, T> g) {
        return obj -> g.apply((IsolineScooterOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engineType;
        private IsolineVehicleLicensePlate licensePlate;
        private Double maxSpeed;
        private Integer occupancy;

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineScooterOptions model) {
            this.engineType(model.engineType);
            this.licensePlate(model.licensePlate);
            this.maxSpeed(model.maxSpeed);
            this.occupancy(model.occupancy);
        }

        public final String getEngineType() {
            return this.engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(IsolineEngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final IsolineVehicleLicensePlate.Builder getLicensePlate() {
            return this.licensePlate != null ? this.licensePlate.toBuilder() : null;
        }

        public final void setLicensePlate(IsolineVehicleLicensePlate.BuilderImpl licensePlate) {
            this.licensePlate = licensePlate != null ? licensePlate.build() : null;
        }

        @Override
        public final Builder licensePlate(IsolineVehicleLicensePlate licensePlate) {
            this.licensePlate = licensePlate;
            return this;
        }

        public final Double getMaxSpeed() {
            return this.maxSpeed;
        }

        public final void setMaxSpeed(Double maxSpeed) {
            this.maxSpeed = maxSpeed;
        }

        @Override
        public final Builder maxSpeed(Double maxSpeed) {
            this.maxSpeed = maxSpeed;
            return this;
        }

        public final Integer getOccupancy() {
            return this.occupancy;
        }

        public final void setOccupancy(Integer occupancy) {
            this.occupancy = occupancy;
        }

        @Override
        public final Builder occupancy(Integer occupancy) {
            this.occupancy = occupancy;
            return this;
        }

        public IsolineScooterOptions build() {
            return new IsolineScooterOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IsolineScooterOptions> {
        public Builder engineType(String var1);

        public Builder engineType(IsolineEngineType var1);

        public Builder licensePlate(IsolineVehicleLicensePlate var1);

        default public Builder licensePlate(Consumer<IsolineVehicleLicensePlate.Builder> licensePlate) {
            return this.licensePlate((IsolineVehicleLicensePlate)((IsolineVehicleLicensePlate.Builder)IsolineVehicleLicensePlate.builder().applyMutation(licensePlate)).build());
        }

        public Builder maxSpeed(Double var1);

        public Builder occupancy(Integer var1);
    }
}

