/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteVehicleNoticeCode {
    ACCURATE_POLYLINE_UNAVAILABLE("AccuratePolylineUnavailable"),
    OTHER("Other"),
    POTENTIAL_VIOLATED_AVOID_TOLL_ROAD_USAGE("PotentialViolatedAvoidTollRoadUsage"),
    POTENTIAL_VIOLATED_CARPOOL_USAGE("PotentialViolatedCarpoolUsage"),
    POTENTIAL_VIOLATED_TURN_RESTRICTION_USAGE("PotentialViolatedTurnRestrictionUsage"),
    POTENTIAL_VIOLATED_VEHICLE_RESTRICTION_USAGE("PotentialViolatedVehicleRestrictionUsage"),
    POTENTIAL_VIOLATED_ZONE_RESTRICTION_USAGE("PotentialViolatedZoneRestrictionUsage"),
    SEASONAL_CLOSURE("SeasonalClosure"),
    TOLLS_DATA_TEMPORARILY_UNAVAILABLE("TollsDataTemporarilyUnavailable"),
    TOLLS_DATA_UNAVAILABLE("TollsDataUnavailable"),
    TOLL_TRANSPONDER("TollTransponder"),
    VIOLATED_AVOID_CONTROLLED_ACCESS_HIGHWAY("ViolatedAvoidControlledAccessHighway"),
    VIOLATED_AVOID_DIFFICULT_TURNS("ViolatedAvoidDifficultTurns"),
    VIOLATED_AVOID_DIRT_ROAD("ViolatedAvoidDirtRoad"),
    VIOLATED_AVOID_SEASONAL_CLOSURE("ViolatedAvoidSeasonalClosure"),
    VIOLATED_AVOID_TOLL_ROAD("ViolatedAvoidTollRoad"),
    VIOLATED_AVOID_TOLL_TRANSPONDER("ViolatedAvoidTollTransponder"),
    VIOLATED_AVOID_TRUCK_ROAD_TYPE("ViolatedAvoidTruckRoadType"),
    VIOLATED_AVOID_TUNNEL("ViolatedAvoidTunnel"),
    VIOLATED_AVOID_U_TURNS("ViolatedAvoidUTurns"),
    VIOLATED_BLOCKED_ROAD("ViolatedBlockedRoad"),
    VIOLATED_CARPOOL("ViolatedCarpool"),
    VIOLATED_EMERGENCY_GATE("ViolatedEmergencyGate"),
    VIOLATED_START_DIRECTION("ViolatedStartDirection"),
    VIOLATED_TURN_RESTRICTION("ViolatedTurnRestriction"),
    VIOLATED_VEHICLE_RESTRICTION("ViolatedVehicleRestriction"),
    VIOLATED_ZONE_RESTRICTION("ViolatedZoneRestriction"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteVehicleNoticeCode> VALUE_MAP;
    private final String value;

    private RouteVehicleNoticeCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteVehicleNoticeCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteVehicleNoticeCode> knownValues() {
        EnumSet<RouteVehicleNoticeCode> knownValues = EnumSet.allOf(RouteVehicleNoticeCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteVehicleNoticeCode.class, RouteVehicleNoticeCode::toString);
    }
}

