/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePublishingDestinationRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, DescribePublishingDestinationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(DescribePublishingDestinationRequest.getter(DescribePublishingDestinationRequest::detectorId)).setter(DescribePublishingDestinationRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationId").getter(DescribePublishingDestinationRequest.getter(DescribePublishingDestinationRequest::destinationId)).setter(DescribePublishingDestinationRequest.setter(Builder::destinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("destinationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DESTINATION_ID_FIELD));
    private final String detectorId;
    private final String destinationId;

    private DescribePublishingDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.destinationId = builder.destinationId;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String destinationId() {
        return this.destinationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePublishingDestinationRequest)) {
            return false;
        }
        DescribePublishingDestinationRequest other = (DescribePublishingDestinationRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.destinationId(), other.destinationId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePublishingDestinationRequest").add("DetectorId", (Object)this.detectorId()).add("DestinationId", (Object)this.destinationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "DestinationId": {
                return Optional.ofNullable(clazz.cast(this.destinationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePublishingDestinationRequest, T> g) {
        return obj -> g.apply((DescribePublishingDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String destinationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePublishingDestinationRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.destinationId(model.destinationId);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePublishingDestinationRequest build() {
            return new DescribePublishingDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePublishingDestinationRequest> {
        public Builder detectorId(String var1);

        public Builder destinationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

