/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot1clickprojects.model.PlacementAttributeMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlacementDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlacementDescription> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(PlacementDescription.getter(PlacementDescription::projectName)).setter(PlacementDescription.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> PLACEMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("placementName").getter(PlacementDescription.getter(PlacementDescription::placementName)).setter(PlacementDescription.setter(Builder::placementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementName").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(PlacementDescription.getter(PlacementDescription::attributes)).setter(PlacementDescription.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(PlacementDescription.getter(PlacementDescription::createdDate)).setter(PlacementDescription.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedDate").getter(PlacementDescription.getter(PlacementDescription::updatedDate)).setter(PlacementDescription.setter(Builder::updatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, PLACEMENT_NAME_FIELD, ATTRIBUTES_FIELD, CREATED_DATE_FIELD, UPDATED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PlacementDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String projectName;
    private final String placementName;
    private final Map<String, String> attributes;
    private final Instant createdDate;
    private final Instant updatedDate;

    private PlacementDescription(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.placementName = builder.placementName;
        this.attributes = builder.attributes;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String placementName() {
        return this.placementName;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant updatedDate() {
        return this.updatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementDescription)) {
            return false;
        }
        PlacementDescription other = (PlacementDescription)obj;
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.placementName(), other.placementName()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.updatedDate(), other.updatedDate());
    }

    public final String toString() {
        return ToString.builder((String)"PlacementDescription").add("ProjectName", (Object)this.projectName()).add("PlacementName", (Object)this.placementName()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("CreatedDate", (Object)this.createdDate()).add("UpdatedDate", (Object)this.updatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "placementName": {
                return Optional.ofNullable(clazz.cast(this.placementName()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "updatedDate": {
                return Optional.ofNullable(clazz.cast(this.updatedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("placementName", PLACEMENT_NAME_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("updatedDate", UPDATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PlacementDescription, T> g) {
        return obj -> g.apply((PlacementDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectName;
        private String placementName;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdDate;
        private Instant updatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementDescription model) {
            this.projectName(model.projectName);
            this.placementName(model.placementName);
            this.attributes(model.attributes);
            this.createdDate(model.createdDate);
            this.updatedDate(model.updatedDate);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getPlacementName() {
            return this.placementName;
        }

        public final void setPlacementName(String placementName) {
            this.placementName = placementName;
        }

        @Override
        public final Builder placementName(String placementName) {
            this.placementName = placementName;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = PlacementAttributeMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = PlacementAttributeMapCopier.copy(attributes);
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getUpdatedDate() {
            return this.updatedDate;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public PlacementDescription build() {
            return new PlacementDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlacementDescription> {
        public Builder projectName(String var1);

        public Builder placementName(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder createdDate(Instant var1);

        public Builder updatedDate(Instant var1);
    }
}

