/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.AlarmCapabilities;
import software.amazon.awssdk.services.iotevents.model.AlarmEventActions;
import software.amazon.awssdk.services.iotevents.model.AlarmNotification;
import software.amazon.awssdk.services.iotevents.model.AlarmRule;
import software.amazon.awssdk.services.iotevents.model.IotEventsRequest;
import software.amazon.awssdk.services.iotevents.model.Tag;
import software.amazon.awssdk.services.iotevents.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAlarmModelRequest
extends IotEventsRequest
implements ToCopyableBuilder<Builder, CreateAlarmModelRequest> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelName").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::alarmModelName)).setter(CreateAlarmModelRequest.setter(Builder::alarmModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()}).build();
    private static final SdkField<String> ALARM_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelDescription").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::alarmModelDescription)).setter(CreateAlarmModelRequest.setter(Builder::alarmModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelDescription").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::roleArn)).setter(CreateAlarmModelRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::tags)).setter(CreateAlarmModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::key)).setter(CreateAlarmModelRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<Integer> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("severity").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::severity)).setter(CreateAlarmModelRequest.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<AlarmRule> ALARM_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmRule").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::alarmRule)).setter(CreateAlarmModelRequest.setter(Builder::alarmRule)).constructor(AlarmRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmRule").build()}).build();
    private static final SdkField<AlarmNotification> ALARM_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmNotification").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::alarmNotification)).setter(CreateAlarmModelRequest.setter(Builder::alarmNotification)).constructor(AlarmNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmNotification").build()}).build();
    private static final SdkField<AlarmEventActions> ALARM_EVENT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmEventActions").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::alarmEventActions)).setter(CreateAlarmModelRequest.setter(Builder::alarmEventActions)).constructor(AlarmEventActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmEventActions").build()}).build();
    private static final SdkField<AlarmCapabilities> ALARM_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmCapabilities").getter(CreateAlarmModelRequest.getter(CreateAlarmModelRequest::alarmCapabilities)).setter(CreateAlarmModelRequest.setter(Builder::alarmCapabilities)).constructor(AlarmCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmCapabilities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD, ALARM_MODEL_DESCRIPTION_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, KEY_FIELD, SEVERITY_FIELD, ALARM_RULE_FIELD, ALARM_NOTIFICATION_FIELD, ALARM_EVENT_ACTIONS_FIELD, ALARM_CAPABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAlarmModelRequest.memberNameToFieldInitializer();
    private final String alarmModelName;
    private final String alarmModelDescription;
    private final String roleArn;
    private final List<Tag> tags;
    private final String key;
    private final Integer severity;
    private final AlarmRule alarmRule;
    private final AlarmNotification alarmNotification;
    private final AlarmEventActions alarmEventActions;
    private final AlarmCapabilities alarmCapabilities;

    private CreateAlarmModelRequest(BuilderImpl builder) {
        super(builder);
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelDescription = builder.alarmModelDescription;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.key = builder.key;
        this.severity = builder.severity;
        this.alarmRule = builder.alarmRule;
        this.alarmNotification = builder.alarmNotification;
        this.alarmEventActions = builder.alarmEventActions;
        this.alarmCapabilities = builder.alarmCapabilities;
    }

    public final String alarmModelName() {
        return this.alarmModelName;
    }

    public final String alarmModelDescription() {
        return this.alarmModelDescription;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String key() {
        return this.key;
    }

    public final Integer severity() {
        return this.severity;
    }

    public final AlarmRule alarmRule() {
        return this.alarmRule;
    }

    public final AlarmNotification alarmNotification() {
        return this.alarmNotification;
    }

    public final AlarmEventActions alarmEventActions() {
        return this.alarmEventActions;
    }

    public final AlarmCapabilities alarmCapabilities() {
        return this.alarmCapabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmEventActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmCapabilities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAlarmModelRequest)) {
            return false;
        }
        CreateAlarmModelRequest other = (CreateAlarmModelRequest)((Object)obj);
        return Objects.equals(this.alarmModelName(), other.alarmModelName()) && Objects.equals(this.alarmModelDescription(), other.alarmModelDescription()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.alarmRule(), other.alarmRule()) && Objects.equals(this.alarmNotification(), other.alarmNotification()) && Objects.equals(this.alarmEventActions(), other.alarmEventActions()) && Objects.equals(this.alarmCapabilities(), other.alarmCapabilities());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAlarmModelRequest").add("AlarmModelName", (Object)this.alarmModelName()).add("AlarmModelDescription", (Object)this.alarmModelDescription()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Key", (Object)this.key()).add("Severity", (Object)this.severity()).add("AlarmRule", (Object)this.alarmRule()).add("AlarmNotification", (Object)this.alarmNotification()).add("AlarmEventActions", (Object)this.alarmEventActions()).add("AlarmCapabilities", (Object)this.alarmCapabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmModelName": {
                return Optional.ofNullable(clazz.cast(this.alarmModelName()));
            }
            case "alarmModelDescription": {
                return Optional.ofNullable(clazz.cast(this.alarmModelDescription()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "alarmRule": {
                return Optional.ofNullable(clazz.cast(this.alarmRule()));
            }
            case "alarmNotification": {
                return Optional.ofNullable(clazz.cast(this.alarmNotification()));
            }
            case "alarmEventActions": {
                return Optional.ofNullable(clazz.cast(this.alarmEventActions()));
            }
            case "alarmCapabilities": {
                return Optional.ofNullable(clazz.cast(this.alarmCapabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alarmModelName", ALARM_MODEL_NAME_FIELD);
        map.put("alarmModelDescription", ALARM_MODEL_DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("key", KEY_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("alarmRule", ALARM_RULE_FIELD);
        map.put("alarmNotification", ALARM_NOTIFICATION_FIELD);
        map.put("alarmEventActions", ALARM_EVENT_ACTIONS_FIELD);
        map.put("alarmCapabilities", ALARM_CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAlarmModelRequest, T> g) {
        return obj -> g.apply((CreateAlarmModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsRequest.BuilderImpl
    implements Builder {
        private String alarmModelName;
        private String alarmModelDescription;
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String key;
        private Integer severity;
        private AlarmRule alarmRule;
        private AlarmNotification alarmNotification;
        private AlarmEventActions alarmEventActions;
        private AlarmCapabilities alarmCapabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAlarmModelRequest model) {
            super(model);
            this.alarmModelName(model.alarmModelName);
            this.alarmModelDescription(model.alarmModelDescription);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.key(model.key);
            this.severity(model.severity);
            this.alarmRule(model.alarmRule);
            this.alarmNotification(model.alarmNotification);
            this.alarmEventActions(model.alarmEventActions);
            this.alarmCapabilities(model.alarmCapabilities);
        }

        public final String getAlarmModelName() {
            return this.alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelDescription() {
            return this.alarmModelDescription;
        }

        public final void setAlarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
        }

        @Override
        public final Builder alarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Integer getSeverity() {
            return this.severity;
        }

        public final void setSeverity(Integer severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Integer severity) {
            this.severity = severity;
            return this;
        }

        public final AlarmRule.Builder getAlarmRule() {
            return this.alarmRule != null ? this.alarmRule.toBuilder() : null;
        }

        public final void setAlarmRule(AlarmRule.BuilderImpl alarmRule) {
            this.alarmRule = alarmRule != null ? alarmRule.build() : null;
        }

        @Override
        public final Builder alarmRule(AlarmRule alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        public final AlarmNotification.Builder getAlarmNotification() {
            return this.alarmNotification != null ? this.alarmNotification.toBuilder() : null;
        }

        public final void setAlarmNotification(AlarmNotification.BuilderImpl alarmNotification) {
            this.alarmNotification = alarmNotification != null ? alarmNotification.build() : null;
        }

        @Override
        public final Builder alarmNotification(AlarmNotification alarmNotification) {
            this.alarmNotification = alarmNotification;
            return this;
        }

        public final AlarmEventActions.Builder getAlarmEventActions() {
            return this.alarmEventActions != null ? this.alarmEventActions.toBuilder() : null;
        }

        public final void setAlarmEventActions(AlarmEventActions.BuilderImpl alarmEventActions) {
            this.alarmEventActions = alarmEventActions != null ? alarmEventActions.build() : null;
        }

        @Override
        public final Builder alarmEventActions(AlarmEventActions alarmEventActions) {
            this.alarmEventActions = alarmEventActions;
            return this;
        }

        public final AlarmCapabilities.Builder getAlarmCapabilities() {
            return this.alarmCapabilities != null ? this.alarmCapabilities.toBuilder() : null;
        }

        public final void setAlarmCapabilities(AlarmCapabilities.BuilderImpl alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities != null ? alarmCapabilities.build() : null;
        }

        @Override
        public final Builder alarmCapabilities(AlarmCapabilities alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAlarmModelRequest build() {
            return new CreateAlarmModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAlarmModelRequest> {
        public Builder alarmModelName(String var1);

        public Builder alarmModelDescription(String var1);

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder key(String var1);

        public Builder severity(Integer var1);

        public Builder alarmRule(AlarmRule var1);

        default public Builder alarmRule(Consumer<AlarmRule.Builder> alarmRule) {
            return this.alarmRule((AlarmRule)((AlarmRule.Builder)AlarmRule.builder().applyMutation(alarmRule)).build());
        }

        public Builder alarmNotification(AlarmNotification var1);

        default public Builder alarmNotification(Consumer<AlarmNotification.Builder> alarmNotification) {
            return this.alarmNotification((AlarmNotification)((AlarmNotification.Builder)AlarmNotification.builder().applyMutation(alarmNotification)).build());
        }

        public Builder alarmEventActions(AlarmEventActions var1);

        default public Builder alarmEventActions(Consumer<AlarmEventActions.Builder> alarmEventActions) {
            return this.alarmEventActions((AlarmEventActions)((AlarmEventActions.Builder)AlarmEventActions.builder().applyMutation(alarmEventActions)).build());
        }

        public Builder alarmCapabilities(AlarmCapabilities var1);

        default public Builder alarmCapabilities(Consumer<AlarmCapabilities.Builder> alarmCapabilities) {
            return this.alarmCapabilities((AlarmCapabilities)((AlarmCapabilities.Builder)AlarmCapabilities.builder().applyMutation(alarmCapabilities)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

