/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VehicleStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VehicleStatus> {
    private static final SdkField<String> CAMPAIGN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("campaignName").getter(VehicleStatus.getter(VehicleStatus::campaignName)).setter(VehicleStatus.setter(Builder::campaignName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignName").build()}).build();
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vehicleName").getter(VehicleStatus.getter(VehicleStatus::vehicleName)).setter(VehicleStatus.setter(Builder::vehicleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(VehicleStatus.getter(VehicleStatus::statusAsString)).setter(VehicleStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_NAME_FIELD, VEHICLE_NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String campaignName;
    private final String vehicleName;
    private final String status;

    private VehicleStatus(BuilderImpl builder) {
        this.campaignName = builder.campaignName;
        this.vehicleName = builder.vehicleName;
        this.status = builder.status;
    }

    public final String campaignName() {
        return this.campaignName;
    }

    public final String vehicleName() {
        return this.vehicleName;
    }

    public final VehicleState status() {
        return VehicleState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VehicleStatus)) {
            return false;
        }
        VehicleStatus other = (VehicleStatus)obj;
        return Objects.equals(this.campaignName(), other.campaignName()) && Objects.equals(this.vehicleName(), other.vehicleName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VehicleStatus").add("CampaignName", (Object)this.campaignName()).add("VehicleName", (Object)this.vehicleName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaignName": {
                return Optional.ofNullable(clazz.cast(this.campaignName()));
            }
            case "vehicleName": {
                return Optional.ofNullable(clazz.cast(this.vehicleName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VehicleStatus, T> g) {
        return obj -> g.apply((VehicleStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String campaignName;
        private String vehicleName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VehicleStatus model) {
            this.campaignName(model.campaignName);
            this.vehicleName(model.vehicleName);
            this.status(model.status);
        }

        public final String getCampaignName() {
            return this.campaignName;
        }

        public final void setCampaignName(String campaignName) {
            this.campaignName = campaignName;
        }

        @Override
        public final Builder campaignName(String campaignName) {
            this.campaignName = campaignName;
            return this;
        }

        public final String getVehicleName() {
            return this.vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VehicleState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public VehicleStatus build() {
            return new VehicleStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VehicleStatus> {
        public Builder campaignName(String var1);

        public Builder vehicleName(String var1);

        public Builder status(String var1);

        public Builder status(VehicleState var1);
    }
}

