/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.Stage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStageResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, CreateStageResponse> {
    private static final SdkField<Stage> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stage").getter(CreateStageResponse.getter(CreateStageResponse::stage)).setter(CreateStageResponse.setter(Builder::stage)).constructor(Stage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final SdkField<List<ParticipantToken>> PARTICIPANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("participantTokens").getter(CreateStageResponse.getter(CreateStageResponse::participantTokens)).setter(CreateStageResponse.setter(Builder::participantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParticipantToken::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD, PARTICIPANT_TOKENS_FIELD));
    private final Stage stage;
    private final List<ParticipantToken> participantTokens;

    private CreateStageResponse(BuilderImpl builder) {
        super(builder);
        this.stage = builder.stage;
        this.participantTokens = builder.participantTokens;
    }

    public final Stage stage() {
        return this.stage;
    }

    public final boolean hasParticipantTokens() {
        return this.participantTokens != null && !(this.participantTokens instanceof SdkAutoConstructList);
    }

    public final List<ParticipantToken> participantTokens() {
        return this.participantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParticipantTokens() ? this.participantTokens() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStageResponse)) {
            return false;
        }
        CreateStageResponse other = (CreateStageResponse)((Object)obj);
        return Objects.equals(this.stage(), other.stage()) && this.hasParticipantTokens() == other.hasParticipantTokens() && Objects.equals(this.participantTokens(), other.participantTokens());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStageResponse").add("Stage", (Object)this.stage()).add("ParticipantTokens", this.hasParticipantTokens() ? this.participantTokens() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
            case "participantTokens": {
                return Optional.ofNullable(clazz.cast(this.participantTokens()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStageResponse, T> g) {
        return obj -> g.apply((CreateStageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private Stage stage;
        private List<ParticipantToken> participantTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStageResponse model) {
            super(model);
            this.stage(model.stage);
            this.participantTokens(model.participantTokens);
        }

        public final Stage.Builder getStage() {
            return this.stage != null ? this.stage.toBuilder() : null;
        }

        public final void setStage(Stage.BuilderImpl stage) {
            this.stage = stage != null ? stage.build() : null;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        public final List<ParticipantToken.Builder> getParticipantTokens() {
            List<ParticipantToken.Builder> result = ParticipantTokenListCopier.copyToBuilder(this.participantTokens);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParticipantTokens(Collection<ParticipantToken.BuilderImpl> participantTokens) {
            this.participantTokens = ParticipantTokenListCopier.copyFromBuilder(participantTokens);
        }

        @Override
        public final Builder participantTokens(Collection<ParticipantToken> participantTokens) {
            this.participantTokens = ParticipantTokenListCopier.copy(participantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantTokens(ParticipantToken ... participantTokens) {
            this.participantTokens(Arrays.asList(participantTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantTokens(Consumer<ParticipantToken.Builder> ... participantTokens) {
            this.participantTokens(Stream.of(participantTokens).map(c -> (ParticipantToken)((ParticipantToken.Builder)ParticipantToken.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateStageResponse build() {
            return new CreateStageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStageResponse> {
        public Builder stage(Stage var1);

        default public Builder stage(Consumer<Stage.Builder> stage) {
            return this.stage((Stage)((Stage.Builder)Stage.builder().applyMutation(stage)).build());
        }

        public Builder participantTokens(Collection<ParticipantToken> var1);

        public Builder participantTokens(ParticipantToken ... var1);

        public Builder participantTokens(Consumer<ParticipantToken.Builder> ... var1);
    }
}

