/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendraranking.model.Document;
import software.amazon.awssdk.services.kendraranking.model.DocumentListCopier;
import software.amazon.awssdk.services.kendraranking.model.KendraRankingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RescoreRequest
extends KendraRankingRequest
implements ToCopyableBuilder<Builder, RescoreRequest> {
    private static final SdkField<String> RESCORE_EXECUTION_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RescoreExecutionPlanId").getter(RescoreRequest.getter(RescoreRequest::rescoreExecutionPlanId)).setter(RescoreRequest.setter(Builder::rescoreExecutionPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RescoreExecutionPlanId").build()}).build();
    private static final SdkField<String> SEARCH_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchQuery").getter(RescoreRequest.getter(RescoreRequest::searchQuery)).setter(RescoreRequest.setter(Builder::searchQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchQuery").build()}).build();
    private static final SdkField<List<Document>> DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Documents").getter(RescoreRequest.getter(RescoreRequest::documents)).setter(RescoreRequest.setter(Builder::documents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESCORE_EXECUTION_PLAN_ID_FIELD, SEARCH_QUERY_FIELD, DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RescoreRequest.memberNameToFieldInitializer();
    private final String rescoreExecutionPlanId;
    private final String searchQuery;
    private final List<Document> documents;

    private RescoreRequest(BuilderImpl builder) {
        super(builder);
        this.rescoreExecutionPlanId = builder.rescoreExecutionPlanId;
        this.searchQuery = builder.searchQuery;
        this.documents = builder.documents;
    }

    public final String rescoreExecutionPlanId() {
        return this.rescoreExecutionPlanId;
    }

    public final String searchQuery() {
        return this.searchQuery;
    }

    public final boolean hasDocuments() {
        return this.documents != null && !(this.documents instanceof SdkAutoConstructList);
    }

    public final List<Document> documents() {
        return this.documents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rescoreExecutionPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocuments() ? this.documents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RescoreRequest)) {
            return false;
        }
        RescoreRequest other = (RescoreRequest)((Object)obj);
        return Objects.equals(this.rescoreExecutionPlanId(), other.rescoreExecutionPlanId()) && Objects.equals(this.searchQuery(), other.searchQuery()) && this.hasDocuments() == other.hasDocuments() && Objects.equals(this.documents(), other.documents());
    }

    public final String toString() {
        return ToString.builder((String)"RescoreRequest").add("RescoreExecutionPlanId", (Object)this.rescoreExecutionPlanId()).add("SearchQuery", (Object)this.searchQuery()).add("Documents", this.hasDocuments() ? this.documents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RescoreExecutionPlanId": {
                return Optional.ofNullable(clazz.cast(this.rescoreExecutionPlanId()));
            }
            case "SearchQuery": {
                return Optional.ofNullable(clazz.cast(this.searchQuery()));
            }
            case "Documents": {
                return Optional.ofNullable(clazz.cast(this.documents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RescoreExecutionPlanId", RESCORE_EXECUTION_PLAN_ID_FIELD);
        map.put("SearchQuery", SEARCH_QUERY_FIELD);
        map.put("Documents", DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RescoreRequest, T> g) {
        return obj -> g.apply((RescoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRankingRequest.BuilderImpl
    implements Builder {
        private String rescoreExecutionPlanId;
        private String searchQuery;
        private List<Document> documents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RescoreRequest model) {
            super(model);
            this.rescoreExecutionPlanId(model.rescoreExecutionPlanId);
            this.searchQuery(model.searchQuery);
            this.documents(model.documents);
        }

        public final String getRescoreExecutionPlanId() {
            return this.rescoreExecutionPlanId;
        }

        public final void setRescoreExecutionPlanId(String rescoreExecutionPlanId) {
            this.rescoreExecutionPlanId = rescoreExecutionPlanId;
        }

        @Override
        public final Builder rescoreExecutionPlanId(String rescoreExecutionPlanId) {
            this.rescoreExecutionPlanId = rescoreExecutionPlanId;
            return this;
        }

        public final String getSearchQuery() {
            return this.searchQuery;
        }

        public final void setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
        }

        @Override
        public final Builder searchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public final List<Document.Builder> getDocuments() {
            List<Document.Builder> result = DocumentListCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<Document.BuilderImpl> documents) {
            this.documents = DocumentListCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<Document> documents) {
            this.documents = DocumentListCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Document ... documents) {
            this.documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<Document.Builder> ... documents) {
            this.documents(Stream.of(documents).map(c -> (Document)((Document.Builder)Document.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RescoreRequest build() {
            return new RescoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRankingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RescoreRequest> {
        public Builder rescoreExecutionPlanId(String var1);

        public Builder searchQuery(String var1);

        public Builder documents(Collection<Document> var1);

        public Builder documents(Document ... var1);

        public Builder documents(Consumer<Document.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

