/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitRange;

public class GetWorkUnitsPublisher
implements SdkPublisher<GetWorkUnitsResponse> {
    private final LakeFormationAsyncClient client;
    private final GetWorkUnitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetWorkUnitsPublisher(LakeFormationAsyncClient client, GetWorkUnitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetWorkUnitsPublisher(LakeFormationAsyncClient client, GetWorkUnitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetWorkUnitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetWorkUnitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkUnitRange> workUnitRanges() {
        Function<GetWorkUnitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workUnitRanges() != null) {
                return response.workUnitRanges().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetWorkUnitsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetWorkUnitsResponseFetcher
    implements AsyncPageFetcher<GetWorkUnitsResponse> {
        private GetWorkUnitsResponseFetcher() {
        }

        public boolean hasNextPage(GetWorkUnitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetWorkUnitsResponse> nextPage(GetWorkUnitsResponse previousPage) {
            if (previousPage == null) {
                return GetWorkUnitsPublisher.this.client.getWorkUnits(GetWorkUnitsPublisher.this.firstRequest);
            }
            return GetWorkUnitsPublisher.this.client.getWorkUnits((GetWorkUnitsRequest)((Object)GetWorkUnitsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

