/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Destination {
    CLOUDWATCH_LOGS("CLOUDWATCH_LOGS"),
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Destination> VALUE_MAP;
    private final String value;

    private Destination(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Destination fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Destination> knownValues() {
        EnumSet<Destination> knownValues = EnumSet.allOf(Destination.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Destination.class, Destination::toString);
    }
}

