/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMigrationResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, StartMigrationResponse> {
    private static final SdkField<String> V1_BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v1BotName").getter(StartMigrationResponse.getter(StartMigrationResponse::v1BotName)).setter(StartMigrationResponse.setter(Builder::v1BotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotName").build()}).build();
    private static final SdkField<String> V1_BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v1BotVersion").getter(StartMigrationResponse.getter(StartMigrationResponse::v1BotVersion)).setter(StartMigrationResponse.setter(Builder::v1BotVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotVersion").build()}).build();
    private static final SdkField<String> V1_BOT_LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v1BotLocale").getter(StartMigrationResponse.getter(StartMigrationResponse::v1BotLocaleAsString)).setter(StartMigrationResponse.setter(Builder::v1BotLocale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotLocale").build()}).build();
    private static final SdkField<String> V2_BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v2BotId").getter(StartMigrationResponse.getter(StartMigrationResponse::v2BotId)).setter(StartMigrationResponse.setter(Builder::v2BotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotId").build()}).build();
    private static final SdkField<String> V2_BOT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v2BotRole").getter(StartMigrationResponse.getter(StartMigrationResponse::v2BotRole)).setter(StartMigrationResponse.setter(Builder::v2BotRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotRole").build()}).build();
    private static final SdkField<String> MIGRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("migrationId").getter(StartMigrationResponse.getter(StartMigrationResponse::migrationId)).setter(StartMigrationResponse.setter(Builder::migrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationId").build()}).build();
    private static final SdkField<String> MIGRATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("migrationStrategy").getter(StartMigrationResponse.getter(StartMigrationResponse::migrationStrategyAsString)).setter(StartMigrationResponse.setter(Builder::migrationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationStrategy").build()}).build();
    private static final SdkField<Instant> MIGRATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("migrationTimestamp").getter(StartMigrationResponse.getter(StartMigrationResponse::migrationTimestamp)).setter(StartMigrationResponse.setter(Builder::migrationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V1_BOT_NAME_FIELD, V1_BOT_VERSION_FIELD, V1_BOT_LOCALE_FIELD, V2_BOT_ID_FIELD, V2_BOT_ROLE_FIELD, MIGRATION_ID_FIELD, MIGRATION_STRATEGY_FIELD, MIGRATION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMigrationResponse.memberNameToFieldInitializer();
    private final String v1BotName;
    private final String v1BotVersion;
    private final String v1BotLocale;
    private final String v2BotId;
    private final String v2BotRole;
    private final String migrationId;
    private final String migrationStrategy;
    private final Instant migrationTimestamp;

    private StartMigrationResponse(BuilderImpl builder) {
        super(builder);
        this.v1BotName = builder.v1BotName;
        this.v1BotVersion = builder.v1BotVersion;
        this.v1BotLocale = builder.v1BotLocale;
        this.v2BotId = builder.v2BotId;
        this.v2BotRole = builder.v2BotRole;
        this.migrationId = builder.migrationId;
        this.migrationStrategy = builder.migrationStrategy;
        this.migrationTimestamp = builder.migrationTimestamp;
    }

    public final String v1BotName() {
        return this.v1BotName;
    }

    public final String v1BotVersion() {
        return this.v1BotVersion;
    }

    public final Locale v1BotLocale() {
        return Locale.fromValue(this.v1BotLocale);
    }

    public final String v1BotLocaleAsString() {
        return this.v1BotLocale;
    }

    public final String v2BotId() {
        return this.v2BotId;
    }

    public final String v2BotRole() {
        return this.v2BotRole;
    }

    public final String migrationId() {
        return this.migrationId;
    }

    public final MigrationStrategy migrationStrategy() {
        return MigrationStrategy.fromValue(this.migrationStrategy);
    }

    public final String migrationStrategyAsString() {
        return this.migrationStrategy;
    }

    public final Instant migrationTimestamp() {
        return this.migrationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.v1BotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.v1BotVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.v1BotLocaleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.v2BotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.v2BotRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMigrationResponse)) {
            return false;
        }
        StartMigrationResponse other = (StartMigrationResponse)((Object)obj);
        return Objects.equals(this.v1BotName(), other.v1BotName()) && Objects.equals(this.v1BotVersion(), other.v1BotVersion()) && Objects.equals(this.v1BotLocaleAsString(), other.v1BotLocaleAsString()) && Objects.equals(this.v2BotId(), other.v2BotId()) && Objects.equals(this.v2BotRole(), other.v2BotRole()) && Objects.equals(this.migrationId(), other.migrationId()) && Objects.equals(this.migrationStrategyAsString(), other.migrationStrategyAsString()) && Objects.equals(this.migrationTimestamp(), other.migrationTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"StartMigrationResponse").add("V1BotName", (Object)this.v1BotName()).add("V1BotVersion", (Object)this.v1BotVersion()).add("V1BotLocale", (Object)this.v1BotLocaleAsString()).add("V2BotId", (Object)this.v2BotId()).add("V2BotRole", (Object)this.v2BotRole()).add("MigrationId", (Object)this.migrationId()).add("MigrationStrategy", (Object)this.migrationStrategyAsString()).add("MigrationTimestamp", (Object)this.migrationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "v1BotName": {
                return Optional.ofNullable(clazz.cast(this.v1BotName()));
            }
            case "v1BotVersion": {
                return Optional.ofNullable(clazz.cast(this.v1BotVersion()));
            }
            case "v1BotLocale": {
                return Optional.ofNullable(clazz.cast(this.v1BotLocaleAsString()));
            }
            case "v2BotId": {
                return Optional.ofNullable(clazz.cast(this.v2BotId()));
            }
            case "v2BotRole": {
                return Optional.ofNullable(clazz.cast(this.v2BotRole()));
            }
            case "migrationId": {
                return Optional.ofNullable(clazz.cast(this.migrationId()));
            }
            case "migrationStrategy": {
                return Optional.ofNullable(clazz.cast(this.migrationStrategyAsString()));
            }
            case "migrationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.migrationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("v1BotName", V1_BOT_NAME_FIELD);
        map.put("v1BotVersion", V1_BOT_VERSION_FIELD);
        map.put("v1BotLocale", V1_BOT_LOCALE_FIELD);
        map.put("v2BotId", V2_BOT_ID_FIELD);
        map.put("v2BotRole", V2_BOT_ROLE_FIELD);
        map.put("migrationId", MIGRATION_ID_FIELD);
        map.put("migrationStrategy", MIGRATION_STRATEGY_FIELD);
        map.put("migrationTimestamp", MIGRATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMigrationResponse, T> g) {
        return obj -> g.apply((StartMigrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String v1BotName;
        private String v1BotVersion;
        private String v1BotLocale;
        private String v2BotId;
        private String v2BotRole;
        private String migrationId;
        private String migrationStrategy;
        private Instant migrationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMigrationResponse model) {
            super(model);
            this.v1BotName(model.v1BotName);
            this.v1BotVersion(model.v1BotVersion);
            this.v1BotLocale(model.v1BotLocale);
            this.v2BotId(model.v2BotId);
            this.v2BotRole(model.v2BotRole);
            this.migrationId(model.migrationId);
            this.migrationStrategy(model.migrationStrategy);
            this.migrationTimestamp(model.migrationTimestamp);
        }

        public final String getV1BotName() {
            return this.v1BotName;
        }

        public final void setV1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
        }

        @Override
        public final Builder v1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
            return this;
        }

        public final String getV1BotVersion() {
            return this.v1BotVersion;
        }

        public final void setV1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
        }

        @Override
        public final Builder v1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
            return this;
        }

        public final String getV1BotLocale() {
            return this.v1BotLocale;
        }

        public final void setV1BotLocale(String v1BotLocale) {
            this.v1BotLocale = v1BotLocale;
        }

        @Override
        public final Builder v1BotLocale(String v1BotLocale) {
            this.v1BotLocale = v1BotLocale;
            return this;
        }

        @Override
        public final Builder v1BotLocale(Locale v1BotLocale) {
            this.v1BotLocale(v1BotLocale == null ? null : v1BotLocale.toString());
            return this;
        }

        public final String getV2BotId() {
            return this.v2BotId;
        }

        public final void setV2BotId(String v2BotId) {
            this.v2BotId = v2BotId;
        }

        @Override
        public final Builder v2BotId(String v2BotId) {
            this.v2BotId = v2BotId;
            return this;
        }

        public final String getV2BotRole() {
            return this.v2BotRole;
        }

        public final void setV2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
        }

        @Override
        public final Builder v2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
            return this;
        }

        public final String getMigrationId() {
            return this.migrationId;
        }

        public final void setMigrationId(String migrationId) {
            this.migrationId = migrationId;
        }

        @Override
        public final Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public final String getMigrationStrategy() {
            return this.migrationStrategy;
        }

        public final void setMigrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
        }

        @Override
        public final Builder migrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
            return this;
        }

        @Override
        public final Builder migrationStrategy(MigrationStrategy migrationStrategy) {
            this.migrationStrategy(migrationStrategy == null ? null : migrationStrategy.toString());
            return this;
        }

        public final Instant getMigrationTimestamp() {
            return this.migrationTimestamp;
        }

        public final void setMigrationTimestamp(Instant migrationTimestamp) {
            this.migrationTimestamp = migrationTimestamp;
        }

        @Override
        public final Builder migrationTimestamp(Instant migrationTimestamp) {
            this.migrationTimestamp = migrationTimestamp;
            return this;
        }

        @Override
        public StartMigrationResponse build() {
            return new StartMigrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMigrationResponse> {
        public Builder v1BotName(String var1);

        public Builder v1BotVersion(String var1);

        public Builder v1BotLocale(String var1);

        public Builder v1BotLocale(Locale var1);

        public Builder v2BotId(String var1);

        public Builder v2BotRole(String var1);

        public Builder migrationId(String var1);

        public Builder migrationStrategy(String var1);

        public Builder migrationStrategy(MigrationStrategy var1);

        public Builder migrationTimestamp(Instant var1);
    }
}

