/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTestSetDiscrepancyReportResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeTestSetDiscrepancyReportResponse.Builder, DescribeTestSetDiscrepancyReportResponse> {
    private static final SdkField<String> TEST_SET_DISCREPANCY_REPORT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("testSetDiscrepancyReportId")
            .getter(getter(DescribeTestSetDiscrepancyReportResponse::testSetDiscrepancyReportId))
            .setter(setter(Builder::testSetDiscrepancyReportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetDiscrepancyReportId").build())
            .build();

    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetId").getter(getter(DescribeTestSetDiscrepancyReportResponse::testSetId))
            .setter(setter(Builder::testSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeTestSetDiscrepancyReportResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<TestSetDiscrepancyReportResourceTarget> TARGET_FIELD = SdkField
            .<TestSetDiscrepancyReportResourceTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(DescribeTestSetDiscrepancyReportResponse::target)).setter(setter(Builder::target))
            .constructor(TestSetDiscrepancyReportResourceTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> TEST_SET_DISCREPANCY_REPORT_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("testSetDiscrepancyReportStatus")
            .getter(getter(DescribeTestSetDiscrepancyReportResponse::testSetDiscrepancyReportStatusAsString))
            .setter(setter(Builder::testSetDiscrepancyReportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetDiscrepancyReportStatus")
                    .build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATA_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDataTime").getter(getter(DescribeTestSetDiscrepancyReportResponse::lastUpdatedDataTime))
            .setter(setter(Builder::lastUpdatedDataTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDataTime").build())
            .build();

    private static final SdkField<TestSetDiscrepancyErrors> TEST_SET_DISCREPANCY_TOP_ERRORS_FIELD = SdkField
            .<TestSetDiscrepancyErrors> builder(MarshallingType.SDK_POJO)
            .memberName("testSetDiscrepancyTopErrors")
            .getter(getter(DescribeTestSetDiscrepancyReportResponse::testSetDiscrepancyTopErrors))
            .setter(setter(Builder::testSetDiscrepancyTopErrors))
            .constructor(TestSetDiscrepancyErrors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetDiscrepancyTopErrors")
                    .build()).build();

    private static final SdkField<String> TEST_SET_DISCREPANCY_RAW_OUTPUT_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("testSetDiscrepancyRawOutputUrl")
            .getter(getter(DescribeTestSetDiscrepancyReportResponse::testSetDiscrepancyRawOutputUrl))
            .setter(setter(Builder::testSetDiscrepancyRawOutputUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetDiscrepancyRawOutputUrl")
                    .build()).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeTestSetDiscrepancyReportResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TEST_SET_DISCREPANCY_REPORT_ID_FIELD, TEST_SET_ID_FIELD, CREATION_DATE_TIME_FIELD, TARGET_FIELD,
            TEST_SET_DISCREPANCY_REPORT_STATUS_FIELD, LAST_UPDATED_DATA_TIME_FIELD, TEST_SET_DISCREPANCY_TOP_ERRORS_FIELD,
            TEST_SET_DISCREPANCY_RAW_OUTPUT_URL_FIELD, FAILURE_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testSetDiscrepancyReportId;

    private final String testSetId;

    private final Instant creationDateTime;

    private final TestSetDiscrepancyReportResourceTarget target;

    private final String testSetDiscrepancyReportStatus;

    private final Instant lastUpdatedDataTime;

    private final TestSetDiscrepancyErrors testSetDiscrepancyTopErrors;

    private final String testSetDiscrepancyRawOutputUrl;

    private final List<String> failureReasons;

    private DescribeTestSetDiscrepancyReportResponse(BuilderImpl builder) {
        super(builder);
        this.testSetDiscrepancyReportId = builder.testSetDiscrepancyReportId;
        this.testSetId = builder.testSetId;
        this.creationDateTime = builder.creationDateTime;
        this.target = builder.target;
        this.testSetDiscrepancyReportStatus = builder.testSetDiscrepancyReportStatus;
        this.lastUpdatedDataTime = builder.lastUpdatedDataTime;
        this.testSetDiscrepancyTopErrors = builder.testSetDiscrepancyTopErrors;
        this.testSetDiscrepancyRawOutputUrl = builder.testSetDiscrepancyRawOutputUrl;
        this.failureReasons = builder.failureReasons;
    }

    /**
     * <p>
     * The unique identifier of the test set discrepancy report to describe.
     * </p>
     * 
     * @return The unique identifier of the test set discrepancy report to describe.
     */
    public final String testSetDiscrepancyReportId() {
        return testSetDiscrepancyReportId;
    }

    /**
     * <p>
     * The test set Id for the test set discrepancy report.
     * </p>
     * 
     * @return The test set Id for the test set discrepancy report.
     */
    public final String testSetId() {
        return testSetId;
    }

    /**
     * <p>
     * The time and date of creation for the test set discrepancy report.
     * </p>
     * 
     * @return The time and date of creation for the test set discrepancy report.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The target bot location for the test set discrepancy report.
     * </p>
     * 
     * @return The target bot location for the test set discrepancy report.
     */
    public final TestSetDiscrepancyReportResourceTarget target() {
        return target;
    }

    /**
     * <p>
     * The status for the test set discrepancy report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testSetDiscrepancyReportStatus} will return {@link TestSetDiscrepancyReportStatus#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #testSetDiscrepancyReportStatusAsString}.
     * </p>
     * 
     * @return The status for the test set discrepancy report.
     * @see TestSetDiscrepancyReportStatus
     */
    public final TestSetDiscrepancyReportStatus testSetDiscrepancyReportStatus() {
        return TestSetDiscrepancyReportStatus.fromValue(testSetDiscrepancyReportStatus);
    }

    /**
     * <p>
     * The status for the test set discrepancy report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testSetDiscrepancyReportStatus} will return {@link TestSetDiscrepancyReportStatus#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #testSetDiscrepancyReportStatusAsString}.
     * </p>
     * 
     * @return The status for the test set discrepancy report.
     * @see TestSetDiscrepancyReportStatus
     */
    public final String testSetDiscrepancyReportStatusAsString() {
        return testSetDiscrepancyReportStatus;
    }

    /**
     * <p>
     * The date and time of the last update for the test set discrepancy report.
     * </p>
     * 
     * @return The date and time of the last update for the test set discrepancy report.
     */
    public final Instant lastUpdatedDataTime() {
        return lastUpdatedDataTime;
    }

    /**
     * <p>
     * The top 200 error results from the test set discrepancy report.
     * </p>
     * 
     * @return The top 200 error results from the test set discrepancy report.
     */
    public final TestSetDiscrepancyErrors testSetDiscrepancyTopErrors() {
        return testSetDiscrepancyTopErrors;
    }

    /**
     * <p>
     * Pre-signed Amazon S3 URL to download the test set discrepancy report.
     * </p>
     * 
     * @return Pre-signed Amazon S3 URL to download the test set discrepancy report.
     */
    public final String testSetDiscrepancyRawOutputUrl() {
        return testSetDiscrepancyRawOutputUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The failure report for the test set discrepancy report generation action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return The failure report for the test set discrepancy report generation action.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSetDiscrepancyReportId());
        hashCode = 31 * hashCode + Objects.hashCode(testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(testSetDiscrepancyReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDataTime());
        hashCode = 31 * hashCode + Objects.hashCode(testSetDiscrepancyTopErrors());
        hashCode = 31 * hashCode + Objects.hashCode(testSetDiscrepancyRawOutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTestSetDiscrepancyReportResponse)) {
            return false;
        }
        DescribeTestSetDiscrepancyReportResponse other = (DescribeTestSetDiscrepancyReportResponse) obj;
        return Objects.equals(testSetDiscrepancyReportId(), other.testSetDiscrepancyReportId())
                && Objects.equals(testSetId(), other.testSetId()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(target(), other.target())
                && Objects.equals(testSetDiscrepancyReportStatusAsString(), other.testSetDiscrepancyReportStatusAsString())
                && Objects.equals(lastUpdatedDataTime(), other.lastUpdatedDataTime())
                && Objects.equals(testSetDiscrepancyTopErrors(), other.testSetDiscrepancyTopErrors())
                && Objects.equals(testSetDiscrepancyRawOutputUrl(), other.testSetDiscrepancyRawOutputUrl())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTestSetDiscrepancyReportResponse")
                .add("TestSetDiscrepancyReportId", testSetDiscrepancyReportId()).add("TestSetId", testSetId())
                .add("CreationDateTime", creationDateTime()).add("Target", target())
                .add("TestSetDiscrepancyReportStatus", testSetDiscrepancyReportStatusAsString())
                .add("LastUpdatedDataTime", lastUpdatedDataTime())
                .add("TestSetDiscrepancyTopErrors", testSetDiscrepancyTopErrors())
                .add("TestSetDiscrepancyRawOutputUrl", testSetDiscrepancyRawOutputUrl())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSetDiscrepancyReportId":
            return Optional.ofNullable(clazz.cast(testSetDiscrepancyReportId()));
        case "testSetId":
            return Optional.ofNullable(clazz.cast(testSetId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "testSetDiscrepancyReportStatus":
            return Optional.ofNullable(clazz.cast(testSetDiscrepancyReportStatusAsString()));
        case "lastUpdatedDataTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDataTime()));
        case "testSetDiscrepancyTopErrors":
            return Optional.ofNullable(clazz.cast(testSetDiscrepancyTopErrors()));
        case "testSetDiscrepancyRawOutputUrl":
            return Optional.ofNullable(clazz.cast(testSetDiscrepancyRawOutputUrl()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testSetDiscrepancyReportId", TEST_SET_DISCREPANCY_REPORT_ID_FIELD);
        map.put("testSetId", TEST_SET_ID_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("testSetDiscrepancyReportStatus", TEST_SET_DISCREPANCY_REPORT_STATUS_FIELD);
        map.put("lastUpdatedDataTime", LAST_UPDATED_DATA_TIME_FIELD);
        map.put("testSetDiscrepancyTopErrors", TEST_SET_DISCREPANCY_TOP_ERRORS_FIELD);
        map.put("testSetDiscrepancyRawOutputUrl", TEST_SET_DISCREPANCY_RAW_OUTPUT_URL_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTestSetDiscrepancyReportResponse, T> g) {
        return obj -> g.apply((DescribeTestSetDiscrepancyReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTestSetDiscrepancyReportResponse> {
        /**
         * <p>
         * The unique identifier of the test set discrepancy report to describe.
         * </p>
         * 
         * @param testSetDiscrepancyReportId
         *        The unique identifier of the test set discrepancy report to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetDiscrepancyReportId(String testSetDiscrepancyReportId);

        /**
         * <p>
         * The test set Id for the test set discrepancy report.
         * </p>
         * 
         * @param testSetId
         *        The test set Id for the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetId(String testSetId);

        /**
         * <p>
         * The time and date of creation for the test set discrepancy report.
         * </p>
         * 
         * @param creationDateTime
         *        The time and date of creation for the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The target bot location for the test set discrepancy report.
         * </p>
         * 
         * @param target
         *        The target bot location for the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(TestSetDiscrepancyReportResourceTarget target);

        /**
         * <p>
         * The target bot location for the test set discrepancy report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TestSetDiscrepancyReportResourceTarget.Builder} avoiding the need to create one manually via
         * {@link TestSetDiscrepancyReportResourceTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetDiscrepancyReportResourceTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #target(TestSetDiscrepancyReportResourceTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link TestSetDiscrepancyReportResourceTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(TestSetDiscrepancyReportResourceTarget)
         */
        default Builder target(Consumer<TestSetDiscrepancyReportResourceTarget.Builder> target) {
            return target(TestSetDiscrepancyReportResourceTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The status for the test set discrepancy report.
         * </p>
         * 
         * @param testSetDiscrepancyReportStatus
         *        The status for the test set discrepancy report.
         * @see TestSetDiscrepancyReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSetDiscrepancyReportStatus
         */
        Builder testSetDiscrepancyReportStatus(String testSetDiscrepancyReportStatus);

        /**
         * <p>
         * The status for the test set discrepancy report.
         * </p>
         * 
         * @param testSetDiscrepancyReportStatus
         *        The status for the test set discrepancy report.
         * @see TestSetDiscrepancyReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSetDiscrepancyReportStatus
         */
        Builder testSetDiscrepancyReportStatus(TestSetDiscrepancyReportStatus testSetDiscrepancyReportStatus);

        /**
         * <p>
         * The date and time of the last update for the test set discrepancy report.
         * </p>
         * 
         * @param lastUpdatedDataTime
         *        The date and time of the last update for the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDataTime(Instant lastUpdatedDataTime);

        /**
         * <p>
         * The top 200 error results from the test set discrepancy report.
         * </p>
         * 
         * @param testSetDiscrepancyTopErrors
         *        The top 200 error results from the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetDiscrepancyTopErrors(TestSetDiscrepancyErrors testSetDiscrepancyTopErrors);

        /**
         * <p>
         * The top 200 error results from the test set discrepancy report.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestSetDiscrepancyErrors.Builder}
         * avoiding the need to create one manually via {@link TestSetDiscrepancyErrors#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetDiscrepancyErrors.Builder#build()} is called immediately
         * and its result is passed to {@link #testSetDiscrepancyTopErrors(TestSetDiscrepancyErrors)}.
         * 
         * @param testSetDiscrepancyTopErrors
         *        a consumer that will call methods on {@link TestSetDiscrepancyErrors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testSetDiscrepancyTopErrors(TestSetDiscrepancyErrors)
         */
        default Builder testSetDiscrepancyTopErrors(Consumer<TestSetDiscrepancyErrors.Builder> testSetDiscrepancyTopErrors) {
            return testSetDiscrepancyTopErrors(TestSetDiscrepancyErrors.builder().applyMutation(testSetDiscrepancyTopErrors)
                    .build());
        }

        /**
         * <p>
         * Pre-signed Amazon S3 URL to download the test set discrepancy report.
         * </p>
         * 
         * @param testSetDiscrepancyRawOutputUrl
         *        Pre-signed Amazon S3 URL to download the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetDiscrepancyRawOutputUrl(String testSetDiscrepancyRawOutputUrl);

        /**
         * <p>
         * The failure report for the test set discrepancy report generation action.
         * </p>
         * 
         * @param failureReasons
         *        The failure report for the test set discrepancy report generation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * The failure report for the test set discrepancy report generation action.
         * </p>
         * 
         * @param failureReasons
         *        The failure report for the test set discrepancy report generation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String testSetDiscrepancyReportId;

        private String testSetId;

        private Instant creationDateTime;

        private TestSetDiscrepancyReportResourceTarget target;

        private String testSetDiscrepancyReportStatus;

        private Instant lastUpdatedDataTime;

        private TestSetDiscrepancyErrors testSetDiscrepancyTopErrors;

        private String testSetDiscrepancyRawOutputUrl;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTestSetDiscrepancyReportResponse model) {
            super(model);
            testSetDiscrepancyReportId(model.testSetDiscrepancyReportId);
            testSetId(model.testSetId);
            creationDateTime(model.creationDateTime);
            target(model.target);
            testSetDiscrepancyReportStatus(model.testSetDiscrepancyReportStatus);
            lastUpdatedDataTime(model.lastUpdatedDataTime);
            testSetDiscrepancyTopErrors(model.testSetDiscrepancyTopErrors);
            testSetDiscrepancyRawOutputUrl(model.testSetDiscrepancyRawOutputUrl);
            failureReasons(model.failureReasons);
        }

        public final String getTestSetDiscrepancyReportId() {
            return testSetDiscrepancyReportId;
        }

        public final void setTestSetDiscrepancyReportId(String testSetDiscrepancyReportId) {
            this.testSetDiscrepancyReportId = testSetDiscrepancyReportId;
        }

        @Override
        public final Builder testSetDiscrepancyReportId(String testSetDiscrepancyReportId) {
            this.testSetDiscrepancyReportId = testSetDiscrepancyReportId;
            return this;
        }

        public final String getTestSetId() {
            return testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final TestSetDiscrepancyReportResourceTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(TestSetDiscrepancyReportResourceTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TestSetDiscrepancyReportResourceTarget target) {
            this.target = target;
            return this;
        }

        public final String getTestSetDiscrepancyReportStatus() {
            return testSetDiscrepancyReportStatus;
        }

        public final void setTestSetDiscrepancyReportStatus(String testSetDiscrepancyReportStatus) {
            this.testSetDiscrepancyReportStatus = testSetDiscrepancyReportStatus;
        }

        @Override
        public final Builder testSetDiscrepancyReportStatus(String testSetDiscrepancyReportStatus) {
            this.testSetDiscrepancyReportStatus = testSetDiscrepancyReportStatus;
            return this;
        }

        @Override
        public final Builder testSetDiscrepancyReportStatus(TestSetDiscrepancyReportStatus testSetDiscrepancyReportStatus) {
            this.testSetDiscrepancyReportStatus(testSetDiscrepancyReportStatus == null ? null : testSetDiscrepancyReportStatus
                    .toString());
            return this;
        }

        public final Instant getLastUpdatedDataTime() {
            return lastUpdatedDataTime;
        }

        public final void setLastUpdatedDataTime(Instant lastUpdatedDataTime) {
            this.lastUpdatedDataTime = lastUpdatedDataTime;
        }

        @Override
        public final Builder lastUpdatedDataTime(Instant lastUpdatedDataTime) {
            this.lastUpdatedDataTime = lastUpdatedDataTime;
            return this;
        }

        public final TestSetDiscrepancyErrors.Builder getTestSetDiscrepancyTopErrors() {
            return testSetDiscrepancyTopErrors != null ? testSetDiscrepancyTopErrors.toBuilder() : null;
        }

        public final void setTestSetDiscrepancyTopErrors(TestSetDiscrepancyErrors.BuilderImpl testSetDiscrepancyTopErrors) {
            this.testSetDiscrepancyTopErrors = testSetDiscrepancyTopErrors != null ? testSetDiscrepancyTopErrors.build() : null;
        }

        @Override
        public final Builder testSetDiscrepancyTopErrors(TestSetDiscrepancyErrors testSetDiscrepancyTopErrors) {
            this.testSetDiscrepancyTopErrors = testSetDiscrepancyTopErrors;
            return this;
        }

        public final String getTestSetDiscrepancyRawOutputUrl() {
            return testSetDiscrepancyRawOutputUrl;
        }

        public final void setTestSetDiscrepancyRawOutputUrl(String testSetDiscrepancyRawOutputUrl) {
            this.testSetDiscrepancyRawOutputUrl = testSetDiscrepancyRawOutputUrl;
        }

        @Override
        public final Builder testSetDiscrepancyRawOutputUrl(String testSetDiscrepancyRawOutputUrl) {
            this.testSetDiscrepancyRawOutputUrl = testSetDiscrepancyRawOutputUrl;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        @Override
        public DescribeTestSetDiscrepancyReportResponse build() {
            return new DescribeTestSetDiscrepancyReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
