/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of items in the intent classification test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntentClassificationTestResultItemCounts implements SdkPojo, Serializable,
        ToCopyableBuilder<IntentClassificationTestResultItemCounts.Builder, IntentClassificationTestResultItemCounts> {
    private static final SdkField<Integer> TOTAL_RESULT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResultCount").getter(getter(IntentClassificationTestResultItemCounts::totalResultCount))
            .setter(setter(Builder::totalResultCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResultCount").build()).build();

    private static final SdkField<Map<String, Integer>> SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("speechTranscriptionResultCounts")
            .getter(getter(IntentClassificationTestResultItemCounts::speechTranscriptionResultCountsAsStrings))
            .setter(setter(Builder::speechTranscriptionResultCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResultCounts")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> INTENT_MATCH_RESULT_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("intentMatchResultCounts")
            .getter(getter(IntentClassificationTestResultItemCounts::intentMatchResultCountsAsStrings))
            .setter(setter(Builder::intentMatchResultCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentMatchResultCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_RESULT_COUNT_FIELD,
            SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD, INTENT_MATCH_RESULT_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer totalResultCount;

    private final Map<String, Integer> speechTranscriptionResultCounts;

    private final Map<String, Integer> intentMatchResultCounts;

    private IntentClassificationTestResultItemCounts(BuilderImpl builder) {
        this.totalResultCount = builder.totalResultCount;
        this.speechTranscriptionResultCounts = builder.speechTranscriptionResultCounts;
        this.intentMatchResultCounts = builder.intentMatchResultCounts;
    }

    /**
     * <p>
     * The total number of results in the intent classification test.
     * </p>
     * 
     * @return The total number of results in the intent classification test.
     */
    public final Integer totalResultCount() {
        return totalResultCount;
    }

    /**
     * <p>
     * The number of matched, mismatched, and execution error results for speech transcription for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpeechTranscriptionResultCounts}
     * method.
     * </p>
     * 
     * @return The number of matched, mismatched, and execution error results for speech transcription for the intent.
     */
    public final Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(speechTranscriptionResultCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the SpeechTranscriptionResultCounts
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSpeechTranscriptionResultCounts() {
        return speechTranscriptionResultCounts != null && !(speechTranscriptionResultCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of matched, mismatched, and execution error results for speech transcription for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpeechTranscriptionResultCounts}
     * method.
     * </p>
     * 
     * @return The number of matched, mismatched, and execution error results for speech transcription for the intent.
     */
    public final Map<String, Integer> speechTranscriptionResultCountsAsStrings() {
        return speechTranscriptionResultCounts;
    }

    /**
     * <p>
     * The number of matched and mismatched results for intent recognition for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntentMatchResultCounts} method.
     * </p>
     * 
     * @return The number of matched and mismatched results for intent recognition for the intent.
     */
    public final Map<TestResultMatchStatus, Integer> intentMatchResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(intentMatchResultCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the IntentMatchResultCounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIntentMatchResultCounts() {
        return intentMatchResultCounts != null && !(intentMatchResultCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of matched and mismatched results for intent recognition for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntentMatchResultCounts} method.
     * </p>
     * 
     * @return The number of matched and mismatched results for intent recognition for the intent.
     */
    public final Map<String, Integer> intentMatchResultCountsAsStrings() {
        return intentMatchResultCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalResultCount());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSpeechTranscriptionResultCounts() ? speechTranscriptionResultCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIntentMatchResultCounts() ? intentMatchResultCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentClassificationTestResultItemCounts)) {
            return false;
        }
        IntentClassificationTestResultItemCounts other = (IntentClassificationTestResultItemCounts) obj;
        return Objects.equals(totalResultCount(), other.totalResultCount())
                && hasSpeechTranscriptionResultCounts() == other.hasSpeechTranscriptionResultCounts()
                && Objects.equals(speechTranscriptionResultCountsAsStrings(), other.speechTranscriptionResultCountsAsStrings())
                && hasIntentMatchResultCounts() == other.hasIntentMatchResultCounts()
                && Objects.equals(intentMatchResultCountsAsStrings(), other.intentMatchResultCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("IntentClassificationTestResultItemCounts")
                .add("TotalResultCount", totalResultCount())
                .add("SpeechTranscriptionResultCounts",
                        hasSpeechTranscriptionResultCounts() ? speechTranscriptionResultCountsAsStrings() : null)
                .add("IntentMatchResultCounts", hasIntentMatchResultCounts() ? intentMatchResultCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalResultCount":
            return Optional.ofNullable(clazz.cast(totalResultCount()));
        case "speechTranscriptionResultCounts":
            return Optional.ofNullable(clazz.cast(speechTranscriptionResultCountsAsStrings()));
        case "intentMatchResultCounts":
            return Optional.ofNullable(clazz.cast(intentMatchResultCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("totalResultCount", TOTAL_RESULT_COUNT_FIELD);
        map.put("speechTranscriptionResultCounts", SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD);
        map.put("intentMatchResultCounts", INTENT_MATCH_RESULT_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntentClassificationTestResultItemCounts, T> g) {
        return obj -> g.apply((IntentClassificationTestResultItemCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntentClassificationTestResultItemCounts> {
        /**
         * <p>
         * The total number of results in the intent classification test.
         * </p>
         * 
         * @param totalResultCount
         *        The total number of results in the intent classification test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResultCount(Integer totalResultCount);

        /**
         * <p>
         * The number of matched, mismatched, and execution error results for speech transcription for the intent.
         * </p>
         * 
         * @param speechTranscriptionResultCounts
         *        The number of matched, mismatched, and execution error results for speech transcription for the
         *        intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> speechTranscriptionResultCounts);

        /**
         * <p>
         * The number of matched, mismatched, and execution error results for speech transcription for the intent.
         * </p>
         * 
         * @param speechTranscriptionResultCounts
         *        The number of matched, mismatched, and execution error results for speech transcription for the
         *        intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts);

        /**
         * <p>
         * The number of matched and mismatched results for intent recognition for the intent.
         * </p>
         * 
         * @param intentMatchResultCounts
         *        The number of matched and mismatched results for intent recognition for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentMatchResultCountsWithStrings(Map<String, Integer> intentMatchResultCounts);

        /**
         * <p>
         * The number of matched and mismatched results for intent recognition for the intent.
         * </p>
         * 
         * @param intentMatchResultCounts
         *        The number of matched and mismatched results for intent recognition for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentMatchResultCounts(Map<TestResultMatchStatus, Integer> intentMatchResultCounts);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalResultCount;

        private Map<String, Integer> speechTranscriptionResultCounts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Integer> intentMatchResultCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IntentClassificationTestResultItemCounts model) {
            totalResultCount(model.totalResultCount);
            speechTranscriptionResultCountsWithStrings(model.speechTranscriptionResultCounts);
            intentMatchResultCountsWithStrings(model.intentMatchResultCounts);
        }

        public final Integer getTotalResultCount() {
            return totalResultCount;
        }

        public final void setTotalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
        }

        @Override
        public final Builder totalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
            return this;
        }

        public final Map<String, Integer> getSpeechTranscriptionResultCounts() {
            if (speechTranscriptionResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return speechTranscriptionResultCounts;
        }

        public final void setSpeechTranscriptionResultCounts(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
        }

        @Override
        public final Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
            return this;
        }

        @Override
        public final Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier
                    .copyEnumToString(speechTranscriptionResultCounts);
            return this;
        }

        public final Map<String, Integer> getIntentMatchResultCounts() {
            if (intentMatchResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return intentMatchResultCounts;
        }

        public final void setIntentMatchResultCounts(Map<String, Integer> intentMatchResultCounts) {
            this.intentMatchResultCounts = TestResultMatchStatusCountMapCopier.copy(intentMatchResultCounts);
        }

        @Override
        public final Builder intentMatchResultCountsWithStrings(Map<String, Integer> intentMatchResultCounts) {
            this.intentMatchResultCounts = TestResultMatchStatusCountMapCopier.copy(intentMatchResultCounts);
            return this;
        }

        @Override
        public final Builder intentMatchResultCounts(Map<TestResultMatchStatus, Integer> intentMatchResultCounts) {
            this.intentMatchResultCounts = TestResultMatchStatusCountMapCopier.copyEnumToString(intentMatchResultCounts);
            return this;
        }

        @Override
        public IntentClassificationTestResultItemCounts build() {
            return new IntentClassificationTestResultItemCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
