/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a list of message groups that Amazon Lex sends to a user to elicit a response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptSpecification.Builder, PromptSpecification> {
    private static final SdkField<List<MessageGroup>> MESSAGE_GROUPS_FIELD = SdkField
            .<List<MessageGroup>> builder(MarshallingType.LIST)
            .memberName("messageGroups")
            .getter(getter(PromptSpecification::messageGroups))
            .setter(setter(Builder::messageGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRetries").getter(getter(PromptSpecification::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetries").build()).build();

    private static final SdkField<Boolean> ALLOW_INTERRUPT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowInterrupt").getter(getter(PromptSpecification::allowInterrupt))
            .setter(setter(Builder::allowInterrupt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowInterrupt").build()).build();

    private static final SdkField<String> MESSAGE_SELECTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageSelectionStrategy").getter(getter(PromptSpecification::messageSelectionStrategyAsString))
            .setter(setter(Builder::messageSelectionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageSelectionStrategy").build())
            .build();

    private static final SdkField<Map<String, PromptAttemptSpecification>> PROMPT_ATTEMPTS_SPECIFICATION_FIELD = SdkField
            .<Map<String, PromptAttemptSpecification>> builder(MarshallingType.MAP)
            .memberName("promptAttemptsSpecification")
            .getter(getter(PromptSpecification::promptAttemptsSpecificationAsStrings))
            .setter(setter(Builder::promptAttemptsSpecificationWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptAttemptsSpecification")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PromptAttemptSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptAttemptSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_GROUPS_FIELD,
            MAX_RETRIES_FIELD, ALLOW_INTERRUPT_FIELD, MESSAGE_SELECTION_STRATEGY_FIELD, PROMPT_ATTEMPTS_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MessageGroup> messageGroups;

    private final Integer maxRetries;

    private final Boolean allowInterrupt;

    private final String messageSelectionStrategy;

    private final Map<String, PromptAttemptSpecification> promptAttemptsSpecification;

    private PromptSpecification(BuilderImpl builder) {
        this.messageGroups = builder.messageGroups;
        this.maxRetries = builder.maxRetries;
        this.allowInterrupt = builder.allowInterrupt;
        this.messageSelectionStrategy = builder.messageSelectionStrategy;
        this.promptAttemptsSpecification = builder.promptAttemptsSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the MessageGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMessageGroups() {
        return messageGroups != null && !(messageGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at
     * runtime.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageGroups} method.
     * </p>
     * 
     * @return A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to
     *         send at runtime.
     */
    public final List<MessageGroup> messageGroups() {
        return messageGroups;
    }

    /**
     * <p>
     * The maximum number of times the bot tries to elicit a response from the user using this prompt.
     * </p>
     * 
     * @return The maximum number of times the bot tries to elicit a response from the user using this prompt.
     */
    public final Integer maxRetries() {
        return maxRetries;
    }

    /**
     * <p>
     * Indicates whether the user can interrupt a speech prompt from the bot.
     * </p>
     * 
     * @return Indicates whether the user can interrupt a speech prompt from the bot.
     */
    public final Boolean allowInterrupt() {
        return allowInterrupt;
    }

    /**
     * <p>
     * Indicates how a message is selected from a message group among retries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #messageSelectionStrategy} will return {@link MessageSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #messageSelectionStrategyAsString}.
     * </p>
     * 
     * @return Indicates how a message is selected from a message group among retries.
     * @see MessageSelectionStrategy
     */
    public final MessageSelectionStrategy messageSelectionStrategy() {
        return MessageSelectionStrategy.fromValue(messageSelectionStrategy);
    }

    /**
     * <p>
     * Indicates how a message is selected from a message group among retries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #messageSelectionStrategy} will return {@link MessageSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #messageSelectionStrategyAsString}.
     * </p>
     * 
     * @return Indicates how a message is selected from a message group among retries.
     * @see MessageSelectionStrategy
     */
    public final String messageSelectionStrategyAsString() {
        return messageSelectionStrategy;
    }

    /**
     * <p>
     * Specifies the advanced settings on each attempt of the prompt.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPromptAttemptsSpecification} method.
     * </p>
     * 
     * @return Specifies the advanced settings on each attempt of the prompt.
     */
    public final Map<PromptAttempt, PromptAttemptSpecification> promptAttemptsSpecification() {
        return PromptAttemptsSpecificationMapCopier.copyStringToEnum(promptAttemptsSpecification);
    }

    /**
     * For responses, this returns true if the service returned a value for the PromptAttemptsSpecification property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPromptAttemptsSpecification() {
        return promptAttemptsSpecification != null && !(promptAttemptsSpecification instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the advanced settings on each attempt of the prompt.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPromptAttemptsSpecification} method.
     * </p>
     * 
     * @return Specifies the advanced settings on each attempt of the prompt.
     */
    public final Map<String, PromptAttemptSpecification> promptAttemptsSpecificationAsStrings() {
        return promptAttemptsSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMessageGroups() ? messageGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(allowInterrupt());
        hashCode = 31 * hashCode + Objects.hashCode(messageSelectionStrategyAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPromptAttemptsSpecification() ? promptAttemptsSpecificationAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptSpecification)) {
            return false;
        }
        PromptSpecification other = (PromptSpecification) obj;
        return hasMessageGroups() == other.hasMessageGroups() && Objects.equals(messageGroups(), other.messageGroups())
                && Objects.equals(maxRetries(), other.maxRetries()) && Objects.equals(allowInterrupt(), other.allowInterrupt())
                && Objects.equals(messageSelectionStrategyAsString(), other.messageSelectionStrategyAsString())
                && hasPromptAttemptsSpecification() == other.hasPromptAttemptsSpecification()
                && Objects.equals(promptAttemptsSpecificationAsStrings(), other.promptAttemptsSpecificationAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PromptSpecification")
                .add("MessageGroups", hasMessageGroups() ? messageGroups() : null)
                .add("MaxRetries", maxRetries())
                .add("AllowInterrupt", allowInterrupt())
                .add("MessageSelectionStrategy", messageSelectionStrategyAsString())
                .add("PromptAttemptsSpecification",
                        hasPromptAttemptsSpecification() ? promptAttemptsSpecificationAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageGroups":
            return Optional.ofNullable(clazz.cast(messageGroups()));
        case "maxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "allowInterrupt":
            return Optional.ofNullable(clazz.cast(allowInterrupt()));
        case "messageSelectionStrategy":
            return Optional.ofNullable(clazz.cast(messageSelectionStrategyAsString()));
        case "promptAttemptsSpecification":
            return Optional.ofNullable(clazz.cast(promptAttemptsSpecificationAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageGroups", MESSAGE_GROUPS_FIELD);
        map.put("maxRetries", MAX_RETRIES_FIELD);
        map.put("allowInterrupt", ALLOW_INTERRUPT_FIELD);
        map.put("messageSelectionStrategy", MESSAGE_SELECTION_STRATEGY_FIELD);
        map.put("promptAttemptsSpecification", PROMPT_ATTEMPTS_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptSpecification, T> g) {
        return obj -> g.apply((PromptSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptSpecification> {
        /**
         * <p>
         * A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send
         * at runtime.
         * </p>
         * 
         * @param messageGroups
         *        A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message
         *        to send at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageGroups(Collection<MessageGroup> messageGroups);

        /**
         * <p>
         * A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send
         * at runtime.
         * </p>
         * 
         * @param messageGroups
         *        A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message
         *        to send at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageGroups(MessageGroup... messageGroups);

        /**
         * <p>
         * A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send
         * at runtime.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #messageGroups(List<MessageGroup>)}.
         * 
         * @param messageGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageGroups(java.util.Collection<MessageGroup>)
         */
        Builder messageGroups(Consumer<MessageGroup.Builder>... messageGroups);

        /**
         * <p>
         * The maximum number of times the bot tries to elicit a response from the user using this prompt.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of times the bot tries to elicit a response from the user using this prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Integer maxRetries);

        /**
         * <p>
         * Indicates whether the user can interrupt a speech prompt from the bot.
         * </p>
         * 
         * @param allowInterrupt
         *        Indicates whether the user can interrupt a speech prompt from the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowInterrupt(Boolean allowInterrupt);

        /**
         * <p>
         * Indicates how a message is selected from a message group among retries.
         * </p>
         * 
         * @param messageSelectionStrategy
         *        Indicates how a message is selected from a message group among retries.
         * @see MessageSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageSelectionStrategy
         */
        Builder messageSelectionStrategy(String messageSelectionStrategy);

        /**
         * <p>
         * Indicates how a message is selected from a message group among retries.
         * </p>
         * 
         * @param messageSelectionStrategy
         *        Indicates how a message is selected from a message group among retries.
         * @see MessageSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageSelectionStrategy
         */
        Builder messageSelectionStrategy(MessageSelectionStrategy messageSelectionStrategy);

        /**
         * <p>
         * Specifies the advanced settings on each attempt of the prompt.
         * </p>
         * 
         * @param promptAttemptsSpecification
         *        Specifies the advanced settings on each attempt of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptAttemptsSpecificationWithStrings(Map<String, PromptAttemptSpecification> promptAttemptsSpecification);

        /**
         * <p>
         * Specifies the advanced settings on each attempt of the prompt.
         * </p>
         * 
         * @param promptAttemptsSpecification
         *        Specifies the advanced settings on each attempt of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptAttemptsSpecification(Map<PromptAttempt, PromptAttemptSpecification> promptAttemptsSpecification);
    }

    static final class BuilderImpl implements Builder {
        private List<MessageGroup> messageGroups = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRetries;

        private Boolean allowInterrupt;

        private String messageSelectionStrategy;

        private Map<String, PromptAttemptSpecification> promptAttemptsSpecification = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PromptSpecification model) {
            messageGroups(model.messageGroups);
            maxRetries(model.maxRetries);
            allowInterrupt(model.allowInterrupt);
            messageSelectionStrategy(model.messageSelectionStrategy);
            promptAttemptsSpecificationWithStrings(model.promptAttemptsSpecification);
        }

        public final List<MessageGroup.Builder> getMessageGroups() {
            List<MessageGroup.Builder> result = MessageGroupsListCopier.copyToBuilder(this.messageGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessageGroups(Collection<MessageGroup.BuilderImpl> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copyFromBuilder(messageGroups);
        }

        @Override
        public final Builder messageGroups(Collection<MessageGroup> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copy(messageGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(MessageGroup... messageGroups) {
            messageGroups(Arrays.asList(messageGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(Consumer<MessageGroup.Builder>... messageGroups) {
            messageGroups(Stream.of(messageGroups).map(c -> MessageGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRetries() {
            return maxRetries;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final Boolean getAllowInterrupt() {
            return allowInterrupt;
        }

        public final void setAllowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
        }

        @Override
        public final Builder allowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
            return this;
        }

        public final String getMessageSelectionStrategy() {
            return messageSelectionStrategy;
        }

        public final void setMessageSelectionStrategy(String messageSelectionStrategy) {
            this.messageSelectionStrategy = messageSelectionStrategy;
        }

        @Override
        public final Builder messageSelectionStrategy(String messageSelectionStrategy) {
            this.messageSelectionStrategy = messageSelectionStrategy;
            return this;
        }

        @Override
        public final Builder messageSelectionStrategy(MessageSelectionStrategy messageSelectionStrategy) {
            this.messageSelectionStrategy(messageSelectionStrategy == null ? null : messageSelectionStrategy.toString());
            return this;
        }

        public final Map<String, PromptAttemptSpecification.Builder> getPromptAttemptsSpecification() {
            Map<String, PromptAttemptSpecification.Builder> result = PromptAttemptsSpecificationMapCopier
                    .copyToBuilder(this.promptAttemptsSpecification);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPromptAttemptsSpecification(
                Map<String, PromptAttemptSpecification.BuilderImpl> promptAttemptsSpecification) {
            this.promptAttemptsSpecification = PromptAttemptsSpecificationMapCopier.copyFromBuilder(promptAttemptsSpecification);
        }

        @Override
        public final Builder promptAttemptsSpecificationWithStrings(
                Map<String, PromptAttemptSpecification> promptAttemptsSpecification) {
            this.promptAttemptsSpecification = PromptAttemptsSpecificationMapCopier.copy(promptAttemptsSpecification);
            return this;
        }

        @Override
        public final Builder promptAttemptsSpecification(
                Map<PromptAttempt, PromptAttemptSpecification> promptAttemptsSpecification) {
            this.promptAttemptsSpecification = PromptAttemptsSpecificationMapCopier.copyEnumToString(promptAttemptsSpecification);
            return this;
        }

        @Override
        public PromptSpecification build() {
            return new PromptSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
