/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing information about a specific session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionSpecification.Builder, SessionSpecification> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(SessionSpecification::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(SessionSpecification::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(SessionSpecification::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("channel")
            .getter(getter(SessionSpecification::channel)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(SessionSpecification::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Instant> CONVERSATION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("conversationStartTime").getter(getter(SessionSpecification::conversationStartTime))
            .setter(setter(Builder::conversationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationStartTime").build())
            .build();

    private static final SdkField<Instant> CONVERSATION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("conversationEndTime").getter(getter(SessionSpecification::conversationEndTime))
            .setter(setter(Builder::conversationEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationEndTime").build())
            .build();

    private static final SdkField<Long> CONVERSATION_DURATION_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("conversationDurationSeconds")
            .getter(getter(SessionSpecification::conversationDurationSeconds))
            .setter(setter(Builder::conversationDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationDurationSeconds")
                    .build()).build();

    private static final SdkField<String> CONVERSATION_END_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationEndState").getter(getter(SessionSpecification::conversationEndStateAsString))
            .setter(setter(Builder::conversationEndState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationEndState").build())
            .build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(SessionSpecification::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<Long> NUMBER_OF_TURNS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfTurns").getter(getter(SessionSpecification::numberOfTurns))
            .setter(setter(Builder::numberOfTurns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfTurns").build()).build();

    private static final SdkField<List<InvokedIntentSample>> INVOKED_INTENT_SAMPLES_FIELD = SdkField
            .<List<InvokedIntentSample>> builder(MarshallingType.LIST)
            .memberName("invokedIntentSamples")
            .getter(getter(SessionSpecification::invokedIntentSamples))
            .setter(setter(Builder::invokedIntentSamples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokedIntentSamples").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvokedIntentSample> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvokedIntentSample::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORIGINATING_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originatingRequestId").getter(getter(SessionSpecification::originatingRequestId))
            .setter(setter(Builder::originatingRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originatingRequestId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, CHANNEL_FIELD, SESSION_ID_FIELD, CONVERSATION_START_TIME_FIELD,
            CONVERSATION_END_TIME_FIELD, CONVERSATION_DURATION_SECONDS_FIELD, CONVERSATION_END_STATE_FIELD, MODE_FIELD,
            NUMBER_OF_TURNS_FIELD, INVOKED_INTENT_SAMPLES_FIELD, ORIGINATING_REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String botAliasId;

    private final String botVersion;

    private final String localeId;

    private final String channel;

    private final String sessionId;

    private final Instant conversationStartTime;

    private final Instant conversationEndTime;

    private final Long conversationDurationSeconds;

    private final String conversationEndState;

    private final String mode;

    private final Long numberOfTurns;

    private final List<InvokedIntentSample> invokedIntentSamples;

    private final String originatingRequestId;

    private SessionSpecification(BuilderImpl builder) {
        this.botAliasId = builder.botAliasId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.channel = builder.channel;
        this.sessionId = builder.sessionId;
        this.conversationStartTime = builder.conversationStartTime;
        this.conversationEndTime = builder.conversationEndTime;
        this.conversationDurationSeconds = builder.conversationDurationSeconds;
        this.conversationEndState = builder.conversationEndState;
        this.mode = builder.mode;
        this.numberOfTurns = builder.numberOfTurns;
        this.invokedIntentSamples = builder.invokedIntentSamples;
        this.originatingRequestId = builder.originatingRequestId;
    }

    /**
     * <p>
     * The identifier of the alias of the bot that the session was held with.
     * </p>
     * 
     * @return The identifier of the alias of the bot that the session was held with.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The version of the bot that the session was held with.
     * </p>
     * 
     * @return The version of the bot that the session was held with.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The locale of the bot that the session was held with.
     * </p>
     * 
     * @return The locale of the bot that the session was held with.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The channel that is integrated with the bot that the session was held with.
     * </p>
     * 
     * @return The channel that is integrated with the bot that the session was held with.
     */
    public final String channel() {
        return channel;
    }

    /**
     * <p>
     * The identifier of the session.
     * </p>
     * 
     * @return The identifier of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The date and time when the conversation began. A conversation is defined as a unique combination of a
     * <code>sessionId</code> and an <code>originatingRequestId</code>.
     * </p>
     * 
     * @return The date and time when the conversation began. A conversation is defined as a unique combination of a
     *         <code>sessionId</code> and an <code>originatingRequestId</code>.
     */
    public final Instant conversationStartTime() {
        return conversationStartTime;
    }

    /**
     * <p>
     * The date and time when the conversation ended. A conversation is defined as a unique combination of a
     * <code>sessionId</code> and an <code>originatingRequestId</code>.
     * </p>
     * 
     * @return The date and time when the conversation ended. A conversation is defined as a unique combination of a
     *         <code>sessionId</code> and an <code>originatingRequestId</code>.
     */
    public final Instant conversationEndTime() {
        return conversationEndTime;
    }

    /**
     * <p>
     * The duration of the conversation in seconds. A conversation is defined as a unique combination of a
     * <code>sessionId</code> and an <code>originatingRequestId</code>.
     * </p>
     * 
     * @return The duration of the conversation in seconds. A conversation is defined as a unique combination of a
     *         <code>sessionId</code> and an <code>originatingRequestId</code>.
     */
    public final Long conversationDurationSeconds() {
        return conversationDurationSeconds;
    }

    /**
     * <p>
     * The final state of the conversation. A conversation is defined as a unique combination of a
     * <code>sessionId</code> and an <code>originatingRequestId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conversationEndState} will return {@link ConversationEndState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conversationEndStateAsString}.
     * </p>
     * 
     * @return The final state of the conversation. A conversation is defined as a unique combination of a
     *         <code>sessionId</code> and an <code>originatingRequestId</code>.
     * @see ConversationEndState
     */
    public final ConversationEndState conversationEndState() {
        return ConversationEndState.fromValue(conversationEndState);
    }

    /**
     * <p>
     * The final state of the conversation. A conversation is defined as a unique combination of a
     * <code>sessionId</code> and an <code>originatingRequestId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conversationEndState} will return {@link ConversationEndState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conversationEndStateAsString}.
     * </p>
     * 
     * @return The final state of the conversation. A conversation is defined as a unique combination of a
     *         <code>sessionId</code> and an <code>originatingRequestId</code>.
     * @see ConversationEndState
     */
    public final String conversationEndStateAsString() {
        return conversationEndState;
    }

    /**
     * <p>
     * The mode of the session. The possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Speech</code> – The session was spoken.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Text</code> – The session was written.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DTMF</code> – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MultiMode</code> – The session used multiple modes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link AnalyticsModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the session. The possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Speech</code> – The session was spoken.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Text</code> – The session was written.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DTMF</code> – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MultiMode</code> – The session used multiple modes.
     *         </p>
     *         </li>
     * @see AnalyticsModality
     */
    public final AnalyticsModality mode() {
        return AnalyticsModality.fromValue(mode);
    }

    /**
     * <p>
     * The mode of the session. The possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Speech</code> – The session was spoken.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Text</code> – The session was written.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DTMF</code> – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MultiMode</code> – The session used multiple modes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link AnalyticsModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the session. The possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Speech</code> – The session was spoken.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Text</code> – The session was written.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DTMF</code> – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MultiMode</code> – The session used multiple modes.
     *         </p>
     *         </li>
     * @see AnalyticsModality
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The number of turns that the session took.
     * </p>
     * 
     * @return The number of turns that the session took.
     */
    public final Long numberOfTurns() {
        return numberOfTurns;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvokedIntentSamples property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvokedIntentSamples() {
        return invokedIntentSamples != null && !(invokedIntentSamples instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing the name of an intent that was invoked.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvokedIntentSamples} method.
     * </p>
     * 
     * @return A list of objects containing the name of an intent that was invoked.
     */
    public final List<InvokedIntentSample> invokedIntentSamples() {
        return invokedIntentSamples;
    }

    /**
     * <p>
     * The identifier of the first request in a session.
     * </p>
     * 
     * @return The identifier of the first request in a session.
     */
    public final String originatingRequestId() {
        return originatingRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(conversationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(conversationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(conversationDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(conversationEndStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTurns());
        hashCode = 31 * hashCode + Objects.hashCode(hasInvokedIntentSamples() ? invokedIntentSamples() : null);
        hashCode = 31 * hashCode + Objects.hashCode(originatingRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionSpecification)) {
            return false;
        }
        SessionSpecification other = (SessionSpecification) obj;
        return Objects.equals(botAliasId(), other.botAliasId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(channel(), other.channel())
                && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(conversationStartTime(), other.conversationStartTime())
                && Objects.equals(conversationEndTime(), other.conversationEndTime())
                && Objects.equals(conversationDurationSeconds(), other.conversationDurationSeconds())
                && Objects.equals(conversationEndStateAsString(), other.conversationEndStateAsString())
                && Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(numberOfTurns(), other.numberOfTurns())
                && hasInvokedIntentSamples() == other.hasInvokedIntentSamples()
                && Objects.equals(invokedIntentSamples(), other.invokedIntentSamples())
                && Objects.equals(originatingRequestId(), other.originatingRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionSpecification").add("BotAliasId", botAliasId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("Channel", channel()).add("SessionId", sessionId())
                .add("ConversationStartTime", conversationStartTime()).add("ConversationEndTime", conversationEndTime())
                .add("ConversationDurationSeconds", conversationDurationSeconds())
                .add("ConversationEndState", conversationEndStateAsString()).add("Mode", modeAsString())
                .add("NumberOfTurns", numberOfTurns())
                .add("InvokedIntentSamples", hasInvokedIntentSamples() ? invokedIntentSamples() : null)
                .add("OriginatingRequestId", originatingRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "conversationStartTime":
            return Optional.ofNullable(clazz.cast(conversationStartTime()));
        case "conversationEndTime":
            return Optional.ofNullable(clazz.cast(conversationEndTime()));
        case "conversationDurationSeconds":
            return Optional.ofNullable(clazz.cast(conversationDurationSeconds()));
        case "conversationEndState":
            return Optional.ofNullable(clazz.cast(conversationEndStateAsString()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "numberOfTurns":
            return Optional.ofNullable(clazz.cast(numberOfTurns()));
        case "invokedIntentSamples":
            return Optional.ofNullable(clazz.cast(invokedIntentSamples()));
        case "originatingRequestId":
            return Optional.ofNullable(clazz.cast(originatingRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botAliasId", BOT_ALIAS_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("channel", CHANNEL_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("conversationStartTime", CONVERSATION_START_TIME_FIELD);
        map.put("conversationEndTime", CONVERSATION_END_TIME_FIELD);
        map.put("conversationDurationSeconds", CONVERSATION_DURATION_SECONDS_FIELD);
        map.put("conversationEndState", CONVERSATION_END_STATE_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("numberOfTurns", NUMBER_OF_TURNS_FIELD);
        map.put("invokedIntentSamples", INVOKED_INTENT_SAMPLES_FIELD);
        map.put("originatingRequestId", ORIGINATING_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionSpecification, T> g) {
        return obj -> g.apply((SessionSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionSpecification> {
        /**
         * <p>
         * The identifier of the alias of the bot that the session was held with.
         * </p>
         * 
         * @param botAliasId
         *        The identifier of the alias of the bot that the session was held with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The version of the bot that the session was held with.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that the session was held with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The locale of the bot that the session was held with.
         * </p>
         * 
         * @param localeId
         *        The locale of the bot that the session was held with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The channel that is integrated with the bot that the session was held with.
         * </p>
         * 
         * @param channel
         *        The channel that is integrated with the bot that the session was held with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(String channel);

        /**
         * <p>
         * The identifier of the session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The date and time when the conversation began. A conversation is defined as a unique combination of a
         * <code>sessionId</code> and an <code>originatingRequestId</code>.
         * </p>
         * 
         * @param conversationStartTime
         *        The date and time when the conversation began. A conversation is defined as a unique combination of a
         *        <code>sessionId</code> and an <code>originatingRequestId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationStartTime(Instant conversationStartTime);

        /**
         * <p>
         * The date and time when the conversation ended. A conversation is defined as a unique combination of a
         * <code>sessionId</code> and an <code>originatingRequestId</code>.
         * </p>
         * 
         * @param conversationEndTime
         *        The date and time when the conversation ended. A conversation is defined as a unique combination of a
         *        <code>sessionId</code> and an <code>originatingRequestId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationEndTime(Instant conversationEndTime);

        /**
         * <p>
         * The duration of the conversation in seconds. A conversation is defined as a unique combination of a
         * <code>sessionId</code> and an <code>originatingRequestId</code>.
         * </p>
         * 
         * @param conversationDurationSeconds
         *        The duration of the conversation in seconds. A conversation is defined as a unique combination of a
         *        <code>sessionId</code> and an <code>originatingRequestId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationDurationSeconds(Long conversationDurationSeconds);

        /**
         * <p>
         * The final state of the conversation. A conversation is defined as a unique combination of a
         * <code>sessionId</code> and an <code>originatingRequestId</code>.
         * </p>
         * 
         * @param conversationEndState
         *        The final state of the conversation. A conversation is defined as a unique combination of a
         *        <code>sessionId</code> and an <code>originatingRequestId</code>.
         * @see ConversationEndState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversationEndState
         */
        Builder conversationEndState(String conversationEndState);

        /**
         * <p>
         * The final state of the conversation. A conversation is defined as a unique combination of a
         * <code>sessionId</code> and an <code>originatingRequestId</code>.
         * </p>
         * 
         * @param conversationEndState
         *        The final state of the conversation. A conversation is defined as a unique combination of a
         *        <code>sessionId</code> and an <code>originatingRequestId</code>.
         * @see ConversationEndState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversationEndState
         */
        Builder conversationEndState(ConversationEndState conversationEndState);

        /**
         * <p>
         * The mode of the session. The possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Speech</code> – The session was spoken.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Text</code> – The session was written.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DTMF</code> – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MultiMode</code> – The session used multiple modes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        The mode of the session. The possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Speech</code> – The session was spoken.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Text</code> – The session was written.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DTMF</code> – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MultiMode</code> – The session used multiple modes.
         *        </p>
         *        </li>
         * @see AnalyticsModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsModality
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode of the session. The possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Speech</code> – The session was spoken.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Text</code> – The session was written.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DTMF</code> – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MultiMode</code> – The session used multiple modes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        The mode of the session. The possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Speech</code> – The session was spoken.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Text</code> – The session was written.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DTMF</code> – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MultiMode</code> – The session used multiple modes.
         *        </p>
         *        </li>
         * @see AnalyticsModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsModality
         */
        Builder mode(AnalyticsModality mode);

        /**
         * <p>
         * The number of turns that the session took.
         * </p>
         * 
         * @param numberOfTurns
         *        The number of turns that the session took.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTurns(Long numberOfTurns);

        /**
         * <p>
         * A list of objects containing the name of an intent that was invoked.
         * </p>
         * 
         * @param invokedIntentSamples
         *        A list of objects containing the name of an intent that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedIntentSamples(Collection<InvokedIntentSample> invokedIntentSamples);

        /**
         * <p>
         * A list of objects containing the name of an intent that was invoked.
         * </p>
         * 
         * @param invokedIntentSamples
         *        A list of objects containing the name of an intent that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedIntentSamples(InvokedIntentSample... invokedIntentSamples);

        /**
         * <p>
         * A list of objects containing the name of an intent that was invoked.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample.Builder#build()} is called
         * immediately and its result is passed to {@link #invokedIntentSamples(List<InvokedIntentSample>)}.
         * 
         * @param invokedIntentSamples
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invokedIntentSamples(java.util.Collection<InvokedIntentSample>)
         */
        Builder invokedIntentSamples(Consumer<InvokedIntentSample.Builder>... invokedIntentSamples);

        /**
         * <p>
         * The identifier of the first request in a session.
         * </p>
         * 
         * @param originatingRequestId
         *        The identifier of the first request in a session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originatingRequestId(String originatingRequestId);
    }

    static final class BuilderImpl implements Builder {
        private String botAliasId;

        private String botVersion;

        private String localeId;

        private String channel;

        private String sessionId;

        private Instant conversationStartTime;

        private Instant conversationEndTime;

        private Long conversationDurationSeconds;

        private String conversationEndState;

        private String mode;

        private Long numberOfTurns;

        private List<InvokedIntentSample> invokedIntentSamples = DefaultSdkAutoConstructList.getInstance();

        private String originatingRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionSpecification model) {
            botAliasId(model.botAliasId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            channel(model.channel);
            sessionId(model.sessionId);
            conversationStartTime(model.conversationStartTime);
            conversationEndTime(model.conversationEndTime);
            conversationDurationSeconds(model.conversationDurationSeconds);
            conversationEndState(model.conversationEndState);
            mode(model.mode);
            numberOfTurns(model.numberOfTurns);
            invokedIntentSamples(model.invokedIntentSamples);
            originatingRequestId(model.originatingRequestId);
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getConversationStartTime() {
            return conversationStartTime;
        }

        public final void setConversationStartTime(Instant conversationStartTime) {
            this.conversationStartTime = conversationStartTime;
        }

        @Override
        public final Builder conversationStartTime(Instant conversationStartTime) {
            this.conversationStartTime = conversationStartTime;
            return this;
        }

        public final Instant getConversationEndTime() {
            return conversationEndTime;
        }

        public final void setConversationEndTime(Instant conversationEndTime) {
            this.conversationEndTime = conversationEndTime;
        }

        @Override
        public final Builder conversationEndTime(Instant conversationEndTime) {
            this.conversationEndTime = conversationEndTime;
            return this;
        }

        public final Long getConversationDurationSeconds() {
            return conversationDurationSeconds;
        }

        public final void setConversationDurationSeconds(Long conversationDurationSeconds) {
            this.conversationDurationSeconds = conversationDurationSeconds;
        }

        @Override
        public final Builder conversationDurationSeconds(Long conversationDurationSeconds) {
            this.conversationDurationSeconds = conversationDurationSeconds;
            return this;
        }

        public final String getConversationEndState() {
            return conversationEndState;
        }

        public final void setConversationEndState(String conversationEndState) {
            this.conversationEndState = conversationEndState;
        }

        @Override
        public final Builder conversationEndState(String conversationEndState) {
            this.conversationEndState = conversationEndState;
            return this;
        }

        @Override
        public final Builder conversationEndState(ConversationEndState conversationEndState) {
            this.conversationEndState(conversationEndState == null ? null : conversationEndState.toString());
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AnalyticsModality mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Long getNumberOfTurns() {
            return numberOfTurns;
        }

        public final void setNumberOfTurns(Long numberOfTurns) {
            this.numberOfTurns = numberOfTurns;
        }

        @Override
        public final Builder numberOfTurns(Long numberOfTurns) {
            this.numberOfTurns = numberOfTurns;
            return this;
        }

        public final List<InvokedIntentSample.Builder> getInvokedIntentSamples() {
            List<InvokedIntentSample.Builder> result = InvokedIntentSamplesCopier.copyToBuilder(this.invokedIntentSamples);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvokedIntentSamples(Collection<InvokedIntentSample.BuilderImpl> invokedIntentSamples) {
            this.invokedIntentSamples = InvokedIntentSamplesCopier.copyFromBuilder(invokedIntentSamples);
        }

        @Override
        public final Builder invokedIntentSamples(Collection<InvokedIntentSample> invokedIntentSamples) {
            this.invokedIntentSamples = InvokedIntentSamplesCopier.copy(invokedIntentSamples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invokedIntentSamples(InvokedIntentSample... invokedIntentSamples) {
            invokedIntentSamples(Arrays.asList(invokedIntentSamples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invokedIntentSamples(Consumer<InvokedIntentSample.Builder>... invokedIntentSamples) {
            invokedIntentSamples(Stream.of(invokedIntentSamples).map(c -> InvokedIntentSample.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOriginatingRequestId() {
            return originatingRequestId;
        }

        public final void setOriginatingRequestId(String originatingRequestId) {
            this.originatingRequestId = originatingRequestId;
        }

        @Override
        public final Builder originatingRequestId(String originatingRequestId) {
            this.originatingRequestId = originatingRequestId;
            return this;
        }

        @Override
        public SessionSpecification build() {
            return new SessionSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
