/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about whether assisted slot resolution is turned on for the slot or not.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotResolutionSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotResolutionSetting.Builder, SlotResolutionSetting> {
    private static final SdkField<String> SLOT_RESOLUTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotResolutionStrategy").getter(getter(SlotResolutionSetting::slotResolutionStrategyAsString))
            .setter(setter(Builder::slotResolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotResolutionStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SLOT_RESOLUTION_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String slotResolutionStrategy;

    private SlotResolutionSetting(BuilderImpl builder) {
        this.slotResolutionStrategy = builder.slotResolutionStrategy;
    }

    /**
     * <p>
     * Specifies whether assisted slot resolution is turned on for the slot or not. If the value is
     * <code>EnhancedFallback</code>, assisted slot resolution is activated when Amazon Lex defaults to the
     * <code>AMAZON.FallbackIntent</code>. If the value is <code>Default</code>, assisted slot resolution is turned off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #slotResolutionStrategy} will return {@link SlotResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #slotResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies whether assisted slot resolution is turned on for the slot or not. If the value is
     *         <code>EnhancedFallback</code>, assisted slot resolution is activated when Amazon Lex defaults to the
     *         <code>AMAZON.FallbackIntent</code>. If the value is <code>Default</code>, assisted slot resolution is
     *         turned off.
     * @see SlotResolutionStrategy
     */
    public final SlotResolutionStrategy slotResolutionStrategy() {
        return SlotResolutionStrategy.fromValue(slotResolutionStrategy);
    }

    /**
     * <p>
     * Specifies whether assisted slot resolution is turned on for the slot or not. If the value is
     * <code>EnhancedFallback</code>, assisted slot resolution is activated when Amazon Lex defaults to the
     * <code>AMAZON.FallbackIntent</code>. If the value is <code>Default</code>, assisted slot resolution is turned off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #slotResolutionStrategy} will return {@link SlotResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #slotResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies whether assisted slot resolution is turned on for the slot or not. If the value is
     *         <code>EnhancedFallback</code>, assisted slot resolution is activated when Amazon Lex defaults to the
     *         <code>AMAZON.FallbackIntent</code>. If the value is <code>Default</code>, assisted slot resolution is
     *         turned off.
     * @see SlotResolutionStrategy
     */
    public final String slotResolutionStrategyAsString() {
        return slotResolutionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotResolutionStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotResolutionSetting)) {
            return false;
        }
        SlotResolutionSetting other = (SlotResolutionSetting) obj;
        return Objects.equals(slotResolutionStrategyAsString(), other.slotResolutionStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotResolutionSetting").add("SlotResolutionStrategy", slotResolutionStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotResolutionStrategy":
            return Optional.ofNullable(clazz.cast(slotResolutionStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("slotResolutionStrategy", SLOT_RESOLUTION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotResolutionSetting, T> g) {
        return obj -> g.apply((SlotResolutionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotResolutionSetting> {
        /**
         * <p>
         * Specifies whether assisted slot resolution is turned on for the slot or not. If the value is
         * <code>EnhancedFallback</code>, assisted slot resolution is activated when Amazon Lex defaults to the
         * <code>AMAZON.FallbackIntent</code>. If the value is <code>Default</code>, assisted slot resolution is turned
         * off.
         * </p>
         * 
         * @param slotResolutionStrategy
         *        Specifies whether assisted slot resolution is turned on for the slot or not. If the value is
         *        <code>EnhancedFallback</code>, assisted slot resolution is activated when Amazon Lex defaults to the
         *        <code>AMAZON.FallbackIntent</code>. If the value is <code>Default</code>, assisted slot resolution is
         *        turned off.
         * @see SlotResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotResolutionStrategy
         */
        Builder slotResolutionStrategy(String slotResolutionStrategy);

        /**
         * <p>
         * Specifies whether assisted slot resolution is turned on for the slot or not. If the value is
         * <code>EnhancedFallback</code>, assisted slot resolution is activated when Amazon Lex defaults to the
         * <code>AMAZON.FallbackIntent</code>. If the value is <code>Default</code>, assisted slot resolution is turned
         * off.
         * </p>
         * 
         * @param slotResolutionStrategy
         *        Specifies whether assisted slot resolution is turned on for the slot or not. If the value is
         *        <code>EnhancedFallback</code>, assisted slot resolution is activated when Amazon Lex defaults to the
         *        <code>AMAZON.FallbackIntent</code>. If the value is <code>Default</code>, assisted slot resolution is
         *        turned off.
         * @see SlotResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotResolutionStrategy
         */
        Builder slotResolutionStrategy(SlotResolutionStrategy slotResolutionStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String slotResolutionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotResolutionSetting model) {
            slotResolutionStrategy(model.slotResolutionStrategy);
        }

        public final String getSlotResolutionStrategy() {
            return slotResolutionStrategy;
        }

        public final void setSlotResolutionStrategy(String slotResolutionStrategy) {
            this.slotResolutionStrategy = slotResolutionStrategy;
        }

        @Override
        public final Builder slotResolutionStrategy(String slotResolutionStrategy) {
            this.slotResolutionStrategy = slotResolutionStrategy;
            return this;
        }

        @Override
        public final Builder slotResolutionStrategy(SlotResolutionStrategy slotResolutionStrategy) {
            this.slotResolutionStrategy(slotResolutionStrategy == null ? null : slotResolutionStrategy.toString());
            return this;
        }

        @Override
        public SlotResolutionSetting build() {
            return new SlotResolutionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
