/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportRequest extends LexModelsV2Request implements
        ToCopyableBuilder<StartImportRequest.Builder, StartImportRequest> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importId").getter(getter(StartImportRequest::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()).build();

    private static final SdkField<ImportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ImportResourceSpecification> builder(MarshallingType.SDK_POJO).memberName("resourceSpecification")
            .getter(getter(StartImportRequest::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ImportResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeStrategy").getter(getter(StartImportRequest::mergeStrategyAsString))
            .setter(setter(Builder::mergeStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()).build();

    private static final SdkField<String> FILE_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePassword").getter(getter(StartImportRequest::filePassword)).setter(setter(Builder::filePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD,
            RESOURCE_SPECIFICATION_FIELD, MERGE_STRATEGY_FIELD, FILE_PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String importId;

    private final ImportResourceSpecification resourceSpecification;

    private final String mergeStrategy;

    private final String filePassword;

    private StartImportRequest(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.resourceSpecification = builder.resourceSpecification;
        this.mergeStrategy = builder.mergeStrategy;
        this.filePassword = builder.filePassword;
    }

    /**
     * <p>
     * The unique identifier for the import. It is included in the response from the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateUploadUrl.html">CreateUploadUrl</a>
     * operation.
     * </p>
     * 
     * @return The unique identifier for the import. It is included in the response from the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateUploadUrl.html">CreateUploadUrl</a>
     *         operation.
     */
    public final String importId() {
        return importId;
    }

    /**
     * <p>
     * Parameters for creating the bot, bot locale or custom vocabulary.
     * </p>
     * 
     * @return Parameters for creating the bot, bot locale or custom vocabulary.
     */
    public final ImportResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    /**
     * <p>
     * The strategy to use when there is a name conflict between the imported resource and an existing resource. When
     * the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The strategy to use when there is a name conflict between the imported resource and an existing resource.
     *         When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the
     *         import fails.
     * @see MergeStrategy
     */
    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * The strategy to use when there is a name conflict between the imported resource and an existing resource. When
     * the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The strategy to use when there is a name conflict between the imported resource and an existing resource.
     *         When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the
     *         import fails.
     * @see MergeStrategy
     */
    public final String mergeStrategyAsString() {
        return mergeStrategy;
    }

    /**
     * <p>
     * The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the
     * zip archive to protect it during transit between your site and Amazon Lex.
     * </p>
     * 
     * @return The password used to encrypt the zip archive that contains the resource definition. You should always
     *         encrypt the zip archive to protect it during transit between your site and Amazon Lex.
     */
    public final String filePassword() {
        return filePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filePassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportRequest)) {
            return false;
        }
        StartImportRequest other = (StartImportRequest) obj;
        return Objects.equals(importId(), other.importId())
                && Objects.equals(resourceSpecification(), other.resourceSpecification())
                && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString())
                && Objects.equals(filePassword(), other.filePassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImportRequest").add("ImportId", importId())
                .add("ResourceSpecification", resourceSpecification()).add("MergeStrategy", mergeStrategyAsString())
                .add("FilePassword", filePassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importId":
            return Optional.ofNullable(clazz.cast(importId()));
        case "resourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        case "mergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        case "filePassword":
            return Optional.ofNullable(clazz.cast(filePassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("importId", IMPORT_ID_FIELD);
        map.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        map.put("mergeStrategy", MERGE_STRATEGY_FIELD);
        map.put("filePassword", FILE_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartImportRequest, T> g) {
        return obj -> g.apply((StartImportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, StartImportRequest> {
        /**
         * <p>
         * The unique identifier for the import. It is included in the response from the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateUploadUrl.html">CreateUploadUrl</a>
         * operation.
         * </p>
         * 
         * @param importId
         *        The unique identifier for the import. It is included in the response from the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateUploadUrl.html"
         *        >CreateUploadUrl</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        /**
         * <p>
         * Parameters for creating the bot, bot locale or custom vocabulary.
         * </p>
         * 
         * @param resourceSpecification
         *        Parameters for creating the bot, bot locale or custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ImportResourceSpecification resourceSpecification);

        /**
         * <p>
         * Parameters for creating the bot, bot locale or custom vocabulary.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportResourceSpecification.Builder}
         * avoiding the need to create one manually via {@link ImportResourceSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportResourceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSpecification(ImportResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ImportResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ImportResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ImportResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ImportResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }

        /**
         * <p>
         * The strategy to use when there is a name conflict between the imported resource and an existing resource.
         * When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import
         * fails.
         * </p>
         * 
         * @param mergeStrategy
         *        The strategy to use when there is a name conflict between the imported resource and an existing
         *        resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not
         *        overwritten and the import fails.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * The strategy to use when there is a name conflict between the imported resource and an existing resource.
         * When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import
         * fails.
         * </p>
         * 
         * @param mergeStrategy
         *        The strategy to use when there is a name conflict between the imported resource and an existing
         *        resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not
         *        overwritten and the import fails.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        /**
         * <p>
         * The password used to encrypt the zip archive that contains the resource definition. You should always encrypt
         * the zip archive to protect it during transit between your site and Amazon Lex.
         * </p>
         * 
         * @param filePassword
         *        The password used to encrypt the zip archive that contains the resource definition. You should always
         *        encrypt the zip archive to protect it during transit between your site and Amazon Lex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePassword(String filePassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String importId;

        private ImportResourceSpecification resourceSpecification;

        private String mergeStrategy;

        private String filePassword;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportRequest model) {
            super(model);
            importId(model.importId);
            resourceSpecification(model.resourceSpecification);
            mergeStrategy(model.mergeStrategy);
            filePassword(model.filePassword);
        }

        public final String getImportId() {
            return importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final ImportResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ImportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ImportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getMergeStrategy() {
            return mergeStrategy;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final String getFilePassword() {
            return filePassword;
        }

        public final void setFilePassword(String filePassword) {
            this.filePassword = filePassword;
        }

        @Override
        public final Builder filePassword(String filePassword) {
            this.filePassword = filePassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportRequest build() {
            return new StartImportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
