/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the data source from which the test set is generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestSetGenerationDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<TestSetGenerationDataSource.Builder, TestSetGenerationDataSource> {
    private static final SdkField<ConversationLogsDataSource> CONVERSATION_LOGS_DATA_SOURCE_FIELD = SdkField
            .<ConversationLogsDataSource> builder(MarshallingType.SDK_POJO)
            .memberName("conversationLogsDataSource")
            .getter(getter(TestSetGenerationDataSource::conversationLogsDataSource))
            .setter(setter(Builder::conversationLogsDataSource))
            .constructor(ConversationLogsDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLogsDataSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONVERSATION_LOGS_DATA_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConversationLogsDataSource conversationLogsDataSource;

    private TestSetGenerationDataSource(BuilderImpl builder) {
        this.conversationLogsDataSource = builder.conversationLogsDataSource;
    }

    /**
     * <p>
     * Contains information about the bot from which the conversation logs are sourced.
     * </p>
     * 
     * @return Contains information about the bot from which the conversation logs are sourced.
     */
    public final ConversationLogsDataSource conversationLogsDataSource() {
        return conversationLogsDataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversationLogsDataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSetGenerationDataSource)) {
            return false;
        }
        TestSetGenerationDataSource other = (TestSetGenerationDataSource) obj;
        return Objects.equals(conversationLogsDataSource(), other.conversationLogsDataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestSetGenerationDataSource").add("ConversationLogsDataSource", conversationLogsDataSource())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversationLogsDataSource":
            return Optional.ofNullable(clazz.cast(conversationLogsDataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conversationLogsDataSource", CONVERSATION_LOGS_DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestSetGenerationDataSource, T> g) {
        return obj -> g.apply((TestSetGenerationDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestSetGenerationDataSource> {
        /**
         * <p>
         * Contains information about the bot from which the conversation logs are sourced.
         * </p>
         * 
         * @param conversationLogsDataSource
         *        Contains information about the bot from which the conversation logs are sourced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLogsDataSource(ConversationLogsDataSource conversationLogsDataSource);

        /**
         * <p>
         * Contains information about the bot from which the conversation logs are sourced.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationLogsDataSource.Builder}
         * avoiding the need to create one manually via {@link ConversationLogsDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationLogsDataSource.Builder#build()} is called immediately
         * and its result is passed to {@link #conversationLogsDataSource(ConversationLogsDataSource)}.
         * 
         * @param conversationLogsDataSource
         *        a consumer that will call methods on {@link ConversationLogsDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLogsDataSource(ConversationLogsDataSource)
         */
        default Builder conversationLogsDataSource(Consumer<ConversationLogsDataSource.Builder> conversationLogsDataSource) {
            return conversationLogsDataSource(ConversationLogsDataSource.builder().applyMutation(conversationLogsDataSource)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConversationLogsDataSource conversationLogsDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(TestSetGenerationDataSource model) {
            conversationLogsDataSource(model.conversationLogsDataSource);
        }

        public final ConversationLogsDataSource.Builder getConversationLogsDataSource() {
            return conversationLogsDataSource != null ? conversationLogsDataSource.toBuilder() : null;
        }

        public final void setConversationLogsDataSource(ConversationLogsDataSource.BuilderImpl conversationLogsDataSource) {
            this.conversationLogsDataSource = conversationLogsDataSource != null ? conversationLogsDataSource.build() : null;
        }

        @Override
        public final Builder conversationLogsDataSource(ConversationLogsDataSource conversationLogsDataSource) {
            this.conversationLogsDataSource = conversationLogsDataSource;
            return this;
        }

        @Override
        public TestSetGenerationDataSource build() {
            return new TestSetGenerationDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
