/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyDetectorConfig;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnomalyDetectorRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, UpdateAnomalyDetectorRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(UpdateAnomalyDetectorRequest.getter(UpdateAnomalyDetectorRequest::anomalyDetectorArn)).setter(UpdateAnomalyDetectorRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(UpdateAnomalyDetectorRequest.getter(UpdateAnomalyDetectorRequest::kmsKeyArn)).setter(UpdateAnomalyDetectorRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorDescription").getter(UpdateAnomalyDetectorRequest.getter(UpdateAnomalyDetectorRequest::anomalyDetectorDescription)).setter(UpdateAnomalyDetectorRequest.setter(Builder::anomalyDetectorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorDescription").build()}).build();
    private static final SdkField<AnomalyDetectorConfig> ANOMALY_DETECTOR_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyDetectorConfig").getter(UpdateAnomalyDetectorRequest.getter(UpdateAnomalyDetectorRequest::anomalyDetectorConfig)).setter(UpdateAnomalyDetectorRequest.setter(Builder::anomalyDetectorConfig)).constructor(AnomalyDetectorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, KMS_KEY_ARN_FIELD, ANOMALY_DETECTOR_DESCRIPTION_FIELD, ANOMALY_DETECTOR_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAnomalyDetectorRequest.memberNameToFieldInitializer();
    private final String anomalyDetectorArn;
    private final String kmsKeyArn;
    private final String anomalyDetectorDescription;
    private final AnomalyDetectorConfig anomalyDetectorConfig;

    private UpdateAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.anomalyDetectorDescription = builder.anomalyDetectorDescription;
        this.anomalyDetectorConfig = builder.anomalyDetectorConfig;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String anomalyDetectorDescription() {
        return this.anomalyDetectorDescription;
    }

    public final AnomalyDetectorConfig anomalyDetectorConfig() {
        return this.anomalyDetectorConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnomalyDetectorRequest)) {
            return false;
        }
        UpdateAnomalyDetectorRequest other = (UpdateAnomalyDetectorRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.anomalyDetectorDescription(), other.anomalyDetectorDescription()) && Objects.equals(this.anomalyDetectorConfig(), other.anomalyDetectorConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnomalyDetectorRequest").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("AnomalyDetectorDescription", (Object)this.anomalyDetectorDescription()).add("AnomalyDetectorConfig", (Object)this.anomalyDetectorConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "AnomalyDetectorDescription": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorDescription()));
            }
            case "AnomalyDetectorConfig": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AnomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("AnomalyDetectorDescription", ANOMALY_DETECTOR_DESCRIPTION_FIELD);
        map.put("AnomalyDetectorConfig", ANOMALY_DETECTOR_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((UpdateAnomalyDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private String kmsKeyArn;
        private String anomalyDetectorDescription;
        private AnomalyDetectorConfig anomalyDetectorConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnomalyDetectorRequest model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.kmsKeyArn(model.kmsKeyArn);
            this.anomalyDetectorDescription(model.anomalyDetectorDescription);
            this.anomalyDetectorConfig(model.anomalyDetectorConfig);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getAnomalyDetectorDescription() {
            return this.anomalyDetectorDescription;
        }

        public final void setAnomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
        }

        @Override
        public final Builder anomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
            return this;
        }

        public final AnomalyDetectorConfig.Builder getAnomalyDetectorConfig() {
            return this.anomalyDetectorConfig != null ? this.anomalyDetectorConfig.toBuilder() : null;
        }

        public final void setAnomalyDetectorConfig(AnomalyDetectorConfig.BuilderImpl anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig != null ? anomalyDetectorConfig.build() : null;
        }

        @Override
        public final Builder anomalyDetectorConfig(AnomalyDetectorConfig anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnomalyDetectorRequest build() {
            return new UpdateAnomalyDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnomalyDetectorRequest> {
        public Builder anomalyDetectorArn(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder anomalyDetectorDescription(String var1);

        public Builder anomalyDetectorConfig(AnomalyDetectorConfig var1);

        default public Builder anomalyDetectorConfig(Consumer<AnomalyDetectorConfig.Builder> anomalyDetectorConfig) {
            return this.anomalyDetectorConfig((AnomalyDetectorConfig)((AnomalyDetectorConfig.Builder)AnomalyDetectorConfig.builder().applyMutation(anomalyDetectorConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

