/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DataSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DataSpec> {
    private static final SdkField<String> DATA_LOCATION_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataLocationS3").getter(S3DataSpec.getter(S3DataSpec::dataLocationS3)).setter(S3DataSpec.setter(Builder::dataLocationS3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLocationS3").build()}).build();
    private static final SdkField<String> DATA_REARRANGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataRearrangement").getter(S3DataSpec.getter(S3DataSpec::dataRearrangement)).setter(S3DataSpec.setter(Builder::dataRearrangement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRearrangement").build()}).build();
    private static final SdkField<String> DATA_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSchema").getter(S3DataSpec.getter(S3DataSpec::dataSchema)).setter(S3DataSpec.setter(Builder::dataSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSchema").build()}).build();
    private static final SdkField<String> DATA_SCHEMA_LOCATION_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSchemaLocationS3").getter(S3DataSpec.getter(S3DataSpec::dataSchemaLocationS3)).setter(S3DataSpec.setter(Builder::dataSchemaLocationS3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSchemaLocationS3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LOCATION_S3_FIELD, DATA_REARRANGEMENT_FIELD, DATA_SCHEMA_FIELD, DATA_SCHEMA_LOCATION_S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataLocationS3", DATA_LOCATION_S3_FIELD);
            this.put("DataRearrangement", DATA_REARRANGEMENT_FIELD);
            this.put("DataSchema", DATA_SCHEMA_FIELD);
            this.put("DataSchemaLocationS3", DATA_SCHEMA_LOCATION_S3_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dataLocationS3;
    private final String dataRearrangement;
    private final String dataSchema;
    private final String dataSchemaLocationS3;

    private S3DataSpec(BuilderImpl builder) {
        this.dataLocationS3 = builder.dataLocationS3;
        this.dataRearrangement = builder.dataRearrangement;
        this.dataSchema = builder.dataSchema;
        this.dataSchemaLocationS3 = builder.dataSchemaLocationS3;
    }

    public final String dataLocationS3() {
        return this.dataLocationS3;
    }

    public final String dataRearrangement() {
        return this.dataRearrangement;
    }

    public final String dataSchema() {
        return this.dataSchema;
    }

    public final String dataSchemaLocationS3() {
        return this.dataSchemaLocationS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRearrangement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchemaLocationS3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSpec)) {
            return false;
        }
        S3DataSpec other = (S3DataSpec)obj;
        return Objects.equals(this.dataLocationS3(), other.dataLocationS3()) && Objects.equals(this.dataRearrangement(), other.dataRearrangement()) && Objects.equals(this.dataSchema(), other.dataSchema()) && Objects.equals(this.dataSchemaLocationS3(), other.dataSchemaLocationS3());
    }

    public final String toString() {
        return ToString.builder((String)"S3DataSpec").add("DataLocationS3", (Object)this.dataLocationS3()).add("DataRearrangement", (Object)this.dataRearrangement()).add("DataSchema", (Object)this.dataSchema()).add("DataSchemaLocationS3", (Object)this.dataSchemaLocationS3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataLocationS3": {
                return Optional.ofNullable(clazz.cast(this.dataLocationS3()));
            }
            case "DataRearrangement": {
                return Optional.ofNullable(clazz.cast(this.dataRearrangement()));
            }
            case "DataSchema": {
                return Optional.ofNullable(clazz.cast(this.dataSchema()));
            }
            case "DataSchemaLocationS3": {
                return Optional.ofNullable(clazz.cast(this.dataSchemaLocationS3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3DataSpec, T> g) {
        return obj -> g.apply((S3DataSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataLocationS3;
        private String dataRearrangement;
        private String dataSchema;
        private String dataSchemaLocationS3;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataSpec model) {
            this.dataLocationS3(model.dataLocationS3);
            this.dataRearrangement(model.dataRearrangement);
            this.dataSchema(model.dataSchema);
            this.dataSchemaLocationS3(model.dataSchemaLocationS3);
        }

        public final String getDataLocationS3() {
            return this.dataLocationS3;
        }

        public final void setDataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
        }

        @Override
        public final Builder dataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
            return this;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final String getDataSchema() {
            return this.dataSchema;
        }

        public final void setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
        }

        @Override
        public final Builder dataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public final String getDataSchemaLocationS3() {
            return this.dataSchemaLocationS3;
        }

        public final void setDataSchemaLocationS3(String dataSchemaLocationS3) {
            this.dataSchemaLocationS3 = dataSchemaLocationS3;
        }

        @Override
        public final Builder dataSchemaLocationS3(String dataSchemaLocationS3) {
            this.dataSchemaLocationS3 = dataSchemaLocationS3;
            return this;
        }

        public S3DataSpec build() {
            return new S3DataSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DataSpec> {
        public Builder dataLocationS3(String var1);

        public Builder dataRearrangement(String var1);

        public Builder dataSchema(String var1);

        public Builder dataSchemaLocationS3(String var1);
    }
}

