/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Detection;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.___listOfDetectionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceProfileDetectionsResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, ListResourceProfileDetectionsResponse> {
    private static final SdkField<List<Detection>> DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detections").getter(ListResourceProfileDetectionsResponse.getter(ListResourceProfileDetectionsResponse::detections)).setter(ListResourceProfileDetectionsResponse.setter(Builder::detections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Detection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListResourceProfileDetectionsResponse.getter(ListResourceProfileDetectionsResponse::nextToken)).setter(ListResourceProfileDetectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("detections", DETECTIONS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<Detection> detections;
    private final String nextToken;

    private ListResourceProfileDetectionsResponse(BuilderImpl builder) {
        super(builder);
        this.detections = builder.detections;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDetections() {
        return this.detections != null && !(this.detections instanceof SdkAutoConstructList);
    }

    public final List<Detection> detections() {
        return this.detections;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetections() ? this.detections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceProfileDetectionsResponse)) {
            return false;
        }
        ListResourceProfileDetectionsResponse other = (ListResourceProfileDetectionsResponse)((Object)obj);
        return this.hasDetections() == other.hasDetections() && Objects.equals(this.detections(), other.detections()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceProfileDetectionsResponse").add("Detections", this.hasDetections() ? this.detections() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detections": {
                return Optional.ofNullable(clazz.cast(this.detections()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceProfileDetectionsResponse, T> g) {
        return obj -> g.apply((ListResourceProfileDetectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private List<Detection> detections = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceProfileDetectionsResponse model) {
            super(model);
            this.detections(model.detections);
            this.nextToken(model.nextToken);
        }

        public final List<Detection.Builder> getDetections() {
            List<Detection.Builder> result = ___listOfDetectionCopier.copyToBuilder(this.detections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetections(Collection<Detection.BuilderImpl> detections) {
            this.detections = ___listOfDetectionCopier.copyFromBuilder(detections);
        }

        @Override
        public final Builder detections(Collection<Detection> detections) {
            this.detections = ___listOfDetectionCopier.copy(detections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(Detection ... detections) {
            this.detections(Arrays.asList(detections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(Consumer<Detection.Builder> ... detections) {
            this.detections(Stream.of(detections).map(c -> (Detection)((Detection.Builder)Detection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceProfileDetectionsResponse build() {
            return new ListResourceProfileDetectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceProfileDetectionsResponse> {
        public Builder detections(Collection<Detection> var1);

        public Builder detections(Detection ... var1);

        public Builder detections(Consumer<Detection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

