/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of the Accessor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Accessor implements SdkPojo, Serializable, ToCopyableBuilder<Accessor.Builder, Accessor> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Accessor::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Accessor::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> BILLING_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingToken").getter(getter(Accessor::billingToken)).setter(setter(Builder::billingToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingToken").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Accessor::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(Accessor::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Accessor::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Accessor::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(Accessor::networkTypeAsString)).setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            BILLING_TOKEN_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, ARN_FIELD, TAGS_FIELD, NETWORK_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String billingToken;

    private final String status;

    private final Instant creationDate;

    private final String arn;

    private final Map<String, String> tags;

    private final String networkType;

    private Accessor(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.billingToken = builder.billingToken;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.arn = builder.arn;
        this.tags = builder.tags;
        this.networkType = builder.networkType;
    }

    /**
     * <p>
     * The unique identifier of the accessor.
     * </p>
     * 
     * @return The unique identifier of the accessor.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the accessor.
     * </p>
     * <note>
     * <p>
     * Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the accessor.</p> <note>
     *         <p>
     *         Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
     *         </p>
     * @see AccessorType
     */
    public final AccessorType type() {
        return AccessorType.fromValue(type);
    }

    /**
     * <p>
     * The type of the accessor.
     * </p>
     * <note>
     * <p>
     * Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the accessor.</p> <note>
     *         <p>
     *         Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
     *         </p>
     * @see AccessorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The billing token is a property of the Accessor. Use this token to when making calls to the blockchain network.
     * The billing token is used to track your accessor token for billing requests.
     * </p>
     * 
     * @return The billing token is a property of the Accessor. Use this token to when making calls to the blockchain
     *         network. The billing token is used to track your accessor token for billing requests.
     */
    public final String billingToken() {
        return billingToken;
    }

    /**
     * <p>
     * The current status of the accessor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AccessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the accessor.
     * @see AccessorStatus
     */
    public final AccessorStatus status() {
        return AccessorStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the accessor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AccessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the accessor.
     * @see AccessorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation date and time of the accessor.
     * </p>
     * 
     * @return The creation date and time of the accessor.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the Accessor.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the Accessor.</p>
     *         <p>
     *         For more information about tags, see <a
     *         href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     *         Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
     *         "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     *         >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The blockchain network that the Accessor token is created for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link AccessorNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #networkTypeAsString}.
     * </p>
     * 
     * @return The blockchain network that the Accessor token is created for.
     * @see AccessorNetworkType
     */
    public final AccessorNetworkType networkType() {
        return AccessorNetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * The blockchain network that the Accessor token is created for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link AccessorNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #networkTypeAsString}.
     * </p>
     * 
     * @return The blockchain network that the Accessor token is created for.
     * @see AccessorNetworkType
     */
    public final String networkTypeAsString() {
        return networkType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(billingToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Accessor)) {
            return false;
        }
        Accessor other = (Accessor) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(billingToken(), other.billingToken())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(arn(), other.arn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(networkTypeAsString(), other.networkTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Accessor").add("Id", id()).add("Type", typeAsString()).add("BillingToken", billingToken())
                .add("Status", statusAsString()).add("CreationDate", creationDate()).add("Arn", arn())
                .add("Tags", hasTags() ? tags() : null).add("NetworkType", networkTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "BillingToken":
            return Optional.ofNullable(clazz.cast(billingToken()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("BillingToken", BILLING_TOKEN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Accessor, T> g) {
        return obj -> g.apply((Accessor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Accessor> {
        /**
         * <p>
         * The unique identifier of the accessor.
         * </p>
         * 
         * @param id
         *        The unique identifier of the accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the accessor.
         * </p>
         * <note>
         * <p>
         * Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
         * </p>
         * </note>
         * 
         * @param type
         *        The type of the accessor.</p> <note>
         *        <p>
         *        Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
         *        </p>
         * @see AccessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the accessor.
         * </p>
         * <note>
         * <p>
         * Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
         * </p>
         * </note>
         * 
         * @param type
         *        The type of the accessor.</p> <note>
         *        <p>
         *        Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
         *        </p>
         * @see AccessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorType
         */
        Builder type(AccessorType type);

        /**
         * <p>
         * The billing token is a property of the Accessor. Use this token to when making calls to the blockchain
         * network. The billing token is used to track your accessor token for billing requests.
         * </p>
         * 
         * @param billingToken
         *        The billing token is a property of the Accessor. Use this token to when making calls to the blockchain
         *        network. The billing token is used to track your accessor token for billing requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingToken(String billingToken);

        /**
         * <p>
         * The current status of the accessor.
         * </p>
         * 
         * @param status
         *        The current status of the accessor.
         * @see AccessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the accessor.
         * </p>
         * 
         * @param status
         *        The current status of the accessor.
         * @see AccessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorStatus
         */
        Builder status(AccessorStatus status);

        /**
         * <p>
         * The creation date and time of the accessor.
         * </p>
         * 
         * @param creationDate
         *        The creation date and time of the accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see
         *        <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The tags assigned to the Accessor.
         * </p>
         * <p>
         * For more information about tags, see <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
         * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the Accessor.</p>
         *        <p>
         *        For more information about tags, see <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
         *        "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The blockchain network that the Accessor token is created for.
         * </p>
         * 
         * @param networkType
         *        The blockchain network that the Accessor token is created for.
         * @see AccessorNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorNetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * The blockchain network that the Accessor token is created for.
         * </p>
         * 
         * @param networkType
         *        The blockchain network that the Accessor token is created for.
         * @see AccessorNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorNetworkType
         */
        Builder networkType(AccessorNetworkType networkType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String billingToken;

        private String status;

        private Instant creationDate;

        private String arn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(Accessor model) {
            id(model.id);
            type(model.type);
            billingToken(model.billingToken);
            status(model.status);
            creationDate(model.creationDate);
            arn(model.arn);
            tags(model.tags);
            networkType(model.networkType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AccessorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getBillingToken() {
            return billingToken;
        }

        public final void setBillingToken(String billingToken) {
            this.billingToken = billingToken;
        }

        @Override
        public final Builder billingToken(String billingToken) {
            this.billingToken = billingToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccessorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = OutputTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = OutputTagMapCopier.copy(tags);
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(AccessorNetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        @Override
        public Accessor build() {
            return new Accessor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
